/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import spottracker2d.Handler;
import spottracker2d.SpotTrackerImageCanvas;
import spottracker2d.TrackDialog;

public class SpotTracker2D_ {
    public SpotTracker2D_() {
        if (IJ.versionLessThan((String)"1.21a")) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.error((String)"No image sequence open.");
            return;
        }
        if (imp.getType() != 0 && imp.getType() != 1 && imp.getType() != 2) {
            IJ.error((String)"Only process the 8-bits or 16-bits 32-bits image");
            return;
        }
        if (imp.getStackSize() <= 1) {
            IJ.error((String)"Only process the stack of image");
            return;
        }
        Handler handler = new Handler(imp, 1);
        if (handler.startSource == null) {
            return;
        }
        SpotTrackerImageCanvas sptcanvas = new SpotTrackerImageCanvas(imp, handler);
        imp.setWindow((ImageWindow)new StackWindow(imp, (ImageCanvas)sptcanvas));
        TrackDialog dlg = new TrackDialog("Spot Tracker 2D", handler, sptcanvas, false);
    }
}

