/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import imageware.ImageWare;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import spottracker2d.CProgressBar;
import spottracker2d.Handler;
import spottracker2d.ViewerCanvas;

public class EnhanceSpotFrame
extends JFrame
implements ActionListener,
Runnable {
    private Properties props = new Properties();
    private String filename = String.valueOf(System.getProperty("user.dir")) + "/plugins/SpotTracker2D/EnhanceSpot.prefs";
    private Thread threadProcess = null;
    private ImagePlus imp;
    private Handler handler;
    private boolean displayResult = false;
    private CProgressBar progress = null;
    private static double spotsize = 1.25;
    private ViewerCanvas canvas;
    private JComboBox cmbSource;
    private boolean usePreferences = false;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private JButton bnEnhance = new JButton("Enhance");
    private JButton bnCancel = new JButton("Cancel");
    private JTextField txtSizeSpot = new JTextField(String.valueOf(spotsize), 10);
    private JCheckBox chkNormalizeLevel = new JCheckBox("Normalize Level", true);

    public EnhanceSpotFrame(boolean usePreferences) {
        super("Spot Enhancing Filter");
        this.usePreferences = usePreferences;
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.error((String)"The image is not valid.");
            return;
        }
        int type = this.imp.getType();
        if (type != 0 && type != 1 && type != 2) {
            IJ.error((String)"Not a 8-bit, 16-bit or 32-bit image.");
            return;
        }
        if (this.imp.getWidth() <= 3) {
            IJ.error((String)"Too small image.");
            return;
        }
        if (this.imp.getHeight() <= 3) {
            IJ.error((String)"Too small image.");
            return;
        }
        this.handler = new Handler(this.imp, 1);
        if (this.handler.startSource == null) {
            return;
        }
        this.progress = new CProgressBar(false);
        this.displayResult = true;
        this.getPreferences();
        this.doDialog();
    }

    public EnhanceSpotFrame(ImagePlus imp, Handler handler, CProgressBar progress, boolean dialog, ViewerCanvas canvas, JComboBox cmbSource) {
        super("Enhance Spot");
        this.imp = imp;
        this.handler = handler;
        this.progress = progress;
        this.canvas = canvas;
        this.cmbSource = cmbSource;
        this.displayResult = false;
        this.getPreferences();
        if (dialog) {
            this.doDialog();
        } else {
            this.start();
        }
    }

    public Insets getInsets() {
        return new Insets(40, 15, 15, 15);
    }

    private void start() {
        if (this.threadProcess == null) {
            this.threadProcess = new Thread(this);
            this.threadProcess.setPriority(1);
            this.threadProcess.start();
        }
    }

    public void run() {
        double startTime = System.currentTimeMillis();
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        int nt = this.handler.volSource.getSizeZ();
        this.progress.start("Enhance Spot ", nt + nt);
        spotsize = this.getDoubleValue(this.txtSizeSpot, 0.1, 1.25, this.handler.nx < this.handler.ny ? this.handler.nx / 3 : this.handler.ny / 3);
        this.handler.volFilter = this.doLoG_Separable(this.handler.volAlign, spotsize);
        this.progress.increment("LoG filter: ", nt / 3);
        this.handler.volFilter.invert();
        this.progress.increment("LoG filter: ", nt / 3);
        this.handler.volFilter.rescale();
        this.handler.startFilter = this.handler.findBestStartingPoint(this.handler.volFilter);
        this.progress.increment("LoG filter: ", nt / 3);
        this.handler.filter = true;
        this.progress.finish();
        if (this.displayResult) {
            this.handler.volFilter.show("S.E.F. (" + spotsize + ") of " + this.imp.getTitle());
        }
        this.setCursor(cursor);
        this.threadProcess = null;
        if (this.canvas != null) {
            this.canvas.setDataViewing(3);
        }
        if (this.cmbSource != null) {
            this.cmbSource.setSelectedIndex(3);
        }
    }

    private void doDialog() {
        JPanel pnSource = new JPanel();
        pnSource.setLayout(this.layout);
        this.addComponent(pnSource, 0, 0, 2, 1, 2, new JLabel("Diameter of the spot [pixels]"));
        this.addComponent(pnSource, 1, 0, 2, 1, 2, this.txtSizeSpot);
        JPanel pnButton = new JPanel();
        pnButton.setLayout(this.layout);
        this.addComponent(pnButton, 0, 0, 1, 1, 3, this.bnCancel);
        this.addComponent(pnButton, 0, 1, 1, 1, 3, this.bnEnhance);
        JPanel pnMain = new JPanel();
        pnMain.setLayout(this.layout);
        this.addComponent(pnMain, 0, 0, 1, 1, 3, pnSource);
        this.addComponent(pnMain, 1, 0, 1, 1, 3, pnButton);
        this.bnEnhance.addActionListener(this);
        this.bnCancel.addActionListener(this);
        this.txtSizeSpot.setText(String.valueOf(spotsize));
        this.getContentPane().add(pnMain);
        this.setResizable(false);
        this.pack();
        GUI.center((Window)this);
        this.show();
    }

    private void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnCancel) {
            this.dispose();
        } else if (e.getSource() == this.bnEnhance) {
            if (this.threadProcess == null) {
                this.threadProcess = new Thread(this);
                this.threadProcess.setPriority(1);
                this.threadProcess.start();
            }
            this.setPreferences();
            this.dispose();
        }
        this.notify();
    }

    private double getDoubleValue(JTextField text, double mini, double defaut, double maxi) {
        double d;
        block5: {
            try {
                String s = text.getText();
                if (s.charAt(0) == '-') {
                    s = s.substring(1);
                }
                if ((d = new Double(s).doubleValue()) < mini) {
                    text.setText(String.valueOf(mini));
                }
                if (d > maxi) {
                    text.setText(String.valueOf(maxi));
                }
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) break block5;
                text.setText(String.valueOf(defaut));
            }
        }
        d = new Double(text.getText());
        return d;
    }

    private void getPreferences() {
        if (!this.usePreferences) {
            return;
        }
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
        }
        catch (Exception exception) {}
        spotsize = Double.parseDouble(this.props.getProperty("txtSizeSpot", "0.75"));
    }

    private void setPreferences() {
        if (!this.usePreferences) {
            return;
        }
        this.props.setProperty("txtSizeSpot", this.txtSizeSpot.getText());
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, "Spot Tracker \n Header");
        }
        catch (Exception exception) {}
    }

    private ImageWare doLoG_Separable(ImageWare input, double sigma) {
        if (input == null) {
            return null;
        }
        int nx = input.getSizeX();
        int ny = input.getSizeY();
        int nt = input.getSizeZ();
        double[] kernelFact = this.createKernelLoG_Fact(sigma);
        double[] kernelBase = this.createKernelLoG_Base(sigma);
        ImageWare outputX = input.convert(3);
        ImageWare outputY = input.convert(3);
        int t = 0;
        while (t < nt) {
            this.progress.increment("LoG filter: " + t);
            double[] vinY = new double[ny];
            double[] voutY = new double[ny];
            int x = 0;
            while (x < nx) {
                outputX.getY(x, 0, t, vinY);
                voutY = this.convolve(vinY, kernelFact);
                outputX.putY(x, 0, t, voutY);
                outputY.getY(x, 0, t, vinY);
                voutY = this.convolve(vinY, kernelBase);
                outputY.putY(x, 0, t, voutY);
                ++x;
            }
            double[] vinX = new double[nx];
            double[] voutX = new double[nx];
            int y = 0;
            while (y < ny) {
                outputX.getX(0, y, t, vinX);
                voutX = this.convolve(vinX, kernelBase);
                outputX.putX(0, y, t, voutX);
                outputY.getX(0, y, t, vinX);
                voutX = this.convolve(vinX, kernelFact);
                outputY.putX(0, y, t, voutX);
                ++y;
            }
            ++t;
        }
        outputX.add(outputY);
        return outputX;
    }

    public double[] createKernelLoG_Fact(double sigma) {
        double s2 = sigma * sigma;
        double s4 = s2 * s2;
        double dem = 2.0 * s2;
        double cst = 1.0 / (Math.PI * 2 * s2);
        int size = (int)Math.round((double)((int)(sigma * 3.0)) * 2.0 + 1.0);
        int size2 = size / 2;
        double[] kernel = new double[size];
        int k = 0;
        while (k < size) {
            double x = (k - size2) * (k - size2);
            kernel[k] = cst * (x / s4 - 1.0 / s2) * Math.exp(-x / dem);
            ++k;
        }
        return kernel;
    }

    public double[] createKernelLoG_Base(double sigma) {
        double s2 = sigma * sigma;
        double dem = 2.0 * s2;
        int size = (int)Math.round((double)((int)(sigma * 3.0)) * 2.0 + 1.0);
        int size2 = size / 2 + 1;
        double[] kernel = new double[size];
        int k = 0;
        while (k < size) {
            double x = (k - size2) * (k - size2);
            kernel[k] = Math.exp(-x / dem);
            ++k;
        }
        return kernel;
    }

    private double[][][] createKernelLoG_NonSeparable3(double sigma) {
        double cst = -(1.0 / (Math.PI * Math.pow(sigma, 4.0)));
        double dem = 2.0 * Math.pow(sigma, 2.0);
        int size = (int)(sigma * 6.0);
        double[][][] kernel = new double[size][size][size];
        int halfsize = size / 2;
        int k = 0;
        while (k < size) {
            int l = 0;
            while (l < size) {
                int m = 0;
                while (m < size) {
                    double x = (k - halfsize) * (k - halfsize);
                    double y = (l - halfsize) * (l - halfsize);
                    double z = (m - halfsize) * (m - halfsize);
                    kernel[k][l][m] = cst * (1.0 - (x + y + z) / dem) * Math.exp(-(x + y + z) / dem);
                    ++m;
                }
                ++l;
            }
            ++k;
        }
        return kernel;
    }

    private double[] convolve(double[] vin, double[] kernel) {
        int n = vin.length;
        int nk = kernel.length;
        int kc = nk / 2;
        double[] vout = new double[n];
        int i = 0;
        while (i < n) {
            double sum = 0.0;
            int k = 0;
            while (k < nk) {
                int im = i + k - kc;
                if (im < 0) {
                    im = -im;
                }
                if (im >= n) {
                    im = 2 * n - im - 1;
                }
                sum += kernel[k] * vin[im];
                ++k;
            }
            vout[i] = sum;
            ++i;
        }
        return vout;
    }
}

