/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import imageware.Builder;
import imageware.ImageWare;
import java.util.Vector;
import spottracker2d.CProgressBar;
import spottracker2d.ControlPoint;
import spottracker2d.FEMatrix;
import spottracker2d.Handler;

public class FitEllipse {
    public final int BOOKSTEIN = 0;
    public final int FPF = 1;
    private CProgressBar progress;
    private Handler handler;
    private boolean ok = false;

    public FitEllipse(CProgressBar progress, Handler handler) {
        this.progress = progress;
        this.handler = handler;
    }

    public void run(ImageWare input, double zoom) {
        int nb = 50;
        int nx = input.getWidth();
        int ny = input.getHeight();
        int nz = input.getSizeZ();
        int mode = 1;
        Vector<ControlPoint> points = new Vector<ControlPoint>(16, 4);
        ImageWare slice = Builder.create(nx, ny, 1, input.getType());
        int z = 0;
        while (z < nz) {
            this.progress.increment("Fit Ellipse:" + z);
            input.getXY(0, 0, z, slice);
            points.removeAllElements();
            int x = 0;
            while (x < nx) {
                int y = 0;
                while (y < ny) {
                    if (input.getPixel(x, y, z) > 0.0) {
                        points.addElement(new ControlPoint(x, y));
                    }
                    ++y;
                }
                ++x;
            }
            this.ok = true;
            double[][] XY = null;
            if (points.size() > 7) {
                double[] pvec = this.compute(points, mode);
                XY = this.draw_conic(pvec, nb);
            }
            if (points.size() > 7 && this.ok) {
                double xc = 0.0;
                double yc = 0.0;
                double xmin = nx;
                double xmax = 0.0;
                double ymin = ny;
                double ymax = 0.0;
                int i = 1;
                while (i < nb) {
                    if (XY[1][i] < xmin) {
                        xmin = XY[1][i];
                    }
                    if (XY[1][i] > xmax) {
                        xmax = XY[1][i];
                    }
                    if (XY[2][i] < ymin) {
                        ymin = XY[2][i];
                    }
                    if (XY[2][i] > ymax) {
                        ymax = XY[2][i];
                    }
                    ++i;
                }
                xmin = xmin < 0.0 ? 0.0 : xmin;
                ymin = ymin < 0.0 ? 0.0 : ymin;
                xmax = xmax >= (double)nx ? (double)(nx - 1) : xmax;
                ymax = ymax >= (double)ny ? (double)(ny - 1) : ymax;
                xc = (xmax + xmin) / 2.0;
                yc = (ymax + ymin) / 2.0;
                this.handler.nucleus[z][3] = (xc - xmin > xmax - xc ? xc - xmin : xmax - xc) + 1.0;
                this.handler.nucleus[z][4] = (yc - ymin > ymax - yc ? yc - ymin : ymax - yc) + 1.0;
                this.handler.nucleus[z][0] = xc;
                this.handler.nucleus[z][1] = yc;
            } else if (z > 0) {
                this.handler.nucleus[z][0] = this.handler.nucleus[z - 1][0];
                this.handler.nucleus[z][1] = this.handler.nucleus[z - 1][1];
                this.handler.nucleus[z][3] = this.handler.nucleus[z - 1][3];
                this.handler.nucleus[z][4] = this.handler.nucleus[z - 1][4];
                IJ.write((String)("Not enough points to fit the ellipse. Image: " + z));
            } else {
                this.handler.nucleus[z][0] = nx / 2;
                this.handler.nucleus[z][1] = ny / 2;
                this.handler.nucleus[z][3] = nx / 4;
                this.handler.nucleus[z][4] = ny / 4;
                IJ.write((String)("Not enough points to fit the ellipse image: " + z));
            }
            ++z;
        }
        int z2 = 0;
        while (z2 < nz) {
            double dr;
            double dl;
            double xc = this.handler.nucleus[z2][0];
            double yc = this.handler.nucleus[z2][1];
            double rx = this.handler.nucleus[z2][3];
            double ry = this.handler.nucleus[z2][4];
            if (xc + rx >= (double)(nx - 1) || xc - rx <= 0.0) {
                dl = xc - rx;
                dr = (double)(nx - 1) - (xc + rx);
                this.handler.nucleus[z2][3] = dl < dr ? xc : (double)(nx - 1) - xc;
            }
            if (yc + ry >= (double)(ny - 1) || yc - ry <= 0.0) {
                dl = yc - ry;
                dr = (double)(ny - 1) - (yc + ry);
                this.handler.nucleus[z2][4] = dl < dr ? yc : (double)(ny - 1) - yc;
            }
            ++z2;
        }
    }

    private double[] compute(Vector points, int mode) {
        int np = points.size();
        double[][] D = new double[np + 1][7];
        double[][] S = new double[7][7];
        double[][] Const = new double[7][7];
        double[][] temp = new double[7][7];
        double[][] L = new double[7][7];
        double[][] C = new double[7][7];
        double[][] invL = new double[7][7];
        double[] d = new double[7];
        double[][] V = new double[7][7];
        double[][] sol = new double[7][7];
        int nrot = 0;
        double[] pvec = new double[7];
        switch (mode) {
            case 1: {
                Const[1][3] = -2.0;
                Const[2][2] = 1.0;
                Const[3][1] = -2.0;
                break;
            }
            case 0: {
                Const[1][1] = 2.0;
                Const[2][2] = 1.0;
                Const[3][3] = 2.0;
            }
        }
        if (np < 6) {
            return null;
        }
        int i = 1;
        while (i <= np) {
            double tx = ((ControlPoint)points.elementAt((int)(i - 1))).x;
            double ty = ((ControlPoint)points.elementAt((int)(i - 1))).y;
            D[i][1] = tx * tx;
            D[i][2] = tx * ty;
            D[i][3] = ty * ty;
            D[i][4] = tx;
            D[i][5] = ty;
            D[i][6] = 1.0;
            ++i;
        }
        FEMatrix.A_TperB(D, D, S, np, 6, np, 6);
        FEMatrix.choldc(S, 6, L);
        FEMatrix.inverse(L, invL, 6);
        FEMatrix.AperB_T(Const, invL, temp, 6, 6, 6, 6);
        FEMatrix.AperB(invL, temp, C, 6, 6, 6, 6);
        FEMatrix.jacobi(C, 6, d, V, nrot);
        FEMatrix.A_TperB(invL, V, sol, 6, 6, 6, 6);
        int j = 1;
        while (j <= 6) {
            double mod = 0.0;
            int i2 = 1;
            while (i2 <= 6) {
                mod += sol[i2][j] * sol[i2][j];
                ++i2;
            }
            int i3 = 1;
            while (i3 <= 6) {
                double[] dArray = sol[i3];
                int n = j;
                dArray[n] = dArray[n] / Math.sqrt(mod);
                ++i3;
            }
            ++j;
        }
        double zero = 1.0E-19;
        double minev = 1.0E21;
        int solind = 0;
        switch (mode) {
            case 0: {
                int i4 = 1;
                while (i4 <= 6) {
                    if (d[i4] < minev && Math.abs(d[i4]) > zero) {
                        solind = i4;
                    }
                    ++i4;
                }
                break;
            }
            case 1: {
                int i4 = 1;
                while (i4 <= 6) {
                    if (d[i4] < 0.0 && Math.abs(d[i4]) > zero) {
                        solind = i4;
                    }
                    ++i4;
                }
                break;
            }
        }
        int j2 = 1;
        while (j2 <= 6) {
            pvec[j2] = sol[j2][solind];
            ++j2;
        }
        return pvec;
    }

    public double[][] draw_conic(double[] pvec, int nptsk) {
        int j;
        int npts = nptsk / 2;
        double[][] u = new double[3][npts + 1];
        double[][] Aiu = new double[3][npts + 1];
        double[][] L = new double[3][npts + 1];
        double[][] B = new double[3][npts + 1];
        double[][] Xpos = new double[3][npts + 1];
        double[][] Xneg = new double[3][npts + 1];
        double[][] ss1 = new double[3][npts + 1];
        double[][] ss2 = new double[3][npts + 1];
        double[] lambda = new double[npts + 1];
        double[][] uAiu = new double[3][npts + 1];
        double[][] A = new double[3][3];
        double[][] Ai = new double[3][3];
        double[][] Aib = new double[3][2];
        double[][] b = new double[3][2];
        double[][] r1 = new double[2][2];
        double[][] XY = new double[3][nptsk + 1];
        double pi = 3.14781;
        double Ao = pvec[6];
        double Ax = pvec[4];
        double Ay = pvec[5];
        double Axx = pvec[1];
        double Ayy = pvec[3];
        double Axy = pvec[2];
        A[1][1] = Axx;
        A[1][2] = Axy / 2.0;
        A[2][1] = Axy / 2.0;
        A[2][2] = Ayy;
        b[1][1] = Ax;
        b[2][1] = Ay;
        int i = 1;
        double theta = 0.0;
        while (i <= npts) {
            u[1][i] = Math.cos(theta);
            u[2][i] = Math.sin(theta);
            ++i;
            theta += pi / (double)npts;
        }
        FEMatrix.inverse(A, Ai, 2);
        FEMatrix.AperB(Ai, b, Aib, 2, 2, 2, 1);
        FEMatrix.A_TperB(b, Aib, r1, 2, 1, 2, 1);
        r1[1][1] = r1[1][1] - 4.0 * Ao;
        FEMatrix.AperB(Ai, u, Aiu, 2, 2, 2, npts);
        i = 1;
        while (i <= 2) {
            j = 1;
            while (j <= npts) {
                uAiu[i][j] = u[i][j] * Aiu[i][j];
                ++j;
            }
            ++i;
        }
        j = 1;
        while (j <= npts) {
            double d;
            double kk = r1[1][1] / (uAiu[1][j] + uAiu[2][j]);
            lambda[j] = d >= 0.0 ? Math.sqrt(kk) : -1.0;
            ++j;
        }
        j = 1;
        while (j <= npts) {
            double d = lambda[j];
            L[2][j] = d;
            L[1][j] = d;
            ++j;
        }
        j = 1;
        while (j <= npts) {
            B[1][j] = b[1][1];
            B[2][j] = b[2][1];
            ++j;
        }
        j = 1;
        while (j <= npts) {
            ss1[1][j] = 0.5 * (L[1][j] * u[1][j] - B[1][j]);
            ss1[2][j] = 0.5 * (L[2][j] * u[2][j] - B[2][j]);
            ss2[1][j] = 0.5 * (-L[1][j] * u[1][j] - B[1][j]);
            ss2[2][j] = 0.5 * (-L[2][j] * u[2][j] - B[2][j]);
            ++j;
        }
        FEMatrix.AperB(Ai, ss1, Xpos, 2, 2, 2, npts);
        FEMatrix.AperB(Ai, ss2, Xneg, 2, 2, 2, npts);
        j = 1;
        while (j <= npts) {
            if (lambda[j] == -1.0) {
                XY[1][j] = -1.0;
                XY[2][j] = -1.0;
                XY[1][j + npts] = -1.0;
                XY[2][j + npts] = -1.0;
                this.ok = false;
            } else {
                XY[1][j] = Xpos[1][j];
                XY[2][j] = Xpos[2][j];
                XY[1][j + npts] = Xneg[1][j];
                XY[2][j + npts] = Xneg[2][j];
            }
            ++j;
        }
        return XY;
    }

    private int round(double f) {
        double f05 = f + 0.5;
        if (f05 >= 0.0) {
            return (int)f05;
        }
        int iAdd = (int)f05 - 1;
        return (int)(f05 - (double)iAdd) + iAdd;
    }
}

