/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import imageware.Builder;
import imageware.Display;
import imageware.ImageWare;
import spottracker2d.CProgressBar;
import spottracker2d.FitEllipse;
import spottracker2d.Handler;

public class Processor {
    private CProgressBar progress;
    private int nx;
    private int ny;
    private int nz;
    private int nt;
    private boolean smooth;
    private boolean isolatedPoints;
    private Handler handler;

    public Processor(CProgressBar progress, Handler handler, boolean smooth, boolean isolatedPoints) {
        this.progress = progress;
        this.handler = handler;
        this.smooth = smooth;
        this.isolatedPoints = isolatedPoints;
        this.nx = handler.volNorm.getWidth();
        this.ny = handler.volNorm.getHeight();
        int progressValue = this.nt = handler.volNorm.getSizeZ();
        progressValue += 2 * this.nt;
        progressValue += (this.nx + this.ny + this.nt) * (smooth ? 1 : 0);
        progress.start("Nucleus Align ", progressValue += this.nt * (isolatedPoints ? 1 : 0));
    }

    public void center(double sigmaXY, double sigmaZ, boolean displayOutline, double zoom, int threshold) {
        ImageWare out = null;
        if (this.smooth) {
            this.progress.increment("Center ", this.nt / 4);
            ImageWare smoothImage = this.handler.volNorm.duplicate();
            this.progress.increment("Center ", this.nt / 4);
            smoothImage.smoothGaussian(sigmaXY, sigmaXY, sigmaZ);
            this.progress.increment("Center ", this.nt / 4);
            smoothImage.thresholdHard(threshold);
            this.progress.increment("Center ", this.nt / 4);
            out = this.isolatedPoints ? this.removeIsolatedPoints(smoothImage, threshold) : smoothImage.duplicate();
        } else {
            ImageWare d = this.handler.volNorm.duplicate();
            d.thresholdHard(threshold);
            out = this.isolatedPoints ? this.removeIsolatedPoints(d, threshold) : d.duplicate();
        }
        FitEllipse fe = new FitEllipse(this.progress, this.handler);
        fe.run(out, zoom);
        if (displayOutline) {
            this.displayOutline(this.handler.volNorm, this.handler.nucleus, zoom);
        }
        this.progress.finish();
    }

    private ImageWare removeIsolatedPoints(ImageWare in, double threshold) {
        int nx = in.getWidth();
        int ny = in.getHeight();
        int nt = in.getSizeZ();
        double[][] slice = new double[nx][ny];
        ImageWare out = in.duplicate();
        double pixel = 0.0;
        int cpt = 0;
        double[][] n = new double[3][3];
        double[] row = new double[nx];
        double[] col = new double[ny];
        int z = 0;
        while (z < nt) {
            this.progress.increment("Isolated points " + z);
            in.getXY(0, 0, 0, slice);
            int i = 1;
            while (i < nx - 1) {
                int j = 1;
                while (j < ny - 1) {
                    if (slice[i][j] > threshold) {
                        cpt = 0;
                        if (slice[i][j - 1] <= threshold) {
                            ++cpt;
                        }
                        if (slice[i + 1][j] <= threshold) {
                            ++cpt;
                        }
                        if (slice[i - 1][j] <= threshold) {
                            ++cpt;
                        }
                        if (slice[i][j + 1] <= threshold) {
                            ++cpt;
                        }
                        if (cpt >= 3) {
                            out.putPixel(i, j, z, 0.0);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            out.putX(0, 0, z, row);
            out.putX(0, ny - 1, z, row);
            out.putY(0, 0, z, col);
            out.putY(nx - 1, 0, z, col);
            ++z;
        }
        return out;
    }

    private void displayOutline(ImageWare image, double[][] nucleus, double zoom) {
        ImageWare back = image.convert(1);
        ImageWare circle = image.convert(1);
        int nbAngle = 180;
        int nx = image.getWidth();
        int ny = image.getHeight();
        int nt = image.getSizeZ();
        double[] cosa = new double[nbAngle];
        double[] sina = new double[nbAngle];
        int a = 0;
        while (a < nbAngle) {
            double aradian = 2.0 * (double)a * Math.PI / (double)nbAngle;
            cosa[a] = Math.cos(aradian);
            sina[a] = Math.sin(aradian);
            ++a;
        }
        int z = 0;
        while (z < nt) {
            int a2 = 0;
            while (a2 < nbAngle) {
                int y;
                int x = this.round(nucleus[z][0] + nucleus[z][3] * cosa[a2]);
                if (x >= 0 && x < nx && (y = this.round(nucleus[z][1] + nucleus[z][4] * sina[a2])) >= 0 && y < ny) {
                    back.putPixel(x, y, z, 0.0);
                    circle.putPixel(x, y, z, 255.0);
                }
                ++a2;
            }
            ++z;
        }
        Display.showColor("Best ellipse", circle, back, back, zoom);
    }

    public ImageWare align(ImageWare input) {
        if (input == null) {
            return null;
        }
        ImageWare output = Builder.create(this.nx, this.ny, this.nt, input.getType());
        double[][] source = new double[this.nx][this.ny];
        int t = 0;
        while (t < this.nt) {
            this.progress.increment("Align image: " + t);
            input.getBoundedXY(0, 0, t, source);
            int x1 = this.round((double)(this.nx / 2) - this.handler.nucleus[t][0]);
            int y1 = this.round((double)(this.ny / 2) - this.handler.nucleus[t][1]);
            output.putBoundedXY(x1, y1, t, source);
            ++t;
        }
        return output;
    }

    public ImageWare alignWithCrop(ImageWare input, boolean align, int border) {
        if (input == null) {
            return null;
        }
        if (!align) {
            return input.duplicate();
        }
        double maxRadiusX = -1.7976931348623157E308;
        double maxRadiusY = -1.7976931348623157E308;
        int k = 0;
        while (k < this.nt) {
            if (this.handler.nucleus[k][3] > maxRadiusX) {
                maxRadiusX = this.handler.nucleus[k][3];
            }
            if (this.handler.nucleus[k][4] > maxRadiusY) {
                maxRadiusY = this.handler.nucleus[k][4];
            }
            ++k;
        }
        maxRadiusX = Math.round(maxRadiusX + (double)border);
        maxRadiusY = Math.round(maxRadiusY + (double)border);
        int nxout = (int)(2.0 * maxRadiusX);
        int nyout = (int)(2.0 * maxRadiusY);
        this.progress.start(" ", this.nt);
        ImageWare output = Builder.create(nxout, nyout, this.nt, input.getType());
        double[][] block = new double[nxout][nyout];
        double[][] source = new double[this.nx][this.ny];
        int t = 0;
        while (t < this.nt) {
            this.progress.increment("Align image: " + t);
            input.getBoundedXY(0, 0, t, source);
            int x1 = this.round(this.handler.nucleus[t][0] - maxRadiusX);
            int y1 = this.round(this.handler.nucleus[t][1] - maxRadiusY);
            int i = 0;
            while (i < nxout) {
                int j = 0;
                while (j < nyout) {
                    int k2 = x1 + i;
                    int l = y1 + j;
                    block[i][j] = k2 >= 0 && l >= 0 && k2 < this.nx && l < this.ny ? source[k2][l] : 0.0;
                    ++j;
                }
                ++i;
            }
            output.putBoundedXY(0, 0, t, block);
            ++t;
        }
        this.progress.finish();
        return output;
    }

    private int round(double f) {
        double f05 = f + 0.5;
        if (f05 >= 0.0) {
            return (int)f05;
        }
        int iAdd = (int)f05 - 1;
        return (int)(f05 - (double)iAdd) + iAdd;
    }
}

