/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import imageware.Builder;
import imageware.ImageWare;

public class ProjectionCurve {
    public static void show(float[] xPoints, float[] yPoints, int[] zPoints, int[] intensity, int nx, int ny) {
        int Npoints = xPoints.length;
        double xCenter = 0.0;
        double yCenter = 0.0;
        double zCenter = 0.0;
        int i = 0;
        while (i < Npoints) {
            xCenter += (double)xPoints[i];
            yCenter += (double)yPoints[i];
            zCenter += (double)zPoints[i];
            ++i;
        }
        xCenter /= (double)Npoints;
        yCenter /= (double)Npoints;
        zCenter /= (double)Npoints;
        ImageWare out = Builder.create(nx, ny, 60, 1);
        int k = 0;
        while (k < 60) {
            double angle = (double)k * 3.0 / Math.PI;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            byte[] processornew = out.getSliceByte(k);
            i = 0;
            while (i < Npoints) {
                double xFinal = cos * ((double)xPoints[i] - xCenter) + sin * ((double)yPoints[i] - yCenter);
                double yFinal = (double)zPoints[i] - zCenter;
                int xcord = (int)(xFinal + (double)(nx / 2));
                int ycord = (int)(yFinal + (double)(ny / 2));
                if (xcord >= 0 && xcord < nx && ycord >= 0 && ycord < ny) {
                    processornew[xcord + nx * ycord] = (byte)intensity[i];
                }
                ++i;
            }
            ++k;
        }
        out.show("Path");
    }
}

