/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import imageware.Builder;
import imageware.Display;
import imageware.ImageWare;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import spottracker2d.CProgressBar;
import spottracker2d.Handler;
import spottracker2d.PointTrack;
import spottracker2d.ViewerCanvas;

public class RescaleSliceFrame
extends JFrame
implements ActionListener,
Runnable {
    private Properties props = new Properties();
    private String filename = String.valueOf(System.getProperty("user.dir")) + "/plugins/SpotTracker2D/RescaleSlice.prefs";
    private Thread threadProcess = null;
    private ImagePlus imp;
    private Handler handler;
    private boolean displayResult = false;
    private CProgressBar progress = null;
    private boolean zeroLevel;
    private boolean normLevel;
    private ViewerCanvas canvas;
    private JComboBox cmbSource;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private JButton bnRescale = new JButton("Rescale");
    private JButton bnCancel = new JButton("Cancel");
    private JCheckBox chkZeroLevel = new JCheckBox("Zero Level", true);
    private JCheckBox chkNormalizeLevel = new JCheckBox("Normalize Level", true);

    public RescaleSliceFrame() {
        super("Rescale Slice");
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.error((String)"The image is not valid.");
            return;
        }
        int type = this.imp.getType();
        if (type != 0 && type != 1 && type != 2) {
            IJ.error((String)"Not a 8-bit, 16-bit or 32-bit image.");
            return;
        }
        this.handler = new Handler(this.imp, 1);
        this.progress = new CProgressBar(false);
        this.canvas = null;
        this.cmbSource = null;
        this.displayResult = true;
        this.getPreferences();
        this.doDialog();
    }

    public RescaleSliceFrame(ImagePlus imp, Handler handler, CProgressBar progress, boolean dialog, ViewerCanvas canvas, JComboBox cmbSource) {
        super("Rescale Slice");
        this.imp = imp;
        this.handler = handler;
        this.progress = progress;
        this.canvas = canvas;
        this.cmbSource = cmbSource;
        this.displayResult = false;
        this.getPreferences();
        if (dialog) {
            this.doDialog();
        } else {
            this.start();
        }
    }

    private void start() {
        if (this.threadProcess == null) {
            this.threadProcess = new Thread(this);
            this.threadProcess.setPriority(1);
            this.threadProcess.start();
        }
    }

    public void run() {
        double startTime = System.currentTimeMillis();
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        int nt = this.handler.volNorm.getSizeZ();
        this.progress.start("Rescale ", nt * (this.zeroLevel ? 1 : 0) + nt * (this.normLevel ? 1 : 0));
        if (this.zeroLevel) {
            this.subtractBackground(this.handler.volNorm, this.progress);
        }
        if (this.normLevel) {
            this.normalize(this.handler.volNorm, this.progress);
        }
        this.progress.finish();
        if (this.displayResult) {
            int nx = this.imp.getWidth();
            int ny = this.imp.getHeight();
            double zoom = 1.0;
            if (nx + ny < 500) {
                zoom = 2.0;
            } else if (nx + ny < 250) {
                zoom = 3.0;
            } else if (nx + ny < 125) {
                zoom = 4.0;
            }
            Display.show("Rescaled " + this.imp.getTitle(), this.handler.volNorm, zoom);
        }
        this.handler.volAlign = this.handler.volNorm.convert(3);
        this.handler.volFilter = this.handler.volAlign.duplicate();
        this.handler.startNorm = this.handler.findBestStartingPoint(this.handler.volNorm);
        this.handler.startAlign = new PointTrack(this.handler.startNorm);
        this.handler.startFilter = new PointTrack(this.handler.startNorm);
        this.setCursor(cursor);
        this.threadProcess = null;
        if (this.canvas != null) {
            this.canvas.setDataViewing(1);
        }
        if (this.cmbSource != null) {
            this.cmbSource.setSelectedIndex(1);
        }
    }

    private void doDialog() {
        JPanel pnSource = new JPanel();
        pnSource.setLayout(this.layout);
        this.addComponent(pnSource, 0, 0, 2, 1, 2, this.chkZeroLevel);
        this.addComponent(pnSource, 1, 0, 2, 1, 2, this.chkNormalizeLevel);
        JPanel pnButton = new JPanel();
        pnButton.setLayout(this.layout);
        this.addComponent(pnButton, 0, 0, 1, 1, 3, this.bnCancel);
        this.addComponent(pnButton, 0, 1, 1, 1, 3, this.bnRescale);
        JPanel pnMain = new JPanel();
        pnMain.setLayout(this.layout);
        this.addComponent(pnMain, 0, 0, 1, 1, 3, pnSource);
        this.addComponent(pnMain, 1, 0, 1, 1, 3, pnButton);
        this.bnRescale.addActionListener(this);
        this.bnCancel.addActionListener(this);
        this.chkZeroLevel.setSelected(this.zeroLevel);
        this.chkNormalizeLevel.setSelected(this.normLevel);
        this.getContentPane().add(pnMain);
        this.setResizable(false);
        this.pack();
        GUI.center((Window)this);
        this.show();
    }

    private void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnCancel) {
            this.dispose();
        } else if (e.getSource() == this.bnRescale) {
            if (this.threadProcess == null) {
                this.threadProcess = new Thread(this);
                this.threadProcess.setPriority(1);
                this.threadProcess.start();
            }
            this.setPreferences();
            this.dispose();
        }
        this.notify();
    }

    private double getDoubleValue(JTextField text, double mini, double defaut, double maxi) {
        double d;
        block5: {
            try {
                String s = text.getText();
                if (s.charAt(0) == '-') {
                    s = s.substring(1);
                }
                if ((d = new Double(s).doubleValue()) < mini) {
                    text.setText(String.valueOf(mini));
                }
                if (d > maxi) {
                    text.setText(String.valueOf(maxi));
                }
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) break block5;
                text.setText(String.valueOf(defaut));
            }
        }
        d = new Double(text.getText());
        return d;
    }

    private void getPreferences() {
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
        }
        catch (Exception exception) {}
        this.zeroLevel = this.props.getProperty("chkZeroLevel", "true").equals("true");
        this.normLevel = this.props.getProperty("chkNormalizeLevel", "true").equals("true");
    }

    private void setPreferences() {
        this.props.setProperty("chkZeroLevel", String.valueOf(this.chkZeroLevel.isSelected()));
        this.props.setProperty("chkNormalizeLevel", String.valueOf(this.chkNormalizeLevel.isSelected()));
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, "Spot Tracker \n Header");
        }
        catch (Exception exception) {}
    }

    private void normalize(ImageWare image, CProgressBar progress) {
        int nx = image.getSizeX();
        int ny = image.getSizeY();
        int nt = image.getSizeZ();
        ImageWare slice = Builder.create(nx, ny, 1, image.getType());
        int t = 0;
        while (t < nt) {
            progress.increment("Normalize Level: " + t);
            image.getXY(0, 0, t, slice);
            slice.rescale();
            image.putXY(0, 0, t, slice);
            ++t;
        }
    }

    private void subtractBackground(ImageWare image, CProgressBar progress) {
        int nx = image.getSizeX();
        int ny = image.getSizeY();
        int nt = image.getSizeZ();
        double[][] slice = new double[nx][ny];
        int t = 0;
        while (t < nt) {
            progress.increment("Zero Level: " + t);
            image.getXY(0, 0, t, slice);
            double back = 0.0;
            int nb = 0;
            int i = 0;
            while (i < nx) {
                back += slice[i][0];
                back += slice[i][1];
                back += slice[i][ny - 1];
                back += slice[i][ny - 2];
                nb += 4;
                ++i;
            }
            int j = 0;
            while (j < ny) {
                back += slice[0][j];
                back += slice[1][j];
                back += slice[nx - 1][j];
                back += slice[nx - 2][j];
                nb += 4;
                ++j;
            }
            float fback = (float)(back / (double)nb);
            int j2 = 0;
            while (j2 < ny) {
                int i2 = 0;
                while (i2 < nx) {
                    double[] dArray = slice[i2];
                    int n = j2;
                    dArray[n] = dArray[n] - (double)fback;
                    slice[i2][j2] = slice[i2][j2] < 0.0 ? 0.0 : slice[i2][j2];
                    ++i2;
                }
                ++j2;
            }
            image.putXY(0, 0, t, slice);
            ++t;
        }
    }
}

