/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ScrollPanel
extends JPanel
implements AdjustmentListener {
    private JLabel lbl;
    private String prefix;
    public JScrollBar scroll;

    public ScrollPanel(int min, int max, int value, String prefix) {
        this.prefix = prefix;
        this.setLayout(new BorderLayout());
        this.scroll = new JScrollBar(0);
        this.scroll.setMinimum(0);
        this.scroll.setMaximum(max + 10);
        this.scroll.setPreferredSize(new Dimension(max, 10));
        this.scroll.addAdjustmentListener(this);
        this.lbl = new JLabel();
        this.setValue(value);
        this.add((Component)this.scroll, "West");
        this.add((Component)this.lbl, "East");
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.scroll) {
            this.setValue(this.scroll.getValue());
        }
    }

    public void setValue(int value) {
        if (this.scroll == null) {
            return;
        }
        this.scroll.setValue(value);
        DecimalFormat df = new DecimalFormat("000");
        this.lbl.setText(" " + this.prefix + df.format(value));
    }

    public int getValue() {
        return this.scroll.getValue();
    }
}

