/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.gui.GUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SetViewing
extends JFrame
implements ActionListener {
    private Properties props = new Properties();
    private String filename = String.valueOf(System.getProperty("user.dir")) + "/plugins/SpotTracker2D/SetViewing.prefs";
    public static int VIEW = 0;
    public static int NUCLEUS = 1;
    public static int NODES = 2;
    public static int SPOT = 3;
    public static int ENV = 4;
    public static int NB = 5;
    private boolean[][] value = new boolean[NB][4];
    private Color[] color = new Color[NB];
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private JButton bnOK = new JButton("OK");
    private JButton bnCancel = new JButton("Cancel");
    private JCheckBox[] chkXY = new JCheckBox[NB];
    private JCheckBox[] chkXT = new JCheckBox[NB];
    private JCheckBox[] chkTY = new JCheckBox[NB];
    private JCheckBox[] chkCT = new JCheckBox[NB];
    private JComboBox[] lstColor = new JComboBox[NB];
    String[] list = new String[]{"Red", "Green", "Blue", "Yellow", "Cyan", "Magenta", "White", "Black"};

    public SetViewing(boolean dialog) {
        super("Set Viewing");
        this.getPreferences();
        if (dialog) {
            this.doDialog();
        }
    }

    public boolean[][] getSettings() {
        return this.value;
    }

    public Color[] getColors() {
        return this.color;
    }

    private void doDialog() {
        JPanel pnSource = new JPanel();
        pnSource.setLayout(this.layout);
        int i = 0;
        while (i < NB) {
            this.chkXY[i] = new JCheckBox("XY", true);
            this.chkXT[i] = new JCheckBox("XT", true);
            this.chkTY[i] = new JCheckBox("TY", true);
            this.chkCT[i] = new JCheckBox("CT", true);
            this.lstColor[i] = new JComboBox<String>(this.list);
            ++i;
        }
        this.addComponent(pnSource, 0, 0, 1, 1, 3, new JLabel("View"));
        this.addComponent(pnSource, 0, 1, 1, 1, 3, this.chkXY[VIEW]);
        this.addComponent(pnSource, 0, 2, 1, 1, 3, this.chkXT[VIEW]);
        this.addComponent(pnSource, 0, 3, 1, 1, 3, this.chkTY[VIEW]);
        this.addComponent(pnSource, 0, 4, 1, 1, 3, this.chkCT[VIEW]);
        this.addComponent(pnSource, 2, 0, 1, 1, 3, new JLabel("Nucleus"));
        this.addComponent(pnSource, 2, 1, 1, 1, 3, this.chkXY[NUCLEUS]);
        this.addComponent(pnSource, 2, 2, 1, 1, 3, this.chkXT[NUCLEUS]);
        this.addComponent(pnSource, 2, 3, 1, 1, 3, this.chkTY[NUCLEUS]);
        this.addComponent(pnSource, 2, 4, 3, 1, 3, this.lstColor[NUCLEUS]);
        this.addComponent(pnSource, 4, 0, 1, 1, 3, new JLabel("Nodes"));
        this.addComponent(pnSource, 4, 1, 1, 1, 3, this.chkXY[NODES]);
        this.addComponent(pnSource, 4, 2, 1, 1, 3, this.chkXT[NODES]);
        this.addComponent(pnSource, 4, 3, 1, 1, 3, this.chkTY[NODES]);
        this.addComponent(pnSource, 4, 4, 1, 1, 3, this.lstColor[NODES]);
        this.addComponent(pnSource, 5, 0, 1, 1, 3, new JLabel("Spot"));
        this.addComponent(pnSource, 5, 1, 1, 1, 3, this.chkXY[SPOT]);
        this.addComponent(pnSource, 5, 2, 1, 1, 3, this.chkXT[SPOT]);
        this.addComponent(pnSource, 5, 3, 1, 1, 3, this.chkTY[SPOT]);
        this.addComponent(pnSource, 5, 4, 1, 1, 3, this.lstColor[SPOT]);
        this.addComponent(pnSource, 6, 0, 1, 1, 3, new JLabel("Enveloppe"));
        this.addComponent(pnSource, 6, 1, 1, 1, 3, this.chkXY[ENV]);
        this.addComponent(pnSource, 6, 2, 1, 1, 3, this.chkXT[ENV]);
        this.addComponent(pnSource, 6, 3, 1, 1, 3, this.chkTY[ENV]);
        this.addComponent(pnSource, 6, 4, 1, 1, 3, this.lstColor[ENV]);
        JPanel pnButton = new JPanel();
        pnButton.setLayout(this.layout);
        this.addComponent(pnButton, 0, 0, 1, 1, 3, this.bnCancel);
        this.addComponent(pnButton, 0, 1, 1, 1, 3, this.bnOK);
        JPanel pnMain = new JPanel();
        pnMain.setLayout(this.layout);
        this.addComponent(pnMain, 0, 0, 1, 1, 3, pnSource);
        this.addComponent(pnMain, 1, 0, 1, 1, 3, pnButton);
        this.bnOK.addActionListener(this);
        this.bnCancel.addActionListener(this);
        int i2 = 0;
        while (i2 < NB) {
            this.chkXY[i2].setSelected(this.value[i2][0]);
            this.chkXT[i2].setSelected(this.value[i2][1]);
            this.chkTY[i2].setSelected(this.value[i2][2]);
            this.chkCT[i2].setSelected(this.value[i2][3]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.color.length) {
            this.lstColor[i3].setSelectedIndex(this.convertColorToIndex(this.color[i3]));
            ++i3;
        }
        this.getContentPane().add(pnMain);
        this.setResizable(false);
        this.pack();
        GUI.center((Window)this);
        this.show();
    }

    private void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnCancel) {
            this.dispose();
        } else if (e.getSource() == this.bnOK) {
            int i = 0;
            while (i < NB) {
                this.value[i][0] = this.chkXY[i].isSelected();
                this.value[i][1] = this.chkXT[i].isSelected();
                this.value[i][2] = this.chkTY[i].isSelected();
                this.value[i][3] = this.chkCT[i].isSelected();
                ++i;
            }
            int i2 = 0;
            while (i2 < this.color.length) {
                this.color[i2] = this.converIndexToColor(this.lstColor[i2].getSelectedIndex());
                ++i2;
            }
            this.setPreferences();
            this.dispose();
        }
        this.notify();
    }

    private Color converIndexToColor(int index) {
        Color c = new Color(255, 0, 0);
        switch (index) {
            case 0: {
                c = Color.red;
                break;
            }
            case 1: {
                c = Color.green;
                break;
            }
            case 2: {
                c = Color.blue;
                break;
            }
            case 3: {
                c = Color.yellow;
                break;
            }
            case 4: {
                c = Color.cyan;
                break;
            }
            case 5: {
                c = Color.magenta;
                break;
            }
            case 6: {
                c = Color.white;
                break;
            }
            case 7: {
                c = Color.black;
                break;
            }
        }
        return c;
    }

    private int convertColorToIndex(Color c) {
        int index = 0;
        if (c.getRed() == 255) {
            if (c.getGreen() == 255 && c.getBlue() == 255) {
                index = 6;
            }
            if (c.getGreen() == 0 && c.getBlue() == 255) {
                index = 5;
            }
            if (c.getGreen() == 255 && c.getBlue() == 0) {
                index = 3;
            }
            if (c.getGreen() == 0 && c.getBlue() == 0) {
                index = 0;
            }
        } else {
            if (c.getGreen() == 255 && c.getBlue() == 255) {
                index = 4;
            }
            if (c.getGreen() == 0 && c.getBlue() == 255) {
                index = 2;
            }
            if (c.getGreen() == 255 && c.getBlue() == 0) {
                index = 1;
            }
            if (c.getGreen() == 0 && c.getBlue() == 0) {
                index = 7;
            }
        }
        return index;
    }

    private void getPreferences() {
        String is;
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
        }
        catch (Exception exception) {}
        int i = 0;
        while (i < NB) {
            int j = 0;
            while (j < 4) {
                is = new Integer(i).toString();
                is = "_" + is.charAt(0);
                String js = new Integer(j).toString();
                js = "_" + js.charAt(0);
                this.value[i][j] = this.props.getProperty("Enable_" + is + js, "true").equals("true");
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < NB) {
            is = new Integer(i2).toString();
            is = "_" + is.charAt(0);
            this.color[i2] = new Color(Integer.parseInt(this.props.getProperty("Color_" + is + "_R", "255")), Integer.parseInt(this.props.getProperty("Color_" + is + "_G", "0")), Integer.parseInt(this.props.getProperty("Color_" + is + "_B", "0")));
            ++i2;
        }
    }

    private void setPreferences() {
        String is;
        int i = 0;
        while (i < NB) {
            int j = 0;
            while (j < 4) {
                is = new Integer(i).toString();
                is = "_" + is.charAt(0);
                String js = new Integer(j).toString();
                js = "_" + js.charAt(0);
                this.props.setProperty("Enable_" + is + js, String.valueOf(this.value[i][j]));
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < NB) {
            is = new Integer(i2).toString();
            is = "_" + is.charAt(0);
            this.props.setProperty("Color_" + is + "_R", String.valueOf(this.color[i2].getRed()));
            this.props.setProperty("Color_" + is + "_G", String.valueOf(this.color[i2].getGreen()));
            this.props.setProperty("Color_" + is + "_B", String.valueOf(this.color[i2].getBlue()));
            ++i2;
        }
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, "Spot Tracker \n Header");
        }
        catch (Exception exception) {}
    }
}

