/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import imageware.FMath;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import spottracker2d.Handler;
import spottracker2d.PointTrack;

public class SpotTrackerImageCanvas
extends ImageCanvas {
    private ImagePlus imp;
    private Handler handler;

    public SpotTrackerImageCanvas(ImagePlus imp, Handler handler) {
        super(imp);
        this.imp = imp;
        this.handler = handler;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.handler.xspot != null) {
            Color saveColor = g.getColor();
            int z = this.imp.getCurrentSlice() - 1;
            double mag = this.getMagnification();
            Rectangle rect = this.getSrcRect();
            double off = this.handler.subpixelTrace ? 0.0 : 0.5;
            int x = FMath.round(((double)(this.handler.xspot[z] - (float)rect.x) + off) * mag);
            int y = FMath.round(((double)(this.handler.yspot[z] - (float)rect.y) + off) * mag);
            int len = FMath.ceil(this.getMagnification());
            g.setColor(Color.red);
            g.drawLine(x, y - len, x, y + len);
            g.drawLine(x - len, y, x + len, y);
            int n = 0;
            while (n < this.handler.nodes.size()) {
                PointTrack pt = (PointTrack)this.handler.nodes.get(n);
                if (pt.t == z) {
                    g.setColor(Color.green);
                    x = FMath.round(((double)(this.handler.xspot[z] - (float)rect.x) - 1.0 + off) * mag);
                    y = FMath.round(((double)(this.handler.yspot[z] - (float)rect.y) - 1.0 + off) * mag);
                    g.drawOval(x, y, 2 * len, 2 * len);
                    break;
                }
                ++n;
            }
            g.setColor(saveColor);
        }
    }
}

