/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.text.TextWindow;
import imageware.Builder;
import imageware.Display;
import imageware.ImageWare;
import spottracker2d.Handler;
import spottracker2d.PointTrack;

public class TableResults {
    public static void showSummTable(Handler handler) {
        int nx = handler.volAlign.getSizeX();
        int ny = handler.volAlign.getSizeY();
        int xsize = 300;
        String headings = "";
        headings = String.valueOf(headings) + "spotx\tspoty\t";
        if (handler.align) {
            headings = String.valueOf(headings) + "centerx\tcentery";
        }
        TextWindow tw = new TextWindow("Spot Results", "", xsize, 500);
        tw.getTextPanel().setColumnHeadings(headings);
        String msg = "";
        int k = 0;
        while (k < handler.xspot.length) {
            msg = "";
            if (handler.xspot != null) {
                msg = String.valueOf(msg) + IJ.d2s((double)((double)(handler.xspot[k] - (float)(nx / 2)) + handler.nucleus[k][0]), (int)1);
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)((double)(handler.yspot[k] - (float)(ny / 2)) + handler.nucleus[k][1]), (int)1);
            }
            if (handler.align) {
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.nucleus[k][0], (int)1);
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.nucleus[k][1], (int)1);
            }
            tw.append(msg);
            ++k;
        }
    }

    public static void showDirectTable(Handler handler) {
        int nx = handler.volAlign.getSizeX();
        int ny = handler.volAlign.getSizeY();
        int xsize = 300;
        String headings = "";
        headings = String.valueOf(headings) + "image\tx spot [px]\ty spot [px]\tConfidence [[]";
        if (handler.align) {
            headings = String.valueOf(headings) + "centerx\tcentery";
        }
        TextWindow tw = new TextWindow("Spot Tracker Results", "", xsize, 500);
        tw.getTextPanel().setColumnHeadings(headings);
        String msg = "";
        int k = 0;
        while (k < handler.xspot.length) {
            msg = "";
            if (handler.xspot != null) {
                msg = String.valueOf(msg) + (k + 1) + "\t" + IJ.d2s((double)handler.xspot[k], (int)2);
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.yspot[k], (int)2);
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.vspot[k], (int)0);
            }
            tw.append(msg);
            ++k;
        }
    }

    public static void showFullTable(Handler handler) {
        int nx = handler.volAlign.getSizeX();
        int ny = handler.volAlign.getSizeY();
        int xsize = 200;
        String headings = "Image\t";
        headings = String.valueOf(headings) + "xspot\tyspot\tXSpot\tYSpot\t";
        if (handler.align && handler.nbz > 1) {
            headings = String.valueOf(headings) + "ZSpot\t";
        }
        if (handler.align) {
            headings = String.valueOf(headings) + "XNucleus\tYNucleus\t";
        }
        headings = String.valueOf(headings) + "Score\t";
        TextWindow tw = new TextWindow("Spot Results", "", xsize += 250, 500);
        tw.getTextPanel().setColumnHeadings(headings);
        String msg = "";
        int k = 0;
        while (k < handler.xspot.length) {
            msg = String.valueOf(k);
            if (handler.xspot != null) {
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)((double)(handler.xspot[k] - (float)(nx / 2)) + handler.nucleus[k][0]), (int)1);
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)((double)(handler.yspot[k] - (float)(ny / 2)) + handler.nucleus[k][1]), (int)1);
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.xspot[k], (int)1);
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.yspot[k], (int)1);
            }
            if (handler.align && handler.nbz > 1) {
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.nucleus[k][2], (int)1);
            }
            if (handler.align) {
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.nucleus[k][0], (int)1);
            }
            if (handler.align) {
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.nucleus[k][1], (int)1);
            }
            if (handler.xspot != null) {
                msg = String.valueOf(msg) + "\t" + IJ.d2s((double)handler.vspot[k], (int)0);
            }
            tw.append(msg);
            ++k;
        }
    }

    public static void showStack(Handler handler, double zoom, int sizeSpot) {
        int[] constraintPointTime = null;
        if (handler.xspot != null) {
            constraintPointTime = new int[handler.nodes.size()];
            int c = 0;
            while (c < constraintPointTime.length) {
                PointTrack pt = (PointTrack)handler.nodes.elementAt(c);
                constraintPointTime[c] = pt.t;
                ++c;
            }
        }
        int nx = handler.volSource.getSizeX();
        int ny = handler.volSource.getSizeY();
        int nt = handler.volSource.getSizeZ();
        boolean offAlign = false;
        ImageWare red = handler.volSource.duplicate();
        ImageWare green = handler.volSource.duplicate();
        ImageWare blue = handler.volSource.duplicate();
        int zi = TableResults.round(zoom);
        ImageWare zred = Builder.create(nx * zi, ny * zi, nt, 1);
        ImageWare zgreen = Builder.create(nx * zi, ny * zi, nt, 1);
        ImageWare zblue = Builder.create(nx * zi, ny * zi, nt, 1);
        double[][] rarray = new double[nx][ny];
        double[][] garray = new double[nx][ny];
        double[][] rblock = new double[zi][zi];
        double[][] gblock = new double[zi][zi];
        int t = 0;
        while (t < nt) {
            red.getXY(0, 0, t, rarray);
            green.getXY(0, 0, t, garray);
            int i = 0;
            while (i < nx) {
                int j = 0;
                while (j < ny) {
                    int k = 0;
                    while (k < zi) {
                        int l = 0;
                        while (l < zi) {
                            rblock[k][l] = rarray[i][j];
                            gblock[k][l] = garray[i][j];
                            ++l;
                        }
                        ++k;
                    }
                    zgreen.putXY(i * zi, j * zi, t, gblock);
                    ++j;
                }
                ++i;
            }
            ++t;
        }
        double rcolor1 = 255.0;
        double gcolor1 = 0.0;
        double bcolor1 = 0.0;
        int lencross = TableResults.round(1.5 * zoom);
        int t2 = 0;
        while (t2 < nt) {
            if (handler.xspot != null) {
                double xz = (double)handler.xspot[t2] * zoom;
                double yz = (double)handler.yspot[t2] * zoom;
                if (handler.align) {
                    xz += (handler.nucleus[t2][0] - (double)(nx / 2)) * zoom;
                    yz += (handler.nucleus[t2][1] - (double)(ny / 2)) * zoom;
                }
                int x = TableResults.round(xz);
                int y = TableResults.round(yz);
                int k = -lencross;
                while (k <= lencross) {
                    zred.putPixel(x + k, y, t2, 255.0);
                    zgreen.putPixel(x + k, y, t2, gcolor1);
                    zred.putPixel(x, y + k, t2, 255.0);
                    zgreen.putPixel(x, y - k, t2, gcolor1);
                    ++k;
                }
            }
            ++t2;
        }
        Display.showColor("Path", zred, zgreen, zblue);
    }

    private static int round(double f) {
        double f05 = f + 0.5;
        if (f05 >= 0.0) {
            return (int)f05;
        }
        int iAdd = (int)f05 - 1;
        return (int)(f05 - (double)iAdd) + iAdd;
    }
}

