/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import imageware.ImageWare;

public class Display {
    public static void show(String string, ImageWare imageWare) {
        new ImagePlus(string, imageWare.buildImageStack()).show();
    }

    public static void showColor(String string, ImageWare imageWare, ImageWare imageWare2, ImageWare imageWare3) {
        new ImagePlus(string, Display.buildColor(imageWare, imageWare2, imageWare3)).show();
    }

    public static void show(String string, ImageWare imageWare, double d) {
        ImagePlus imagePlus = new ImagePlus(string, imageWare.buildImageStack());
        imagePlus.show();
        ImageWindow imageWindow = imagePlus.getWindow();
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        imageCanvas.setMagnification(d);
        imageCanvas.setDrawingSize((int)Math.ceil((double)imageWare.getWidth() * d), (int)Math.ceil((double)imageWare.getHeight() * d));
        imageWindow.pack();
        imagePlus.updateAndRepaintWindow();
    }

    public static void showColor(String string, ImageWare imageWare, ImageWare imageWare2, ImageWare imageWare3, double d) {
        ImagePlus imagePlus = new ImagePlus(string, Display.buildColor(imageWare, imageWare2, imageWare3));
        imagePlus.show();
        ImageWindow imageWindow = imagePlus.getWindow();
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        imageCanvas.setMagnification(d);
        imageCanvas.setDrawingSize((int)Math.ceil((double)imageWare.getWidth() * d), (int)Math.ceil((double)imageWare.getHeight() * d));
        imageWindow.pack();
        imagePlus.updateAndRepaintWindow();
    }

    private static ImageStack buildColor(ImageWare imageWare, ImageWare imageWare2, ImageWare imageWare3) {
        if (!imageWare.isSameSize(imageWare2)) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to create a ImageStack the channel are not the same size.\n[" + imageWare.getSizeX() + "," + imageWare.getSizeY() + "," + imageWare.getSizeZ() + "] != " + "[" + imageWare2.getSizeX() + "," + imageWare2.getSizeY() + "," + imageWare2.getSizeZ() + "].\n" + "-------------------------------------------------------\n");
        }
        if (!imageWare.isSameSize(imageWare3)) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to create a ImageStack the channel are not the same size.\n[" + imageWare.getSizeX() + "," + imageWare.getSizeY() + "," + imageWare.getSizeZ() + "] != " + "[" + imageWare3.getSizeX() + "," + imageWare3.getSizeY() + "," + imageWare3.getSizeZ() + "].\n" + "-------------------------------------------------------\n");
        }
        int n = imageWare.getSizeX();
        int n2 = imageWare.getSizeY();
        int n3 = imageWare.getSizeZ();
        int n4 = n * n2;
        ImageStack imageStack = new ImageStack(n, n2);
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            double[] dArray;
            ColorProcessor colorProcessor = new ColorProcessor(n, n2);
            switch (imageWare.getType()) {
                case 4: {
                    dArray = imageWare.getSliceDouble(n5);
                    int n7 = 0;
                    while (n7 < n4) {
                        byArray[n7] = (byte)dArray[n7];
                        ++n7;
                    }
                    break;
                }
                case 3: {
                    float[] fArray = imageWare.getSliceFloat(n5);
                    int n8 = 0;
                    while (n8 < n4) {
                        byArray[n8] = (byte)fArray[n8];
                        ++n8;
                    }
                    break;
                }
                case 2: {
                    short[] sArray = imageWare.getSliceShort(n5);
                    n6 = 0;
                    while (n6 < n4) {
                        byArray[n6] = (byte)sArray[n6];
                        ++n6;
                    }
                    break;
                }
                case 1: {
                    byArray = imageWare.getSliceByte(n5);
                    break;
                }
            }
            switch (imageWare2.getType()) {
                case 4: {
                    dArray = imageWare2.getSliceDouble(n5);
                    int n9 = 0;
                    while (n9 < n4) {
                        byArray2[n9] = (byte)dArray[n9];
                        ++n9;
                    }
                    break;
                }
                case 3: {
                    float[] fArray = imageWare2.getSliceFloat(n5);
                    int n10 = 0;
                    while (n10 < n4) {
                        byArray2[n10] = (byte)fArray[n10];
                        ++n10;
                    }
                    break;
                }
                case 2: {
                    short[] sArray = imageWare2.getSliceShort(n5);
                    n6 = 0;
                    while (n6 < n4) {
                        byArray2[n6] = (byte)sArray[n6];
                        ++n6;
                    }
                    break;
                }
                case 1: {
                    byArray2 = imageWare2.getSliceByte(n5);
                    break;
                }
            }
            switch (imageWare3.getType()) {
                case 4: {
                    dArray = imageWare3.getSliceDouble(n5);
                    int n11 = 0;
                    while (n11 < n4) {
                        byArray3[n11] = (byte)dArray[n11];
                        ++n11;
                    }
                    break;
                }
                case 3: {
                    float[] fArray = imageWare3.getSliceFloat(n5);
                    int n12 = 0;
                    while (n12 < n4) {
                        byArray3[n12] = (byte)fArray[n12];
                        ++n12;
                    }
                    break;
                }
                case 2: {
                    short[] sArray = imageWare3.getSliceShort(n5);
                    n6 = 0;
                    while (n6 < n4) {
                        byArray3[n6] = (byte)sArray[n6];
                        ++n6;
                    }
                    break;
                }
                case 1: {
                    byArray3 = imageWare3.getSliceByte(n5);
                    break;
                }
            }
            colorProcessor.setRGB(byArray, byArray2, byArray3);
            imageStack.addSlice(String.valueOf(n5), (ImageProcessor)colorProcessor);
            ++n5;
        }
        return imageStack;
    }
}

