/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import imageware.Buffer;
import imageware.ImageWare;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;

public class ShortBuffer
implements Buffer {
    protected Object[] data = null;
    protected int nx = 0;
    protected int ny = 0;
    protected int nz = 0;
    protected int nxy = 0;

    protected ShortBuffer(int n, int n2, int n3) {
        this.nx = n;
        this.ny = n2;
        this.nz = n3;
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            this.throw_constructor(n, n2, n3);
        }
        this.allocate();
    }

    protected ShortBuffer(Image image, int n) {
        if (image == null) {
            this.throw_constructor();
        }
        ImageObserver imageObserver = null;
        this.nx = image.getWidth(imageObserver);
        this.ny = image.getHeight(imageObserver);
        this.nz = 1;
        this.nxy = this.nx * this.ny;
        byte[] byArray = new byte[this.nxy];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.nx, this.ny, false);
        try {
            pixelGrabber.grabPixels();
            byArray = (byte[])pixelGrabber.getPixels();
        }
        catch (Exception exception) {
            this.throw_constructor();
        }
        this.allocate();
        int n2 = 0;
        while (n2 < this.nxy) {
            ((short[])this.data[0])[n2] = (short)(byArray[n2] & 0xFF);
            ++n2;
        }
    }

    protected ShortBuffer(ImageStack imageStack, int n) {
        if (imageStack == null) {
            this.throw_constructor();
        }
        this.nx = imageStack.getWidth();
        this.ny = imageStack.getHeight();
        this.nz = imageStack.getSize();
        this.nxy = this.nx * this.ny;
        switch (n) {
            case 2: {
                this.data = imageStack.getImageArray();
                break;
            }
            case 1: {
                this.allocate();
                ImageProcessor imageProcessor = imageStack.getProcessor(1);
                if (imageProcessor instanceof ByteProcessor) {
                    Object[] objectArray = imageStack.getImageArray();
                    int n2 = 0;
                    while (n2 < this.nz) {
                        byte[] byArray = (byte[])objectArray[n2];
                        int n3 = 0;
                        while (n3 < this.nxy) {
                            ((short[])this.data[n2])[n3] = (short)(byArray[n3] & 0xFF);
                            ++n3;
                        }
                        ++n2;
                    }
                    break;
                }
                if (imageProcessor instanceof ShortProcessor) {
                    Object[] objectArray = imageStack.getImageArray();
                    int n4 = 0;
                    while (n4 < this.nz) {
                        short[] sArray = (short[])objectArray[n4];
                        int n5 = 0;
                        while (n5 < this.nxy) {
                            ((short[])this.data[n4])[n5] = (short)(sArray[n5] & 0xFFFF);
                            ++n5;
                        }
                        ++n4;
                    }
                    break;
                }
                if (imageProcessor instanceof FloatProcessor) {
                    Object[] objectArray = imageStack.getImageArray();
                    int n6 = 0;
                    while (n6 < this.nz) {
                        float[] fArray = (float[])objectArray[n6];
                        int n7 = 0;
                        while (n7 < this.nxy) {
                            ((short[])this.data[n6])[n7] = (short)fArray[n7];
                            ++n7;
                        }
                        ++n6;
                    }
                    break;
                }
                if (imageProcessor instanceof ColorProcessor) {
                    int n8 = 0;
                    while (n8 < this.nz) {
                        ColorProcessor colorProcessor = (ColorProcessor)imageStack.getProcessor(n8 + 1);
                        int[] nArray = (int[])colorProcessor.getPixels();
                        int n9 = 0;
                        while (n9 < this.nxy) {
                            int n10 = nArray[n9];
                            double d = (n10 & 0xFF0000) >> 16;
                            double d2 = (n10 & 0xFF00) >> 8;
                            double d3 = n10 & 0xFF;
                            ((short[])this.data[n8])[n9] = (short)((d + d2 + d3) / 3.0);
                            ++n9;
                        }
                        ++n8;
                    }
                    break;
                }
                this.throw_constructor();
                break;
            }
            default: {
                this.throw_constructor();
            }
        }
    }

    protected ShortBuffer(ImageStack imageStack, byte by) {
        if (imageStack == null) {
            this.throw_constructor();
        }
        this.nx = imageStack.getWidth();
        this.ny = imageStack.getHeight();
        this.nz = imageStack.getSize();
        this.nxy = this.nx * this.ny;
        this.allocate();
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        if (imageProcessor instanceof ByteProcessor) {
            Object[] objectArray = imageStack.getImageArray();
            int n = 0;
            while (n < this.nz) {
                byte[] byArray = (byte[])objectArray[n];
                int n2 = 0;
                while (n2 < this.nxy) {
                    ((short[])this.data[n])[n2] = (short)(byArray[n2] & 0xFF);
                    ++n2;
                }
                ++n;
            }
        } else if (imageProcessor instanceof ShortProcessor) {
            Object[] objectArray = imageStack.getImageArray();
            int n = 0;
            while (n < this.nz) {
                short[] sArray = (short[])objectArray[n];
                int n3 = 0;
                while (n3 < this.nxy) {
                    ((short[])this.data[n])[n3] = (short)(sArray[n3] & 0xFFFF);
                    ++n3;
                }
                ++n;
            }
        } else if (imageProcessor instanceof FloatProcessor) {
            Object[] objectArray = imageStack.getImageArray();
            int n = 0;
            while (n < this.nz) {
                float[] fArray = (float[])objectArray[n];
                int n4 = 0;
                while (n4 < this.nxy) {
                    ((short[])this.data[n])[n4] = (short)fArray[n4];
                    ++n4;
                }
                ++n;
            }
        } else if (imageProcessor instanceof ColorProcessor) {
            int n = 0;
            while (n < this.nz) {
                ColorProcessor colorProcessor = (ColorProcessor)imageStack.getProcessor(n + 1);
                int[] nArray = (int[])colorProcessor.getPixels();
                switch (by) {
                    case 0: {
                        int n5 = 0;
                        while (n5 < this.nxy) {
                            ((short[])this.data[n])[n5] = (short)((nArray[n5] & 0xFF0000) >> 16);
                            ++n5;
                        }
                        break;
                    }
                    case 1: {
                        int n5 = 0;
                        while (n5 < this.nxy) {
                            ((short[])this.data[n])[n5] = (short)((nArray[n5] & 0xFF00) >> 8);
                            ++n5;
                        }
                        break;
                    }
                    case 2: {
                        int n5 = 0;
                        while (n5 < this.nxy) {
                            ((short[])this.data[n])[n5] = (short)(nArray[n5] & 0xFF);
                            ++n5;
                        }
                        break;
                    }
                    default: {
                        this.throw_constructor();
                    }
                }
                ++n;
            }
        } else {
            this.throw_constructor();
        }
    }

    protected ShortBuffer(byte[] byArray, int n) {
        if (byArray == null) {
            this.throw_constructor();
        }
        this.nx = byArray.length;
        this.ny = 1;
        this.nz = 1;
        this.allocate();
        this.putX(0, 0, 0, byArray);
    }

    protected ShortBuffer(byte[][] byArray, int n) {
        if (byArray == null) {
            this.throw_constructor();
        }
        this.nx = byArray.length;
        this.ny = byArray[0].length;
        this.nz = 1;
        this.allocate();
        this.putXY(0, 0, 0, byArray);
    }

    protected ShortBuffer(byte[][][] byArray, int n) {
        if (byArray == null) {
            this.throw_constructor();
        }
        this.nx = byArray.length;
        this.ny = byArray[0].length;
        this.nz = byArray[0][0].length;
        this.allocate();
        this.putXYZ(0, 0, 0, byArray);
    }

    protected ShortBuffer(short[] sArray, int n) {
        if (sArray == null) {
            this.throw_constructor();
        }
        this.nx = sArray.length;
        this.ny = 1;
        this.nz = 1;
        this.allocate();
        this.putX(0, 0, 0, sArray);
    }

    protected ShortBuffer(short[][] sArray, int n) {
        if (sArray == null) {
            this.throw_constructor();
        }
        this.nx = sArray.length;
        this.ny = sArray[0].length;
        this.nz = 1;
        this.allocate();
        this.putXY(0, 0, 0, sArray);
    }

    protected ShortBuffer(short[][][] sArray, int n) {
        if (sArray == null) {
            this.throw_constructor();
        }
        this.nx = sArray.length;
        this.ny = sArray[0].length;
        this.nz = sArray[0][0].length;
        this.allocate();
        this.putXYZ(0, 0, 0, sArray);
    }

    protected ShortBuffer(float[] fArray, int n) {
        if (fArray == null) {
            this.throw_constructor();
        }
        this.nx = fArray.length;
        this.ny = 1;
        this.nz = 1;
        this.allocate();
        this.putX(0, 0, 0, fArray);
    }

    protected ShortBuffer(float[][] fArray, int n) {
        if (fArray == null) {
            this.throw_constructor();
        }
        this.nx = fArray.length;
        this.ny = fArray[0].length;
        this.nz = 1;
        this.allocate();
        this.putXY(0, 0, 0, fArray);
    }

    protected ShortBuffer(float[][][] fArray, int n) {
        if (fArray == null) {
            this.throw_constructor();
        }
        this.nx = fArray.length;
        this.ny = fArray[0].length;
        this.nz = fArray[0][0].length;
        this.allocate();
        this.putXYZ(0, 0, 0, fArray);
    }

    protected ShortBuffer(double[] dArray, int n) {
        if (dArray == null) {
            this.throw_constructor();
        }
        this.nx = dArray.length;
        this.ny = 1;
        this.nz = 1;
        this.allocate();
        this.putX(0, 0, 0, dArray);
    }

    protected ShortBuffer(double[][] dArray, int n) {
        if (dArray == null) {
            this.throw_constructor();
        }
        this.nx = dArray.length;
        this.ny = dArray[0].length;
        this.nz = 1;
        this.allocate();
        this.putXY(0, 0, 0, dArray);
    }

    protected ShortBuffer(double[][][] dArray, int n) {
        if (dArray == null) {
            this.throw_constructor();
        }
        this.nx = dArray.length;
        this.ny = dArray[0].length;
        this.nz = dArray[0][0].length;
        this.allocate();
        this.putXYZ(0, 0, 0, dArray);
    }

    public int getType() {
        return 2;
    }

    public String getTypeToString() {
        return "Short";
    }

    public int getDimension() {
        int n = 0;
        n += this.nx > 1 ? 1 : 0;
        n += this.ny > 1 ? 1 : 0;
        return n += this.nz > 1 ? 1 : 0;
    }

    public int[] getSize() {
        int[] nArray = new int[]{this.nx, this.ny, this.nz};
        return nArray;
    }

    public int getSizeX() {
        return this.nx;
    }

    public int getSizeY() {
        return this.ny;
    }

    public int getSizeZ() {
        return this.nz;
    }

    public int getWidth() {
        return this.nx;
    }

    public int getHeight() {
        return this.ny;
    }

    public int getDepth() {
        return this.nz;
    }

    public int getTotalSize() {
        return this.nxy * this.nz;
    }

    public boolean isSameSize(ImageWare imageWare) {
        if (this.nx != imageWare.getSizeX()) {
            return false;
        }
        if (this.ny != imageWare.getSizeY()) {
            return false;
        }
        return this.nz == imageWare.getSizeZ();
    }

    public void putX(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeX();
        double[] dArray = new double[n4];
        imageWare.getX(0, 0, 0, dArray);
        this.putX(n, n2, n3, dArray);
    }

    public void putY(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeY();
        double[] dArray = new double[n4];
        imageWare.getY(0, 0, 0, dArray);
        this.putY(n, n2, n3, dArray);
    }

    public void putZ(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeZ();
        double[] dArray = new double[n4];
        imageWare.getZ(0, 0, 0, dArray);
        this.putZ(n, n2, n3, dArray);
    }

    public void putXY(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeX();
        int n5 = imageWare.getSizeY();
        double[][] dArray = new double[n4][n5];
        imageWare.getXY(0, 0, 0, dArray);
        this.putXY(n, n2, n3, dArray);
    }

    public void putXZ(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeX();
        int n5 = imageWare.getSizeZ();
        double[][] dArray = new double[n4][n5];
        imageWare.getXZ(0, 0, 0, dArray);
        this.putXZ(n, n2, n3, dArray);
    }

    public void putYZ(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeY();
        int n5 = imageWare.getSizeZ();
        double[][] dArray = new double[n4][n5];
        imageWare.getYZ(0, 0, 0, dArray);
        this.putYZ(n, n2, n3, dArray);
    }

    public void putXYZ(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeX();
        int n5 = imageWare.getSizeY();
        int n6 = imageWare.getSizeZ();
        double[][][] dArray = new double[n4][n5][n6];
        imageWare.getXYZ(0, 0, 0, dArray);
        this.putXYZ(n, n2, n3, dArray);
    }

    public void putX(int n, int n2, int n3, byte[] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                sArray[n4] = (short)(byArray[n6] & 0xFF);
                ++n4;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("X", "No check", byArray, n, n2, n3);
        }
    }

    public void putX(int n, int n2, int n3, short[] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            short[] sArray2 = (short[])this.data[n3];
            System.arraycopy(sArray, 0, sArray2, n4, n5);
        }
        catch (Exception exception) {
            this.throw_put("X", "No check", sArray, n, n2, n3);
        }
    }

    public void putX(int n, int n2, int n3, float[] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                sArray[n4] = (short)fArray[n6];
                ++n4;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("X", "No check", fArray, n, n2, n3);
        }
    }

    public void putX(int n, int n2, int n3, double[] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                sArray[n4] = (short)dArray[n6];
                ++n4;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("X", "No check", dArray, n, n2, n3);
        }
    }

    public void putY(int n, int n2, int n3, byte[] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                sArray[n4] = (short)(byArray[n6] & 0xFF);
                n4 += this.nx;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("Y", "No check", byArray, n, n2, n3);
        }
    }

    public void putY(int n, int n2, int n3, short[] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            short[] sArray2 = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                sArray2[n4] = (short)(sArray[n6] & 0xFFFF);
                n4 += this.nx;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("Y", "No check", sArray, n, n2, n3);
        }
    }

    public void putY(int n, int n2, int n3, float[] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                sArray[n4] = (short)fArray[n6];
                n4 += this.nx;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("Y", "No check", fArray, n, n2, n3);
        }
    }

    public void putY(int n, int n2, int n3, double[] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                sArray[n4] = (short)dArray[n6];
                n4 += this.nx;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("Y", "No check", dArray, n, n2, n3);
        }
    }

    public void putZ(int n, int n2, int n3, byte[] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = 0;
            while (n6 < n5) {
                ((short[])this.data[n3])[n4] = (short)(byArray[n6] & 0xFF);
                ++n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("Z", "No check", byArray, n, n2, n3);
        }
    }

    public void putZ(int n, int n2, int n3, short[] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = 0;
            while (n6 < n5) {
                ((short[])this.data[n3])[n4] = (short)(sArray[n6] & 0xFFFF);
                ++n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("Z", "No check", sArray, n, n2, n3);
        }
    }

    public void putZ(int n, int n2, int n3, float[] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = 0;
            while (n6 < n5) {
                ((short[])this.data[n3])[n4] = (short)fArray[n6];
                ++n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("Z", "No check", fArray, n, n2, n3);
        }
    }

    public void putZ(int n, int n2, int n3, double[] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = 0;
            while (n6 < n5) {
                ((short[])this.data[n3])[n4] = (short)dArray[n6];
                ++n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_put("Z", "No check", dArray, n, n2, n3);
        }
    }

    public void putXY(int n, int n2, int n3, byte[][] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = byArray[0].length;
            short[] sArray = (short[])this.data[n3];
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + (n2 + n7) * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n4] = (short)(byArray[n8][n7] & 0xFF);
                    ++n8;
                    ++n4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            this.throw_put("XY", "No check", byArray, n, n2, n3);
        }
    }

    public void putXY(int n, int n2, int n3, short[][] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = sArray[0].length;
            short[] sArray2 = (short[])this.data[n3];
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + (n2 + n7) * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    sArray2[n4] = (short)(sArray[n8][n7] & 0xFFFF);
                    ++n8;
                    ++n4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            this.throw_put("XY", "No check", sArray, n, n2, n3);
        }
    }

    public void putXY(int n, int n2, int n3, float[][] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = fArray[0].length;
            short[] sArray = (short[])this.data[n3];
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + (n2 + n7) * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n4] = (short)fArray[n8][n7];
                    ++n8;
                    ++n4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            this.throw_put("XY", "No check", fArray, n, n2, n3);
        }
    }

    public void putXY(int n, int n2, int n3, double[][] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = dArray[0].length;
            short[] sArray = (short[])this.data[n3];
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + (n2 + n7) * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n4] = (short)dArray[n8][n7];
                    ++n8;
                    ++n4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            this.throw_put("XY", "No check", dArray, n, n2, n3);
        }
    }

    public void putXZ(int n, int n2, int n3, byte[][] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = byArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + n7 * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    ((short[])this.data[n3])[n4] = (short)(byArray[n8][n7] & 0xFF);
                    ++n8;
                    ++n4;
                }
                ++n7;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_put("YZ", "No check", byArray, n, n2, n3);
        }
    }

    public void putXZ(int n, int n2, int n3, short[][] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = sArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + n7 * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    ((short[])this.data[n3])[n4] = (short)(sArray[n8][n7] & 0xFFFF);
                    ++n8;
                    ++n4;
                }
                ++n7;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_put("YZ", "No check", sArray, n, n2, n3);
        }
    }

    public void putXZ(int n, int n2, int n3, float[][] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = fArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + n7 * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    ((short[])this.data[n3])[n4] = (short)fArray[n8][n7];
                    ++n8;
                    ++n4;
                }
                ++n7;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_put("YZ", "No check", fArray, n, n2, n3);
        }
    }

    public void putXZ(int n, int n2, int n3, double[][] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = dArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + n7 * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    ((short[])this.data[n3])[n4] = (short)dArray[n8][n7];
                    ++n8;
                    ++n4;
                }
                ++n7;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_put("YZ", "No check", dArray, n, n2, n3);
        }
    }

    public void putYZ(int n, int n2, int n3, byte[][] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = byArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    ((short[])this.data[n3])[n4] = (short)(byArray[n8][n7] & 0xFF);
                    ++n8;
                    n4 += this.nx;
                }
                ++n7;
                ++n3;
                n4 = n + this.nx * n2;
            }
        }
        catch (Exception exception) {
            this.throw_put("XZ", "No check", byArray, n, n2, n3);
        }
    }

    public void putYZ(int n, int n2, int n3, short[][] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = sArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    ((short[])this.data[n3])[n4] = (short)(sArray[n8][n7] & 0xFFFF);
                    ++n8;
                    n4 += this.nx;
                }
                ++n7;
                ++n3;
                n4 = n + this.nx * n2;
            }
        }
        catch (Exception exception) {
            this.throw_put("XZ", "No check", sArray, n, n2, n3);
        }
    }

    public void putYZ(int n, int n2, int n3, float[][] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = fArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    ((short[])this.data[n3])[n4] = (short)fArray[n8][n7];
                    ++n8;
                    n4 += this.nx;
                }
                ++n7;
                ++n3;
                n4 = n + this.nx * n2;
            }
        }
        catch (Exception exception) {
            this.throw_put("XZ", "No check", fArray, n, n2, n3);
        }
    }

    public void putYZ(int n, int n2, int n3, double[][] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = dArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    ((short[])this.data[n3])[n4] = (short)dArray[n8][n7];
                    ++n8;
                    n4 += this.nx;
                }
                ++n7;
                ++n3;
                n4 = n + this.nx * n2;
            }
        }
        catch (Exception exception) {
            this.throw_put("XZ", "No check", dArray, n, n2, n3);
        }
    }

    public void putXYZ(int n, int n2, int n3, byte[][][] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = byArray[0].length;
            int n7 = byArray[0][0].length;
            int n8 = 0;
            while (n8 < n7) {
                short[] sArray = (short[])this.data[n3];
                int n9 = 0;
                while (n9 < n6) {
                    n4 = n + (n9 + n2) * this.nx;
                    int n10 = 0;
                    while (n10 < n5) {
                        sArray[n4] = (short)(byArray[n10][n9][n8] & 0xFF);
                        ++n10;
                        ++n4;
                    }
                    ++n9;
                }
                ++n8;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_put("XYZ", "No check", byArray, n, n2, n3);
        }
    }

    public void putXYZ(int n, int n2, int n3, short[][][] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = sArray[0].length;
            int n7 = sArray[0][0].length;
            int n8 = 0;
            while (n8 < n7) {
                short[] sArray2 = (short[])this.data[n3];
                int n9 = 0;
                while (n9 < n6) {
                    n4 = n + (n9 + n2) * this.nx;
                    int n10 = 0;
                    while (n10 < n5) {
                        sArray2[n4] = (short)(sArray[n10][n9][n8] & 0xFFFF);
                        ++n10;
                        ++n4;
                    }
                    ++n9;
                }
                ++n8;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_put("XYZ", "No check", sArray, n, n2, n3);
        }
    }

    public void putXYZ(int n, int n2, int n3, float[][][] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = fArray[0].length;
            int n7 = fArray[0][0].length;
            int n8 = 0;
            while (n8 < n7) {
                short[] sArray = (short[])this.data[n3];
                int n9 = 0;
                while (n9 < n6) {
                    n4 = n + (n9 + n2) * this.nx;
                    int n10 = 0;
                    while (n10 < n5) {
                        sArray[n4] = (short)fArray[n10][n9][n8];
                        ++n10;
                        ++n4;
                    }
                    ++n9;
                }
                ++n8;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_put("XYZ", "No check", fArray, n, n2, n3);
        }
    }

    public void putXYZ(int n, int n2, int n3, double[][][] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = dArray[0].length;
            int n7 = dArray[0][0].length;
            int n8 = 0;
            while (n8 < n7) {
                short[] sArray = (short[])this.data[n3];
                int n9 = 0;
                while (n9 < n6) {
                    n4 = n + (n9 + n2) * this.nx;
                    int n10 = 0;
                    while (n10 < n5) {
                        sArray[n4] = (short)dArray[n10][n9][n8];
                        ++n10;
                        ++n4;
                    }
                    ++n9;
                }
                ++n8;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_put("XYZ", "No check", dArray, n, n2, n3);
        }
    }

    public void getX(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeX();
        double[] dArray = new double[n4];
        this.getX(n, n2, n3, dArray);
        imageWare.putX(0, 0, 0, dArray);
    }

    public void getY(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeY();
        double[] dArray = new double[n4];
        this.getY(n, n2, n3, dArray);
        imageWare.putY(0, 0, 0, dArray);
    }

    public void getZ(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeZ();
        double[] dArray = new double[n4];
        this.getZ(n, n2, n3, dArray);
        imageWare.putZ(0, 0, 0, dArray);
    }

    public void getXY(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeX();
        int n5 = imageWare.getSizeY();
        double[][] dArray = new double[n4][n5];
        this.getXY(n, n2, n3, dArray);
        imageWare.putXY(0, 0, 0, dArray);
    }

    public void getXZ(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeX();
        int n5 = imageWare.getSizeZ();
        double[][] dArray = new double[n4][n5];
        this.getXZ(n, n2, n3, dArray);
        imageWare.putXZ(0, 0, 0, dArray);
    }

    public void getYZ(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeY();
        int n5 = imageWare.getSizeZ();
        double[][] dArray = new double[n4][n5];
        this.getYZ(n, n2, n3, dArray);
        imageWare.putYZ(0, 0, 0, dArray);
    }

    public void getXYZ(int n, int n2, int n3, ImageWare imageWare) {
        int n4 = imageWare.getSizeX();
        int n5 = imageWare.getSizeY();
        int n6 = imageWare.getSizeZ();
        double[][][] dArray = new double[n4][n5][n6];
        this.getXYZ(n, n2, n3, dArray);
        imageWare.putXYZ(0, 0, 0, dArray);
    }

    public void getX(int n, int n2, int n3, byte[] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                byArray[n6] = (byte)(sArray[n4] & 0xFFFF);
                ++n4;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "No check", byArray, n, n2, n3);
        }
    }

    public void getX(int n, int n2, int n3, short[] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            short[] sArray2 = (short[])this.data[n3];
            System.arraycopy(sArray2, n4, sArray, 0, n5);
        }
        catch (Exception exception) {
            this.throw_get("X", "No check", sArray, n, n2, n3);
        }
    }

    public void getX(int n, int n2, int n3, float[] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                fArray[n6] = sArray[n4] & 0xFFFF;
                ++n4;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "No check", fArray, n, n2, n3);
        }
    }

    public void getX(int n, int n2, int n3, double[] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                dArray[n6] = sArray[n4] & 0xFFFF;
                ++n4;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "No check", dArray, n, n2, n3);
        }
    }

    public void getY(int n, int n2, int n3, byte[] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                byArray[n6] = (byte)(sArray[n4] & 0xFFFF);
                n4 += this.nx;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "No check", byArray, n, n2, n3);
        }
    }

    public void getY(int n, int n2, int n3, short[] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            short[] sArray2 = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                sArray[n6] = (short)(sArray2[n4] & 0xFFFF);
                n4 += this.nx;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "No check", sArray, n, n2, n3);
        }
    }

    public void getY(int n, int n2, int n3, float[] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                fArray[n6] = sArray[n4] & 0xFFFF;
                n4 += this.nx;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "No check", fArray, n, n2, n3);
        }
    }

    public void getY(int n, int n2, int n3, double[] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            short[] sArray = (short[])this.data[n3];
            int n6 = 0;
            while (n6 < n5) {
                dArray[n6] = sArray[n4] & 0xFFFF;
                n4 += this.nx;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "No check", dArray, n, n2, n3);
        }
    }

    public void getZ(int n, int n2, int n3, byte[] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = 0;
            while (n6 < n5) {
                byArray[n6] = (byte)(((short[])this.data[n3])[n4] & 0xFFFF);
                ++n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "No check", byArray, n, n2, n3);
        }
    }

    public void getZ(int n, int n2, int n3, short[] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = 0;
            while (n6 < n5) {
                sArray[n6] = (short)(((short[])this.data[n3])[n4] & 0xFFFF);
                ++n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "No check", sArray, n, n2, n3);
        }
    }

    public void getZ(int n, int n2, int n3, float[] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = 0;
            while (n6 < n5) {
                fArray[n6] = ((short[])this.data[n3])[n4] & 0xFFFF;
                ++n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "No check", fArray, n, n2, n3);
        }
    }

    public void getZ(int n, int n2, int n3, double[] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = 0;
            while (n6 < n5) {
                dArray[n6] = ((short[])this.data[n3])[n4] & 0xFFFF;
                ++n3;
                ++n6;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "No check", dArray, n, n2, n3);
        }
    }

    public void getXY(int n, int n2, int n3, byte[][] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = byArray[0].length;
            short[] sArray = (short[])this.data[n3];
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + (n2 + n7) * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    byArray[n8][n7] = (byte)(sArray[n4] & 0xFFFF);
                    ++n8;
                    ++n4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "No check", byArray, n, n2, n3);
        }
    }

    public void getXY(int n, int n2, int n3, short[][] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = sArray[0].length;
            short[] sArray2 = (short[])this.data[n3];
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + (n2 + n7) * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n8][n7] = (short)(sArray2[n4] & 0xFFFF);
                    ++n8;
                    ++n4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "No check", sArray, n, n2, n3);
        }
    }

    public void getXY(int n, int n2, int n3, float[][] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = fArray[0].length;
            short[] sArray = (short[])this.data[n3];
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + (n2 + n7) * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    fArray[n8][n7] = sArray[n4] & 0xFFFF;
                    ++n8;
                    ++n4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "No check", fArray, n, n2, n3);
        }
    }

    public void getXY(int n, int n2, int n3, double[][] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = dArray[0].length;
            short[] sArray = (short[])this.data[n3];
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + (n2 + n7) * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    dArray[n8][n7] = sArray[n4] & 0xFFFF;
                    ++n8;
                    ++n4;
                }
                ++n7;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "No check", dArray, n, n2, n3);
        }
    }

    public void getXZ(int n, int n2, int n3, byte[][] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = byArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + n2 * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    byArray[n8][n7] = (byte)(((short[])this.data[n3])[n4] & 0xFFFF);
                    ++n8;
                    ++n4;
                }
                ++n7;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "No check", byArray, n, n2, n3);
        }
    }

    public void getXZ(int n, int n2, int n3, short[][] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = sArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + n2 * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n8][n7] = (short)(((short[])this.data[n3])[n4] & 0xFFFF);
                    ++n8;
                    ++n4;
                }
                ++n7;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "No check", sArray, n, n2, n3);
        }
    }

    public void getXZ(int n, int n2, int n3, float[][] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = fArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + n2 * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    fArray[n8][n7] = ((short[])this.data[n3])[n4] & 0xFFFF;
                    ++n8;
                    ++n4;
                }
                ++n7;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "No check", fArray, n, n2, n3);
        }
    }

    public void getXZ(int n, int n2, int n3, double[][] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = dArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                n4 = n + n2 * this.nx;
                int n8 = 0;
                while (n8 < n5) {
                    dArray[n8][n7] = ((short[])this.data[n3])[n4] & 0xFFFF;
                    ++n8;
                    ++n4;
                }
                ++n7;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "No check", dArray, n, n2, n3);
        }
    }

    public void getYZ(int n, int n2, int n3, byte[][] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = byArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    byArray[n8][n7] = (byte)(((short[])this.data[n3])[n4] & 0xFFFF);
                    ++n8;
                    n4 += this.nx;
                }
                ++n7;
                ++n3;
                n4 = n + this.nx * n2;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "No check", byArray, n, n2, n3);
        }
    }

    public void getYZ(int n, int n2, int n3, short[][] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = sArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n8][n7] = (short)(((short[])this.data[n3])[n4] & 0xFFFF);
                    ++n8;
                    n4 += this.nx;
                }
                ++n7;
                ++n3;
                n4 = n + this.nx * n2;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "No check", sArray, n, n2, n3);
        }
    }

    public void getYZ(int n, int n2, int n3, float[][] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = fArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    fArray[n8][n7] = ((short[])this.data[n3])[n4] & 0xFFFF;
                    ++n8;
                    n4 += this.nx;
                }
                ++n7;
                ++n3;
                n4 = n + this.nx * n2;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "No check", fArray, n, n2, n3);
        }
    }

    public void getYZ(int n, int n2, int n3, double[][] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = dArray[0].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = 0;
                while (n8 < n5) {
                    dArray[n8][n7] = ((short[])this.data[n3])[n4] & 0xFFFF;
                    ++n8;
                    n4 += this.nx;
                }
                ++n7;
                ++n3;
                n4 = n + this.nx * n2;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "No check", dArray, n, n2, n3);
        }
    }

    public void getXYZ(int n, int n2, int n3, byte[][][] byArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = byArray.length;
            int n6 = byArray[0].length;
            int n7 = byArray[0][0].length;
            int n8 = 0;
            while (n8 < n7) {
                short[] sArray = (short[])this.data[n3];
                int n9 = 0;
                while (n9 < n6) {
                    n4 = n + (n9 + n2) * this.nx;
                    int n10 = 0;
                    while (n10 < n5) {
                        byArray[n10][n9][n8] = (byte)(sArray[n4] & 0xFFFF);
                        ++n10;
                        ++n4;
                    }
                    ++n9;
                }
                ++n8;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "No check", byArray, n, n2, n3);
        }
    }

    public void getXYZ(int n, int n2, int n3, short[][][] sArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = sArray.length;
            int n6 = sArray[0].length;
            int n7 = sArray[0][0].length;
            int n8 = 0;
            while (n8 < n7) {
                short[] sArray2 = (short[])this.data[n3];
                int n9 = 0;
                while (n9 < n6) {
                    n4 = n + (n9 + n2) * this.nx;
                    int n10 = 0;
                    while (n10 < n5) {
                        sArray[n10][n9][n8] = (short)(sArray2[n4] & 0xFFFF);
                        ++n10;
                        ++n4;
                    }
                    ++n9;
                }
                ++n8;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "No check", sArray, n, n2, n3);
        }
    }

    public void getXYZ(int n, int n2, int n3, float[][][] fArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = fArray.length;
            int n6 = fArray[0].length;
            int n7 = fArray[0][0].length;
            int n8 = 0;
            while (n8 < n7) {
                short[] sArray = (short[])this.data[n3];
                int n9 = 0;
                while (n9 < n6) {
                    n4 = n + (n9 + n2) * this.nx;
                    int n10 = 0;
                    while (n10 < n5) {
                        fArray[n10][n9][n8] = sArray[n4] & 0xFFFF;
                        ++n10;
                        ++n4;
                    }
                    ++n9;
                }
                ++n8;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "No check", fArray, n, n2, n3);
        }
    }

    public void getXYZ(int n, int n2, int n3, double[][][] dArray) {
        try {
            int n4 = n + n2 * this.nx;
            int n5 = dArray.length;
            int n6 = dArray[0].length;
            int n7 = dArray[0][0].length;
            int n8 = 0;
            while (n8 < n7) {
                short[] sArray = (short[])this.data[n3];
                int n9 = 0;
                while (n9 < n6) {
                    n4 = n + (n9 + n2) * this.nx;
                    int n10 = 0;
                    while (n10 < n5) {
                        dArray[n10][n9][n8] = sArray[n4] & 0xFFFF;
                        ++n10;
                        ++n4;
                    }
                    ++n9;
                }
                ++n8;
                ++n3;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "No check", dArray, n, n2, n3);
        }
    }

    protected void throw_constructor() {
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to create a short imageware.\n-------------------------------------------------------\n");
    }

    protected void throw_constructor(int n, int n2, int n3) {
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to create a short imageware " + n + "," + n2 + "," + n3 + "].\n" + "-------------------------------------------------------\n");
    }

    protected void throw_get(String string, String string2, Object object, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string3 = " unknown type";
        if (object instanceof byte[]) {
            n4 = ((byte[])object).length;
            string3 = " 1D byte";
        } else if (object instanceof short[]) {
            n4 = ((short[])object).length;
            string3 = " 1D short";
        } else if (object instanceof float[]) {
            n4 = ((float[])object).length;
            string3 = " 1D float";
        } else if (object instanceof double[]) {
            n4 = ((double[])object).length;
            string3 = " 1D double";
        } else if (object instanceof byte[][]) {
            n4 = ((byte[][])object).length;
            n5 = ((byte[][])object)[0].length;
            string3 = " 2D byte";
        } else if (object instanceof short[][]) {
            n4 = ((short[][])object).length;
            n5 = ((short[][])object)[0].length;
            string3 = " 2D short";
        } else if (object instanceof float[][]) {
            n4 = ((float[][])object).length;
            n5 = ((float[][])object)[0].length;
            string3 = " 2D float";
        } else if (object instanceof double[][]) {
            n4 = ((double[][])object).length;
            n5 = ((double[][])object)[0].length;
            string3 = " 2D double";
        } else if (object instanceof byte[][][]) {
            n4 = ((byte[][][])object).length;
            n5 = ((byte[][][])object)[0].length;
            n6 = ((byte[][][])object)[0][0].length;
            string3 = " 3D byte";
        } else if (object instanceof short[][][]) {
            n4 = ((short[][][])object).length;
            n5 = ((short[][][])object)[0].length;
            n6 = ((short[][][])object)[0][0].length;
            string3 = " 3D short";
        } else if (object instanceof float[][][]) {
            n4 = ((float[][][])object).length;
            n5 = ((float[][][])object)[0].length;
            n6 = ((float[][][])object)[0][0].length;
            string3 = " 3D float";
        } else if (object instanceof double[][][]) {
            n4 = ((double[][][])object).length;
            n5 = ((double[][][])object)[0].length;
            n6 = ((double[][][])object)[0][0].length;
            string3 = " 3D double";
        }
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to get a" + string3 + " buffer [" + (n4 == 0 ? "" : String.valueOf(n4)) + (n5 == 0 ? "" : "," + n5) + (n6 == 0 ? "" : "," + n6) + "] \n" + "from the short imageware [" + this.nx + "," + this.ny + "," + this.nz + "]\n" + "at the position (" + n + "," + n2 + "," + n3 + ") in direction " + string + "\n" + "using " + string2 + ".\n" + "-------------------------------------------------------\n");
    }

    protected void throw_put(String string, String string2, Object object, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string3 = " unknown type";
        if (object instanceof byte[]) {
            n4 = ((byte[])object).length;
            string3 = " 1D byte";
        } else if (object instanceof short[]) {
            n4 = ((short[])object).length;
            string3 = " 1D short";
        } else if (object instanceof float[]) {
            n4 = ((float[])object).length;
            string3 = " 1D float";
        } else if (object instanceof double[]) {
            n4 = ((double[])object).length;
            string3 = " 1D double";
        } else if (object instanceof byte[][]) {
            n4 = ((byte[][])object).length;
            n5 = ((byte[][])object)[0].length;
            string3 = " 2D byte";
        } else if (object instanceof short[][]) {
            n4 = ((short[][])object).length;
            n5 = ((short[][])object)[0].length;
            string3 = " 2D short";
        } else if (object instanceof float[][]) {
            n4 = ((float[][])object).length;
            n5 = ((float[][])object)[0].length;
            string3 = " 2D float";
        } else if (object instanceof double[][]) {
            n4 = ((double[][])object).length;
            n5 = ((double[][])object)[0].length;
            string3 = " 2D double";
        } else if (object instanceof byte[][][]) {
            n4 = ((byte[][][])object).length;
            n5 = ((byte[][][])object)[0].length;
            n6 = ((byte[][][])object)[0][0].length;
            string3 = " 3D byte";
        } else if (object instanceof short[][][]) {
            n4 = ((short[][][])object).length;
            n5 = ((short[][][])object)[0].length;
            n6 = ((short[][][])object)[0][0].length;
            string3 = " 3D short";
        } else if (object instanceof float[][][]) {
            n4 = ((float[][][])object).length;
            n5 = ((float[][][])object)[0].length;
            n6 = ((float[][][])object)[0][0].length;
            string3 = " 3D float";
        } else if (object instanceof double[][][]) {
            n4 = ((double[][][])object).length;
            n5 = ((double[][][])object)[0].length;
            n6 = ((double[][][])object)[0][0].length;
            string3 = " 3D double";
        }
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to put a" + string3 + " buffer [" + (n4 == 0 ? "" : String.valueOf(n4)) + (n5 == 0 ? "" : "," + n5) + (n6 == 0 ? "" : "," + n6) + "] \n" + "into the short imageware [" + this.nx + "," + this.ny + "," + this.nz + "]\n" + "at the position (" + n + "," + n2 + "," + n3 + ") in direction " + string + "\n" + "using " + string2 + ".\n" + "-------------------------------------------------------\n");
    }

    public Object[] getVolume() {
        return this.data;
    }

    public byte[] getSliceByte(int n) {
        return null;
    }

    public short[] getSliceShort(int n) {
        return (short[])this.data[n];
    }

    public float[] getSliceFloat(int n) {
        return null;
    }

    public double[] getSliceDouble(int n) {
        return null;
    }

    private void allocate() {
        try {
            this.data = new Object[this.nz];
            this.nxy = this.nx * this.ny;
            int n = 0;
            while (n < this.nz) {
                this.data[n] = new short[this.nxy];
                ++n;
            }
        }
        catch (Exception exception) {
            this.throw_constructor(this.nx, this.ny, this.nz);
        }
    }
}

