/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImageStack;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import imageware.Pointwise;
import imageware.ShortAccess;
import java.awt.Image;
import java.util.Random;

public class ShortPointwise
extends ShortAccess
implements Pointwise {
    protected ShortPointwise(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected ShortPointwise(Image image, int n) {
        super(image, n);
    }

    protected ShortPointwise(ImageStack imageStack, int n) {
        super(imageStack, n);
    }

    protected ShortPointwise(ImageStack imageStack, byte by) {
        super(imageStack, by);
    }

    protected ShortPointwise(byte[] byArray, int n) {
        super(byArray, n);
    }

    protected ShortPointwise(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected ShortPointwise(byte[][][] byArray, int n) {
        super(byArray, n);
    }

    protected ShortPointwise(short[] sArray, int n) {
        super(sArray, n);
    }

    protected ShortPointwise(short[][] sArray, int n) {
        super(sArray, n);
    }

    protected ShortPointwise(short[][][] sArray, int n) {
        super(sArray, n);
    }

    protected ShortPointwise(float[] fArray, int n) {
        super(fArray, n);
    }

    protected ShortPointwise(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected ShortPointwise(float[][][] fArray, int n) {
        super(fArray, n);
    }

    protected ShortPointwise(double[] dArray, int n) {
        super(dArray, n);
    }

    protected ShortPointwise(double[][] dArray, int n) {
        super(dArray, n);
    }

    protected ShortPointwise(double[][][] dArray, int n) {
        super(dArray, n);
    }

    public void fillConstant(double d) {
        short s = (short)d;
        short[] sArray = null;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = s;
                ++n2;
            }
            ++n;
        }
    }

    public void fillRamp() {
        int n = 0;
        short[] sArray = null;
        int n2 = 0;
        while (n2 < this.nz) {
            sArray = (short[])this.data[n2];
            int n3 = 0;
            while (n3 < this.nxy) {
                sArray[n3] = (short)(n + n3);
                ++n3;
            }
            n += this.nxy;
            ++n2;
        }
    }

    public void fillGaussianNoise(double d) {
        Random random = new Random();
        short[] sArray = null;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = (short)(random.nextGaussian() * d);
                ++n2;
            }
            ++n;
        }
    }

    public void fillUniformNoise(double d) {
        Random random = new Random();
        short[] sArray = null;
        d *= 2.0;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = (short)((random.nextDouble() - 0.5) * d);
                ++n2;
            }
            ++n;
        }
    }

    public void fillSaltPepper(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        double d5;
        Random random = new Random();
        Object var10_6 = null;
        if (d3 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d3;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                ((short[])this.data[n])[n2] = (short)(random.nextDouble() * d);
                ++n3;
            }
        }
        if (d4 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d4;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                ((short[])this.data[n])[n2] = (short)(-random.nextDouble() * d);
                ++n3;
            }
        }
    }

    public ImageStack buildImageStack() {
        ImageStack imageStack = new ImageStack(this.nx, this.ny);
        int n = 0;
        while (n < this.nz) {
            ShortProcessor shortProcessor = new ShortProcessor(this.nx, this.ny);
            short[] sArray = (short[])shortProcessor.getPixels();
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = ((short[])this.data[n])[n2];
                ++n2;
            }
            imageStack.addSlice(String.valueOf(n), (ImageProcessor)shortProcessor);
            ++n;
        }
        return imageStack;
    }

    public void invert() {
        short[] sArray;
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if ((double)(sArray[n2] & 0xFFFF) > d) {
                    d = sArray[n2] & 0xFFFF;
                }
                ++n2;
            }
            ++n;
        }
        double d2 = d;
        int n3 = 0;
        while (n3 < this.nz) {
            sArray = (short[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                sArray[n4] = (short)(d - (double)(sArray[n4] & 0xFFFF));
                ++n4;
            }
            ++n3;
        }
    }

    public void negate() {
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = (short)(-((double)(sArray[n2] & 0xFFFF)));
                ++n2;
            }
            ++n;
        }
    }

    public void clip() {
        this.clip(0.0, 255.0);
    }

    public void clip(double d, double d2) {
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            short s = (short)d;
            short s2 = (short)d2;
            int n2 = 0;
            while (n2 < this.nxy) {
                short s3 = (short)(sArray[n2] & 0xFFFF);
                if (s3 < s) {
                    sArray[n2] = s;
                }
                if (s3 > s2) {
                    sArray[n2] = s2;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void rescale() {
        double d;
        short[] sArray;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if ((double)(sArray[n2] & 0xFFFF) > d2) {
                    d2 = sArray[n2] & 0xFFFF;
                }
                if ((double)(sArray[n2] & 0xFFFF) < d3) {
                    d3 = sArray[n2] & 0xFFFF;
                }
                ++n2;
            }
            ++n;
        }
        if (d3 - d2 == 0.0) {
            d = 1.0;
            d3 = 128.0;
        } else {
            d = 255.0 / (d2 - d3);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            sArray = (short[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                sArray[n4] = (short)(d * ((double)(sArray[n4] & 0xFFFF) - d3));
                ++n4;
            }
            ++n3;
        }
    }

    public void rescale(double d, double d2) {
        double d3;
        short[] sArray;
        double d4 = -1.7976931348623157E308;
        double d5 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if ((double)(sArray[n2] & 0xFFFF) > d4) {
                    d4 = sArray[n2] & 0xFFFF;
                }
                if ((double)(sArray[n2] & 0xFFFF) < d5) {
                    d5 = sArray[n2] & 0xFFFF;
                }
                ++n2;
            }
            ++n;
        }
        if (d5 - d4 == 0.0) {
            d3 = 1.0;
            d5 = (d2 - d) / 2.0;
        } else {
            d3 = (d2 - d) / (d4 - d5);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            sArray = (short[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                sArray[n4] = (short)(d3 * ((double)(sArray[n4] & 0xFFFF) - d5) + d);
                ++n4;
            }
            ++n3;
        }
    }

    public void rescaleCenter(double d, double d2) {
        double d3;
        short[] sArray;
        double d4 = -1.7976931348623157E308;
        double d5 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if ((double)(sArray[n2] & 0xFFFF) > d4) {
                    d4 = sArray[n2] & 0xFFFF;
                }
                if ((double)(sArray[n2] & 0xFFFF) < d5) {
                    d5 = sArray[n2] & 0xFFFF;
                }
                ++n2;
            }
            ++n;
        }
        double d6 = (d2 + d) / 2.0;
        if (d5 - d4 == 0.0) {
            d3 = 1.0;
            d5 = (d2 - d) / 2.0;
        } else {
            d3 = Math.abs(d4) > Math.abs(d5) ? (d2 - d6) / Math.abs(d4) : (d6 - d) / Math.abs(d5);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            sArray = (short[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                sArray[n4] = (short)(d3 * ((double)(sArray[n4] & 0xFFFF) - d5) + d6);
                ++n4;
            }
            ++n3;
        }
    }

    public void abs() {
    }

    public void log() {
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = (short)Math.log(sArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void exp() {
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = (short)Math.exp(sArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void sqrt() {
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = (short)Math.sqrt(sArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void sqr() {
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2;
                sArray[n3] = (short)(sArray[n3] * sArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void pow(double d) {
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = (short)Math.pow(sArray[n2], d);
                ++n2;
            }
            ++n;
        }
    }

    public void add(double d) {
        short s = (short)d;
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] + s);
            }
            ++n;
        }
    }

    public void multiply(double d) {
        short s = (short)d;
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] * s);
            }
            ++n;
        }
    }

    public void subtract(double d) {
        short s = (short)d;
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] - s);
            }
            ++n;
        }
    }

    public void divide(double d) {
        if (d == 0.0) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to divide because the constant is 0.\n-------------------------------------------------------\n");
        }
        short s = (short)d;
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] / s);
            }
            ++n;
        }
    }

    public void threshold(double d) {
        this.threshold(d, 0.0, 255.0);
    }

    public void threshold(double d, double d2, double d3) {
        short s = (short)d2;
        short s2 = (short)d3;
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                sArray[n2] = (double)(sArray[n2] & 0xFFFF) > d ? s2 : s;
                ++n2;
            }
            ++n;
        }
    }

    public void thresholdSoft(double d) {
        short s = 0;
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                double d2 = sArray[n2] & 0xFFFF;
                sArray[n2] = d2 <= -d ? (short)(d2 + d) : (d2 > d ? (short)(d2 - d) : s);
                ++n2;
            }
            ++n;
        }
    }

    public void thresholdHard(double d) {
        short s = 0;
        int n = 0;
        while (n < this.nz) {
            short[] sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                double d2 = sArray[n2] & 0xFFFF;
                if (d2 > -d && d2 < d) {
                    sArray[n2] = s;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void addGaussianNoise(double d) {
        Random random = new Random();
        short[] sArray = null;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] + (short)(random.nextGaussian() * d));
            }
            ++n;
        }
    }

    public void addUniformNoise(double d) {
        Random random = new Random();
        short[] sArray = null;
        d *= 2.0;
        int n = 0;
        while (n < this.nz) {
            sArray = (short[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                sArray[n3] = (short)(sArray[n3] + (short)((random.nextDouble() - 0.5) * d));
            }
            ++n;
        }
    }

    public void addSaltPepper(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        double d5;
        Random random = new Random();
        Object var10_6 = null;
        if (d3 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d3;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                short[] sArray = (short[])this.data[n];
                int n4 = n2;
                sArray[n4] = (short)(sArray[n4] + (short)(random.nextDouble() * d));
                ++n3;
            }
        }
        if (d4 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d4;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                short[] sArray = (short[])this.data[n];
                int n5 = n2;
                sArray[n5] = (short)(sArray[n5] - (short)(random.nextDouble() * d));
                ++n3;
            }
        }
    }
}

