/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import spottracker2d.Handler;
import spottracker2d.PointTrack;
import spottracker2d.ViewerCanvas;

public class SpotTrackerPopup
extends PopupMenu
implements ActionListener {
    private MenuItem[] mi;
    private Handler handler;
    private ViewerCanvas canvas;
    private Vector items;

    public SpotTrackerPopup(Handler handler, ViewerCanvas canvas, Vector items) {
        this.handler = handler;
        this.canvas = canvas;
        this.items = items;
        int nb = items.size();
        this.mi = new MenuItem[nb];
        PointTrack pt0 = (PointTrack)items.elementAt(0);
        this.mi[0] = new MenuItem("Add a node at (" + pt0.t + "," + pt0.x + "," + pt0.y + ")");
        this.mi[0].addActionListener(this);
        this.add(this.mi[0]);
        int i = 1;
        while (i < nb) {
            PointTrack pt = (PointTrack)items.elementAt(i);
            this.mi[i] = new MenuItem("Remove the node (" + pt.t + "," + pt.x + "," + pt.y + ")");
            this.mi[i].addActionListener(this);
            this.add(this.mi[i]);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        int nb = this.mi.length;
        int i = 0;
        while (i < nb) {
            if (e.getSource() == this.mi[i]) {
                if (i == 0) {
                    this.handler.addConstraintPoint((PointTrack)this.items.elementAt(0));
                } else {
                    this.handler.removeConstraintPoint((PointTrack)this.items.elementAt(i));
                }
                this.canvas.repaint();
            }
            ++i;
        }
    }
}

