/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ThresholdPanel
extends JPanel
implements ActionListener,
AdjustmentListener {
    static final double defaultMinThreshold = 40.0;
    static final double defaultMaxThreshold = 255.0;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static Frame instance;
    private int MIN_MAX = 16;
    private int MODE = 16;
    Thread thread;
    int minValue = -1;
    int maxValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doApplyLut;
    boolean doStateChange;
    boolean doSet;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int STATE_CHANGE = 4;
    static final int MIN_THRESHOLD = 5;
    static final int MAX_THRESHOLD = 6;
    static final int SET = 7;
    JPanel panel;
    JButton resetB;
    JButton stateB;
    int previousImageID;
    int previousImageType;
    double previousMin;
    double previousMax;
    double minThreshold;
    double maxThreshold;
    JScrollBar minSlider;
    JLabel label1;
    boolean done;
    boolean invertedLut;
    boolean blackAndWhite;
    int lutColor = 0;
    ImagePlus imp = null;
    private int tmin = 0;

    public ThresholdPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        boolean y = false;
        this.minSlider = new JScrollBar(0, this.sliderRange / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90 : 100;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.minSlider, c);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10 : 0;
        c.insets = new Insets(5, 0, 0, 10);
        this.label1 = new JLabel("       ", 11);
        this.add((Component)this.label1, c);
        this.panel = new JPanel();
        this.resetB = new JButton("B&W");
        this.resetB.addActionListener(this);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 10, 5);
    }

    public int getMin() {
        return this.tmin;
    }

    public JButton getButton() {
        return this.resetB;
    }

    public void setMin(int min) {
        this.imp = this.imp;
        this.tmin = min;
        this.minThreshold = min;
        this.minSlider.setValue(min);
        this.minValue = this.minSlider.getValue();
    }

    public void activeRed(ImagePlus imp, int min) {
        this.imp = imp;
        this.tmin = min;
        this.minThreshold = min;
        this.minSlider.setValue(min);
        this.minValue = this.minSlider.getValue();
        this.resetB.setText("B&W");
        this.doReset = false;
        this.doUpdate();
    }

    public void activeBW() {
        this.resetB.setText("B&W");
        this.doReset = false;
        this.doUpdate();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.minSlider) {
            this.minValue = this.minSlider.getValue();
            this.resetB.setText("B&W");
            this.doReset = false;
            this.doUpdate();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.resetB) {
            if (this.resetB.getText().equals("B&W")) {
                this.resetB.setText("Red");
                this.doReset = true;
                this.doUpdate();
            } else {
                this.minValue = this.minSlider.getValue();
                this.resetB.setText("B&W");
                this.doReset = false;
                this.doUpdate();
            }
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        int type = imp.getType();
        if (type == 4) {
            return null;
        }
        ImageProcessor ip = imp.getProcessor();
        boolean minMaxChange = false;
        if (type == 1 || type == 2) {
            if (ip.getMin() != this.previousMin || ip.getMax() != this.previousMax) {
                minMaxChange = true;
            }
            this.previousMin = ip.getMin();
            this.previousMax = ip.getMax();
        }
        int id = imp.getID();
        if (minMaxChange || id != this.previousImageID || type != this.previousImageType) {
            this.invertedLut = imp.isInvertedLut();
            this.minThreshold = ip.getMinThreshold();
            this.maxThreshold = ip.getMaxThreshold();
            if (this.minThreshold == -808080.0) {
                this.minThreshold = 40.0;
                this.maxThreshold = 255.0;
            }
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
            this.updateLabels(imp, ip);
            this.updateScrollBars();
            imp.updateAndDraw();
        }
        this.previousImageID = id;
        this.previousImageType = type;
        return ip;
    }

    void scaleUpAndSet(ImageProcessor ip, double minThreshold, double maxThreshold) {
        if (!(ip instanceof ByteProcessor) && minThreshold != -808080.0) {
            double min = ip.getMin();
            double max = ip.getMax();
            if (max > min) {
                minThreshold = min + minThreshold / 255.0 * (max - min);
                maxThreshold = min + maxThreshold / 255.0 * (max - min);
            } else {
                minThreshold = -808080.0;
            }
        }
        ip.setThreshold(minThreshold, maxThreshold, this.lutColor);
    }

    double scaleDown(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (threshold - min) / (max - min) * 255.0;
        }
        return -808080.0;
    }

    double scaleUp(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return min + threshold / 255.0 * (max - min);
        }
        return -808080.0;
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        double min = ip.getMinThreshold();
        double max = ip.getMaxThreshold();
        if (min == -808080.0) {
            this.label1.setText("");
        } else {
            Calibration cal = imp.getCalibration();
            if (cal.calibrated()) {
                min = cal.getCValue((int)min);
                max = cal.getCValue((int)max);
            }
            if ((double)((int)min) == min && (double)((int)max) == max || ip instanceof ShortProcessor) {
                this.label1.setText(String.valueOf((int)min));
            } else {
                this.label1.setText(String.valueOf(IJ.d2s((double)min, (int)2)));
            }
            this.tmin = (int)min;
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue((int)this.minThreshold);
    }

    void adjustMinThreshold(ImagePlus imp, ImageProcessor ip, double value) {
        if (IJ.altKeyDown()) {
            double width = this.maxThreshold - this.minThreshold;
            if (width < 1.0) {
                width = 1.0;
            }
            this.minThreshold = value;
            this.maxThreshold = this.minThreshold + width;
            if (this.minThreshold + width > 255.0) {
                this.minThreshold = 255.0 - width;
                this.maxThreshold = this.minThreshold + width;
                this.minSlider.setValue((int)this.minThreshold);
            }
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
            return;
        }
        this.minThreshold = value;
        if (this.maxThreshold < this.minThreshold) {
            this.maxThreshold = this.minThreshold;
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
    }

    void adjustMaxThreshold(ImagePlus imp, ImageProcessor ip, int cvalue) {
        this.maxThreshold = cvalue;
        if (this.minThreshold > this.maxThreshold) {
            this.minThreshold = this.maxThreshold;
            this.minSlider.setValue((int)this.minThreshold);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        ip.resetThreshold();
        this.updateScrollBars();
    }

    void changeState(ImagePlus imp, ImageProcessor ip) {
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void doUpdate() {
        int action;
        int min = this.minValue;
        int max = this.maxValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doStateChange) {
            action = 4;
        } else if (this.doSet) {
            action = 7;
        } else if (this.minValue >= 0) {
            action = 5;
        } else if (this.maxValue >= 0) {
            action = 6;
        } else {
            return;
        }
        this.minValue = -1;
        this.maxValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doApplyLut = false;
        this.doStateChange = false;
        this.doSet = false;
        if (this.imp == null) {
            IJ.beep();
            IJ.showStatus((String)"No image");
            return;
        }
        ImageProcessor ip = this.setup(this.imp);
        if (ip == null) {
            this.imp.unlock();
            IJ.beep();
            IJ.showStatus((String)"RGB images cannot be thresolded");
            return;
        }
        switch (action) {
            case 0: {
                this.reset(this.imp, ip);
                break;
            }
            case 4: {
                this.changeState(this.imp, ip);
                break;
            }
            case 5: {
                this.adjustMinThreshold(this.imp, ip, min);
                break;
            }
            case 6: {
                this.adjustMaxThreshold(this.imp, ip, max);
                break;
            }
        }
        this.updateLabels(this.imp, ip);
        ip.setLutAnimation(true);
        this.imp.updateAndDraw();
    }
}

