/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import imageware.FMath;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import spottracker2d.Handler;
import spottracker2d.PointTrack;

public class TraceImageCanvas
extends ImageCanvas {
    private ImagePlus imp;
    private Handler handler;
    private int view;

    public TraceImageCanvas(ImagePlus imp, Handler handler, int view) {
        super(imp);
        this.imp = imp;
        this.handler = handler;
        this.view = view;
        double max = handler.imp.getProcessor().getMax();
        double min = handler.imp.getProcessor().getMin();
        if (imp.getStackSize() > 1) {
            imp.setSlice(imp.getStackSize() / 2);
        }
        imp.getProcessor().setMinAndMax(min, max);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.handler.xspot != null) {
            Color saveColor = g.getColor();
            double mag = this.getMagnification();
            Rectangle rect = this.getSrcRect();
            int x0 = 0;
            int x1 = 0;
            int y0 = 0;
            int y1 = 0;
            int nt = this.handler.volSource.getSizeZ();
            g.setColor(Color.red);
            double off = this.handler.subpixelTrace ? 0.0 : 0.5;
            switch (this.view) {
                case 0: {
                    x0 = FMath.round(((double)(this.handler.xspot[0] - (float)rect.x) + off) * mag);
                    y0 = FMath.round(((double)(this.handler.yspot[0] - (float)rect.y) + off) * mag);
                    int k = 1;
                    while (k < nt) {
                        x1 = FMath.round(((double)(this.handler.xspot[k] - (float)rect.x) + off) * mag);
                        y1 = FMath.round(((double)(this.handler.yspot[k] - (float)rect.y) + off) * mag);
                        g.drawLine(x0, y0, x1, y1);
                        x0 = x1;
                        y0 = y1;
                        ++k;
                    }
                    break;
                }
                case 1: {
                    x0 = FMath.round(((double)(this.handler.xspot[0] - (float)rect.x) + off) * mag);
                    y0 = FMath.round(((double)(-rect.y) + 0.5) * mag);
                    int k = 1;
                    while (k < nt) {
                        x1 = FMath.round(((double)(this.handler.xspot[k] - (float)rect.x) + off) * mag);
                        y1 = FMath.round(((double)(k - rect.y) + 0.5) * mag);
                        g.drawLine(x0, y0, x1, y1);
                        x0 = x1;
                        y0 = y1;
                        ++k;
                    }
                    g.setColor(Color.green);
                    int n = 0;
                    while (n < this.handler.nodes.size()) {
                        PointTrack pt = (PointTrack)this.handler.nodes.get(n);
                        x0 = FMath.round(((double)(pt.x - rect.x) + 0.5) * mag);
                        int t0 = FMath.round(((double)(pt.t - rect.y) + 0.5) * mag);
                        x1 = FMath.round(((double)(pt.x - rect.x) - 1.5) * mag);
                        int t1 = FMath.round(((double)(pt.t - rect.y) - 1.5) * mag);
                        int x2 = FMath.round(((double)(pt.x - rect.x) + 2.5) * mag);
                        int t2 = FMath.round(((double)(pt.t - rect.y) + 2.5) * mag);
                        g.drawLine(x1, t0, x2, t0);
                        g.drawLine(x0, t1, x0, t2);
                        ++n;
                    }
                    break;
                }
                case 2: {
                    x0 = FMath.round(((double)(this.handler.yspot[0] - (float)rect.x) + off) * mag);
                    y0 = FMath.round(((double)(-rect.y) + 0.5) * mag);
                    int k = 1;
                    while (k < nt) {
                        x1 = FMath.round(((double)(this.handler.yspot[k] - (float)rect.x) + off) * mag);
                        y1 = FMath.round(((double)(k - rect.y) + 0.5) * mag);
                        g.drawLine(x0, y0, x1, y1);
                        x0 = x1;
                        y0 = y1;
                        ++k;
                    }
                    g.setColor(Color.green);
                    int n = 0;
                    while (n < this.handler.nodes.size()) {
                        PointTrack pt = (PointTrack)this.handler.nodes.get(n);
                        y0 = FMath.round(((double)(pt.y - rect.x) + 0.5) * mag);
                        int t0 = FMath.round(((double)(pt.t - rect.y) + 0.5) * mag);
                        y1 = FMath.round(((double)(pt.y - rect.x) - 1.5) * mag);
                        int t1 = FMath.round(((double)(pt.t - rect.y) - 1.5) * mag);
                        int y2 = FMath.round(((double)(pt.y - rect.x) + 2.5) * mag);
                        int t2 = FMath.round(((double)(pt.t - rect.y) + 2.5) * mag);
                        g.drawLine(y1, t0, y2, t0);
                        g.drawLine(y0, t1, y0, t2);
                        ++n;
                    }
                    break;
                }
            }
            g.setColor(saveColor);
        }
    }
}

