/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.TiffEncoder;
import imageware.FMath;
import imageware.ImageWare;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.swing.JPanel;
import spottracker2d.Handler;
import spottracker2d.PointTrack;
import spottracker2d.SetViewing;
import spottracker2d.SpotTrackerPopup;
import spottracker2d.ViewerFrame;

public class ViewerCanvas
extends JPanel {
    private Image imageXY = null;
    private Image imageYZ = null;
    private Image imageXZ = null;
    private Rectangle rectXY;
    private Rectangle rectYZ;
    private Rectangle rectXZ;
    private Rectangle rectCT;
    private final int ACTIVE_VIEW_XY = 0;
    private final int ACTIVE_VIEW_YZ = 1;
    private final int ACTIVE_VIEW_XZ = 2;
    private final int ACTIVE_VIEW_CT = 3;
    public final int VIEW_SECTION = 0;
    public final int VIEW_MAXI_PROJECTION = 1;
    public final int VIEW_SPOT_PROJECTION = 2;
    public static final int VIEWERCANVAS_SOURCE = 0;
    public static final int VIEWERCANVAS_NORM = 1;
    public static final int VIEWERCANVAS_ALIGN = 2;
    public static final int VIEWERCANVAS_FILTER = 3;
    public int projection = 0;
    public int nx;
    public int ny;
    public int nt;
    private int xpos;
    private int ypos;
    private int tpos;
    public int interval = 5;
    private int activeView = 0;
    private Vector node = new Vector(1, 1);
    private float[] xspot = null;
    private float[] yspot = null;
    private int[] vspot = null;
    private Rectangle[] enveloppe = null;
    private boolean[][] settings = null;
    private Color[] colors = null;
    private int decision = 0;
    public double zoomX = 1.0;
    public double zoomY = 1.0;
    public double zoomZ = 1.0;
    private Image offScreen = null;
    private int dataview = 0;
    private boolean drag = false;
    private ColorModel colormodel;
    private Handler handler;
    private boolean inverse = false;
    private boolean displayEnveloppe = false;
    private boolean displayNucleus = true;
    private boolean displayTrack = true;
    private boolean displaySpot = true;
    private boolean displayNode = true;
    private ViewerFrame frame;
    public SpotTrackerPopup popup;
    private double previousTimeMouseDragedd;

    public ViewerCanvas(Handler handler, ViewerFrame frame, double zoomXY) {
        this.handler = handler;
        SetViewing sv = new SetViewing(false);
        this.colors = sv.getColors();
        this.settings = sv.getSettings();
        this.frame = frame;
        this.nt = handler.volSource.getSizeZ();
        this.nx = handler.volSource.getSizeX();
        this.ny = handler.volSource.getSizeY();
        this.colormodel = this.makeDefaultColorModel();
        PointTrack pt = handler.getStartPoint(this.dataview);
        this.xpos = pt.x;
        this.ypos = pt.y;
        this.tpos = pt.t + 1;
        int nxz = this.round((double)this.nx * this.zoomX);
        int nyz = this.round((double)this.ny * this.zoomY);
        int ntz = this.round((double)this.nt * this.zoomZ);
        this.rectXY = new Rectangle(0, 0, this.nx, this.ny);
        this.rectXZ = new Rectangle(0, this.ny, this.nx, this.nt);
        this.rectYZ = new Rectangle(this.nx, 0, this.nt, this.ny);
        this.rectCT = new Rectangle(this.nx, this.ny, this.nt, this.nt);
        this.setSize(nxz + ntz + 10, nyz + ntz + 10);
        this.setBounds(0, 0, nxz + ntz + 10, nyz + ntz + 10);
        this.zoomX = zoomXY;
        this.zoomY = zoomXY;
        this.updateSlice();
        this.previousTimeMouseDragedd = System.currentTimeMillis();
    }

    public Dimension getPreferredSize() {
        int nxz = this.round((double)this.nx * this.zoomX);
        int nyz = this.round((double)this.ny * this.zoomY);
        int ntz = this.round((double)this.nt * this.zoomZ);
        return new Dimension(nxz + ntz, nyz + ntz);
    }

    public void setSettings(boolean[][] settings, Color[] colors) {
        this.settings = settings;
        this.colors = colors;
        this.repaint();
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public void setDataViewing(int dataview) {
        this.dataview = dataview;
        this.updateSlice();
    }

    public int getDataViewing() {
        return this.dataview;
    }

    public void setProjection(int projection) {
        this.projection = projection;
        this.updateSlice();
    }

    public void displayEnveloppe(boolean displayEnveloppe) {
        this.displayEnveloppe = displayEnveloppe;
        this.updateSlice();
    }

    public void displayNucleus(boolean displayNucleus) {
        this.displayNucleus = displayNucleus;
        this.updateSlice();
    }

    public void displayTrack(boolean displayTrack) {
        this.displayTrack = displayTrack;
        this.updateSlice();
    }

    public void displaySpot(boolean displaySpot) {
        this.displaySpot = displaySpot;
        this.updateSlice();
    }

    public void displayNode(boolean displayNode) {
        this.displayNode = displayNode;
        this.updateSlice();
    }

    public PointTrack getCurrentPosition() {
        float value = 0.0f;
        switch (this.dataview) {
            case 0: {
                value = (float)this.handler.volSource.getPixel(this.xpos, this.ypos, this.tpos);
                break;
            }
            case 1: {
                value = (float)this.handler.volNorm.getPixel(this.xpos, this.ypos, this.tpos);
                break;
            }
            case 2: {
                value = (float)this.handler.volAlign.getPixel(this.xpos, this.ypos, this.tpos);
                break;
            }
            case 3: {
                value = (float)this.handler.volFilter.getPixel(this.xpos, this.ypos, this.tpos);
                break;
            }
        }
        return new PointTrack(this.xpos, this.ypos, 0, this.tpos, value);
    }

    public void setNode(Vector node) {
        this.node = node;
    }

    public void updateDisplay(int decision) {
        this.node = this.handler.nodes;
        this.xspot = this.handler.xspot;
        this.yspot = this.handler.yspot;
        this.vspot = this.handler.vspot;
        this.enveloppe = this.handler.getEnveloppe();
        this.decision = decision;
        this.repaint();
    }

    public void activatePopup() {
        Vector<PointTrack> items = new Vector<PointTrack>();
        items.addElement(new PointTrack(this.xpos, this.ypos, 1, this.tpos, 1.0f));
        int nb = this.handler.nodes.size();
        if (nb >= 2) {
            int i = 0;
            while (i < nb) {
                PointTrack pti = (PointTrack)this.handler.nodes.elementAt(i);
                double dist = Math.sqrt((this.xpos - pti.x) * (this.xpos - pti.x) + (this.ypos - pti.y) * (this.ypos - pti.y) + (this.tpos - pti.t) * (this.tpos - pti.t));
                if (dist < 60.0) {
                    items.addElement(pti);
                }
                ++i;
            }
        }
        this.popup = new SpotTrackerPopup(this.handler, this, items);
    }

    public void inverse() {
        this.inverse ^= true;
        this.repaint();
    }

    public void setCursorPosition(int xpos, int ypos, int tpos) {
        this.xpos = xpos;
        this.ypos = ypos;
        this.tpos = tpos;
        this.updateSlice();
    }

    private void createOffScreen(boolean withCursor) {
        int k;
        int ktc;
        int k2;
        int ktp;
        int obj;
        int cx = this.round(this.zoomX) / 2;
        int cy = this.round(this.zoomY) / 2;
        int cz = this.round(this.zoomZ) / 2;
        this.offScreen = null;
        Dimension dim = this.getSize();
        this.offScreen = this.createImage(dim.width, dim.height);
        Graphics g = this.offScreen.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, dim.width, dim.height);
        int ntz = this.round((double)this.nt * this.zoomZ);
        int XYx = this.round((double)this.rectXY.x * this.zoomX) + this.interval;
        int XYy = this.round((double)this.rectXY.y * this.zoomY) + this.interval;
        int XYw = this.round((double)this.rectXY.width * this.zoomX);
        int XYh = this.round((double)this.rectXY.height * this.zoomY);
        int XZx = XYx;
        int XZy = XYy + XYh + 2 * this.interval;
        int XZw = XYw;
        int XZh = ntz;
        int YZx = XYx + XYw + 2 * this.interval;
        int YZy = XYy;
        int YZw = ntz;
        int YZh = XYh;
        int CTx = YZx;
        int CTy = XZy;
        int CTw = ntz;
        int CTh = ntz;
        int xp = this.round((double)this.xpos * this.zoomX) + cx;
        int yp = this.round((double)this.ypos * this.zoomY) + cy;
        int zp = this.round((double)this.tpos * this.zoomZ) + cz;
        if (this.settings[SetViewing.VIEW][0] && this.imageXY != null) {
            g.drawImage(this.imageXY, XYx, XYy, XYx + XYw, XYy + XYh, 0, 0, this.nx, this.ny, Color.green, this.frame);
        }
        if (this.settings[SetViewing.VIEW][1] && this.imageXZ != null) {
            g.drawImage(this.imageXZ, XZx, XZy, XZx + XZw, XZy + XZh, 0, 0, this.nx, this.nt, Color.green, this.frame);
        }
        if (this.settings[SetViewing.VIEW][2] && this.imageYZ != null) {
            g.drawImage(this.imageYZ, YZx, YZy, YZx + YZw, YZy + YZh, 0, 0, this.nt, this.ny, Color.green, this.frame);
        }
        if (withCursor) {
            g.setColor(Color.black);
            if (this.settings[SetViewing.VIEW][0]) {
                g.fillRect(XYx + xp - 6, XYy + yp - 1, 13, 3);
                g.fillRect(XYx + xp - 1, XYy + yp - 6, 3, 13);
            }
            if (this.settings[SetViewing.VIEW][1]) {
                g.fillRect(XZx + xp - 6, XZy + zp - 1 - cz, 13, 3);
                g.fillRect(XZx + xp - 1, XZy + zp - 6 - cz, 3, 13);
            }
            if (this.settings[SetViewing.VIEW][2]) {
                g.fillRect(YZx + zp - 6 - cz, YZy + yp - 1, 13, 3);
                g.fillRect(YZx + zp - 1 - cz, YZy + yp - 6, 3, 13);
            }
            g.setColor(Color.white);
            if (this.settings[SetViewing.VIEW][0]) {
                g.drawLine(XYx + xp - 5, XYy + yp, XYx + xp + 5, XYy + yp);
                g.drawLine(XYx + xp, XYy + yp - 5, XYx + xp, XYy + yp + 5);
            }
            if (this.settings[SetViewing.VIEW][1]) {
                g.drawLine(XZx + xp - 5, XZy + zp - cz, XZx + xp + 5, XZy + zp - cz);
                g.drawLine(XZx + xp, XZy + zp - 5 - cz, XZx + xp, XZy + zp + 5 - cz);
            }
            if (this.settings[SetViewing.VIEW][2]) {
                g.drawLine(YZx + zp - 5 - cz, YZy + yp, YZx + zp + 5 - cz, YZy + yp);
                g.drawLine(YZx + zp - cz, YZy + yp - 5, YZx + zp - cz, YZy + yp + 5);
            }
        }
        if (this.handler.nucleus != null && this.handler.align && this.displayNucleus && (this.dataview == 2 || this.dataview == 3)) {
            g.setColor(this.colors[SetViewing.NUCLEUS]);
            obj = SetViewing.NUCLEUS;
            if (this.settings[SetViewing.VIEW][0] && this.settings[obj][0]) {
                int rx = (int)(this.handler.nucleus[this.tpos][3] * this.zoomX);
                int ry = (int)(this.handler.nucleus[this.tpos][4] * this.zoomY);
                g.drawArc(XYx + XYw / 2 - rx, XYy + XYh / 2 - ry, rx * 2, ry * 2, 0, 360);
            }
            if (this.settings[SetViewing.VIEW][1] && this.settings[obj][1]) {
                int XZc = XZx + XZw / 2;
                int ktp2 = 0;
                int rtp = (int)(this.handler.nucleus[0][3] * this.zoomX);
                int k3 = 1;
                while (k3 < this.handler.nucleus.length - 1) {
                    int ktc2 = (int)((double)k3 * this.zoomZ);
                    int rtc = (int)(this.handler.nucleus[k3][3] * this.zoomX);
                    g.drawLine(XZc + rtp, XZy + ktp2, XZc + rtc, XZy + ktc2);
                    g.drawLine(XZc - rtp, XZy + ktp2, XZc - rtc, XZy + ktc2);
                    ktp2 = ktc2;
                    rtp = rtc;
                    ++k3;
                }
            }
            if (this.settings[SetViewing.VIEW][2] && this.settings[obj][2]) {
                int YZc = YZy + YZh / 2;
                ktp = 0;
                int rtp = (int)(this.handler.nucleus[0][4] * this.zoomY);
                k2 = 1;
                while (k2 < this.handler.nucleus.length - 1) {
                    ktc = (int)((double)k2 * this.zoomZ);
                    int rtc = (int)(this.handler.nucleus[k2][4] * this.zoomY);
                    g.drawLine(YZx + ktp, YZc + rtp, YZx + ktc, YZc + rtc);
                    g.drawLine(YZx + ktp, YZc - rtp, YZx + ktc, YZc - rtc);
                    ktp = ktc;
                    rtp = rtc;
                    ++k2;
                }
            }
        }
        if (this.enveloppe != null && this.xspot != null && this.displayEnveloppe) {
            obj = SetViewing.ENV;
            g.setColor(this.colors[SetViewing.ENV]);
            if (this.settings[SetViewing.VIEW][0] && this.settings[obj][0]) {
                g.drawRect(XYx + this.round((double)this.enveloppe[this.tpos].x * this.zoomX), XYy + this.round((double)this.enveloppe[this.tpos].y * this.zoomY), this.round((double)this.enveloppe[this.tpos].width * this.zoomX + this.zoomX - 1.0), this.round((double)this.enveloppe[this.tpos].height * this.zoomY + this.zoomX - 1.0));
            }
            if (this.settings[SetViewing.VIEW][1] && this.settings[obj][1]) {
                ktp = cz;
                int xp1 = (int)((double)this.enveloppe[0].x * this.zoomX);
                int xp2 = (int)((double)(this.enveloppe[0].x + this.enveloppe[0].width) * this.zoomX + this.zoomX - 1.0);
                k2 = 1;
                while (k2 < this.enveloppe.length) {
                    ktc = (int)((double)k2 * this.zoomZ) + cz;
                    int xc1 = (int)((double)this.enveloppe[k2].x * this.zoomX);
                    int xc2 = (int)((double)(this.enveloppe[k2].x + this.enveloppe[k2].width) * this.zoomX + this.zoomX - 1.0);
                    g.drawLine(XZx + xp1, XZy + ktp, XZx + xc1, XZy + ktc);
                    g.drawLine(XZx + xp2, XZy + ktp, XZx + xc2, XZy + ktc);
                    ktp = ktc;
                    xp1 = xc1;
                    xp2 = xc2;
                    ++k2;
                }
            }
            if (this.settings[SetViewing.VIEW][2] && this.settings[obj][2]) {
                ktp = cz;
                int yp1 = (int)((double)this.enveloppe[0].y * this.zoomY);
                int yp2 = (int)((double)(this.enveloppe[0].y + this.enveloppe[0].height) * this.zoomY + this.zoomY - 1.0);
                k2 = 1;
                while (k2 < this.enveloppe.length) {
                    ktc = (int)((double)k2 * this.zoomZ) + cz;
                    int yc1 = (int)((double)this.enveloppe[k2].y * this.zoomY);
                    int yc2 = (int)((double)(this.enveloppe[k2].y + this.enveloppe[k2].height) * this.zoomY + this.zoomY - 1.0);
                    g.drawLine(YZx + ktp, YZy + yp1, YZx + ktc, YZy + yc1);
                    g.drawLine(YZx + ktp, YZy + yp2, YZx + ktc, YZy + yc2);
                    ktp = ktc;
                    yp1 = yc1;
                    yp2 = yc2;
                    ++k2;
                }
            }
        }
        int offx = cx - this.round(this.zoomX * 1.5);
        int offy = cy - this.round(this.zoomY * 1.5);
        int offz = cz - this.round(this.zoomZ * 1.5);
        int radx = this.round(this.zoomX * 3.0);
        int rady = this.round(this.zoomY * 3.0);
        int radz = this.round(this.zoomZ * 3.0);
        if (this.node != null && this.displayNode) {
            obj = SetViewing.NODES;
            g.setColor(this.colors[SetViewing.NODES]);
            int sx = this.round(this.zoomX);
            int sy = this.round(this.zoomY);
            int n = 0;
            while (n < this.node.size()) {
                PointTrack pt = (PointTrack)this.node.elementAt(n);
                int xn = this.round((double)pt.x * this.zoomX);
                int yn = this.round((double)pt.y * this.zoomY);
                int tn = this.round((double)pt.t * this.zoomZ);
                if (this.settings[SetViewing.VIEW][0] && this.settings[obj][0] && this.tpos == pt.t) {
                    g.drawArc(offx + XYx + xn, offy + XYy + yn, radx, rady, 0, 360);
                }
                if (this.settings[SetViewing.VIEW][1] && this.settings[obj][1]) {
                    g.drawArc(offx + XZx + xn, offz + XZy + tn, radx, radz, 0, 360);
                }
                if (this.settings[SetViewing.VIEW][2] && this.settings[obj][2]) {
                    g.drawArc(offz + YZx + tn, offy + YZy + yn, radz, rady, 0, 360);
                }
                ++n;
            }
        }
        if (this.xspot != null && this.displaySpot) {
            obj = SetViewing.SPOT;
            g.setColor(this.colors[obj]);
            if (this.settings[SetViewing.VIEW][0] && this.settings[obj][0]) {
                g.drawArc(offx + XYx + this.round((double)this.xspot[this.tpos] * this.zoomX), offy + XYy + this.round((double)this.yspot[this.tpos] * this.zoomY), radx, rady, 0, 360);
            }
            if (this.settings[SetViewing.VIEW][1] && this.settings[obj][1]) {
                g.drawArc(offx + XZx + this.round((double)this.xspot[this.tpos] * this.zoomX), offz + XZy + this.round((double)this.tpos * this.zoomZ), radx, radz, 0, 360);
            }
            if (this.settings[SetViewing.VIEW][2] && this.settings[obj][2]) {
                g.drawArc(offz + YZx + this.round((double)this.tpos * this.zoomZ), offy + YZy + this.round((double)this.yspot[this.tpos] * this.zoomY), radz, rady, 0, 360);
            }
        }
        XYx += cx;
        XYy += cy;
        XYw += cx;
        XYh += cy;
        XZx += cx;
        XZy += cz;
        XZw += cx;
        XZh += cz;
        YZy += cz;
        YZw += cy;
        YZh += cz;
        CTx += cz;
        CTy += cz;
        CTw += cz;
        CTh += cz;
        double r = (double)this.nt * this.zoomZ / 100.0;
        if (this.xspot != null && this.displayTrack) {
            obj = SetViewing.SPOT;
            g.setColor(this.colors[obj]);
            k = 1;
            while (k < this.xspot.length) {
                if (this.vspot[k] >= this.decision) {
                    int kk = (int)((double)k * this.zoomZ);
                    int kkk = (int)((double)(k - 1) * this.zoomZ);
                    if (this.settings[SetViewing.VIEW][0] && this.settings[obj][0]) {
                        g.drawLine(XYx + (int)((double)this.xspot[k - 1] * this.zoomX), XYy + (int)((double)this.yspot[k - 1] * this.zoomY), XYx + (int)((double)this.xspot[k] * this.zoomX), XYy + (int)((double)this.yspot[k] * this.zoomY));
                    }
                    if (this.settings[SetViewing.VIEW][1] && this.settings[obj][1]) {
                        g.drawLine(XZx + (int)((double)this.xspot[k - 1] * this.zoomX), XZy + kkk, XZx + (int)((double)this.xspot[k] * this.zoomX), XZy + kk);
                    }
                    if (this.settings[SetViewing.VIEW][2] && this.settings[obj][2]) {
                        g.drawLine(YZx + kkk, YZy + (int)((double)this.yspot[k - 1] * this.zoomY), YZx + kk, YZy + (int)((double)this.yspot[k] * this.zoomY));
                    }
                }
                ++k;
            }
        }
        if (this.settings[SetViewing.VIEW][3] && this.xspot != null && this.displayTrack) {
            g.setColor(this.colors[SetViewing.SPOT]);
            k = 1;
            while (k < this.xspot.length) {
                if (this.vspot[k] >= this.decision) {
                    int kz = this.round((double)k * this.zoomZ);
                    int kkz = this.round((double)(k - 1) * this.zoomZ);
                    g.drawLine(CTx + kkz + cz, CTy + CTh - this.round((double)this.vspot[k - 1] * r), CTx + kz + cz, CTy + CTh - this.round((double)this.vspot[k] * r));
                }
                ++k;
            }
            g.drawLine(CTx, CTy + CTh - this.round((double)this.decision * r), CTx + CTw - 2 * cz, CTy + CTh - this.round((double)this.decision * r));
        }
        g.setColor(Color.black);
        if (this.settings[SetViewing.VIEW][0]) {
            g.drawRect(XYx - this.round(this.zoomX / 2.0), XYy - this.round(this.zoomY / 2.0), XYw - 1, XYh - 1);
        }
        if (this.settings[SetViewing.VIEW][1]) {
            g.drawRect(XZx - this.round(this.zoomX / 2.0), XZy - this.round(this.zoomZ / 2.0), XZw - 1, XZh - 1);
        }
        if (this.settings[SetViewing.VIEW][2]) {
            g.drawRect(YZx - this.round(this.zoomY / 2.0), YZy - this.round(this.zoomZ / 2.0), YZw, YZh - 1);
        }
        if (this.settings[SetViewing.VIEW][3]) {
            g.drawRect(CTx - this.round(this.zoomY / 2.0), CTy - this.round(this.zoomZ / 2.0), CTw, CTh - 1);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.createOffScreen(true);
        if (this.offScreen != null) {
            g.drawImage(this.offScreen, 0, 0, this);
        }
    }

    public void saveView() {
        block3: {
            FileDialog dlg = new FileDialog(new Frame(), "Save View as a TIFF image", 1);
            ((Component)dlg).setVisible(true);
            String path = dlg.getDirectory();
            String filename = dlg.getFile();
            if (path == null || filename == null) {
                return;
            }
            if (this.offScreen == null) break block3;
            ImagePlus impFull = new ImagePlus("Save View", this.offScreen);
            FileInfo fi = impFull.getFileInfo();
            fi.nImages = 1;
            try {
                TiffEncoder file = new TiffEncoder(fi);
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + "/" + filename)));
                file.write(out);
                out.close();
            }
            catch (Exception e) {
                IJ.write((String)(" " + e));
            }
        }
    }

    public void updateSlice() {
        boolean flag;
        double elpas = (double)System.currentTimeMillis() - this.previousTimeMouseDragedd;
        boolean bl = flag = elpas < 300.0;
        if (flag) {
            this.repaint();
            return;
        }
        this.previousTimeMouseDragedd = System.currentTimeMillis();
        double chrono = System.currentTimeMillis();
        this.xpos = this.xpos < 0 ? 0 : this.xpos;
        this.ypos = this.ypos < 0 ? 0 : this.ypos;
        this.tpos = this.tpos < 0 ? 0 : this.tpos;
        this.xpos = this.xpos > this.nx - 1 ? this.nx - 1 : this.xpos;
        this.ypos = this.ypos > this.ny - 1 ? this.ny - 1 : this.ypos;
        this.tpos = this.tpos > this.nt - 1 ? this.nt - 1 : this.tpos;
        switch (this.dataview) {
            case 0: {
                this.imageXY = this.buildColorProcessorXY(this.handler.volSource, this.tpos);
                this.imageXZ = this.buildColorProcessorXT(this.handler.volSource, this.ypos);
                this.imageYZ = this.buildColorProcessorTY(this.handler.volSource, this.xpos);
                break;
            }
            case 1: {
                this.imageXY = this.buildColorProcessorXY(this.handler.volNorm, this.tpos);
                this.imageXZ = this.buildColorProcessorXT(this.handler.volNorm, this.ypos);
                this.imageYZ = this.buildColorProcessorTY(this.handler.volNorm, this.xpos);
                break;
            }
            case 2: {
                this.imageXY = this.buildColorProcessorXY(this.handler.volAlign, this.tpos);
                this.imageXZ = this.buildColorProcessorXT(this.handler.volAlign, this.ypos);
                this.imageYZ = this.buildColorProcessorTY(this.handler.volAlign, this.xpos);
                break;
            }
            case 3: {
                this.imageXY = this.buildColorProcessorXY(this.handler.volFilter, this.tpos);
                this.imageXZ = this.buildColorProcessorXT(this.handler.volFilter, this.ypos);
                this.imageYZ = this.buildColorProcessorTY(this.handler.volFilter, this.xpos);
                break;
            }
        }
        this.repaint();
        this.frame.setStatus();
    }

    public void mouseDragged(MouseEvent e) {
        Point pt = e.getPoint();
        Rectangle rxz = new Rectangle(this.round((double)this.rectXZ.x * this.zoomX) + this.interval, this.round((double)this.rectXZ.y * this.zoomY) + 2 * this.interval, this.round((double)this.rectXZ.width * this.zoomX), this.round((double)this.rectXZ.height * this.zoomZ));
        if (rxz.contains(pt)) {
            this.tpos = this.round((double)(pt.y - rxz.y) / this.zoomZ - 0.5);
            this.activeView = 2;
            this.updateSlice();
            return;
        }
        Rectangle ryz = new Rectangle(this.round((double)this.rectYZ.x * this.zoomX) + 2 * this.interval, this.round((double)this.rectYZ.y * this.zoomY) + this.interval, this.round((double)this.rectYZ.width * this.zoomZ), this.round((double)this.rectYZ.height * this.zoomY));
        if (ryz.contains(pt)) {
            this.tpos = this.round((double)(pt.x - ryz.x) / this.zoomZ - 0.5);
            this.activeView = 1;
            this.updateSlice();
            this.repaint();
            return;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void pressPosition(MouseEvent e) {
        Point pt = e.getPoint();
        Rectangle rxy = new Rectangle(this.round((double)this.rectXY.x * this.zoomX) + this.interval, this.round((double)this.rectXY.y * this.zoomY) + this.interval, this.round((double)this.rectXY.width * this.zoomX), this.round((double)this.rectXY.height * this.zoomY));
        if (rxy.contains(pt)) {
            this.xpos = this.round((double)(pt.x - rxy.x) / this.zoomX - 0.5);
            this.ypos = this.round((double)(pt.y - rxy.y) / this.zoomY - 0.5);
            this.activeView = 0;
            this.updateSlice();
            this.frame.setStatus();
            return;
        }
        Rectangle rxz = new Rectangle(this.round((double)this.rectXZ.x * this.zoomX) + this.interval, this.round((double)this.rectXZ.y * this.zoomY) + 2 * this.interval, this.round((double)this.rectXZ.width * this.zoomX), this.round((double)this.rectXZ.height * this.zoomZ));
        if (rxz.contains(pt)) {
            this.tpos = this.round((double)(pt.y - rxz.y) / this.zoomZ - 0.5);
            this.activeView = 2;
            this.updateSlice();
            return;
        }
        Rectangle ryz = new Rectangle(this.round((double)this.rectYZ.x * this.zoomX) + 2 * this.interval, this.round((double)this.rectYZ.y * this.zoomY) + this.interval, this.round((double)this.rectYZ.width * this.zoomZ), this.round((double)this.rectYZ.height * this.zoomY));
        if (ryz.contains(pt)) {
            this.tpos = this.round((double)(pt.x - ryz.x) / this.zoomZ - 0.5);
            this.activeView = 1;
            this.updateSlice();
            return;
        }
        Rectangle rct = new Rectangle(ryz.x, rxz.y, ryz.width, rxz.height);
        if (rct.contains(pt)) {
            this.tpos = this.round((double)(pt.x - rct.x) / this.zoomZ - 0.5);
            this.activeView = 3;
            this.updateSlice();
            return;
        }
    }

    public void pressed(KeyEvent e) {
        boolean shift = KeyEvent.getKeyModifiersText(e.getModifiers()).equals("Shift");
        if (shift & this.activeView == 0) {
            switch (e.getKeyCode()) {
                case 37: {
                    --this.tpos;
                    break;
                }
                case 39: {
                    ++this.tpos;
                    break;
                }
            }
            this.updateSlice();
            return;
        }
        switch (e.getKeyCode()) {
            case 32: 
            case 33: 
            case 123: {
                ++this.tpos;
                this.updateSlice();
                break;
            }
            case 8: 
            case 34: 
            case 122: {
                --this.tpos;
                this.updateSlice();
                break;
            }
            case 40: {
                ++this.ypos;
                this.updateSlice();
                break;
            }
            case 38: {
                --this.ypos;
                this.updateSlice();
                break;
            }
            case 37: {
                --this.xpos;
                this.updateSlice();
                break;
            }
            case 39: {
                ++this.xpos;
                this.updateSlice();
                break;
            }
        }
    }

    private int round(double f) {
        double f05 = f + 0.5;
        if (f05 >= 0.0) {
            return (int)f05;
        }
        int iAdd = (int)f05 - 1;
        return (int)(f05 - (double)iAdd) + iAdd;
    }

    private ColorModel makeDefaultColorModel() {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        int i = 0;
        while (i < 256) {
            rLUT[i] = (byte)i;
            gLUT[i] = (byte)i;
            bLUT[i] = (byte)i;
            ++i;
        }
        IndexColorModel cm = new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
        return cm;
    }

    public Image buildColorProcessorXY(ImageWare input, int z) {
        int maxb;
        double[][] arr = new double[this.nx][this.ny];
        byte[] pixels = new byte[this.nx * this.ny];
        int off = 0;
        double maxd = 255.0;
        input.getXY(0, 0, z, arr);
        if (!this.inverse) {
            maxb = -1;
            int y = 0;
            while (y < this.ny) {
                int x = 0;
                while (x < this.nx) {
                    pixels[x + off] = (byte)(arr[x][y] > maxd ? maxb : (byte)arr[x][y]);
                    ++x;
                }
                ++y;
                off += this.nx;
            }
        } else {
            maxb = 0;
            int cst = -1;
            int y = 0;
            while (y < this.ny) {
                int x = 0;
                while (x < this.nx) {
                    pixels[x + off] = (byte)(arr[x][y] > maxd ? maxb : (byte)((double)cst - arr[x][y]));
                    ++x;
                }
                ++y;
                off += this.nx;
            }
        }
        MemoryImageSource source = new MemoryImageSource(this.nx, this.ny, this.colormodel, pixels, 0, this.nx);
        return Toolkit.getDefaultToolkit().createImage(source);
    }

    public Image buildColorProcessorXT(ImageWare input, int y) {
        byte[] pixels = new byte[this.nx * this.nt];
        int index = 0;
        double maxd = 255.0;
        if (this.projection == 0) {
            double[][] arr = new double[this.nx][this.nt];
            input.getXZ(0, y, 0, arr);
            if (!this.inverse) {
                int maxb = -1;
                int t = 0;
                while (t < this.nt) {
                    int x = 0;
                    while (x < this.nx) {
                        pixels[index++] = (byte)(arr[x][t] > maxd ? maxb : (byte)arr[x][t]);
                        ++x;
                    }
                    ++t;
                }
            } else {
                byte maxb = 0;
                int cst = -1;
                int t = 0;
                while (t < this.nt) {
                    int x = 0;
                    while (x < this.nx) {
                        pixels[index++] = arr[x][t] > maxd ? maxb : (byte)((double)cst - arr[x][t]);
                        ++x;
                    }
                    ++t;
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.nx, this.nt, this.colormodel, pixels, 0, this.nx));
        }
        if (this.projection == 1) {
            double maxi = 0.0;
            double[] line = new double[this.ny];
            int t = 0;
            while (t < this.nt) {
                int x = 0;
                while (x < this.nx) {
                    int maxb;
                    input.getY(x, 0, t, line);
                    maxi = line[0];
                    y = 1;
                    while (y < this.ny) {
                        if (maxi < line[y]) {
                            maxi = line[y];
                        }
                        ++y;
                    }
                    if (!this.inverse) {
                        maxb = -1;
                        pixels[index++] = (byte)(maxi > maxd ? maxb : (byte)maxi);
                    } else {
                        maxb = 0;
                        int cst = -1;
                        pixels[index++] = (byte)(maxi > maxd ? maxb : (byte)((double)cst - maxi));
                    }
                    ++x;
                }
                ++t;
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.nx, this.nt, this.colormodel, pixels, 0, this.nx));
        }
        if (this.projection == 2 && this.xspot != null) {
            double[][] slice = new double[this.nx][this.ny];
            int t = 0;
            while (t < this.nt) {
                int maxb;
                input.getXY(0, 0, t, slice);
                if (!this.inverse) {
                    maxb = -1;
                    int x = 0;
                    while (x < this.nx) {
                        pixels[index++] = (byte)(slice[x][FMath.round(this.yspot[t])] > maxd ? maxb : (byte)slice[x][FMath.round(this.yspot[t])]);
                        ++x;
                    }
                } else {
                    maxb = 0;
                    int cst = -1;
                    int x = 0;
                    while (x < this.nx) {
                        pixels[index++] = (byte)(slice[x][FMath.round(this.yspot[t])] > maxd ? maxb : (byte)((double)cst - slice[x][FMath.round(this.yspot[t])]));
                        ++x;
                    }
                }
                ++t;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.nx, this.nt, this.colormodel, pixels, 0, this.nx));
    }

    public Image buildColorProcessorTY(ImageWare input, int x) {
        int index = 0;
        byte[] pixels = new byte[this.ny * this.nt];
        double maxd = 255.0;
        if (this.projection == 0) {
            double[][] arr = new double[this.ny][this.nt];
            input.getYZ(x, 0, 0, arr);
            if (!this.inverse) {
                int maxb = -1;
                int y = 0;
                while (y < this.ny) {
                    int t = 0;
                    while (t < this.nt) {
                        pixels[index++] = (byte)(arr[y][t] > maxd ? maxb : (byte)arr[y][t]);
                        ++t;
                    }
                    ++y;
                }
            } else {
                byte maxb = 0;
                int cst = -1;
                int y = 0;
                while (y < this.ny) {
                    int t = 0;
                    while (t < this.nt) {
                        pixels[index++] = arr[y][t] > maxd ? maxb : (byte)((double)cst - arr[y][t]);
                        ++t;
                    }
                    ++y;
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.nt, this.ny, this.colormodel, pixels, 0, this.nt));
        }
        if (this.projection == 1) {
            double[] line = new double[this.nx];
            double maxi = 0.0;
            int y = 0;
            while (y < this.ny) {
                int t = 0;
                while (t < this.nt) {
                    int maxb;
                    input.getX(0, y, t, line);
                    maxi = line[0];
                    x = 1;
                    while (x < this.nx) {
                        if (maxi < line[x]) {
                            maxi = line[x];
                        }
                        ++x;
                    }
                    if (!this.inverse) {
                        maxb = -1;
                        pixels[index++] = (byte)(maxi > maxd ? maxb : (byte)maxi);
                    } else {
                        maxb = 0;
                        int cst = -1;
                        pixels[index++] = (byte)(maxi > maxd ? maxb : (byte)((double)cst - maxi));
                    }
                    ++t;
                }
                ++y;
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.nt, this.ny, this.colormodel, pixels, 0, this.nt));
        }
        if (this.projection == 2) {
            double[][] slice = new double[this.nx][this.ny];
            if (this.xspot != null) {
                int t = 0;
                while (t < this.nt) {
                    int maxb;
                    input.getXY(0, 0, t, slice);
                    if (!this.inverse) {
                        maxb = -1;
                        int y = 0;
                        while (y < this.ny) {
                            pixels[t + y * this.nt] = (byte)(slice[FMath.round(this.xspot[t])][y] > maxd ? maxb : (byte)slice[FMath.round(this.xspot[t])][y]);
                            ++y;
                        }
                    } else {
                        maxb = 0;
                        int cst = -1;
                        int y = 0;
                        while (y < this.ny) {
                            pixels[t + y * this.nt] = (byte)(slice[FMath.round(this.xspot[t])][y] > maxd ? maxb : (byte)((double)cst - slice[FMath.round(this.xspot[t])][y]));
                            ++y;
                        }
                    }
                    ++t;
                }
            }
        }
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.nt, this.ny, this.colormodel, pixels, 0, this.nt));
    }
}

