/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

class pointHandler
extends Roi {
    public static final int RAINBOW = 1;
    public static final int MONOCHROME = 2;
    public static final int GAMUT = 1024;
    private static final int CROSS_HALFSIZE = 5;
    private final Color[] spectrum = new Color[1024];
    private final boolean[] usedColor = new boolean[1024];
    private final Vector listColors = new Vector(0, 16);
    private final Vector listPoints = new Vector(0, 16);
    private ImagePlus imp;
    private pointAction pa;
    private pointToolbar tb;
    private int nextColor = 0;
    private int currentPoint = -1;
    private int numPoints = 0;
    private boolean started = false;

    public void addPoint(int n, int n2) {
        if (this.numPoints < 1024) {
            if (this.usedColor[this.nextColor]) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < 1024) {
                    ++this.nextColor;
                    this.nextColor &= 0x3FF;
                    if (!this.usedColor[this.nextColor]) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    throw new IllegalStateException("Unexpected lack of available colors");
                }
            }
            Point point = new Point(n, n2);
            this.listPoints.addElement(point);
            this.listColors.addElement(new Integer(this.nextColor));
            this.usedColor[this.nextColor] = true;
            ++this.nextColor;
            this.nextColor &= 0x3FF;
            this.currentPoint = this.numPoints++;
        } else {
            IJ.error((String)"Maximum number of points reached for this slice");
        }
    }

    public void addPoint(int n, int n2, int n3) {
        if (this.usedColor[n3]) {
            throw new IllegalStateException("Illegal color request");
        }
        Point point = new Point(n, n2);
        this.listPoints.addElement(point);
        this.listColors.addElement(new Integer(n3));
        this.usedColor[n3] = true;
        this.currentPoint = this.numPoints++;
    }

    public void draw(Graphics graphics) {
        if (this.started) {
            float f = (float)this.ic.getMagnification();
            int n = (int)((double)f / 2.0);
            int n2 = (int)((double)f / 2.0);
            int n3 = 0;
            while (n3 < this.numPoints) {
                Point point = (Point)this.listPoints.elementAt(n3);
                graphics.setColor(this.spectrum[(Integer)this.listColors.elementAt(n3)]);
                if (n3 == this.currentPoint) {
                    if (this.pa.isActive()) {
                        graphics.drawLine(this.ic.screenX(point.x - 5 - 1) + n, this.ic.screenY(point.y - 1) + n2, this.ic.screenX(point.x - 1) + n, this.ic.screenY(point.y - 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x - 1) + n, this.ic.screenY(point.y - 1) + n2, this.ic.screenX(point.x - 1) + n, this.ic.screenY(point.y - 5 - 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x - 1) + n, this.ic.screenY(point.y - 5 - 1) + n2, this.ic.screenX(point.x + 1) + n, this.ic.screenY(point.y - 5 - 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x + 1) + n, this.ic.screenY(point.y - 5 - 1) + n2, this.ic.screenX(point.x + 1) + n, this.ic.screenY(point.y - 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x + 1) + n, this.ic.screenY(point.y - 1) + n2, this.ic.screenX(point.x + 5 + 1) + n, this.ic.screenY(point.y - 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x + 5 + 1) + n, this.ic.screenY(point.y - 1) + n2, this.ic.screenX(point.x + 5 + 1) + n, this.ic.screenY(point.y + 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x + 5 + 1) + n, this.ic.screenY(point.y + 1) + n2, this.ic.screenX(point.x + 1) + n, this.ic.screenY(point.y + 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x + 1) + n, this.ic.screenY(point.y + 1) + n2, this.ic.screenX(point.x + 1) + n, this.ic.screenY(point.y + 5 + 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x + 1) + n, this.ic.screenY(point.y + 5 + 1) + n2, this.ic.screenX(point.x - 1) + n, this.ic.screenY(point.y + 5 + 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x - 1) + n, this.ic.screenY(point.y + 5 + 1) + n2, this.ic.screenX(point.x - 1) + n, this.ic.screenY(point.y + 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x - 1) + n, this.ic.screenY(point.y + 1) + n2, this.ic.screenX(point.x - 5 - 1) + n, this.ic.screenY(point.y + 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x - 5 - 1) + n, this.ic.screenY(point.y + 1) + n2, this.ic.screenX(point.x - 5 - 1) + n, this.ic.screenY(point.y - 1) + n2);
                        if (this.ic.getMagnification() > 1.0) {
                            graphics.drawLine(this.ic.screenX(point.x - 5) + n, this.ic.screenY(point.y) + n2, this.ic.screenX(point.x + 5) + n, this.ic.screenY(point.y) + n2);
                            graphics.drawLine(this.ic.screenX(point.x) + n, this.ic.screenY(point.y - 5) + n2, this.ic.screenX(point.x) + n, this.ic.screenY(point.y + 5) + n2);
                        }
                    } else {
                        graphics.drawLine(this.ic.screenX(point.x - 5 + 1) + n, this.ic.screenY(point.y - 5 + 1) + n2, this.ic.screenX(point.x + 5 - 1) + n, this.ic.screenY(point.y + 5 - 1) + n2);
                        graphics.drawLine(this.ic.screenX(point.x - 5 + 1) + n, this.ic.screenY(point.y + 5 - 1) + n2, this.ic.screenX(point.x + 5 - 1) + n, this.ic.screenY(point.y - 5 + 1) + n2);
                    }
                } else {
                    graphics.drawLine(this.ic.screenX(point.x - 5) + n, this.ic.screenY(point.y) + n2, this.ic.screenX(point.x + 5) + n, this.ic.screenY(point.y) + n2);
                    graphics.drawLine(this.ic.screenX(point.x) + n, this.ic.screenY(point.y - 5) + n2, this.ic.screenX(point.x) + n, this.ic.screenY(point.y + 5) + n2);
                }
                ++n3;
            }
            if (this.updateFullWindow) {
                this.updateFullWindow = false;
                this.imp.draw();
            }
        }
    }

    public void findClosest(int n, int n2) {
        if (this.numPoints == 0) {
            return;
        }
        n = this.ic.offScreenX(n);
        n2 = this.ic.offScreenY(n2);
        Point point = new Point((Point)this.listPoints.elementAt(this.currentPoint));
        float f = (float)(n - point.x) * (float)(n - point.x) + (float)(n2 - point.y) * (float)(n2 - point.y);
        int n3 = 0;
        while (n3 < this.numPoints) {
            point = (Point)this.listPoints.elementAt(n3);
            float f2 = (float)(n - point.x) * (float)(n - point.x) + (float)(n2 - point.y) * (float)(n2 - point.y);
            if (f2 < f) {
                f = f2;
                this.currentPoint = n3;
            }
            ++n3;
        }
    }

    public Vector getColors() {
        return this.listColors;
    }

    public Integer getCurrentColor() {
        return this.currentPoint >= 0 ? (Integer)this.listColors.elementAt(this.currentPoint) : new Integer(-1);
    }

    public Point getPoint() {
        return this.currentPoint >= 0 ? (Point)this.listPoints.elementAt(this.currentPoint) : null;
    }

    public Vector getPoints() {
        return this.listPoints;
    }

    public boolean isUsedColor(int n) {
        return this.usedColor[n];
    }

    public void movePoint(int n, int n2) {
        if (this.currentPoint >= 0) {
            n = this.ic.offScreenX(n);
            n2 = this.ic.offScreenY(n2);
            n = n < 0 ? 0 : n;
            n = this.imp.getWidth() <= n ? this.imp.getWidth() - 1 : n;
            n2 = n2 < 0 ? 0 : n2;
            n2 = this.imp.getHeight() <= n2 ? this.imp.getHeight() - 1 : n2;
            this.listPoints.removeElementAt(this.currentPoint);
            Point point = new Point(n, n2);
            this.listPoints.insertElementAt(point, this.currentPoint);
        }
    }

    public void movePoint(int n, int n2, Integer n3) {
        int n4 = this.listColors.indexOf(n3);
        if (n4 == -1) {
            return;
        }
        this.currentPoint = n4;
        this.movePoint(n, n2);
    }

    public void nextPoint() {
        this.currentPoint = this.currentPoint == this.numPoints - 1 ? 0 : this.currentPoint + 1;
    }

    public pointHandler(ImagePlus imagePlus, pointToolbar pointToolbar2) {
        super(0, 0, imagePlus.getWidth(), imagePlus.getHeight(), imagePlus);
        this.imp = imagePlus;
        this.tb = pointToolbar2;
        this.setSpectrum(1);
    }

    public void removePoint() {
        if (this.numPoints > 0) {
            this.listPoints.removeElementAt(this.currentPoint);
            this.usedColor[((Integer)this.listColors.elementAt((int)this.currentPoint)).intValue()] = false;
            this.listColors.removeElementAt(this.currentPoint);
            --this.numPoints;
        }
        this.currentPoint = this.numPoints - 1;
        if (this.currentPoint < 0) {
            this.tb.setTool(0);
        }
    }

    public void removePoint(Integer n) {
        int n2 = this.listColors.indexOf(n);
        if (n2 == -1) {
            return;
        }
        this.currentPoint = n2;
        this.removePoint();
    }

    public void removePoints() {
        this.listPoints.removeAllElements();
        this.listColors.removeAllElements();
        int n = 0;
        while (n < 1024) {
            this.usedColor[n] = false;
            ++n;
        }
        this.nextColor = 0;
        this.numPoints = 0;
        this.currentPoint = -1;
        this.tb.setTool(0);
        this.imp.setRoi((Roi)this);
    }

    public void setPointAction(pointAction pointAction2) {
        this.pa = pointAction2;
        this.started = true;
    }

    public void setSpectrum(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                int n3 = 170;
                int n4 = 341;
                int n5 = 512;
                int n6 = 682;
                int n7 = 853;
                int n8 = 1024;
                float f = 170.0f;
                float f2 = 171.0f;
                float f3 = 171.0f;
                float f4 = 170.0f;
                float f5 = 171.0f;
                float f6 = 171.0f;
                do {
                    this.spectrum[this.stirColor((int)n2)] = new Color(1.0f, (float)n2 / 170.0f, 0.0f);
                    this.usedColor[this.stirColor((int)n2)] = false;
                } while (++n2 < 170);
                do {
                    this.spectrum[this.stirColor((int)n2)] = new Color(1.0f - (float)(n2 - 170) / 171.0f, 1.0f, 0.0f);
                    this.usedColor[this.stirColor((int)n2)] = false;
                } while (++n2 < 341);
                do {
                    this.spectrum[this.stirColor((int)n2)] = new Color(0.0f, 1.0f, (float)(n2 - 341) / 171.0f);
                    this.usedColor[this.stirColor((int)n2)] = false;
                } while (++n2 < 512);
                do {
                    this.spectrum[this.stirColor((int)n2)] = new Color(0.0f, 1.0f - (float)(n2 - 512) / 170.0f, 1.0f);
                    this.usedColor[this.stirColor((int)n2)] = false;
                } while (++n2 < 682);
                do {
                    this.spectrum[this.stirColor((int)n2)] = new Color((float)(n2 - 682) / 171.0f, 0.0f, 1.0f);
                    this.usedColor[this.stirColor((int)n2)] = false;
                } while (++n2 < 853);
                do {
                    this.spectrum[this.stirColor((int)n2)] = new Color(1.0f, 0.0f, 1.0f - (float)(n2 - 853) / 171.0f);
                    this.usedColor[this.stirColor((int)n2)] = false;
                } while (++n2 < 1024);
                break;
            }
            case 2: {
                n2 = 0;
                while (n2 < 1024) {
                    this.spectrum[n2] = Roi.ROIColor;
                    this.usedColor[n2] = false;
                    ++n2;
                }
                break;
            }
        }
        this.imp.setRoi((Roi)this);
    }

    private int stirColor(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < (int)Math.round(Math.log(1024.0) / Math.log(2.0))) {
            n2 <<= 1;
            n2 |= n & 1;
            n >>= 1;
            ++n3;
        }
        return n2;
    }
}

