/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import imageware.ByteAccess;
import imageware.Pointwise;
import java.awt.Image;
import java.util.Random;

public class BytePointwise
extends ByteAccess
implements Pointwise {
    protected BytePointwise(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected BytePointwise(Image image, int n) {
        super(image, n);
    }

    protected BytePointwise(ImageStack imageStack, int n) {
        super(imageStack, n);
    }

    protected BytePointwise(ImageStack imageStack, byte by) {
        super(imageStack, by);
    }

    protected BytePointwise(byte[] byArray, int n) {
        super(byArray, n);
    }

    protected BytePointwise(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected BytePointwise(byte[][][] byArray, int n) {
        super(byArray, n);
    }

    protected BytePointwise(short[] sArray, int n) {
        super(sArray, n);
    }

    protected BytePointwise(short[][] sArray, int n) {
        super(sArray, n);
    }

    protected BytePointwise(short[][][] sArray, int n) {
        super(sArray, n);
    }

    protected BytePointwise(float[] fArray, int n) {
        super(fArray, n);
    }

    protected BytePointwise(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected BytePointwise(float[][][] fArray, int n) {
        super(fArray, n);
    }

    protected BytePointwise(double[] dArray, int n) {
        super(dArray, n);
    }

    protected BytePointwise(double[][] dArray, int n) {
        super(dArray, n);
    }

    protected BytePointwise(double[][][] dArray, int n) {
        super(dArray, n);
    }

    public void fillConstant(double d) {
        byte by = (byte)d;
        byte[] byArray = null;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = by;
                ++n2;
            }
            ++n;
        }
    }

    public void fillRamp() {
        int n = 0;
        byte[] byArray = null;
        int n2 = 0;
        while (n2 < this.nz) {
            byArray = (byte[])this.data[n2];
            int n3 = 0;
            while (n3 < this.nxy) {
                byArray[n3] = (byte)(n + n3);
                ++n3;
            }
            n += this.nxy;
            ++n2;
        }
    }

    public void fillGaussianNoise(double d) {
        Random random = new Random();
        byte[] byArray = null;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = (byte)(random.nextGaussian() * d);
                ++n2;
            }
            ++n;
        }
    }

    public void fillUniformNoise(double d) {
        Random random = new Random();
        byte[] byArray = null;
        d *= 2.0;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = (byte)((random.nextDouble() - 0.5) * d);
                ++n2;
            }
            ++n;
        }
    }

    public void fillSaltPepper(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        double d5;
        Random random = new Random();
        Object var10_6 = null;
        if (d3 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d3;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                ((byte[])this.data[n])[n2] = (byte)(random.nextDouble() * d);
                ++n3;
            }
        }
        if (d4 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d4;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                ((byte[])this.data[n])[n2] = (byte)(-random.nextDouble() * d);
                ++n3;
            }
        }
    }

    public ImageStack buildImageStack() {
        ImageStack imageStack = new ImageStack(this.nx, this.ny);
        int n = 0;
        while (n < this.nz) {
            ByteProcessor byteProcessor = new ByteProcessor(this.nx, this.ny);
            byte[] byArray = (byte[])byteProcessor.getPixels();
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = ((byte[])this.data[n])[n2];
                ++n2;
            }
            imageStack.addSlice(String.valueOf(n), (ImageProcessor)byteProcessor);
            ++n;
        }
        return imageStack;
    }

    public void invert() {
        byte[] byArray;
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if ((double)(byArray[n2] & 0xFF) > d) {
                    d = byArray[n2] & 0xFF;
                }
                ++n2;
            }
            ++n;
        }
        double d2 = d;
        int n3 = 0;
        while (n3 < this.nz) {
            byArray = (byte[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                byArray[n4] = (byte)(d - (double)(byArray[n4] & 0xFF));
                ++n4;
            }
            ++n3;
        }
    }

    public void negate() {
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = (byte)(-((double)(byArray[n2] & 0xFF)));
                ++n2;
            }
            ++n;
        }
    }

    public void clip() {
        this.clip(0.0, 255.0);
    }

    public void clip(double d, double d2) {
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            byte by = (byte)d;
            byte by2 = (byte)d2;
            int n2 = 0;
            while (n2 < this.nxy) {
                byte by3 = (byte)(byArray[n2] & 0xFF);
                if (by3 < by) {
                    byArray[n2] = by;
                }
                if (by3 > by2) {
                    byArray[n2] = by2;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void rescale() {
        double d;
        byte[] byArray;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if ((double)(byArray[n2] & 0xFF) > d2) {
                    d2 = byArray[n2] & 0xFF;
                }
                if ((double)(byArray[n2] & 0xFF) < d3) {
                    d3 = byArray[n2] & 0xFF;
                }
                ++n2;
            }
            ++n;
        }
        if (d3 - d2 == 0.0) {
            d = 1.0;
            d3 = 128.0;
        } else {
            d = 255.0 / (d2 - d3);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            byArray = (byte[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                byArray[n4] = (byte)(d * ((double)(byArray[n4] & 0xFF) - d3));
                ++n4;
            }
            ++n3;
        }
    }

    public void rescale(double d, double d2) {
        double d3;
        byte[] byArray;
        double d4 = -1.7976931348623157E308;
        double d5 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if ((double)(byArray[n2] & 0xFF) > d4) {
                    d4 = byArray[n2] & 0xFF;
                }
                if ((double)(byArray[n2] & 0xFF) < d5) {
                    d5 = byArray[n2] & 0xFF;
                }
                ++n2;
            }
            ++n;
        }
        if (d5 - d4 == 0.0) {
            d3 = 1.0;
            d5 = (d2 - d) / 2.0;
        } else {
            d3 = (d2 - d) / (d4 - d5);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            byArray = (byte[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                byArray[n4] = (byte)(d3 * ((double)(byArray[n4] & 0xFF) - d5) + d);
                ++n4;
            }
            ++n3;
        }
    }

    public void rescaleCenter(double d, double d2) {
        double d3;
        byte[] byArray;
        double d4 = -1.7976931348623157E308;
        double d5 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if ((double)(byArray[n2] & 0xFF) > d4) {
                    d4 = byArray[n2] & 0xFF;
                }
                if ((double)(byArray[n2] & 0xFF) < d5) {
                    d5 = byArray[n2] & 0xFF;
                }
                ++n2;
            }
            ++n;
        }
        double d6 = (d2 + d) / 2.0;
        if (d5 - d4 == 0.0) {
            d3 = 1.0;
            d5 = (d2 - d) / 2.0;
        } else {
            d3 = Math.abs(d4) > Math.abs(d5) ? (d2 - d6) / Math.abs(d4) : (d6 - d) / Math.abs(d5);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            byArray = (byte[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                byArray[n4] = (byte)(d3 * ((double)(byArray[n4] & 0xFF) - d5) + d6);
                ++n4;
            }
            ++n3;
        }
    }

    public void abs() {
    }

    public void log() {
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = (byte)Math.log(byArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void exp() {
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = (byte)Math.exp(byArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void sqrt() {
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = (byte)Math.sqrt(byArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void sqr() {
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] * byArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void pow(double d) {
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = (byte)Math.pow(byArray[n2], d);
                ++n2;
            }
            ++n;
        }
    }

    public void add(double d) {
        byte by = (byte)d;
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] + by);
            }
            ++n;
        }
    }

    public void multiply(double d) {
        byte by = (byte)d;
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] * by);
            }
            ++n;
        }
    }

    public void subtract(double d) {
        byte by = (byte)d;
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] - by);
            }
            ++n;
        }
    }

    public void divide(double d) {
        if (d == 0.0) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to divide because the constant is 0.\n-------------------------------------------------------\n");
        }
        byte by = (byte)d;
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] / by);
            }
            ++n;
        }
    }

    public void threshold(double d) {
        this.threshold(d, 0.0, 255.0);
    }

    public void threshold(double d, double d2, double d3) {
        byte by = (byte)d2;
        byte by2 = (byte)d3;
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                byArray[n2] = (double)(byArray[n2] & 0xFF) > d ? by2 : by;
                ++n2;
            }
            ++n;
        }
    }

    public void thresholdSoft(double d) {
        byte by = 0;
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                double d2 = byArray[n2] & 0xFF;
                byArray[n2] = d2 <= -d ? (byte)(d2 + d) : (d2 > d ? (byte)(d2 - d) : by);
                ++n2;
            }
            ++n;
        }
    }

    public void thresholdHard(double d) {
        byte by = 0;
        int n = 0;
        while (n < this.nz) {
            byte[] byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                double d2 = byArray[n2] & 0xFF;
                if (d2 > -d && d2 < d) {
                    byArray[n2] = by;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void addGaussianNoise(double d) {
        Random random = new Random();
        byte[] byArray = null;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] + (byte)(random.nextGaussian() * d));
            }
            ++n;
        }
    }

    public void addUniformNoise(double d) {
        Random random = new Random();
        byte[] byArray = null;
        d *= 2.0;
        int n = 0;
        while (n < this.nz) {
            byArray = (byte[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] + (byte)((random.nextDouble() - 0.5) * d));
            }
            ++n;
        }
    }

    public void addSaltPepper(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        double d5;
        Random random = new Random();
        Object var10_6 = null;
        if (d3 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d3;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                byte[] byArray = (byte[])this.data[n];
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] + (byte)(random.nextDouble() * d));
                ++n3;
            }
        }
        if (d4 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d4;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                byte[] byArray = (byte[])this.data[n];
                int n5 = n2;
                byArray[n5] = (byte)(byArray[n5] - (byte)(random.nextDouble() * d));
                ++n3;
            }
        }
    }
}

