/*
 * Decompiled with CFR 0.152.
 */
package imageware;

public class Convolver {
    private static double tolerance = 1.0E-5;

    public static double[] convolveFIR(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        if (n2 <= 1) {
            throw new IllegalArgumentException("convolveFIR: input signal too short");
        }
        double[] dArray3 = new double[n2];
        int n3 = dArray2.length - 1;
        int n4 = 0;
        int n5 = 2 * (n2 - 1);
        int n6 = dArray2.length / 2;
        n -= (long)(n = 1 + n6 - dArray2.length) < 0L ? n5 * ((n + 1 - n5) / n5) : n5 * (n / n5);
        int n7 = 0;
        while (n7 < n2) {
            int n8 = -dArray2.length;
            int n9 = n;
            n3 = dArray2.length - 1;
            double d = 0.0;
            while (n8 < 0) {
                int n10;
                int n11;
                n4 = n9;
                int n12 = n11 = n9 - n2 < n8 ? n8 : n9 - n2;
                if ((long)n11 < 0L) {
                    n10 = n11;
                    while (n10 < 0) {
                        d += dArray[n4] * dArray2[n3];
                        --n3;
                        ++n4;
                        ++n10;
                    }
                    n9 -= n11;
                    n8 -= n11;
                }
                n4 = n5 - n9;
                int n13 = n10 = n9 - n5 < n8 ? n8 : n9 - n5;
                if ((long)n10 < 0L) {
                    int n14 = n10;
                    while (n14 < 0) {
                        d += dArray[n4] * dArray2[n3];
                        --n3;
                        --n4;
                        ++n14;
                    }
                    n8 -= n10;
                }
                n9 = 0;
            }
            if (++n == n5) {
                n = 0;
            }
            dArray3[n7] = d;
            ++n7;
        }
        return dArray3;
    }

    public static double[] convolveIIR(double[] dArray, double[] dArray2) {
        double d = 1.0;
        int n = dArray.length;
        double[] dArray3 = new double[n];
        int n2 = 0;
        while (n2 < dArray2.length) {
            d = d * (1.0 - dArray2[n2]) * (1.0 - 1.0 / dArray2[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            dArray3[n3] = dArray[n3] * d;
            ++n3;
        }
        int n4 = 0;
        while (n4 < dArray2.length) {
            dArray3[0] = Convolver.getInitialCausalCoefficientMirror(dArray3, dArray2[n4]);
            int n5 = 1;
            while (n5 < n) {
                dArray3[n5] = dArray3[n5] + dArray2[n4] * dArray3[n5 - 1];
                ++n5;
            }
            dArray3[n - 1] = Convolver.getInitialAntiCausalCoefficientMirror(dArray3, dArray2[n4]);
            int n6 = n - 2;
            while (n6 >= 0) {
                dArray3[n6] = dArray2[n4] * (dArray3[n6 + 1] - dArray3[n6]);
                --n6;
            }
            ++n4;
        }
        return dArray3;
    }

    public static double[] convolveIIR2(double[] dArray, double d, double d2) {
        int n = dArray.length;
        int n2 = 2 * n;
        double d3 = -(d2 + 1.0) * (1.0 - d + d2) / ((d2 - 1.0) * (1.0 + d + d2));
        double d4 = -d3 * d2 * d / (d2 + 1.0);
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        int n3 = 0;
        while (n3 < n) {
            dArray3[n3] = dArray[n3];
            dArray3[n2 - n3 - 1] = dArray[n3];
            ++n3;
        }
        int n4 = 2;
        if (tolerance > 0.0 && d2 != 1.0) {
            n4 = n2 - (int)Math.ceil(2.0 * Math.log(tolerance) / Math.log(d2));
        }
        if (n4 < 2) {
            n4 = 2;
        }
        dArray2[n4 - 1] = 0.0;
        dArray2[n4 - 2] = 0.0;
        int n5 = n4;
        while (n5 < n2) {
            dArray2[n5] = d3 * dArray3[n5] + d4 * dArray3[n5 - 1] + d * dArray2[n5 - 1] - d2 * dArray2[n5 - 2];
            ++n5;
        }
        dArray2[0] = d3 * dArray3[0] + d4 * dArray3[n2 - 1] + d * dArray2[n2 - 1] - d2 * dArray2[n2 - 2];
        dArray2[1] = d3 * dArray3[1] + d4 * dArray3[0] + d * dArray2[0] - d2 * dArray2[n2 - 1];
        int n6 = 2;
        while (n6 < n2) {
            dArray2[n6] = d3 * dArray3[n6] + d4 * dArray3[n6 - 1] + d * dArray2[n6 - 1] - d2 * dArray2[n6 - 2];
            ++n6;
        }
        double[] dArray4 = new double[n];
        int n7 = 0;
        while (n7 < n) {
            dArray4[n7] = dArray2[n7] + dArray2[n2 - n7 - 1] - d3 * dArray[n7];
            ++n7;
        }
        return dArray4;
    }

    private static double getInitialAntiCausalCoefficientMirror(double[] dArray, double d) {
        return (d * dArray[dArray.length - 2] + dArray[dArray.length - 1]) * d / (d * d - 1.0);
    }

    private static double getInitialCausalCoefficientMirror(double[] dArray, double d) {
        double d2 = d;
        double d3 = Math.pow(d, dArray.length - 1);
        double d4 = dArray[0] + d3 * dArray[dArray.length - 1];
        int n = dArray.length;
        if (tolerance > 0.0) {
            n = 2 + (int)(Math.log(tolerance) / Math.log(Math.abs(d)));
            n = n < dArray.length ? n : dArray.length;
        }
        d3 *= d3;
        int n2 = 1;
        while (n2 < n - 1) {
            d4 += (d2 + (d3 /= d)) * dArray[n2];
            d2 *= d;
            ++n2;
        }
        return d4 / (1.0 - Math.pow(d, 2 * dArray.length - 2));
    }
}

