/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImagePlus;
import ij.ImageStack;
import imageware.ByteSet;
import imageware.DoubleProcess;
import imageware.FloatSet;
import imageware.ImageWare;
import imageware.ShortSet;
import java.awt.Image;

public class DoubleSet
extends DoubleProcess
implements ImageWare {
    protected DoubleSet(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected DoubleSet(Image image, int n) {
        super(image, n);
    }

    protected DoubleSet(ImageStack imageStack, int n) {
        super(imageStack, n);
    }

    protected DoubleSet(ImageStack imageStack, byte by) {
        super(imageStack, by);
    }

    protected DoubleSet(byte[] byArray, int n) {
        super(byArray, n);
    }

    protected DoubleSet(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected DoubleSet(byte[][][] byArray, int n) {
        super(byArray, n);
    }

    protected DoubleSet(short[] sArray, int n) {
        super(sArray, n);
    }

    protected DoubleSet(short[][] sArray, int n) {
        super(sArray, n);
    }

    protected DoubleSet(short[][][] sArray, int n) {
        super(sArray, n);
    }

    protected DoubleSet(float[] fArray, int n) {
        super(fArray, n);
    }

    protected DoubleSet(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected DoubleSet(float[][][] fArray, int n) {
        super(fArray, n);
    }

    protected DoubleSet(double[] dArray, int n) {
        super(dArray, n);
    }

    protected DoubleSet(double[][] dArray, int n) {
        super(dArray, n);
    }

    protected DoubleSet(double[][][] dArray, int n) {
        super(dArray, n);
    }

    public ImageWare duplicate() {
        DoubleSet doubleSet = new DoubleSet(this.nx, this.ny, this.nz);
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])doubleSet.data[n];
            System.arraycopy(this.data[n], 0, dArray, 0, this.nxy);
            ++n;
        }
        return doubleSet;
    }

    public ImageWare replicate() {
        return new DoubleSet(this.nx, this.ny, this.nz);
    }

    public ImageWare replicate(int n) {
        switch (n) {
            case 1: {
                return new ByteSet(this.nx, this.ny, this.nz);
            }
            case 2: {
                return new ShortSet(this.nx, this.ny, this.nz);
            }
            case 3: {
                return new FloatSet(this.nx, this.ny, this.nz);
            }
            case 4: {
                return new DoubleSet(this.nx, this.ny, this.nz);
            }
        }
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + n + "].\n" + "-------------------------------------------------------\n");
    }

    public void copy(ImageWare imageWare) {
        if (this.nx != imageWare.getSizeX()) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to copy because it is not the same size (" + this.nx + " != " + imageWare.getSizeX() + ").\n" + "-------------------------------------------------------\n");
        }
        if (this.ny != imageWare.getSizeY()) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to copy because it is not the same size (" + this.ny + " != " + imageWare.getSizeY() + ").\n" + "-------------------------------------------------------\n");
        }
        if (this.nz != imageWare.getSizeZ()) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to copy because it is not the same size (" + this.nz + " != " + imageWare.getSizeZ() + ").\n" + "-------------------------------------------------------\n");
        }
        if (this.getType() != imageWare.getType()) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to copy because it is not the same type (" + this.getType() + " != " + imageWare.getType() + ").\n" + "-------------------------------------------------------\n");
        }
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])((DoubleSet)imageWare).data[n];
            System.arraycopy(dArray, 0, this.data[n], 0, this.nxy);
            ++n;
        }
    }

    public ImageWare convert(int n) {
        if (n == 4) {
            return this.duplicate();
        }
        ImageWare imageWare = null;
        switch (n) {
            case 1: {
                imageWare = new ByteSet(this.nx, this.ny, this.nz);
                int n2 = 0;
                while (n2 < this.nz) {
                    double[] dArray = (double[])this.data[n2];
                    byte[] byArray = (byte[])imageWare.data[n2];
                    int n3 = 0;
                    while (n3 < this.nxy) {
                        byArray[n3] = (byte)dArray[n3];
                        ++n3;
                    }
                    ++n2;
                }
                break;
            }
            case 2: {
                imageWare = new ShortSet(this.nx, this.ny, this.nz);
                int n4 = 0;
                while (n4 < this.nz) {
                    double[] dArray = (double[])this.data[n4];
                    short[] sArray = (short[])((ShortSet)imageWare).data[n4];
                    int n5 = 0;
                    while (n5 < this.nxy) {
                        sArray[n5] = (short)dArray[n5];
                        ++n5;
                    }
                    ++n4;
                }
                break;
            }
            case 3: {
                imageWare = new FloatSet(this.nx, this.ny, this.nz);
                int n6 = 0;
                while (n6 < this.nz) {
                    double[] dArray = (double[])this.data[n6];
                    float[] fArray = (float[])((FloatSet)imageWare).data[n6];
                    int n7 = 0;
                    while (n7 < this.nxy) {
                        fArray[n7] = (float)dArray[n7];
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
            case 4: {
                imageWare = new DoubleSet(this.nx, this.ny, this.nz);
                int n8 = 0;
                while (n8 < this.nz) {
                    double[] dArray = (double[])this.data[n8];
                    double[] dArray2 = (double[])((DoubleSet)imageWare).data[n8];
                    int n9 = 0;
                    while (n9 < this.nxy) {
                        dArray2[n9] = dArray[n9];
                        ++n9;
                    }
                    ++n8;
                }
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + n + "].\n" + "-------------------------------------------------------\n");
            }
        }
        return imageWare;
    }

    public void printInfo() {
        System.out.println("ImageWare object information");
        System.out.println("Dimension: " + this.getDimension());
        System.out.println("Size: [" + this.nx + ", " + this.ny + ", " + this.nz + "]");
        System.out.println("TotalSize: " + this.getTotalSize());
        System.out.println("Type: " + this.getTypeToString());
        System.out.println("Maximun: " + this.getMaximum());
        System.out.println("Minimun: " + this.getMinimum());
        System.out.println("Mean: " + this.getMean());
        System.out.println("Norm1: " + this.getNorm1());
        System.out.println("Norm2: " + this.getNorm2());
        System.out.println("Total: " + this.getTotal());
        System.out.println("");
    }

    public void show() {
        String string = this.getTypeToString();
        switch (this.getDimension()) {
            case 1: {
                string = String.valueOf(string) + " line";
                break;
            }
            case 2: {
                string = String.valueOf(string) + " image";
                break;
            }
            case 3: {
                string = String.valueOf(string) + " volume";
                break;
            }
        }
        ImagePlus imagePlus = new ImagePlus(string, this.buildImageStack());
        imagePlus.show();
    }

    public void show(String string) {
        ImagePlus imagePlus = new ImagePlus(string, this.buildImageStack());
        imagePlus.show();
    }

    public double getMinimum() {
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if (dArray[n2] < d) {
                    d = dArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public double getMaximum() {
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if (dArray[n2] > d) {
                    d = dArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public double getMean() {
        return this.getTotal() / (double)(this.nz * this.nxy);
    }

    public double getNorm1() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                d2 = dArray[n2];
                d += d2 > 0.0 ? d2 : -d2;
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public double getNorm2() {
        double d = 0.0;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                d += dArray[n2] * dArray[n2];
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public double getTotal() {
        double d = 0.0;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                d += dArray[n2];
                ++n2;
            }
            ++n;
        }
        return d;
    }

    public double[] getMinMax() {
        double d = -1.7976931348623157E308;
        double d2 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if (dArray[n2] > d) {
                    d = dArray[n2];
                }
                if (dArray[n2] < d2) {
                    d2 = dArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        double[] dArray = new double[]{d2, d};
        return dArray;
    }
}

