/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import imageware.Display;
import imageware.FMath;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import spottracker2d.CProgressBar;
import spottracker2d.Handler;
import spottracker2d.PointTrack;
import spottracker2d.Processor;
import spottracker2d.ThresholdPanel;
import spottracker2d.ViewerCanvas;

public class AlignNucleusFrame
extends JFrame
implements ActionListener,
Runnable {
    private Properties props = new Properties();
    private String filename = String.valueOf(System.getProperty("user.dir")) + "/plugins/SpotTracker2D/AlignNucleus.prefs";
    private Thread threadProcess = null;
    private ImagePlus imp = null;
    private double zoom = 1.0;
    private Handler handler = null;
    private CProgressBar progress = null;
    private boolean displayResult = true;
    private boolean display = false;
    private double sigmaXY = 1.0;
    private double sigmaZ = 1.0;
    private boolean smooth = false;
    private boolean isolated = false;
    private int threshold = 40;
    private ViewerCanvas canvas = null;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private JComboBox inputImages;
    private JComboBox cmbSource;
    private JButton bnAlign = new JButton("Align");
    private JButton bnClose = new JButton("Close");
    private JTextField txtSigmaXY = new JTextField("0.75", 4);
    private JTextField txtSigmaZ = new JTextField("0.75", 4);
    private JCheckBox chkDisplayNucleus = new JCheckBox("Display nucleus", true);
    private JCheckBox chkIsolatePoints = new JCheckBox("Remove isolated points", true);
    private JCheckBox chkSmooth = new JCheckBox("Smooth", true);
    private JCheckBox chkLevel = new JCheckBox("Threshold", true);
    private ThresholdPanel pnThreshold = new ThresholdPanel();

    public AlignNucleusFrame() {
        super("Align Nucleus");
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.error((String)"The image is not valid.");
            return;
        }
        int type = this.imp.getType();
        if (type != 0 && type != 1 && type != 2) {
            IJ.error((String)"Not a 8-bit, 16-bit or 32-bit image.");
            return;
        }
        this.handler = new Handler(this.imp, 1);
        this.progress = new CProgressBar(false);
        this.getPreferences();
        this.showThresholdImage();
        this.doDialog();
    }

    public AlignNucleusFrame(ImagePlus imp, Handler handler, CProgressBar progress, boolean dialog, ViewerCanvas canvas, JComboBox cmbSource) {
        super("Align Nucleus");
        this.imp = imp;
        this.handler = handler;
        this.progress = progress;
        this.canvas = canvas;
        this.cmbSource = cmbSource;
        this.displayResult = false;
        this.getPreferences();
        if (dialog) {
            this.showThresholdImage();
            this.doDialog();
        } else {
            this.start();
        }
    }

    private void start() {
        if (this.threadProcess == null) {
            this.threadProcess = new Thread(this);
            this.threadProcess.setPriority(1);
            this.threadProcess.start();
        }
    }

    private void showThresholdImage() {
        int ny;
        int nx = this.imp.getWidth();
        if (nx + (ny = this.imp.getHeight()) < 500) {
            this.zoom = 2.0;
        } else if (nx + ny < 250) {
            this.zoom = 3.0;
        } else if (nx + ny < 125) {
            this.zoom = 4.0;
        }
        ImageWindow win = this.imp.getWindow();
        ImageCanvas canvas = win.getCanvas();
        canvas.setDrawingSize(FMath.ceil((double)nx * this.zoom), FMath.ceil((double)ny * this.zoom));
        win.pack();
        canvas.setMagnification(this.zoom);
        this.pnThreshold.activeRed(this.imp, this.pnThreshold.getMin());
    }

    public void run() {
        double startTime = System.currentTimeMillis();
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        String title = this.imp.getTitle();
        int nt = this.imp.getStackSize();
        int nx = this.imp.getWidth();
        int ny = this.imp.getHeight();
        Processor process = new Processor(this.progress, this.handler, this.smooth, this.isolated);
        process.center(this.sigmaXY, this.sigmaZ, this.display, this.zoom, this.threshold);
        this.handler.volAlign = process.align(this.handler.volNorm);
        this.handler.volFilter = this.handler.volAlign.duplicate();
        this.handler.align = true;
        this.handler.startAlign = this.handler.findBestStartingPoint(this.handler.volAlign);
        this.handler.startFilter = new PointTrack(this.handler.startAlign);
        this.progress.finish();
        if (this.displayResult) {
            Display.show("NA " + title, this.handler.volAlign, this.zoom);
        }
        this.pnThreshold.activeBW();
        this.setCursor(cursor);
        this.threadProcess = null;
        if (this.canvas != null) {
            this.canvas.setDataViewing(2);
        }
        if (this.cmbSource != null) {
            this.cmbSource.setSelectedIndex(2);
        }
    }

    private void doDialog() {
        JPanel pnSmooth = new JPanel();
        pnSmooth.setLayout(this.layout);
        this.addComponent(pnSmooth, 0, 1, 1, 1, 3, new JLabel(" XY"));
        this.addComponent(pnSmooth, 0, 2, 1, 1, 3, this.txtSigmaXY);
        this.addComponent(pnSmooth, 0, 3, 1, 1, 3, new JLabel(" T"));
        this.addComponent(pnSmooth, 0, 4, 1, 1, 3, this.txtSigmaZ);
        JPanel pnSource = new JPanel();
        pnSource.setLayout(this.layout);
        this.addComponent(pnSource, 3, 0, 1, 1, 2, this.chkSmooth);
        this.addComponent(pnSource, 3, 1, 2, 1, 2, pnSmooth);
        this.addComponent(pnSource, 4, 0, 1, 1, 2, this.chkLevel);
        this.addComponent(pnSource, 4, 1, 2, 1, 2, this.pnThreshold);
        this.addComponent(pnSource, 5, 0, 2, 1, 2, this.chkIsolatePoints);
        this.addComponent(pnSource, 7, 0, 2, 1, 2, this.chkDisplayNucleus);
        JPanel pnButton = new JPanel();
        pnButton.setLayout(this.layout);
        this.addComponent(pnButton, 0, 0, 1, 1, 3, this.bnClose);
        this.addComponent(pnButton, 0, 1, 1, 1, 3, this.bnAlign);
        JPanel pnMain = new JPanel();
        pnMain.setLayout(this.layout);
        this.addComponent(pnMain, 0, 0, 1, 1, 3, pnSource);
        this.addComponent(pnMain, 1, 0, 1, 1, 3, pnButton);
        this.bnAlign.addActionListener(this);
        this.bnClose.addActionListener(this);
        this.txtSigmaXY.setText(String.valueOf(this.sigmaXY));
        this.txtSigmaZ.setText(String.valueOf(this.sigmaZ));
        this.pnThreshold.setMin(this.threshold);
        this.chkSmooth.setSelected(this.smooth);
        this.chkDisplayNucleus.setSelected(this.display);
        this.chkIsolatePoints.setSelected(this.isolated);
        this.getContentPane().add(pnMain);
        this.setResizable(false);
        this.pack();
        GUI.center((Window)this);
        this.show();
    }

    private void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnClose) {
            this.dispose();
        } else if (e.getSource() == this.bnAlign) {
            if (this.threadProcess == null) {
                this.threadProcess = new Thread(this);
                this.threadProcess.setPriority(1);
                this.threadProcess.start();
            }
            this.setPreferences();
            this.dispose();
        }
        this.notify();
    }

    private double getDoubleValue(JTextField text, double mini, double defaut, double maxi) {
        double d;
        block5: {
            try {
                String s = text.getText();
                if (s.charAt(0) == '-') {
                    s = s.substring(1);
                }
                if ((d = new Double(s).doubleValue()) < mini) {
                    text.setText(String.valueOf(mini));
                }
                if (d > maxi) {
                    text.setText(String.valueOf(maxi));
                }
            }
            catch (Exception e) {
                if (!(e instanceof NumberFormatException)) break block5;
                text.setText(String.valueOf(defaut));
            }
        }
        d = new Double(text.getText());
        return d;
    }

    private void getPreferences() {
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
        }
        catch (Exception exception) {}
        this.sigmaXY = Double.parseDouble(this.props.getProperty("txtSigmaXY", "0.75"));
        this.sigmaZ = Double.parseDouble(this.props.getProperty("txtSigmaZ", "0.75"));
        this.threshold = new Integer(this.props.getProperty("pnThreshold", "40"));
        this.smooth = this.props.getProperty("chkSmooth", "true").equals("true");
        this.display = this.props.getProperty("chkDisplayNucleus", "true").equals("true");
        this.isolated = this.props.getProperty("chkIsolatePoints", "true").equals("true");
    }

    private void setPreferences() {
        this.props.setProperty("chkSmooth", String.valueOf(this.chkSmooth.isSelected()));
        this.props.setProperty("chkDisplayNucleus", String.valueOf(this.chkDisplayNucleus.isSelected()));
        this.props.setProperty("chkIsolatePoints", String.valueOf(this.chkIsolatePoints.isSelected()));
        this.props.setProperty("txtSigmaXY", String.valueOf(this.txtSigmaXY.getText()));
        this.props.setProperty("txtSigmaZ", String.valueOf(this.txtSigmaZ.getText()));
        this.props.setProperty("pnThreshold", String.valueOf(this.pnThreshold.getMin()));
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, "Spot Tracker \n Header");
        }
        catch (Exception exception) {}
    }
}

