/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import imageware.Builder;
import imageware.FMath;
import imageware.ImageWare;
import imageware.Pointwise;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import spottracker2d.Handler;
import spottracker2d.TraceImageCanvas;

public class DisplayResultsDialog
extends JDialog
implements ActionListener,
ItemListener {
    public final int VIEW_SECTION = 0;
    public final int VIEW_MAXI_PROJECTION = 1;
    public final int VIEW_SPOT_PROJECTION = 2;
    private Handler handler = null;
    private static double zoom = 1.0;
    private static int view = 0;
    private static int mode = 0;
    private static int trace = 1;
    private static int text = 1;
    private static boolean inverse = false;
    private String[] listMode = new String[]{"Stack", "Maximum Intensity Projection", "Kymograph"};
    private String[] listView = new String[]{"(x,y) frame indexed by t (time)", "(t,x) indexed by y", "(t,y) indexed by x"};
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private JComboBox cmbMode = new JComboBox<String>(this.listMode);
    private JComboBox cmbView = new JComboBox<String>(this.listView);
    private JButton bnOK = new JButton("OK");
    private JButton bnCancel = new JButton("Cancel");
    private JCheckBox chkInverse = new JCheckBox("Inverse intensity", inverse);
    private JCheckBox chkTrace = new JCheckBox("Show overlaid trace", true);

    public DisplayResultsDialog(Handler handler) {
        super((Frame)new JFrame(), "Display Results");
        this.handler = handler;
        this.doDialog();
    }

    private void doDialog() {
        JPanel pnParams = new JPanel();
        pnParams.setLayout(this.layout);
        this.addComponent(pnParams, 0, 0, 1, 1, 4, new JLabel("View"));
        this.addComponent(pnParams, 0, 1, 2, 1, 4, this.cmbView);
        this.addComponent(pnParams, 1, 0, 1, 1, 4, new JLabel("Mode"));
        this.addComponent(pnParams, 1, 1, 2, 1, 4, this.cmbMode);
        this.addComponent(pnParams, 3, 1, 1, 1, 4, this.chkInverse);
        this.cmbView.setSelectedIndex(view);
        this.cmbMode.setSelectedIndex(mode);
        JPanel pnButton = new JPanel();
        pnButton.setLayout(this.layout);
        this.addComponent(pnButton, 0, 0, 1, 1, 4, this.bnCancel);
        this.addComponent(pnButton, 0, 1, 1, 1, 4, this.bnOK);
        JPanel pnMain = new JPanel();
        pnMain.setLayout(this.layout);
        this.addComponent(pnMain, 0, 0, 1, 1, 10, pnParams);
        this.addComponent(pnMain, 1, 0, 1, 1, 10, pnButton);
        this.bnOK.addActionListener(this);
        this.bnCancel.addActionListener(this);
        this.cmbView.addItemListener(this);
        this.getContentPane().add(pnMain);
        this.setResizable(false);
        this.pack();
        GUI.center((Window)this);
        this.setModal(true);
        this.updateInterface();
        this.show();
    }

    private void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnCancel) {
            this.dispose();
        } else if (e.getSource() == this.bnOK) {
            mode = this.cmbMode.getSelectedIndex();
            view = this.cmbView.getSelectedIndex();
            inverse = this.chkInverse.isSelected();
            int nt = this.handler.volSource.getSizeZ();
            Pointwise image = null;
            switch (view) {
                case 0: {
                    image = this.buildColorProcessorXY(this.handler.volSource, this.handler.nx, this.handler.ny, nt);
                    break;
                }
                case 1: {
                    image = this.buildColorProcessorXT(this.handler.volSource, this.handler.nx, this.handler.ny, nt);
                    break;
                }
                case 2: {
                    image = this.buildColorProcessorTY(this.handler.volSource, this.handler.nx, this.handler.ny, nt);
                    break;
                }
            }
            if (image != null) {
                if (inverse) {
                    image.invert();
                }
                ImagePlus impr = new ImagePlus("Trace on " + this.handler.imp.getTitle(), image.buildImageStack());
                TraceImageCanvas tcanvas = new TraceImageCanvas(impr, this.handler, view);
                if (image.getSizeZ() == 1) {
                    impr.setWindow(new ImageWindow(impr, (ImageCanvas)tcanvas));
                } else {
                    impr.setWindow((ImageWindow)new StackWindow(impr, (ImageCanvas)tcanvas));
                }
            }
            this.dispose();
        }
        this.notify();
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cmbView) {
            this.updateInterface();
        }
    }

    private void updateInterface() {
        view = this.cmbView.getSelectedIndex();
        if (view == 0) {
            this.cmbMode.setSelectedIndex(0);
            this.cmbMode.setEnabled(false);
        } else {
            this.cmbMode.setEnabled(true);
        }
    }

    public ImageWare buildColorProcessorXY(ImageWare input, int nx, int ny, int nz) {
        return input.duplicate();
    }

    public ImageWare buildColorProcessorXT(ImageWare input, int nx, int ny, int nt) {
        double[][] arr = new double[nx][nt];
        switch (mode) {
            case 0: {
                ImageWare out = Builder.create(nx, nt, ny, input.getType());
                int y = 0;
                while (y < ny) {
                    input.getXZ(0, y, 0, arr);
                    out.putXY(0, 0, y, arr);
                    ++y;
                }
                return out;
            }
            case 1: {
                double maxi = 0.0;
                double[] line = new double[ny];
                int t = 0;
                while (t < nt) {
                    int x = 0;
                    while (x < nx) {
                        input.getY(x, 0, t, line);
                        maxi = line[0];
                        int y = 1;
                        while (y < ny) {
                            if (maxi < line[y]) {
                                maxi = line[y];
                            }
                            ++y;
                        }
                        arr[x][t] = maxi;
                        ++x;
                    }
                    ++t;
                }
                return Builder.create(arr);
            }
            case 2: {
                if (this.handler.xspot == null) break;
                double[][] slice = new double[nx][ny];
                int t = 0;
                while (t < nt) {
                    input.getXY(0, 0, t, slice);
                    int x = 0;
                    while (x < nx) {
                        arr[x][t] = slice[x][FMath.round(this.handler.yspot[t])];
                        ++x;
                    }
                    ++t;
                }
                return Builder.create(arr);
            }
        }
        return null;
    }

    public ImageWare buildColorProcessorTY(ImageWare input, int nx, int ny, int nt) {
        double maxd = 255.0;
        double[][] arr = new double[ny][nt];
        switch (mode) {
            case 0: {
                ImageWare out = Builder.create(ny, nt, nx, input.getType());
                int x = 0;
                while (x < nx) {
                    input.getYZ(x, 0, 0, arr);
                    out.putXY(0, 0, x, arr);
                    ++x;
                }
                return out;
            }
            case 1: {
                double[] line = new double[nx];
                double maxi = 0.0;
                int y = 0;
                while (y < ny) {
                    int t = 0;
                    while (t < nt) {
                        input.getX(0, y, t, line);
                        maxi = line[0];
                        int x = 1;
                        while (x < nx) {
                            if (maxi < line[x]) {
                                maxi = line[x];
                            }
                            ++x;
                        }
                        int maxb = -1;
                        arr[y][t] = maxi;
                        ++t;
                    }
                    ++y;
                }
                return Builder.create(arr);
            }
            case 2: {
                if (this.handler.yspot == null) break;
                double[][] slice = new double[nx][ny];
                int t = 0;
                while (t < nt) {
                    input.getXY(0, 0, t, slice);
                    int maxb = -1;
                    int y = 0;
                    while (y < ny) {
                        arr[y][t] = slice[FMath.round(this.handler.xspot[t])][y];
                        ++y;
                    }
                    ++t;
                }
                return Builder.create(arr);
            }
        }
        return null;
    }
}

