/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import imageware.Builder;
import imageware.FMath;
import imageware.ImageWare;
import java.awt.Rectangle;
import java.util.Vector;
import spottracker2d.PointTrack;
import spottracker2d.TrackDialog;

public class Handler {
    public double[][] nucleus = null;
    public ImageWare volSource = null;
    public ImageWare volNorm = null;
    public ImageWare volAlign = null;
    public ImageWare volFilter = null;
    public float[] xspot = null;
    public float[] yspot = null;
    public int[] vspot = null;
    public PointTrack startAlign = null;
    public PointTrack startSource = null;
    public PointTrack startNorm = null;
    public PointTrack startFilter = null;
    public int nx = 1;
    public int ny = 1;
    public int nbz = 1;
    public boolean align = false;
    public boolean filter = false;
    public Vector nodes = null;
    public int[] X1Enveloppe = null;
    public int[] Y1Enveloppe = null;
    public int[] X2Enveloppe = null;
    public int[] Y2Enveloppe = null;
    public TrackDialog trackDialog = null;
    public ImagePlus imp;
    public boolean subpixelTrace = false;

    public Handler(ImagePlus imp, int nbz) {
        this.imp = imp;
        int nz = imp.getStackSize();
        this.nbz = nbz;
        int type = imp.getType();
        if (type == 0 || type == 1 || type == 2) {
            Roi roi = imp.getRoi();
            if (roi != null) {
                Rectangle rect = roi.getBoundingRect();
                ImageWare allImage = Builder.create(imp, 3);
                this.volSource = Builder.create(rect.width, rect.height, nz, 3);
                allImage.getXYZ(rect.x, rect.y, 0, this.volSource);
                ImageProcessor mask = roi.getMask();
                if (mask != null) {
                    float[] linez = new float[nz];
                    int mnx = mask.getWidth();
                    int mny = mask.getHeight();
                    int y = 0;
                    while (y < mny) {
                        int x = 0;
                        while (x < mnx) {
                            if ((double)mask.getPixel(x, y) == 0.0) {
                                this.volSource.putZ(x, y, 0, linez);
                            }
                            ++x;
                        }
                        ++y;
                    }
                }
            } else {
                this.volSource = Builder.create(imp, 3);
            }
        } else {
            IJ.error((String)"only process 8-bit images");
            return;
        }
        this.nx = this.volSource.getWidth();
        this.ny = this.volSource.getHeight();
        this.nucleus = new double[nz / nbz + 1][5];
        double xc = (double)this.nx / 2.0;
        double yc = (double)this.ny / 2.0;
        int t = 0;
        while (t < nz + 1) {
            this.nucleus[t][0] = xc;
            this.nucleus[t][1] = yc;
            this.nucleus[t][2] = 1.0;
            this.nucleus[t][3] = xc - 2.0;
            this.nucleus[t][4] = yc - 2.0;
            ++t;
        }
        this.volNorm = this.volSource.duplicate();
        this.volAlign = this.volSource.duplicate();
        this.volFilter = this.volSource.duplicate();
        this.startSource = this.findBestStartingPoint(this.volSource);
        if (this.startSource != null) {
            this.startAlign = new PointTrack(this.startSource);
            this.startNorm = new PointTrack(this.startSource);
            this.startFilter = new PointTrack(this.startSource);
        }
    }

    public void updateNodes() {
        if (this.trackDialog != null && this.trackDialog.isVisible()) {
            this.trackDialog.setTableNode();
        }
    }

    public void addConstraintPoint(PointTrack pt) {
        if ((double)this.nx / 2.0 - this.nucleus[pt.t][3] < (double)pt.x && (double)pt.x < (double)this.nx / 2.0 + this.nucleus[pt.t][3] && (double)this.ny / 2.0 - this.nucleus[pt.t][4] < (double)pt.y && (double)pt.y < (double)this.ny / 2.0 + this.nucleus[pt.t][4]) {
            this.nodes.addElement(pt);
        } else {
            IJ.error((String)"This constraint node is outside of the nucleus");
        }
        this.updateNodes();
    }

    public void removeConstraintPoint(PointTrack pt) {
        if (this.nodes.size() > 1) {
            this.nodes.remove(pt);
        }
        this.updateNodes();
    }

    public PointTrack getStartPoint(int dataview) {
        switch (dataview) {
            case 0: {
                return this.startSource;
            }
            case 1: {
                return this.startNorm;
            }
            case 2: {
                return this.startAlign;
            }
            case 3: {
                return this.startFilter;
            }
        }
        return null;
    }

    public PointTrack findBestStartingPoint(ImageWare source) {
        if (source == null) {
            return null;
        }
        int nxout = source.getWidth();
        int nyout = source.getHeight();
        int nt = source.getSizeZ();
        double[][] slice = new double[nxout][nyout];
        PointTrack start = new PointTrack();
        start.value = -3.4028235E38f;
        int t = 0;
        while (t < nt) {
            source.getXY(0, 0, t, slice);
            int x1 = FMath.round(this.nucleus[t][0] - this.nucleus[t][3]);
            int x2 = FMath.round(this.nucleus[t][0] + this.nucleus[t][3]);
            int y1 = FMath.round(this.nucleus[t][1] - this.nucleus[t][4]);
            int y2 = FMath.round(this.nucleus[t][1] + this.nucleus[t][4]);
            int i = x1;
            while (i < x2) {
                int j = y1;
                while (j < y2) {
                    if (slice[i][j] > (double)start.value) {
                        start.x = i;
                        start.y = j;
                        start.t = t;
                        start.value = (float)slice[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            ++t;
        }
        if (start.value == -3.4028235E38f) {
            IJ.error((String)("Invalid starting point.\nImage size is [" + this.nx + "," + this.ny + "]"));
            return null;
        }
        this.nodes = new Vector();
        this.nodes.addElement(start);
        return start;
    }

    public Rectangle[] getEnveloppe() {
        if (this.X1Enveloppe == null) {
            return null;
        }
        int nt = this.volSource.getSizeZ();
        Rectangle[] env = new Rectangle[nt];
        int t = 0;
        while (t < nt) {
            env[t] = new Rectangle(this.X1Enveloppe[t], this.Y1Enveloppe[t], this.X2Enveloppe[t] - this.X1Enveloppe[t], this.Y2Enveloppe[t] - this.Y1Enveloppe[t]);
            ++t;
        }
        return env;
    }
}

