/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.gui.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.DefaultCaret;

public class HelpFrame
extends JFrame
implements ActionListener {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private JButton bnClose = new JButton("Close");

    public HelpFrame() {
        super("Help on SpotTracker");
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setContentType("text/html; charset=ISO-8859-1");
        pane.setText("<html>\t<head><title>SpotTracker2D</title><style type=text/css>p{color:#000000;font-size:1em;font-family:Verdana,Helvetica,Arial,Geneva,Swiss,SunSans-Regular,sans-serif}li{color:#000000;font-size:1em;font-family:Verdana,Helvetica,Arial,Geneva,Swiss,SunSans-Regular,sans-serif}h3{margin-top:7px;margin-bottom:3px;color:#000000;font-size:1em;font-weight:bold;font-family:Verdana,Helvetica,Arial,Geneva,Swiss,SunSans-Regular,sans-serif}h2{margin-top:7px;margin-bottom:3px;color:#999999;font-size:1em;font-family:Verdana,Helvetica,Arial,Geneva,Swiss,SunSans-Regular,sans-serif}h1{color: #ffffff; font-size: 1.2em; font-family: Verdana, Helvetica, Arial, Geneva, Swiss, SunSans-Regular, sans-serif; background-color: #003366; text-align: center }address { color: #333333; font-size: 0.8em; font-family: Verdana, Helvetica, Arial, Geneva, Swiss, SunSans-Regular, sans-serif; text-align: center }</style></head><body bgcolor=#ffffff><table cellpadding=10><tr><td><h1>Spot Tracker 2D</h1><h2>Reference</h2><p>Daniel Sage, Frank R. Neumann, Florence Hediger, Susan M. Gasser and Michael Unser <i>Automatic Tracking of Individual Fluoresence Particles: Application to the Study of Chromosome Dynamics</i> IEEE Transactions on Image Processing, vol. 14, no. 9, pp. 1372-1383, September 2005.<h2>Data: Image Sequence</h2><p>The plugin SpotTracker is able to track a single bright particle over an image sequence. The images in the sequence should be in either 8-bit or 16-bit or 32-bit grayscale.</p><h2>Preprocessing step (Optional): Spot Enhancing Filter</h2><p>The goal of the preprocessing is to enhance particle modelling by a Gaussian shape. Start the plugin <b>SpotEnhancingFilter</b> and choose an estimate of the diameter of the particle in pixels. Click on the <u>Enhance</u> button. The plugin will generate an output image sequence.</p><h2>Tracking step</h2><p>The single particle tracking is a global optimization process which is based on the evaluation of a cost function. Start the plugin <b>SpotTracker2D</b> and tune the parameters:</p><ul><li><i>Max. displacement</i> The maximum displacement for one frame to the next frame in pixels. Be prepare to wait a long time if you select a large value.</li><li>The weights of the cost function:</li><ol><li><i>Intensity factor</i> for the bright intensities of the position;</li><li><i>Movement constraint</i> for the short displacement from one frame to the next one;</li><li><i>Center constraint</i> for the close position relative to the center of the image.</li></ol><li>Nodes: The user can force the trajectory to pass through specific positions called nodes. At least one node is required. At the starting of the plugin, the program determines the brightest position as the first node.</li></ul><h2>Trajectory editing (Optional)</h2><p>To add nodes, select the PointTool (large cross and small square) of ImageJ,  choose a position on any desired frame, and just click on the <u>Add</u> button. Several such nodes can be added or removed</p> <p>Then, press <u>Track</u> again to start the tracking. The algorithm optimizes the trajectory with the constraint that it goes through the specified position(s)</p><h2>Output</h2><p>At the end of the tracking, the program generates a table with the coordinates of the trajectory. A red cross is placed on the particle, in addition a green circle is placed over the nodes. The user can also choose other views to display the result by clicking on the <u>Display Results</u> button.</p><p>&nbsp;</p><hr><p>Author: Daniel Sage</p><p>Biomedical Imaging Group</p><p>Swiss Federal Institute of Technology Lausanne (EPFL)</p><p>&nbsp;</p><hr><p>1 July 2005</p><p></p></td></tr></table></body></html>\t");
        pane.setCaret(new DefaultCaret());
        JScrollPane helpScrollPane = new JScrollPane(pane);
        helpScrollPane.setVerticalScrollBarPolicy(22);
        helpScrollPane.setPreferredSize(new Dimension(600, 600));
        this.getContentPane().add((Component)helpScrollPane, "Center");
        this.pack();
        GUI.center((Window)this);
        this.show();
    }

    private void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnClose) {
            this.dispose();
        }
        this.notify();
    }
}

