/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderPanel
extends JPanel
implements ChangeListener {
    private JLabel lbl;
    public JSlider slider;
    private JLabel title;
    private String prefix;
    private String suffix;

    public SliderPanel(String Title, String suffix, int min, int max, int value, boolean snap) {
        this.prefix = "";
        suffix = "";
        this.setLayout(new BorderLayout());
        this.slider = new JSlider(min, max, value);
        this.slider.setMinorTickSpacing(max / 5 / 2);
        this.slider.setMajorTickSpacing(max / 5);
        this.slider.setPaintTicks(false);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(snap);
        this.lbl = new JLabel();
        this.title = new JLabel(Title);
        this.setValue(value);
        this.add((Component)this.title, "North");
        this.add((Component)this.slider, "Center");
        this.add((Component)this.lbl, "East");
        this.slider.addChangeListener(this);
    }

    public SliderPanel(String Title, int min, int max, int value, String prefix, String suffix, boolean snap) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.setLayout(new BorderLayout());
        this.slider = new JSlider(min, max, value);
        this.slider.setMinorTickSpacing(max / 5 / 2);
        this.slider.setMajorTickSpacing(max / 5);
        this.slider.setPaintTicks(false);
        this.slider.setPaintLabels(true);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.slider.setSnapToTicks(snap);
        this.lbl = new JLabel();
        this.title = new JLabel(Title);
        this.setValue(value);
        this.add((Component)this.title, "North");
        this.add((Component)this.slider, "Center");
        this.add((Component)this.lbl, "East");
        this.slider.addChangeListener(this);
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public JLabel getTitle() {
        return this.title;
    }

    public JLabel getLabel() {
        return this.lbl;
    }

    public synchronized void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.slider) {
            this.setValue(this.slider.getValue());
        }
    }

    public void setValue(int value) {
        this.slider.setValue(value);
        DecimalFormat df = new DecimalFormat(String.valueOf(this.prefix) + "000");
        this.lbl.setText(String.valueOf(df.format(value)) + this.suffix);
    }

    public int getValue() {
        return this.slider.getValue();
    }
}

