/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.gui.GUI;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import spottracker2d.CProgressBar;
import spottracker2d.DisplayResultsDialog;
import spottracker2d.Handler;
import spottracker2d.HelpFrame;
import spottracker2d.PointTrack;
import spottracker2d.SliderPanel;
import spottracker2d.SpotTrackerImageCanvas;
import spottracker2d.TableNode;
import spottracker2d.TableResults;
import spottracker2d.Tracker;
import spottracker2d.ViewerCanvas;

public class TrackDialog
extends JFrame
implements ActionListener,
ChangeListener,
Runnable {
    private Properties props = new Properties();
    private String filename = String.valueOf(System.getProperty("user.dir")) + "/plugins/SpotTracker2D/Tracking.prefs";
    private Thread threadProcess = null;
    private Handler handler;
    private final int NBMAXNODES = 100;
    private ViewerCanvas canvas = null;
    private SpotTrackerImageCanvas sptcanvas = null;
    private CProgressBar progress = null;
    private boolean flagIntegratedVersion = false;
    private boolean usePreferences = false;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private JButton bnTrack = new JButton("Track");
    private JButton bnDisplayResult = new JButton("Display Results");
    private JButton bnCancel = new JButton("Close");
    private JButton bnRemove = new JButton("Remove");
    private JButton bnAdd = new JButton("Add");
    private JButton bnClear = new JButton("Clear");
    private JButton bnHelp = new JButton("Help ...");
    private SliderPanel sliderCone = new SliderPanel("Max. displacement", 1, 50, 5, "", " [px]", false);
    private SliderPanel sliderNormalize = new SliderPanel("Intensity factor", 0, 100, 80, "", " %", false);
    private SliderPanel sliderMovement = new SliderPanel("Movement constraint", 0, 100, 20, "", " %", false);
    private SliderPanel sliderCenter = new SliderPanel("Center constraint", 0, 100, 10, "", " %", false);
    private JSlider sliderDecision = new JSlider();
    private JCheckBox chkRefinePosition = new JCheckBox("Post-processing: sub-pixels position refinement", true);
    private JCheckBox chkShowResultStack = new JCheckBox("Show result in a color image sequence", false);
    private JCheckBox chkShowResultTable = new JCheckBox("Show results in a table report", true);
    private JTabbedPane tabbedPane = new JTabbedPane();
    private TableNode table;
    private DefaultTableModel modelTable;
    private Font font = new Font("Arial", 0, 10);

    public TrackDialog(String title, Handler handler, CProgressBar progress, ViewerCanvas canvas, Point location, boolean usePreferences) {
        super(title);
        this.usePreferences = usePreferences;
        this.flagIntegratedVersion = true;
        this.handler = handler;
        this.canvas = canvas;
        this.progress = progress;
        this.doDialog(location);
    }

    public TrackDialog(String title, Handler handler, SpotTrackerImageCanvas sptcanvas, boolean usePreferences) {
        super(title);
        this.usePreferences = usePreferences;
        this.flagIntegratedVersion = false;
        this.handler = handler;
        this.sptcanvas = sptcanvas;
        this.progress = new CProgressBar(false);
        this.doDialog(null);
    }

    public Insets getInsets() {
        return new Insets(40, 15, 15, 15);
    }

    private void doDialog(Point location) {
        JTextArea txtCopyright = new JTextArea(2, 20);
        txtCopyright.append("SpotTracker: http://bigwww.epfl.ch/spottracker/\n");
        txtCopyright.append("Biomedical Imaging Group, 2005\n");
        txtCopyright.append("Swiss Federal Institute of Technology Lausanne (EPFL)");
        txtCopyright.setFont(this.font);
        txtCopyright.setBorder(BorderFactory.createEtchedBorder());
        txtCopyright.setForeground(new Color(0, 32, 128));
        txtCopyright.setBackground(((Component)this).getBackground());
        JPanel pnTrack = new JPanel();
        pnTrack.setLayout(this.layout);
        this.addComponent(pnTrack, 1, 0, 1, 1, 2, this.sliderCone.getTitle());
        this.addComponent(pnTrack, 1, 1, 1, 1, 2, this.sliderCone.getSlider());
        this.addComponent(pnTrack, 1, 2, 1, 1, 2, this.sliderCone.getLabel());
        this.addComponent(pnTrack, 2, 0, 1, 1, 2, this.sliderNormalize.getTitle());
        this.addComponent(pnTrack, 2, 1, 1, 1, 2, this.sliderNormalize.getSlider());
        this.addComponent(pnTrack, 2, 2, 1, 1, 2, this.sliderNormalize.getLabel());
        this.addComponent(pnTrack, 3, 0, 1, 1, 2, this.sliderMovement.getTitle());
        this.addComponent(pnTrack, 3, 1, 1, 1, 2, this.sliderMovement.getSlider());
        this.addComponent(pnTrack, 3, 2, 1, 1, 2, this.sliderMovement.getLabel());
        this.addComponent(pnTrack, 4, 0, 1, 1, 2, this.sliderCenter.getTitle());
        this.addComponent(pnTrack, 4, 1, 1, 1, 2, this.sliderCenter.getSlider());
        this.addComponent(pnTrack, 4, 2, 1, 1, 2, this.sliderCenter.getLabel());
        JPanel pnSliderDecision = new JPanel();
        if (this.flagIntegratedVersion) {
            pnSliderDecision.setLayout(this.layout);
            this.sliderDecision = new JSlider(0, 100, 10);
            this.sliderDecision.setMinorTickSpacing(10);
            this.sliderDecision.setMajorTickSpacing(20);
            this.sliderDecision.setPaintTicks(true);
            this.sliderDecision.setPaintLabels(true);
            this.sliderDecision.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.sliderDecision.setSnapToTicks(false);
            this.addComponent(pnSliderDecision, 0, 0, 1, 1, 1, new JLabel("Confidence Decision"));
            this.addComponent(pnSliderDecision, 1, 0, 1, 1, 1, this.sliderDecision);
        }
        Object[] header = new String[]{"Image", "X (size:" + this.handler.nx + ")", "Y (size:" + this.handler.ny + ")"};
        this.modelTable = new DefaultTableModel(header, 100);
        this.table = new TableNode(this.modelTable);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 80));
        JPanel pnNodes = new JPanel();
        pnNodes.setLayout(this.layout);
        this.addComponent(pnTrack, 5, 1, 2, 3, 2, scrollPane);
        if (!this.flagIntegratedVersion) {
            this.addComponent(pnTrack, 5, 0, 1, 1, 2, new JLabel("Nodes"));
            this.addComponent(pnTrack, 6, 0, 1, 1, 2, this.bnAdd);
            this.addComponent(pnTrack, 7, 0, 1, 1, 2, this.bnRemove);
        }
        this.addComponent(pnTrack, 9, 0, 3, 1, 2, this.chkRefinePosition);
        JPanel pnButton = new JPanel();
        pnButton.setLayout(this.layout);
        if (!this.flagIntegratedVersion) {
            this.addComponent(pnButton, 0, 1, 1, 1, 6, this.bnHelp);
            this.addComponent(pnButton, 0, 2, 1, 1, 6, this.bnDisplayResult);
            this.bnDisplayResult.setEnabled(false);
        }
        this.addComponent(pnButton, 0, 0, 1, 1, 6, this.bnCancel);
        this.addComponent(pnButton, 0, 3, 1, 1, 6, this.bnTrack);
        JPanel pnMain = new JPanel();
        pnMain.setLayout(this.layout);
        this.addComponent(pnMain, 0, 0, 1, 1, 2, txtCopyright);
        this.addComponent(pnMain, 1, 0, 1, 1, 2, pnTrack);
        if (this.flagIntegratedVersion) {
            this.addComponent(pnMain, 3, 0, 3, 1, 2, pnSliderDecision);
        }
        if (!this.flagIntegratedVersion) {
            this.addComponent(pnTrack, 10, 0, 3, 1, 2, this.chkShowResultStack);
            this.addComponent(pnTrack, 11, 0, 3, 1, 2, this.chkShowResultTable);
        }
        this.addComponent(pnMain, 5, 0, 1, 1, 2, pnButton);
        this.bnTrack.addActionListener(this);
        this.bnCancel.addActionListener(this);
        this.bnRemove.addActionListener(this);
        this.bnAdd.addActionListener(this);
        this.bnDisplayResult.addActionListener(this);
        this.bnHelp.addActionListener(this);
        this.sliderDecision.addChangeListener(this);
        this.setTableNode();
        JPanel pnMainBorder = new JPanel();
        pnButton.setLayout(this.layout);
        this.addComponent(pnMainBorder, 0, 0, 1, 1, 80, pnMain);
        this.getContentPane().add(pnMainBorder);
        this.pack();
        this.getPreferences();
        if (location != null) {
            ((Component)this).setLocation(location);
        } else {
            GUI.center((Window)this);
        }
        this.show();
    }

    private void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnCancel) {
            this.setPreferences();
            this.dispose();
        } else if (e.getSource() == this.bnTrack) {
            this.startTracking();
            this.setPreferences();
        } else if (e.getSource() == this.bnDisplayResult) {
            DisplayResultsDialog dlg = new DisplayResultsDialog(this.handler);
        } else if (e.getSource() == this.bnHelp) {
            HelpFrame help = new HelpFrame();
        } else if (e.getSource() == this.bnAdd) {
            if (this.handler.nodes.size() >= 99) {
                IJ.error((String)"Too many nodes.\n");
            } else {
                Roi roi = this.handler.imp.getRoi();
                if (roi != null) {
                    Rectangle rect = roi.getBoundingRect();
                    int x = rect.x + rect.width / 2;
                    int y = rect.y + rect.height / 2;
                    int t = this.handler.imp.getCurrentSlice() - 1;
                    PointTrack pt = new PointTrack(x, y, 0, t, (float)this.handler.volSource.getPixel(x, y, t));
                    this.handler.nodes.add(pt);
                    this.setTableNode();
                } else {
                    IJ.error((String)"The node is the center of a ROI (Region of Interest).\nSelect a ROI using the ImageJ toolbars to enter a node.");
                }
            }
        } else if (e.getSource() == this.bnRemove) {
            if (this.handler.nodes.size() >= 2) {
                int[] ipt = this.table.getSelectedRows();
                if (ipt.length == 1) {
                    if (ipt[0] >= 0 && ipt[0] < this.handler.nodes.size()) {
                        this.handler.nodes.remove(ipt[0]);
                    }
                    this.setTableNode();
                } else {
                    IJ.error((String)"Select one node to remove in the table.");
                }
            } else {
                IJ.error((String)"The SpotTracker requires at least one node.");
            }
        }
        this.notify();
    }

    public synchronized void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.sliderDecision && this.flagIntegratedVersion) {
            this.canvas.updateDisplay(this.sliderDecision.getValue());
        }
    }

    public void setTableNode() {
        this.sortNode();
        int i = 0;
        while (i < this.handler.nodes.size()) {
            PointTrack pt = (PointTrack)this.handler.nodes.elementAt(i);
            this.modelTable.setValueAt(this.convertToString(pt.t + 1), i, 0);
            this.modelTable.setValueAt(this.convertToString(pt.x), i, 1);
            this.modelTable.setValueAt(this.convertToString(pt.y), i, 2);
            ++i;
        }
        int i2 = this.handler.nodes.size();
        while (i2 < 100) {
            this.modelTable.setValueAt("", i2, 0);
            this.modelTable.setValueAt("", i2, 1);
            this.modelTable.setValueAt("", i2, 2);
            ++i2;
        }
    }

    private Vector cleanupNode() {
        Vector<PointTrack> result = new Vector<PointTrack>();
        int nb = this.handler.nodes.size();
        int i = 0;
        while (i < nb) {
            PointTrack pti = (PointTrack)this.handler.nodes.elementAt(i);
            int jequal = i;
            int j = i + 1;
            while (j < nb) {
                PointTrack ptj = (PointTrack)this.handler.nodes.elementAt(j);
                if (pti.t == ptj.t) {
                    jequal = j;
                }
                ++j;
            }
            i = jequal;
            result.addElement((PointTrack)this.handler.nodes.elementAt(jequal));
            ++i;
        }
        return result;
    }

    private void sortNode() {
        PointTrack temp = new PointTrack();
        int i = 0;
        while (i < this.handler.nodes.size()) {
            PointTrack pti = (PointTrack)this.handler.nodes.elementAt(i);
            int j = i + 1;
            while (j < this.handler.nodes.size()) {
                PointTrack ptj = (PointTrack)this.handler.nodes.elementAt(j);
                if (pti.t > ptj.t) {
                    temp = (PointTrack)this.handler.nodes.elementAt(i);
                    this.handler.nodes.setElementAt((PointTrack)this.handler.nodes.elementAt(j), i);
                    this.handler.nodes.setElementAt(temp, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void startTracking() {
        if (this.threadProcess == null) {
            this.threadProcess = new Thread(this);
            this.threadProcess.setPriority(1);
            this.threadProcess.start();
            this.setPreferences();
        }
    }

    public void run() {
        double startTime = System.currentTimeMillis();
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        double norm = (double)this.sliderNormalize.getValue() / 100.0;
        double cMove = (double)this.sliderMovement.getValue() / 100.0;
        double cCenter = (double)this.sliderCenter.getValue() / 100.0;
        int delta = this.sliderCone.getValue();
        boolean subpix = this.chkRefinePosition.isSelected();
        if (!this.flagIntegratedVersion) {
            Tracker tracker = new Tracker(this.handler.volSource, this.handler, this.progress);
            boolean flag = tracker.run(this.handler.startSource, this.handler.nodes, delta, norm, cMove, cCenter, subpix);
            this.bnDisplayResult.setEnabled(flag);
            if (flag) {
                if (this.chkShowResultTable.isSelected()) {
                    TableResults.showDirectTable(this.handler);
                }
                if (this.chkShowResultStack.isSelected()) {
                    double zi = 1.0;
                    zi = this.handler.nx + this.handler.ny < 100 ? 5.0 : (this.handler.nx + this.handler.ny < 200 ? 4.0 : (this.handler.nx + this.handler.ny < 300 ? 3.0 : (this.handler.nx + this.handler.ny < 400 ? 2.0 : 1.0)));
                    TableResults.showStack(this.handler, 3.0, 1);
                }
            }
            ((Component)((Object)this.sptcanvas)).repaint();
        } else {
            switch (this.canvas.getDataViewing()) {
                case 0: {
                    Tracker tracker1 = new Tracker(this.handler.volSource, this.handler, this.progress);
                    tracker1.run(this.handler.startSource, this.handler.nodes, delta, norm, cMove, cCenter, subpix);
                    break;
                }
                case 1: {
                    Tracker tracker2 = new Tracker(this.handler.volNorm, this.handler, this.progress);
                    tracker2.run(this.handler.startNorm, this.handler.nodes, delta, norm, cMove, cCenter, subpix);
                    break;
                }
                case 2: {
                    Tracker tracker3 = new Tracker(this.handler.volAlign, this.handler, this.progress);
                    tracker3.run(this.handler.startAlign, this.handler.nodes, delta, norm, cMove, cCenter, subpix);
                    break;
                }
                case 3: {
                    Tracker tracker4 = new Tracker(this.handler.volFilter, this.handler, this.progress);
                    tracker4.run(this.handler.startFilter, this.handler.nodes, delta, norm, cMove, cCenter, subpix);
                    break;
                }
            }
            this.canvas.updateDisplay(this.sliderDecision.getValue());
        }
        this.setCursor(cursor);
        this.threadProcess = null;
    }

    private void getPreferences() {
        if (!this.usePreferences) {
            return;
        }
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
        }
        catch (Exception exception) {}
        this.sliderCone.setValue(new Integer(this.props.getProperty("sliderCone", "2")));
        this.sliderNormalize.setValue(new Integer(this.props.getProperty("sliderNormalize", "75")));
        this.sliderMovement.setValue(new Integer(this.props.getProperty("sliderMovement", "25")));
        this.sliderCenter.setValue(new Integer(this.props.getProperty("sliderCenter", "0")));
        this.chkRefinePosition.setSelected(this.props.getProperty("chkRefinePosition", "true").equals("true"));
    }

    private void setPreferences() {
        if (!this.usePreferences) {
            return;
        }
        this.props.setProperty("sliderCone", String.valueOf(this.sliderCone.getValue()));
        this.props.setProperty("sliderNormalize", String.valueOf(this.sliderNormalize.getValue()));
        this.props.setProperty("sliderMovement", String.valueOf(this.sliderMovement.getValue()));
        this.props.setProperty("sliderCenter", String.valueOf(this.sliderCenter.getValue()));
        this.props.setProperty("chkRefinePosition", String.valueOf(this.chkRefinePosition.isSelected()));
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, "Spot Tracker \n Header");
        }
        catch (Exception exception) {}
    }

    public String convertToString(int d) {
        String s = IJ.d2s((double)d, (int)0);
        if (d < 10) {
            s = "00" + s;
        } else if (d < 100) {
            s = "0" + s;
        }
        return s;
    }

    public String convertToString(float d) {
        String s = IJ.d2s((double)d, (int)0);
        if (d < 10.0f) {
            s = "00" + s;
        } else if (d < 100.0f) {
            s = "0" + s;
        }
        return s;
    }
}

