/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.ImagePlus;
import imageware.FMath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import spottracker2d.AlignNucleusFrame;
import spottracker2d.CProgressBar;
import spottracker2d.EnhanceSpotFrame;
import spottracker2d.Handler;
import spottracker2d.MessageBox;
import spottracker2d.PointTrack;
import spottracker2d.RescaleSliceFrame;
import spottracker2d.ScrollPanel;
import spottracker2d.SetViewing;
import spottracker2d.TableResults;
import spottracker2d.TrackDialog;
import spottracker2d.ViewerCanvas;

public class ViewerFrame
extends JFrame
implements WindowListener,
ActionListener,
MouseListener,
KeyListener,
AdjustmentListener {
    public ViewerCanvas canvas;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private double zoomXY;
    private int nx;
    private int ny;
    private int nz;
    private int nbz;
    private Handler handler;
    private String[] zoomList = new String[]{"100%", "200%", "300%", "400%", "500%", "600%", "700%", "800%", "900%", "1000%"};
    private ImagePlus imp = null;
    private JLabel status = new JLabel("", 2);
    private JMenuBar menuBar = new JMenuBar();
    private JMenu mnuFile = new JMenu("File");
    private JMenuItem mnuSave = new JMenuItem("Save Screnshot As...");
    private JMenuItem mnuClose = new JMenuItem("Close");
    private JMenu mnuView = new JMenu("View");
    private JMenuItem mnuInverse = new JMenuItem("Inverse");
    private JMenu mnuZoomingX = new JMenu("Zoom X");
    private JMenu mnuZoomingY = new JMenu("Zoom Y");
    private JMenu mnuZoomingT = new JMenu("Zoom T");
    private JRadioButtonMenuItem[] mnuZoomX = new JRadioButtonMenuItem[this.zoomList.length];
    private JRadioButtonMenuItem[] mnuZoomY = new JRadioButtonMenuItem[this.zoomList.length];
    private JRadioButtonMenuItem[] mnuZoomT = new JRadioButtonMenuItem[this.zoomList.length];
    private JMenuItem mnuSetViewing = new JMenuItem("Settings ...");
    private JMenu mnuProcessing = new JMenu("Processing");
    private JMenuItem mnuNorm = new JMenuItem("Rescale Slices ...");
    private JMenuItem mnuAlign = new JMenuItem("Nucleus Alignment ...");
    private JMenuItem mnuFilter = new JMenuItem("Spot Enhancing Filter ...");
    private JMenuItem mnuTrack = new JMenuItem("Track ...");
    private JMenu mnuResult = new JMenu("Result");
    private JMenu mnuResultTable = new JMenu("Show as table");
    private JMenu mnuResultStack = new JMenu("Show as stack");
    private JMenuItem mnuSummTable = new JMenuItem("Summary");
    private JMenuItem mnuFullTable = new JMenuItem("Full");
    private JMenuItem mnuResultStack1 = new JMenuItem("100%");
    private JMenuItem mnuResultStack2 = new JMenuItem("200%");
    private JMenuItem mnuResultStack3 = new JMenuItem("300%");
    private JMenuItem mnuResultStack4 = new JMenuItem("400%");
    private JMenuItem mnuResultStack5 = new JMenuItem("500%");
    private JMenu mnuHelpMenu = new JMenu("Help");
    private JMenuItem mnuHelp = new JMenuItem("Help ...");
    private JMenuItem mnuAbout = new JMenuItem("About ...");
    private JButton toolRescale = new JButton("Rescale");
    private JButton toolAlign = new JButton("Align");
    private JButton toolEnhance = new JButton("Enhance");
    private JButton toolTrack = new JButton("Track");
    private String[] lstSource = new String[]{"Source", "Rescaled", "Aligned", "Enhanced"};
    private String[] lstProj = new String[]{"Section", "M.I.P.", "Spot Proj."};
    private JComboBox cmbSource = new JComboBox<String>(this.lstSource);
    private JComboBox cmbProj = new JComboBox<String>(this.lstProj);
    private JCheckBox chkNucleus = new JCheckBox("Nucleus", true);
    private JCheckBox chkEnveloppe = new JCheckBox("Env.", false);
    private JCheckBox chkTrace = new JCheckBox("Trace", true);
    private JCheckBox chkSpot = new JCheckBox("Spot", true);
    private JCheckBox chkNode = new JCheckBox("Node", true);
    private CProgressBar progress = new CProgressBar(true);
    private JToolBar t1 = new JToolBar();
    private ScrollPanel sliderX;
    private ScrollPanel sliderY;
    private ScrollPanel sliderT;

    public ViewerFrame(ImagePlus imp, Handler handler, double zoomXY) {
        super("Spot Tracker [" + imp.getTitle() + "]");
        this.nbz = this.nbz;
        this.handler = handler;
        this.zoomXY = zoomXY;
        this.imp = imp;
        this.nx = handler.volSource.getSizeX();
        this.ny = handler.volSource.getSizeY();
        this.nz = handler.volSource.getSizeZ();
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.mnuFile);
        this.menuBar.add(this.mnuView);
        this.menuBar.add(this.mnuProcessing);
        this.menuBar.add(this.mnuResult);
        this.menuBar.add(this.mnuHelpMenu);
        this.mnuFile.add(this.mnuSave);
        this.mnuFile.add(this.mnuClose);
        this.mnuProcessing.add(this.mnuNorm);
        this.mnuProcessing.add(this.mnuAlign);
        this.mnuProcessing.add(this.mnuFilter);
        this.mnuProcessing.add(this.mnuTrack);
        this.mnuView.add(this.mnuInverse);
        this.mnuView.add(this.mnuZoomingX);
        this.mnuView.add(this.mnuZoomingY);
        this.mnuView.add(this.mnuZoomingT);
        ButtonGroup groupZoomX = new ButtonGroup();
        ButtonGroup groupZoomY = new ButtonGroup();
        ButtonGroup groupZoomT = new ButtonGroup();
        int i = 0;
        while (i < this.zoomList.length) {
            this.mnuZoomX[i] = new JRadioButtonMenuItem(this.zoomList[i]);
            this.mnuZoomingX.add(this.mnuZoomX[i]);
            groupZoomX.add(this.mnuZoomX[i]);
            this.mnuZoomX[i].addActionListener(this);
            ++i;
        }
        this.mnuZoomX[FMath.round(zoomXY) - 1].setSelected(true);
        int i2 = 0;
        while (i2 < this.zoomList.length) {
            this.mnuZoomY[i2] = new JRadioButtonMenuItem(this.zoomList[i2]);
            this.mnuZoomingY.add(this.mnuZoomY[i2]);
            groupZoomY.add(this.mnuZoomY[i2]);
            this.mnuZoomY[i2].addActionListener(this);
            ++i2;
        }
        this.mnuZoomY[FMath.round(zoomXY) - 1].setSelected(true);
        int i3 = 0;
        while (i3 < this.zoomList.length) {
            this.mnuZoomT[i3] = new JRadioButtonMenuItem(this.zoomList[i3]);
            this.mnuZoomingT.add(this.mnuZoomT[i3]);
            groupZoomT.add(this.mnuZoomT[i3]);
            this.mnuZoomT[i3].addActionListener(this);
            ++i3;
        }
        this.mnuView.add(this.mnuSetViewing);
        this.mnuResult.add(this.mnuResultTable);
        this.mnuResult.add(this.mnuResultStack);
        this.mnuResultTable.add(this.mnuSummTable);
        this.mnuResultTable.add(this.mnuFullTable);
        this.mnuResultStack.add(this.mnuResultStack1);
        this.mnuResultStack.add(this.mnuResultStack2);
        this.mnuResultStack.add(this.mnuResultStack3);
        this.mnuResultStack.add(this.mnuResultStack4);
        this.mnuResultStack.add(this.mnuResultStack5);
        this.mnuClose.addActionListener(this);
        this.mnuInverse.addActionListener(this);
        this.mnuSave.addActionListener(this);
        this.mnuHelp.addActionListener(this);
        this.mnuAbout.addActionListener(this);
        this.mnuNorm.addActionListener(this);
        this.mnuAlign.addActionListener(this);
        this.mnuFilter.addActionListener(this);
        this.mnuTrack.addActionListener(this);
        this.mnuSetViewing.addActionListener(this);
        this.cmbSource.addActionListener(this);
        this.cmbProj.addActionListener(this);
        this.mnuSummTable.addActionListener(this);
        this.mnuFullTable.addActionListener(this);
        this.mnuResultStack1.addActionListener(this);
        this.mnuResultStack2.addActionListener(this);
        this.mnuResultStack3.addActionListener(this);
        this.mnuResultStack4.addActionListener(this);
        this.mnuResultStack5.addActionListener(this);
        Font fontChk = this.chkTrace.getFont();
        Font font2 = new Font(fontChk.getFamily(), fontChk.getStyle(), fontChk.getSize() - 2);
        this.chkTrace.setFont(font2);
        this.chkNucleus.setFont(font2);
        this.chkEnveloppe.setFont(font2);
        this.chkSpot.setFont(font2);
        this.chkNode.setFont(font2);
        Font fontCmb = this.cmbSource.getFont();
        Font font1 = new Font(fontCmb.getFamily(), fontCmb.getStyle(), fontCmb.getSize() - 2);
        this.cmbSource.setFont(font1);
        this.cmbProj.setFont(font1);
        ((Container)this.t1).setLayout(new FlowLayout(0));
        this.t1.add(this.toolRescale);
        this.t1.add(this.toolAlign);
        this.t1.add(this.toolEnhance);
        this.t1.add(this.toolTrack);
        this.t1.add(this.cmbSource);
        this.t1.add(this.cmbProj);
        this.t1.add(this.chkNucleus);
        this.t1.add(this.chkEnveloppe);
        this.t1.add(this.chkNode);
        this.t1.add(this.chkTrace);
        this.t1.add(this.chkSpot);
        this.t1.setFloatable(true);
        this.t1.removeKeyListener(this);
        this.toolRescale.addActionListener(this);
        this.toolAlign.addActionListener(this);
        this.toolEnhance.addActionListener(this);
        this.toolTrack.addActionListener(this);
        this.chkTrace.addActionListener(this);
        this.chkNucleus.addActionListener(this);
        this.chkEnveloppe.addActionListener(this);
        this.chkSpot.addActionListener(this);
        this.chkNode.addActionListener(this);
        Font fontStatus = this.status.getFont();
        this.status.setFont(new Font(fontStatus.getFamily(), fontStatus.getStyle(), fontStatus.getSize() - 2));
        JToolBar t2 = new JToolBar();
        ((Container)t2).setLayout(new FlowLayout(0));
        t2.add(this.progress);
        t2.add(this.status);
        t2.setFloatable(true);
        t2.removeKeyListener(this);
        this.sliderX = new ScrollPanel(0, this.nx, this.nx / 2, "x=");
        this.sliderY = new ScrollPanel(0, this.ny, this.ny / 2, "y=");
        this.sliderT = new ScrollPanel(0, this.nz, this.nz / 2, "t=");
        this.sliderX.scroll.addAdjustmentListener(this);
        this.sliderY.scroll.addAdjustmentListener(this);
        this.sliderT.scroll.addAdjustmentListener(this);
        JToolBar t3 = new JToolBar();
        ((Container)t3).setLayout(new FlowLayout(0));
        t3.add(this.sliderX);
        t3.add(this.sliderY);
        t3.add(this.sliderT);
        t3.setFloatable(true);
        t3.removeKeyListener(this);
        this.canvas = new ViewerCanvas(handler, this, zoomXY);
        this.canvas.addMouseListener(this);
        int nt = imp.getStackSize();
        if (nt > 400) {
            this.canvas.zoomZ = 1.0;
        } else if (nt > 200) {
            this.canvas.zoomZ = 2.0;
        } else if (nt > 100) {
            this.canvas.zoomZ = 2.0;
        } else if (nt > 100) {
            this.canvas.zoomZ = 4.0;
        }
        this.mnuZoomT[FMath.round(this.canvas.zoomZ) - 1].setSelected(true);
        JScrollPane scrollPaneCanvas = new JScrollPane(this.canvas);
        scrollPaneCanvas.setHorizontalScrollBarPolicy(32);
        scrollPaneCanvas.setVerticalScrollBarPolicy(22);
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.requestFocus();
        this.getContentPane().add((Component)this.t1, "North");
        this.getContentPane().add((Component)scrollPaneCanvas, "Center");
        JPanel bot = new JPanel();
        bot.setLayout(new BorderLayout());
        bot.add((Component)t3, "North");
        bot.add((Component)t2, "South");
        this.getContentPane().add((Component)bot, "South");
        this.pack();
        this.setStatus();
        this.show();
    }

    public void setStatus() {
        if (this.canvas == null) {
            return;
        }
        PointTrack cursor = this.canvas.getCurrentPosition();
        this.status.setText(" value=" + IJ.d2s((double)cursor.value, (int)4));
        this.sliderX.scroll.setValue(cursor.x);
        this.sliderY.scroll.setValue(cursor.y);
        this.sliderT.scroll.setValue(cursor.t);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mnuClose) {
            if (this.handler.trackDialog != null) {
                this.handler.trackDialog.dispose();
            }
            this.dispose();
        } else if (e.getSource() == this.mnuSave) {
            this.canvas.saveView();
        } else if (e.getSource() == this.mnuHelp) {
            MessageBox.help();
        } else if (e.getSource() == this.mnuAbout) {
            MessageBox.about();
        } else if (e.getSource() == this.mnuSummTable) {
            TableResults.showSummTable(this.handler);
        } else if (e.getSource() == this.mnuFullTable) {
            TableResults.showFullTable(this.handler);
        } else if (e.getSource() == this.mnuResultStack1) {
            TableResults.showStack(this.handler, 1.0, 3);
        } else if (e.getSource() == this.mnuResultStack2) {
            TableResults.showStack(this.handler, 2.0, 3);
        } else if (e.getSource() == this.mnuResultStack3) {
            TableResults.showStack(this.handler, 3.0, 3);
        } else if (e.getSource() == this.mnuResultStack4) {
            TableResults.showStack(this.handler, 4.0, 3);
        } else if (e.getSource() == this.mnuResultStack5) {
            TableResults.showStack(this.handler, 5.0, 3);
        } else if (e.getSource() == this.mnuInverse) {
            this.canvas.inverse();
        } else if (e.getSource() == this.chkEnveloppe) {
            this.canvas.displayEnveloppe(this.chkEnveloppe.isSelected());
            this.requestFocus();
        } else if (e.getSource() == this.chkNucleus) {
            this.canvas.displayNucleus(this.chkNucleus.isSelected());
            this.requestFocus();
        } else if (e.getSource() == this.chkTrace) {
            this.canvas.displayTrack(this.chkTrace.isSelected());
            this.requestFocus();
        } else if (e.getSource() == this.chkSpot) {
            this.canvas.displaySpot(this.chkSpot.isSelected());
            this.requestFocus();
        } else if (e.getSource() == this.chkNode) {
            this.canvas.displaySpot(this.chkNode.isSelected());
            this.requestFocus();
        } else if (e.getSource() == this.mnuSetViewing) {
            SetViewing sv = new SetViewing(true);
            this.canvas.setSettings(sv.getSettings(), sv.getColors());
        } else if (e.getSource() == this.mnuNorm || e.getSource() == this.toolRescale) {
            RescaleSliceFrame rs = new RescaleSliceFrame(this.imp, this.handler, this.progress, e.getSource() == this.mnuNorm, this.canvas, this.cmbSource);
        } else if (e.getSource() == this.mnuAlign || e.getSource() == this.toolAlign) {
            AlignNucleusFrame an = new AlignNucleusFrame(this.imp, this.handler, this.progress, e.getSource() == this.mnuAlign, this.canvas, this.cmbSource);
        } else if (e.getSource() == this.mnuFilter || e.getSource() == this.toolEnhance) {
            EnhanceSpotFrame aen = new EnhanceSpotFrame(this.imp, this.handler, this.progress, e.getSource() == this.mnuFilter, this.canvas, this.cmbSource);
        } else if (e.getSource() == this.mnuTrack || e.getSource() == this.toolTrack) {
            if (this.handler.trackDialog == null) {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension size = this.getSize();
                Point location = this.getLocation();
                int left = location.x;
                int right = screen.width - (location.x + size.width);
                location.x = right > 50 && left > 50 ? (right > left - 100 ? (location.x += size.width) : 10) : screen.width / 2 - 100;
                this.handler.trackDialog = new TrackDialog("Tracking", this.handler, this.progress, this.canvas, location, true);
            } else {
                if (!this.handler.trackDialog.isVisible()) {
                    this.handler.trackDialog.show();
                }
                this.handler.trackDialog.startTracking();
            }
        } else if (e.getSource() == this.cmbSource) {
            this.canvas.setDataViewing(this.cmbSource.getSelectedIndex());
            this.requestFocus();
        } else if (e.getSource() == this.cmbProj) {
            this.canvas.setProjection(this.cmbProj.getSelectedIndex());
            this.requestFocus();
        }
        int i = 0;
        while (i < this.zoomList.length) {
            if (e.getSource() == this.mnuZoomX[i]) {
                this.canvas.zoomX = i + 1;
                this.canvas.updateSlice();
                this.requestFocus();
                this.pack();
            }
            if (e.getSource() == this.mnuZoomY[i]) {
                this.canvas.zoomY = i + 1;
                this.canvas.updateSlice();
                this.requestFocus();
                this.pack();
            }
            if (e.getSource() == this.mnuZoomT[i]) {
                this.canvas.zoomZ = i + 1;
                this.canvas.updateSlice();
                this.pack();
            }
            ++i;
        }
        this.requestFocus();
    }

    public synchronized void mouseEntered(MouseEvent e) {
    }

    public synchronized void mouseExited(MouseEvent e) {
    }

    public synchronized void mouseReleased(MouseEvent e) {
    }

    public synchronized void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.canvas.pressPosition(e);
        if (e.isMetaDown() || e.isAltDown() || e.isControlDown()) {
            Point pt = e.getPoint();
            Dimension size = this.t1.getSize();
            this.canvas.activatePopup();
            this.add(this.canvas.popup);
            this.canvas.popup.show(this, e.getX(), e.getY() + size.height);
        }
        this.setStatus();
        this.requestFocus();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.sliderX.scroll) {
            this.canvas.setCursorPosition(this.sliderX.scroll.getValue(), this.sliderY.scroll.getValue(), this.sliderT.scroll.getValue());
        } else if (e.getSource() == this.sliderY.scroll) {
            this.canvas.setCursorPosition(this.sliderX.scroll.getValue(), this.sliderY.scroll.getValue(), this.sliderT.scroll.getValue());
        } else if (e.getSource() == this.sliderT.scroll) {
            this.canvas.setCursorPosition(this.sliderX.scroll.getValue(), this.sliderY.scroll.getValue(), this.sliderT.scroll.getValue());
        }
    }

    public synchronized void keyReleased(KeyEvent e) {
    }

    public synchronized void keyTyped(KeyEvent e) {
    }

    public synchronized void keyPressed(KeyEvent e) {
        this.canvas.pressed(e);
        this.setStatus();
        this.requestFocus();
    }

    public synchronized void windowActivated(WindowEvent e) {
    }

    public synchronized void windowClosed(WindowEvent e) {
    }

    public synchronized void windowDeactivated(WindowEvent e) {
    }

    public synchronized void windowDeiconified(WindowEvent e) {
    }

    public synchronized void windowIconified(WindowEvent e) {
    }

    public synchronized void windowOpened(WindowEvent e) {
    }

    public synchronized void windowClosing(WindowEvent e) {
        if (this.handler.trackDialog != null) {
            this.handler.trackDialog.dispose();
        }
        this.dispose();
    }
}

