/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class pointToolbar
extends Canvas
implements AdjustmentListener,
MouseListener {
    private static final int NUM_TOOLS = 19;
    private static final int SIZE = 22;
    private static final int OFFSET = 3;
    private static final Color gray = Color.lightGray;
    private static final Color brighter = gray.brighter();
    private static final Color darker = gray.darker();
    private static final Color evenDarker = darker.darker();
    private final boolean[] down = new boolean[19];
    private Graphics g;
    private Scrollbar scrollbar;
    private ImagePlus imp;
    private Toolbar previousInstance;
    private pointAction pa;
    private pointHandler[] ph;
    private pointToolbar instance;
    private long mouseDownTime;
    private int currentTool = 0;
    private int currentMode = 4;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.imp.setRoi((Roi)this.ph[adjustmentEvent.getValue() - 1]);
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public int getCurrentTool() {
        return this.currentTool;
    }

    public void installListeners(pointAction pointAction2) {
        this.pa = pointAction2;
        ImageWindow imageWindow = this.imp.getWindow();
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        imageWindow.requestFocus();
        imageWindow.removeKeyListener((KeyListener)IJ.getInstance());
        imageCanvas.removeMouseListener((MouseListener)imageCanvas);
        imageCanvas.removeMouseMotionListener((MouseMotionListener)imageCanvas);
        imageCanvas.addMouseMotionListener(pointAction2);
        imageCanvas.addMouseListener(pointAction2);
        imageWindow.addKeyListener(pointAction2);
        if (this.imp.getWindow() instanceof StackWindow) {
            StackWindow stackWindow = (StackWindow)this.imp.getWindow();
            Component[] componentArray = stackWindow.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof Scrollbar) {
                    this.scrollbar = (Scrollbar)componentArray[n];
                    this.scrollbar.addAdjustmentListener(this);
                }
                ++n;
            }
        } else {
            this.scrollbar = null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Dialog dialog;
        Dialog dialog2;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.currentTool;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 19) {
            if (n5 * 22 < n && n < n5 * 22 + 22) {
                n4 = n5;
            }
            ++n5;
        }
        boolean bl = n4 == this.getCurrentTool() && System.currentTimeMillis() - this.mouseDownTime <= 500L;
        this.mouseDownTime = System.currentTimeMillis();
        switch (n4) {
            case 4: 
            case 5: {
                this.setMode(n4);
                return;
            }
        }
        this.setTool(n4);
        if (bl) {
            switch (n4) {
                case 0: 
                case 1: {
                    dialog2 = new pointPickerColorSettings((Frame)IJ.getInstance(), this.ph, this.imp);
                    GUI.center((Window)dialog2);
                    ((Component)dialog2).setVisible(true);
                    dialog2.dispose();
                    break;
                }
                case 2: {
                    dialog = new pointPickerClearAll((Frame)IJ.getInstance(), this.ph, this.imp);
                    GUI.center((Window)dialog);
                    ((Component)dialog).setVisible(true);
                    dialog.dispose();
                    break;
                }
            }
        }
        switch (n4) {
            case 7: {
                dialog2 = new pointPickerFile((Frame)IJ.getInstance(), this.ph, this.imp);
                GUI.center((Window)dialog2);
                ((Component)dialog2).setVisible(true);
                this.setTool(n3);
                dialog2.dispose();
                break;
            }
            case 8: {
                dialog = new pointPickerTerminate((Frame)IJ.getInstance());
                GUI.center((Window)dialog);
                ((Component)dialog).setVisible(true);
                if (((pointPickerTerminate)dialog).choseCancel()) {
                    this.setTool(n3);
                } else {
                    int n6 = 0;
                    while (n6 < this.ph.length) {
                        this.ph[n6].removePoints();
                        ++n6;
                    }
                    this.cleanUpListeners();
                    this.restorePreviousToolbar();
                    Toolbar.getInstance().repaint();
                }
                dialog.dispose();
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < 19) {
            this.drawButton(graphics, n);
            ++n;
        }
    }

    public pointToolbar(Toolbar toolbar) {
        this.previousInstance = toolbar;
        this.instance = this;
        Container container = toolbar.getParent();
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == toolbar) {
                container.remove((Component)toolbar);
                container.add((Component)this, n);
                break;
            }
            ++n;
        }
        this.resetButtons();
        this.down[this.currentTool] = true;
        this.down[this.currentMode] = true;
        this.setTool(this.currentTool);
        this.setMode(this.currentMode);
        this.setForeground(evenDarker);
        this.setBackground(gray);
        this.addMouseListener(this);
        container.validate();
    }

    public void setMode(int n) {
        if (n == this.currentMode) {
            return;
        }
        this.down[n] = true;
        this.down[this.currentMode] = false;
        Graphics graphics = this.getGraphics();
        this.drawButton(graphics, this.currentMode);
        this.drawButton(graphics, n);
        graphics.dispose();
        this.showMessage(n);
        this.currentMode = n;
    }

    public void setTool(int n) {
        if (n == this.currentTool) {
            return;
        }
        this.down[n] = true;
        this.down[this.currentTool] = false;
        Graphics graphics = this.getGraphics();
        this.drawButton(graphics, this.currentTool);
        this.drawButton(graphics, n);
        graphics.dispose();
        this.showMessage(n);
        this.currentTool = n;
    }

    public void setWindow(pointHandler[] pointHandlerArray, ImagePlus imagePlus) {
        this.ph = pointHandlerArray;
        this.imp = imagePlus;
    }

    private void cleanUpListeners() {
        if (this.scrollbar != null) {
            this.scrollbar.removeAdjustmentListener(this);
        }
        ImageWindow imageWindow = this.imp.getWindow();
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        imageWindow.removeKeyListener(this.pa);
        imageCanvas.removeMouseListener(this.pa);
        imageCanvas.removeMouseMotionListener(this.pa);
        imageCanvas.addMouseMotionListener((MouseMotionListener)imageCanvas);
        imageCanvas.addMouseListener((MouseListener)imageCanvas);
        imageWindow.addKeyListener((KeyListener)IJ.getInstance());
    }

    private void d(int n, int n2) {
        this.g.drawLine(this.x, this.y, n += this.xOffset, n2 += this.yOffset);
        this.x = n;
        this.y = n2;
    }

    private void drawButton(Graphics graphics, int n) {
        this.fill3DRect(graphics, n * 22 + 1, 1, 22, 21, this.down[n] ^ true);
        graphics.setColor(Color.black);
        int n2 = n * 22 + 3;
        int n3 = 3;
        if (this.down[n]) {
            ++n2;
            ++n3;
        }
        this.g = graphics;
        switch (n) {
            case 0: {
                this.xOffset = n2;
                this.yOffset = n3;
                this.m(7, 0);
                this.d(7, 1);
                this.m(6, 2);
                this.d(6, 3);
                this.m(8, 2);
                this.d(8, 3);
                this.m(5, 4);
                this.d(5, 5);
                this.m(9, 4);
                this.d(9, 5);
                this.m(4, 6);
                this.d(4, 8);
                this.m(10, 6);
                this.d(10, 8);
                this.m(5, 9);
                this.d(5, 14);
                this.m(9, 9);
                this.d(9, 14);
                this.m(7, 4);
                this.d(7, 6);
                this.m(7, 8);
                this.d(7, 8);
                this.m(4, 11);
                this.d(10, 11);
                graphics.fillRect(n2 + 6, n3 + 12, 3, 3);
                this.m(11, 13);
                this.d(15, 13);
                this.m(13, 11);
                this.d(13, 15);
                break;
            }
            case 1: {
                this.xOffset = n2;
                this.yOffset = n3;
                this.m(1, 1);
                this.d(1, 10);
                this.m(2, 2);
                this.d(2, 9);
                this.m(3, 3);
                this.d(3, 8);
                this.m(4, 4);
                this.d(4, 7);
                this.m(5, 5);
                this.d(5, 7);
                this.m(6, 6);
                this.d(6, 7);
                this.m(7, 7);
                this.d(7, 7);
                this.m(11, 5);
                this.d(11, 6);
                this.m(10, 7);
                this.d(10, 8);
                this.m(12, 7);
                this.d(12, 8);
                this.m(9, 9);
                this.d(9, 11);
                this.m(13, 9);
                this.d(13, 11);
                this.m(10, 12);
                this.d(10, 15);
                this.m(12, 12);
                this.d(12, 15);
                this.m(11, 9);
                this.d(11, 10);
                this.m(11, 13);
                this.d(11, 15);
                this.m(9, 13);
                this.d(13, 13);
                break;
            }
            case 2: {
                this.xOffset = n2;
                this.yOffset = n3;
                this.m(7, 0);
                this.d(7, 1);
                this.m(6, 2);
                this.d(6, 3);
                this.m(8, 2);
                this.d(8, 3);
                this.m(5, 4);
                this.d(5, 5);
                this.m(9, 4);
                this.d(9, 5);
                this.m(4, 6);
                this.d(4, 8);
                this.m(10, 6);
                this.d(10, 8);
                this.m(5, 9);
                this.d(5, 14);
                this.m(9, 9);
                this.d(9, 14);
                this.m(7, 4);
                this.d(7, 6);
                this.m(7, 8);
                this.d(7, 8);
                this.m(4, 11);
                this.d(10, 11);
                graphics.fillRect(n2 + 6, n3 + 12, 3, 3);
                this.m(11, 13);
                this.d(15, 13);
                break;
            }
            case 4: {
                this.xOffset = n2;
                this.yOffset = n3;
                this.m(2, 6);
                this.d(2, 6);
                this.m(3, 5);
                this.d(3, 5);
                this.m(5, 3);
                this.d(5, 3);
                this.m(6, 2);
                this.d(6, 2);
                this.m(9, 6);
                this.d(9, 6);
                this.m(10, 5);
                this.d(10, 5);
                this.m(12, 3);
                this.d(12, 3);
                this.m(13, 2);
                this.d(13, 2);
                this.m(9, 13);
                this.d(9, 13);
                this.m(10, 12);
                this.d(10, 12);
                this.m(12, 10);
                this.d(12, 10);
                this.m(13, 9);
                this.d(13, 9);
                this.m(2, 13);
                this.d(2, 13);
                this.m(3, 12);
                this.d(3, 12);
                this.m(4, 11);
                this.d(11, 11);
                this.d(11, 4);
                this.d(4, 4);
                this.d(4, 11);
                break;
            }
            case 5: {
                this.xOffset = n2;
                this.yOffset = n3;
                this.m(2, 13);
                this.d(9, 13);
                this.d(9, 6);
                this.d(2, 6);
                this.d(2, 13);
                this.m(3, 5);
                this.d(3, 5);
                this.m(4, 4);
                this.d(11, 4);
                this.d(11, 11);
                this.m(10, 12);
                this.d(10, 12);
                this.m(10, 5);
                this.d(10, 5);
                this.m(12, 3);
                this.d(12, 3);
                this.m(12, 10);
                this.d(12, 10);
                this.m(5, 3);
                this.d(5, 3);
                this.m(6, 2);
                this.d(13, 2);
                this.d(13, 9);
                break;
            }
            case 7: {
                this.xOffset = n2;
                this.yOffset = n3;
                this.m(3, 1);
                this.d(9, 1);
                this.d(9, 4);
                this.d(12, 4);
                this.d(12, 14);
                this.d(3, 14);
                this.d(3, 1);
                this.m(10, 2);
                this.d(11, 3);
                this.m(5, 4);
                this.d(7, 4);
                this.m(5, 6);
                this.d(10, 6);
                this.m(5, 8);
                this.d(10, 8);
                this.m(5, 10);
                this.d(10, 10);
                this.m(5, 12);
                this.d(10, 12);
                break;
            }
            case 8: {
                this.xOffset = n2;
                this.yOffset = n3;
                this.m(5, 0);
                this.d(5, 8);
                this.m(4, 5);
                this.d(4, 7);
                this.m(3, 6);
                this.d(3, 7);
                this.m(2, 7);
                this.d(2, 9);
                this.m(1, 8);
                this.d(1, 9);
                this.m(2, 10);
                this.d(6, 10);
                this.m(3, 11);
                this.d(3, 13);
                this.m(1, 14);
                this.d(6, 14);
                this.m(0, 15);
                this.d(7, 15);
                this.m(2, 13);
                this.d(2, 13);
                this.m(5, 13);
                this.d(5, 13);
                this.m(7, 8);
                this.d(14, 8);
                this.m(8, 7);
                this.d(15, 7);
                this.m(8, 9);
                this.d(13, 9);
                this.m(9, 6);
                this.d(9, 10);
                this.m(15, 4);
                this.d(15, 6);
                this.d(14, 6);
                break;
            }
            case 11: {
                this.xOffset = n2 + 2;
                this.yOffset = n3 + 2;
                this.m(3, 0);
                this.d(3, 0);
                this.d(5, 0);
                this.d(8, 3);
                this.d(8, 5);
                this.d(7, 6);
                this.d(7, 7);
                this.d(6, 7);
                this.d(5, 8);
                this.d(3, 8);
                this.d(0, 5);
                this.d(0, 3);
                this.d(3, 0);
                this.m(8, 8);
                this.d(9, 8);
                this.d(13, 12);
                this.d(13, 13);
                this.d(12, 13);
                this.d(8, 9);
                this.d(8, 8);
                break;
            }
        }
    }

    private void fill3DRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            graphics.setColor(gray);
        } else {
            graphics.setColor(darker);
        }
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(bl ? brighter : evenDarker);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.drawLine(n + 1, n2, n + n3 - 2, n2);
        graphics.setColor(bl ? evenDarker : brighter);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 2);
    }

    private void m(int n, int n2) {
        this.x = this.xOffset + n;
        this.y = this.yOffset + n2;
    }

    private void resetButtons() {
        int n = 0;
        while (n < 19) {
            this.down[n] = false;
            ++n;
        }
    }

    private void restorePreviousToolbar() {
        Container container = this.instance.getParent();
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == this.instance) {
                container.remove(this.instance);
                container.add((Component)this.previousInstance, n);
                container.validate();
                break;
            }
            ++n;
        }
    }

    private void showMessage(int n) {
        switch (n) {
            case 0: {
                IJ.showStatus((String)"Add crosses");
                return;
            }
            case 1: {
                IJ.showStatus((String)"Move crosses");
                return;
            }
            case 2: {
                IJ.showStatus((String)"Remove crosses");
                return;
            }
            case 4: {
                IJ.showStatus((String)"Apply to the current slice");
                return;
            }
            case 5: {
                IJ.showStatus((String)"Apply to all slices");
                return;
            }
            case 7: {
                IJ.showStatus((String)"Export/Import list of points");
                return;
            }
            case 8: {
                IJ.showStatus((String)"Exit PointPicker");
                return;
            }
            case 11: {
                IJ.showStatus((String)"Magnifying glass");
                return;
            }
        }
        IJ.showStatus((String)"Undefined operation");
    }
}

