/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import imageware.ByteSet;
import imageware.DoubleSet;
import imageware.FloatSet;
import imageware.ImageWare;
import imageware.ShortSet;
import java.awt.Image;

public class Builder {
    public static ImageWare wrapOnFocus() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        return Builder.wrap(imagePlus.getStack());
    }

    public static ImageWare wrap(ImagePlus imagePlus) {
        return Builder.wrap(imagePlus.getStack());
    }

    public static ImageWare wrap(ImageStack imageStack) {
        ImageProcessor imageProcessor;
        if (imageStack == null) {
            Builder.throw_null();
        }
        if ((imageProcessor = imageStack.getProcessor(1)) instanceof ByteProcessor) {
            return new ByteSet(imageStack, 2);
        }
        if (imageProcessor instanceof ShortProcessor) {
            return new ShortSet(imageStack, 2);
        }
        if (imageProcessor instanceof FloatProcessor) {
            return new FloatSet(imageStack, 2);
        }
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to wrap this ImageStack object.\nSupport only the 8-bit, 16-bit and 32-bits type.\n-------------------------------------------------------\n");
    }

    public static ImageWare create(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 1: {
                return new ByteSet(n, n2, n3);
            }
            case 2: {
                return new ShortSet(n, n2, n3);
            }
            case 3: {
                return new FloatSet(n, n2, n3);
            }
            case 4: {
                return new DoubleSet(n, n2, n3);
            }
        }
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + n4 + ".\n" + "-------------------------------------------------------\n");
    }

    public static ImageWare create(Image image) {
        if (image == null) {
            Builder.throw_null();
        }
        return new ByteSet(image, 1);
    }

    public static ImageWare createOnFocus() {
        return Builder.create(WindowManager.getCurrentImage());
    }

    public static ImageWare create(ImageStack imageStack) {
        if (imageStack == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.wrap(imageStack);
        return imageWare.duplicate();
    }

    public static ImageWare create(ImagePlus imagePlus) {
        if (imagePlus == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.wrap(imagePlus);
        return imageWare.duplicate();
    }

    public static ImageWare[] createColors(ImagePlus imagePlus) {
        if (imagePlus == null) {
            Builder.throw_null();
        }
        return Builder.createColors(imagePlus.getStack());
    }

    public static ImageWare[] createColors(ImageStack imageStack) {
        if (imageStack == null) {
            Builder.throw_null();
        }
        ImageWare[] imageWareArray = new ImageWare[]{new ByteSet(imageStack, 0), new ByteSet(imageStack, 1), new ByteSet(imageStack, 2)};
        return imageWareArray;
    }

    public static ImageWare createColorChannel(ImagePlus imagePlus, byte by) {
        if (imagePlus == null) {
            Builder.throw_null();
        }
        return Builder.createColorChannel(imagePlus.getStack(), by);
    }

    public static ImageWare createColorChannel(ImageStack imageStack, byte by) {
        if (imageStack == null) {
            Builder.throw_null();
        }
        return new ByteSet(imageStack, by);
    }

    public static ImageWare create(byte[] byArray) {
        if (byArray == null) {
            Builder.throw_null();
        }
        return new ByteSet(byArray, 1);
    }

    public static ImageWare create(short[] sArray) {
        if (sArray == null) {
            Builder.throw_null();
        }
        return new ShortSet(sArray, 1);
    }

    public static ImageWare create(float[] fArray) {
        if (fArray == null) {
            Builder.throw_null();
        }
        return new FloatSet(fArray, 1);
    }

    public static ImageWare create(double[] dArray) {
        if (dArray == null) {
            Builder.throw_null();
        }
        return new DoubleSet(dArray, 1);
    }

    public static ImageWare create(byte[][] byArray) {
        if (byArray == null) {
            Builder.throw_null();
        }
        return new ByteSet(byArray, 1);
    }

    public static ImageWare create(short[][] sArray) {
        if (sArray == null) {
            Builder.throw_null();
        }
        return new ByteSet(sArray, 1);
    }

    public static ImageWare create(float[][] fArray) {
        if (fArray == null) {
            Builder.throw_null();
        }
        return new FloatSet(fArray, 1);
    }

    public static ImageWare create(double[][] dArray) {
        if (dArray == null) {
            Builder.throw_null();
        }
        return new DoubleSet(dArray, 1);
    }

    public static ImageWare create(byte[][][] byArray) {
        if (byArray == null) {
            Builder.throw_null();
        }
        return new ByteSet(byArray, 1);
    }

    public static ImageWare create(short[][][] sArray) {
        if (sArray == null) {
            Builder.throw_null();
        }
        return new ShortSet(sArray, 1);
    }

    public static ImageWare create(float[][][] fArray) {
        if (fArray == null) {
            Builder.throw_null();
        }
        return new FloatSet(fArray, 1);
    }

    public static ImageWare create(double[][][] dArray) {
        if (dArray == null) {
            Builder.throw_null();
        }
        return new DoubleSet(dArray, 1);
    }

    public static ImageWare create(Image image, int n) {
        if (image == null) {
            Builder.throw_null();
        }
        switch (n) {
            case 1: {
                return new ByteSet(image, 1);
            }
            case 2: {
                return new ShortSet(image, 1);
            }
            case 3: {
                return new FloatSet(image, 1);
            }
            case 4: {
                return new DoubleSet(image, 1);
            }
        }
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + n + ".\n" + "-------------------------------------------------------\n");
    }

    public static ImageWare createOnFocus(int n) {
        return Builder.create(WindowManager.getCurrentImage(), n);
    }

    public static ImageWare create(ImagePlus imagePlus, int n) {
        if (imagePlus == null) {
            Builder.throw_null();
        }
        switch (n) {
            case 1: {
                return new ByteSet(imagePlus.getStack(), 1);
            }
            case 2: {
                return new ShortSet(imagePlus.getStack(), 1);
            }
            case 3: {
                return new FloatSet(imagePlus.getStack(), 1);
            }
            case 4: {
                return new DoubleSet(imagePlus.getStack(), 1);
            }
        }
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + n + ".\n" + "-------------------------------------------------------\n");
    }

    public static ImageWare create(ImageStack imageStack, int n) {
        if (imageStack == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.wrap(imageStack);
        return imageWare.convert(n);
    }

    public static ImageWare[] createColor(ImagePlus imagePlus, int n) {
        if (imagePlus == null) {
            Builder.throw_null();
        }
        return Builder.createColor(imagePlus.getStack(), n);
    }

    public static ImageWare[] createColor(ImageStack imageStack, int n) {
        if (imageStack == null) {
            Builder.throw_null();
        }
        ImageWare[] imageWareArray = new ImageWare[3];
        switch (n) {
            case 1: {
                imageWareArray[0] = new ByteSet(imageStack, 0);
                imageWareArray[1] = new ByteSet(imageStack, 1);
                imageWareArray[2] = new ByteSet(imageStack, 2);
                break;
            }
            case 2: {
                imageWareArray[0] = new ShortSet(imageStack, 0);
                imageWareArray[1] = new ShortSet(imageStack, 1);
                imageWareArray[2] = new ShortSet(imageStack, 2);
                break;
            }
            case 3: {
                imageWareArray[0] = new FloatSet(imageStack, 0);
                imageWareArray[1] = new FloatSet(imageStack, 1);
                imageWareArray[2] = new FloatSet(imageStack, 2);
                break;
            }
            case 4: {
                imageWareArray[0] = new DoubleSet(imageStack, 0);
                imageWareArray[1] = new DoubleSet(imageStack, 1);
                imageWareArray[2] = new DoubleSet(imageStack, 2);
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + n + ".\n" + "-------------------------------------------------------\n");
            }
        }
        return imageWareArray;
    }

    public static ImageWare createColorChannel(ImagePlus imagePlus, byte by, int n) {
        if (imagePlus == null) {
            Builder.throw_null();
        }
        return Builder.createColorChannel(imagePlus.getStack(), by, n);
    }

    public static ImageWare createColorChannel(ImageStack imageStack, byte by, int n) {
        if (imageStack == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = null;
        switch (n) {
            case 1: {
                imageWare = new ByteSet(imageStack, by);
                break;
            }
            case 2: {
                imageWare = new ShortSet(imageStack, by);
                break;
            }
            case 3: {
                imageWare = new FloatSet(imageStack, by);
                break;
            }
            case 4: {
                imageWare = new DoubleSet(imageStack, by);
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + n + ".\n" + "-------------------------------------------------------\n");
            }
        }
        return imageWare;
    }

    public static ImageWare create(byte[] byArray, int n) {
        if (byArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(byArray.length, 1, 1, n);
        imageWare.putX(0, 0, 0, byArray);
        return imageWare;
    }

    public static ImageWare create(short[] sArray, int n) {
        if (sArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(sArray.length, 1, 1, n);
        imageWare.putX(0, 0, 0, sArray);
        return imageWare;
    }

    public static ImageWare create(float[] fArray, int n) {
        if (fArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(fArray.length, 1, 1, n);
        imageWare.putX(0, 0, 0, fArray);
        return imageWare;
    }

    public static ImageWare create(double[] dArray, int n) {
        if (dArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(dArray.length, 1, 1, n);
        imageWare.putX(0, 0, 0, dArray);
        return imageWare;
    }

    public static ImageWare create(byte[][] byArray, int n) {
        if (byArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(byArray.length, byArray[0].length, 1, n);
        imageWare.putXY(0, 0, 0, byArray);
        return imageWare;
    }

    public static ImageWare create(short[][] sArray, int n) {
        if (sArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(sArray.length, sArray[0].length, 1, n);
        imageWare.putXY(0, 0, 0, sArray);
        return imageWare;
    }

    public static ImageWare create(float[][] fArray, int n) {
        if (fArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(fArray.length, fArray[0].length, 1, n);
        imageWare.putXY(0, 0, 0, fArray);
        return imageWare;
    }

    public static ImageWare create(double[][] dArray, int n) {
        if (dArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(dArray.length, dArray[0].length, 1, n);
        imageWare.putXY(0, 0, 0, dArray);
        return imageWare;
    }

    public static ImageWare create(byte[][][] byArray, int n) {
        if (byArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(byArray.length, byArray[0].length, byArray[0][0].length, n);
        imageWare.putXYZ(0, 0, 0, byArray);
        return imageWare;
    }

    public static ImageWare create(short[][][] sArray, int n) {
        if (sArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(sArray.length, sArray[0].length, sArray[0][0].length, n);
        imageWare.putXYZ(0, 0, 0, sArray);
        return imageWare;
    }

    public static ImageWare create(float[][][] fArray, int n) {
        if (fArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(fArray.length, fArray[0].length, fArray[0][0].length, n);
        imageWare.putXYZ(0, 0, 0, fArray);
        return imageWare;
    }

    public static ImageWare create(double[][][] dArray, int n) {
        if (dArray == null) {
            Builder.throw_null();
        }
        ImageWare imageWare = Builder.createType(dArray.length, dArray[0].length, dArray[0][0].length, n);
        imageWare.putXYZ(0, 0, 0, dArray);
        return imageWare;
    }

    private static ImageWare createType(int n, int n2, int n3, int n4) {
        ImageWare imageWare = null;
        switch (n4) {
            case 1: {
                imageWare = new ByteSet(n, n2, n3);
                break;
            }
            case 2: {
                imageWare = new ShortSet(n, n2, n3);
                break;
            }
            case 3: {
                imageWare = new FloatSet(n, n2, n3);
                break;
            }
            case 4: {
                imageWare = new DoubleSet(n, n2, n3);
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to create this object.\n-------------------------------------------------------\n");
            }
        }
        return imageWare;
    }

    private static void throw_null() {
        throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to wrap the ImagePlus.\nThe object parameter is null.\n-------------------------------------------------------\n");
    }
}

