/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImageStack;
import imageware.BytePointwise;
import imageware.ByteSet;
import imageware.Convolver;
import imageware.DoubleSet;
import imageware.FloatSet;
import imageware.ImageWare;
import imageware.Process;
import imageware.ShortSet;
import java.awt.Image;

public class ByteProcess
extends BytePointwise
implements Process {
    protected ByteProcess(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected ByteProcess(Image image, int n) {
        super(image, n);
    }

    protected ByteProcess(ImageStack imageStack, int n) {
        super(imageStack, n);
    }

    protected ByteProcess(ImageStack imageStack, byte by) {
        super(imageStack, by);
    }

    protected ByteProcess(byte[] byArray, int n) {
        super(byArray, n);
    }

    protected ByteProcess(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected ByteProcess(byte[][][] byArray, int n) {
        super(byArray, n);
    }

    protected ByteProcess(short[] sArray, int n) {
        super(sArray, n);
    }

    protected ByteProcess(short[][] sArray, int n) {
        super(sArray, n);
    }

    protected ByteProcess(short[][][] sArray, int n) {
        super(sArray, n);
    }

    protected ByteProcess(float[] fArray, int n) {
        super(fArray, n);
    }

    protected ByteProcess(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected ByteProcess(float[][][] fArray, int n) {
        super(fArray, n);
    }

    protected ByteProcess(double[] dArray, int n) {
        super(dArray, n);
    }

    protected ByteProcess(double[][] dArray, int n) {
        super(dArray, n);
    }

    protected ByteProcess(double[][][] dArray, int n) {
        super(dArray, n);
    }

    public void smoothGaussian(double d) {
        this.smoothGaussian(d, d, d);
    }

    public void smoothGaussian(double d, double d2, double d3) {
        int n;
        int n2;
        double[] dArray;
        double d4;
        double d5;
        int n3 = 3;
        double d6 = n3;
        double d7 = 1.0 / (double)(this.nx + this.ny + this.nz);
        double[] dArray2 = new double[n3];
        if (this.nx > 1 && d > 0.0) {
            d5 = d * d;
            dArray2[1] = dArray2[2] = (d4 = 1.0 + d6 / d5 - Math.sqrt(d6 * d6 + 2.0 * d6 * d5) / d5);
            dArray2[0] = dArray2[2];
            dArray = new double[this.nx];
            n2 = 0;
            while (n2 < this.nz) {
                n = 0;
                while (n < this.ny) {
                    this.getX(0, n, n2, dArray);
                    this.putX(0, n, n2, Convolver.convolveIIR(dArray, dArray2));
                    ++n;
                }
                ++n2;
            }
        }
        if (this.ny > 1 && d2 > 0.0) {
            d5 = d2 * d2;
            dArray2[1] = dArray2[2] = (d4 = 1.0 + d6 / d5 - Math.sqrt(d6 * d6 + 2.0 * d6 * d5) / d5);
            dArray2[0] = dArray2[2];
            dArray = new double[this.ny];
            n2 = 0;
            while (n2 < this.nx) {
                n = 0;
                while (n < this.nz) {
                    this.getY(n2, 0, n, dArray);
                    this.putY(n2, 0, n, Convolver.convolveIIR(dArray, dArray2));
                    ++n;
                }
                ++n2;
            }
        }
        if (this.nz > 1 && d3 > 0.0) {
            d5 = d3 * d3;
            dArray2[1] = dArray2[2] = (d4 = 1.0 + d6 / d5 - Math.sqrt(d6 * d6 + 2.0 * d6 * d5) / d5);
            dArray2[0] = dArray2[2];
            dArray = new double[this.nz];
            n2 = 0;
            while (n2 < this.ny) {
                n = 0;
                while (n < this.nx) {
                    this.getZ(n, n2, 0, dArray);
                    this.putZ(n, n2, 0, Convolver.convolveIIR(dArray, dArray2));
                    ++n;
                }
                ++n2;
            }
        }
    }

    public void max(ImageWare imageWare) {
        if (!this.isSameSize(imageWare)) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to get the maximum because the two operands are not the same size.\n[" + this.nx + "," + this.ny + "," + "," + this.nz + "] != " + "[" + imageWare.getSizeX() + "," + imageWare.getSizeY() + "," + imageWare.getSizeZ() + "].\n" + "-------------------------------------------------------\n");
        }
        switch (imageWare.getType()) {
            case 1: {
                int n = 0;
                while (n < this.nz) {
                    byte[] byArray = ((ByteSet)imageWare).getSliceByte(n);
                    int n2 = 0;
                    while (n2 < this.nxy) {
                        if (((byte[])this.data[n])[n2] < byArray[n2]) {
                            ((byte[])this.data[n])[n2] = byArray[n2];
                        }
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.nz) {
                    short[] sArray = ((ShortSet)imageWare).getSliceShort(n);
                    int n3 = 0;
                    while (n3 < this.nxy) {
                        if (((byte[])this.data[n])[n3] < (byte)sArray[n3]) {
                            ((byte[])this.data[n])[n3] = (byte)sArray[n3];
                        }
                        ++n3;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.nz) {
                    float[] fArray = ((FloatSet)imageWare).getSliceFloat(n);
                    int n4 = 0;
                    while (n4 < this.nxy) {
                        if (((byte[])this.data[n])[n4] < (byte)fArray[n4]) {
                            ((byte[])this.data[n])[n4] = (byte)fArray[n4];
                        }
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.nz) {
                    double[] dArray = ((DoubleSet)imageWare).getSliceDouble(n);
                    int n5 = 0;
                    while (n5 < this.nxy) {
                        if (((byte[])this.data[n])[n5] < (byte)dArray[n5]) {
                            ((byte[])this.data[n])[n5] = (byte)dArray[n5];
                        }
                        ++n5;
                    }
                    ++n;
                }
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + imageWare.getType() + "].\n" + "-------------------------------------------------------\n");
            }
        }
    }

    public void min(ImageWare imageWare) {
        if (!this.isSameSize(imageWare)) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to get the minimum because the two operands are not the same size.\n[" + this.nx + "," + this.ny + "," + "," + this.nz + "] != " + "[" + imageWare.getSizeX() + "," + imageWare.getSizeY() + "," + imageWare.getSizeZ() + "].\n" + "-------------------------------------------------------\n");
        }
        switch (imageWare.getType()) {
            case 1: {
                int n = 0;
                while (n < this.nz) {
                    byte[] byArray = ((ByteSet)imageWare).getSliceByte(n);
                    int n2 = 0;
                    while (n2 < this.nxy) {
                        if (((byte[])this.data[n])[n2] > byArray[n2]) {
                            ((byte[])this.data[n])[n2] = byArray[n2];
                        }
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.nz) {
                    short[] sArray = ((ShortSet)imageWare).getSliceShort(n);
                    int n3 = 0;
                    while (n3 < this.nxy) {
                        if (((byte[])this.data[n])[n3] > (byte)sArray[n3]) {
                            ((byte[])this.data[n])[n3] = (byte)sArray[n3];
                        }
                        ++n3;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.nz) {
                    float[] fArray = ((FloatSet)imageWare).getSliceFloat(n);
                    int n4 = 0;
                    while (n4 < this.nxy) {
                        if (((byte[])this.data[n])[n4] > (byte)fArray[n4]) {
                            ((byte[])this.data[n])[n4] = (byte)fArray[n4];
                        }
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.nz) {
                    double[] dArray = ((DoubleSet)imageWare).getSliceDouble(n);
                    int n5 = 0;
                    while (n5 < this.nxy) {
                        if (((byte[])this.data[n])[n5] > (byte)dArray[n5]) {
                            ((byte[])this.data[n])[n5] = (byte)dArray[n5];
                        }
                        ++n5;
                    }
                    ++n;
                }
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + imageWare.getType() + "].\n" + "-------------------------------------------------------\n");
            }
        }
    }

    public void add(ImageWare imageWare) {
        if (!this.isSameSize(imageWare)) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to add because the two operands are not the same size.\n[" + this.nx + "," + this.ny + "," + "," + this.nz + "] != " + "[" + imageWare.getSizeX() + "," + imageWare.getSizeY() + "," + imageWare.getSizeZ() + "].\n" + "-------------------------------------------------------\n");
        }
        switch (imageWare.getType()) {
            case 1: {
                int n = 0;
                while (n < this.nz) {
                    byte[] byArray = ((ByteSet)imageWare).getSliceByte(n);
                    int n2 = 0;
                    while (n2 < this.nxy) {
                        byte[] byArray2 = (byte[])this.data[n];
                        int n3 = n2;
                        byArray2[n3] = (byte)(byArray2[n3] + byArray[n2]);
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.nz) {
                    short[] sArray = ((ShortSet)imageWare).getSliceShort(n);
                    int n4 = 0;
                    while (n4 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n5 = n4;
                        byArray[n5] = (byte)(byArray[n5] + (byte)sArray[n4]);
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.nz) {
                    float[] fArray = ((FloatSet)imageWare).getSliceFloat(n);
                    int n6 = 0;
                    while (n6 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n7 = n6;
                        byArray[n7] = (byte)(byArray[n7] + (byte)fArray[n6]);
                        ++n6;
                    }
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.nz) {
                    double[] dArray = ((DoubleSet)imageWare).getSliceDouble(n);
                    int n8 = 0;
                    while (n8 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n9 = n8;
                        byArray[n9] = (byte)(byArray[n9] + (byte)dArray[n8]);
                        ++n8;
                    }
                    ++n;
                }
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + imageWare.getType() + "].\n" + "-------------------------------------------------------\n");
            }
        }
    }

    public void multiply(ImageWare imageWare) {
        if (!this.isSameSize(imageWare)) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to multiply because the two operands are not the same size.\n[" + this.nx + "," + this.ny + "," + "," + this.nz + "] != " + "[" + imageWare.getSizeX() + "," + imageWare.getSizeY() + "," + imageWare.getSizeZ() + "].\n" + "-------------------------------------------------------\n");
        }
        switch (imageWare.getType()) {
            case 1: {
                int n = 0;
                while (n < this.nz) {
                    byte[] byArray = ((ByteSet)imageWare).getSliceByte(n);
                    int n2 = 0;
                    while (n2 < this.nxy) {
                        byte[] byArray2 = (byte[])this.data[n];
                        int n3 = n2;
                        byArray2[n3] = (byte)(byArray2[n3] * byArray[n2]);
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.nz) {
                    short[] sArray = ((ShortSet)imageWare).getSliceShort(n);
                    int n4 = 0;
                    while (n4 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n5 = n4;
                        byArray[n5] = (byte)(byArray[n5] * (byte)sArray[n4]);
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.nz) {
                    float[] fArray = ((FloatSet)imageWare).getSliceFloat(n);
                    int n6 = 0;
                    while (n6 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n7 = n6;
                        byArray[n7] = (byte)(byArray[n7] * (byte)fArray[n6]);
                        ++n6;
                    }
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.nz) {
                    double[] dArray = ((DoubleSet)imageWare).getSliceDouble(n);
                    int n8 = 0;
                    while (n8 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n9 = n8;
                        byArray[n9] = (byte)(byArray[n9] * (byte)dArray[n8]);
                        ++n8;
                    }
                    ++n;
                }
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + imageWare.getType() + "].\n" + "-------------------------------------------------------\n");
            }
        }
    }

    public void subtract(ImageWare imageWare) {
        if (!this.isSameSize(imageWare)) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to subtract because the two operands are not the same size.\n[" + this.nx + "," + this.ny + "," + "," + this.nz + "] != " + "[" + imageWare.getSizeX() + "," + imageWare.getSizeY() + "," + imageWare.getSizeZ() + "].\n" + "-------------------------------------------------------\n");
        }
        switch (imageWare.getType()) {
            case 1: {
                int n = 0;
                while (n < this.nz) {
                    byte[] byArray = ((ByteSet)imageWare).getSliceByte(n);
                    int n2 = 0;
                    while (n2 < this.nxy) {
                        byte[] byArray2 = (byte[])this.data[n];
                        int n3 = n2;
                        byArray2[n3] = (byte)(byArray2[n3] - byArray[n2]);
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.nz) {
                    short[] sArray = ((ShortSet)imageWare).getSliceShort(n);
                    int n4 = 0;
                    while (n4 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n5 = n4;
                        byArray[n5] = (byte)(byArray[n5] - (byte)sArray[n4]);
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.nz) {
                    float[] fArray = ((FloatSet)imageWare).getSliceFloat(n);
                    int n6 = 0;
                    while (n6 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n7 = n6;
                        byArray[n7] = (byte)(byArray[n7] - (byte)fArray[n6]);
                        ++n6;
                    }
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.nz) {
                    double[] dArray = ((DoubleSet)imageWare).getSliceDouble(n);
                    int n8 = 0;
                    while (n8 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n9 = n8;
                        byArray[n9] = (byte)(byArray[n9] - (byte)dArray[n8]);
                        ++n8;
                    }
                    ++n;
                }
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + imageWare.getType() + "].\n" + "-------------------------------------------------------\n");
            }
        }
    }

    public void divide(ImageWare imageWare) {
        if (!this.isSameSize(imageWare)) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to divide because the two operands are not the same size.\n[" + this.nx + "," + this.ny + "," + "," + this.nz + "] != " + "[" + imageWare.getSizeX() + "," + imageWare.getSizeY() + "," + imageWare.getSizeZ() + "].\n" + "-------------------------------------------------------\n");
        }
        switch (imageWare.getType()) {
            case 1: {
                int n = 0;
                while (n < this.nz) {
                    byte[] byArray = ((ByteSet)imageWare).getSliceByte(n);
                    int n2 = 0;
                    while (n2 < this.nxy) {
                        byte[] byArray2 = (byte[])this.data[n];
                        int n3 = n2;
                        byArray2[n3] = (byte)(byArray2[n3] / byArray[n2]);
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.nz) {
                    short[] sArray = ((ShortSet)imageWare).getSliceShort(n);
                    int n4 = 0;
                    while (n4 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n5 = n4;
                        byArray[n5] = (byte)(byArray[n5] / (byte)sArray[n4]);
                        ++n4;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.nz) {
                    float[] fArray = ((FloatSet)imageWare).getSliceFloat(n);
                    int n6 = 0;
                    while (n6 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n7 = n6;
                        byArray[n7] = (byte)(byArray[n7] / (byte)fArray[n6]);
                        ++n6;
                    }
                    ++n;
                }
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.nz) {
                    double[] dArray = ((DoubleSet)imageWare).getSliceDouble(n);
                    int n8 = 0;
                    while (n8 < this.nxy) {
                        byte[] byArray = (byte[])this.data[n];
                        int n9 = n8;
                        byArray[n9] = (byte)(byArray[n9] / (byte)dArray[n8]);
                        ++n8;
                    }
                    ++n;
                }
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnknown type " + imageWare.getType() + "].\n" + "-------------------------------------------------------\n");
            }
        }
    }
}

