/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import imageware.DoubleAccess;
import imageware.Pointwise;
import java.awt.Image;
import java.util.Random;

public class DoublePointwise
extends DoubleAccess
implements Pointwise {
    protected DoublePointwise(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected DoublePointwise(Image image, int n) {
        super(image, n);
    }

    protected DoublePointwise(ImageStack imageStack, int n) {
        super(imageStack, n);
    }

    protected DoublePointwise(ImageStack imageStack, byte by) {
        super(imageStack, by);
    }

    protected DoublePointwise(byte[] byArray, int n) {
        super(byArray, n);
    }

    protected DoublePointwise(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected DoublePointwise(byte[][][] byArray, int n) {
        super(byArray, n);
    }

    protected DoublePointwise(short[] sArray, int n) {
        super(sArray, n);
    }

    protected DoublePointwise(short[][] sArray, int n) {
        super(sArray, n);
    }

    protected DoublePointwise(short[][][] sArray, int n) {
        super(sArray, n);
    }

    protected DoublePointwise(float[] fArray, int n) {
        super(fArray, n);
    }

    protected DoublePointwise(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected DoublePointwise(float[][][] fArray, int n) {
        super(fArray, n);
    }

    protected DoublePointwise(double[] dArray, int n) {
        super(dArray, n);
    }

    protected DoublePointwise(double[][] dArray, int n) {
        super(dArray, n);
    }

    protected DoublePointwise(double[][][] dArray, int n) {
        super(dArray, n);
    }

    public void fillConstant(double d) {
        double d2 = d;
        double[] dArray = null;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = d2;
                ++n2;
            }
            ++n;
        }
    }

    public void fillRamp() {
        int n = 0;
        double[] dArray = null;
        int n2 = 0;
        while (n2 < this.nz) {
            dArray = (double[])this.data[n2];
            int n3 = 0;
            while (n3 < this.nxy) {
                dArray[n3] = n + n3;
                ++n3;
            }
            n += this.nxy;
            ++n2;
        }
    }

    public void fillGaussianNoise(double d) {
        Random random = new Random();
        double[] dArray = null;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = random.nextGaussian() * d;
                ++n2;
            }
            ++n;
        }
    }

    public void fillUniformNoise(double d) {
        Random random = new Random();
        double[] dArray = null;
        d *= 2.0;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = (random.nextDouble() - 0.5) * d;
                ++n2;
            }
            ++n;
        }
    }

    public void fillSaltPepper(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        double d5;
        Random random = new Random();
        Object var10_6 = null;
        if (d3 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d3;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                ((double[])this.data[n])[n2] = random.nextDouble() * d;
                ++n3;
            }
        }
        if (d4 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d4;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                ((double[])this.data[n])[n2] = -random.nextDouble() * d;
                ++n3;
            }
        }
    }

    public ImageStack buildImageStack() {
        ImageStack imageStack = new ImageStack(this.nx, this.ny);
        int n = 0;
        while (n < this.nz) {
            FloatProcessor floatProcessor = new FloatProcessor(this.nx, this.ny);
            float[] fArray = (float[])floatProcessor.getPixels();
            int n2 = 0;
            while (n2 < this.nxy) {
                fArray[n2] = (float)((double[])this.data[n])[n2];
                ++n2;
            }
            imageStack.addSlice(String.valueOf(n), (ImageProcessor)floatProcessor);
            ++n;
        }
        return imageStack;
    }

    public void invert() {
        double[] dArray;
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if (dArray[n2] > d) {
                    d = dArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        double d2 = d;
        int n3 = 0;
        while (n3 < this.nz) {
            dArray = (double[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                dArray[n4] = d - dArray[n4];
                ++n4;
            }
            ++n3;
        }
    }

    public void negate() {
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = -dArray[n2];
                ++n2;
            }
            ++n;
        }
    }

    public void clip() {
        this.clip(0.0, 255.0);
    }

    public void clip(double d, double d2) {
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            double d3 = d;
            double d4 = d2;
            int n2 = 0;
            while (n2 < this.nxy) {
                double d5 = dArray[n2];
                if (d5 < d3) {
                    dArray[n2] = d3;
                }
                if (d5 > d4) {
                    dArray[n2] = d4;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void rescale() {
        double d;
        double[] dArray;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if (dArray[n2] > d2) {
                    d2 = dArray[n2];
                }
                if (dArray[n2] < d3) {
                    d3 = dArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        if (d3 - d2 == 0.0) {
            d = 1.0;
            d3 = 128.0;
        } else {
            d = 255.0 / (d2 - d3);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            dArray = (double[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                dArray[n4] = d * (dArray[n4] - d3);
                ++n4;
            }
            ++n3;
        }
    }

    public void rescale(double d, double d2) {
        double d3;
        double[] dArray;
        double d4 = -1.7976931348623157E308;
        double d5 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if (dArray[n2] > d4) {
                    d4 = dArray[n2];
                }
                if (dArray[n2] < d5) {
                    d5 = dArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        if (d5 - d4 == 0.0) {
            d3 = 1.0;
            d5 = (d2 - d) / 2.0;
        } else {
            d3 = (d2 - d) / (d4 - d5);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            dArray = (double[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                dArray[n4] = d3 * (dArray[n4] - d5) + d;
                ++n4;
            }
            ++n3;
        }
    }

    public void rescaleCenter(double d, double d2) {
        double d3;
        double[] dArray;
        double d4 = -1.7976931348623157E308;
        double d5 = Double.MAX_VALUE;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if (dArray[n2] > d4) {
                    d4 = dArray[n2];
                }
                if (dArray[n2] < d5) {
                    d5 = dArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        double d6 = (d2 + d) / 2.0;
        if (d5 - d4 == 0.0) {
            d3 = 1.0;
            d5 = (d2 - d) / 2.0;
        } else {
            d3 = Math.abs(d4) > Math.abs(d5) ? (d2 - d6) / Math.abs(d4) : (d6 - d) / Math.abs(d5);
        }
        int n3 = 0;
        while (n3 < this.nz) {
            dArray = (double[])this.data[n3];
            int n4 = 0;
            while (n4 < this.nxy) {
                dArray[n4] = d3 * (dArray[n4] - d5) + d6;
                ++n4;
            }
            ++n3;
        }
    }

    public void abs() {
        double d = 0.0;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                if (dArray[n2] < d) {
                    dArray[n2] = -dArray[n2];
                }
                ++n2;
            }
            ++n;
        }
    }

    public void log() {
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = Math.log(dArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void exp() {
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = Math.exp(dArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void sqrt() {
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = Math.sqrt(dArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public void sqr() {
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2;
                dArray[n3] = dArray[n3] * dArray[n2];
                ++n2;
            }
            ++n;
        }
    }

    public void pow(double d) {
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = Math.pow(dArray[n2], d);
                ++n2;
            }
            ++n;
        }
    }

    public void add(double d) {
        double d2 = d;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] + d2;
            }
            ++n;
        }
    }

    public void multiply(double d) {
        double d2 = d;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] * d2;
            }
            ++n;
        }
    }

    public void subtract(double d) {
        double d2 = d;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] - d2;
            }
            ++n;
        }
    }

    public void divide(double d) {
        if (d == 0.0) {
            throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to divide because the constant is 0.\n-------------------------------------------------------\n");
        }
        double d2 = d;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] / d2;
            }
            ++n;
        }
    }

    public void threshold(double d) {
        this.threshold(d, 0.0, 255.0);
    }

    public void threshold(double d, double d2, double d3) {
        double d4 = d2;
        double d5 = d3;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                dArray[n2] = dArray[n2] > d ? d5 : d4;
                ++n2;
            }
            ++n;
        }
    }

    public void thresholdSoft(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                double d3 = dArray[n2];
                dArray[n2] = d3 <= -d ? d3 + d : (d3 > d ? d3 - d : d2);
                ++n2;
            }
            ++n;
        }
    }

    public void thresholdHard(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.nz) {
            double[] dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                double d3 = dArray[n2];
                if (d3 > -d && d3 < d) {
                    dArray[n2] = d2;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void addGaussianNoise(double d) {
        Random random = new Random();
        double[] dArray = null;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] + random.nextGaussian() * d;
            }
            ++n;
        }
    }

    public void addUniformNoise(double d) {
        Random random = new Random();
        double[] dArray = null;
        d *= 2.0;
        int n = 0;
        while (n < this.nz) {
            dArray = (double[])this.data[n];
            int n2 = 0;
            while (n2 < this.nxy) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] + (random.nextDouble() - 0.5) * d;
            }
            ++n;
        }
    }

    public void addSaltPepper(double d, double d2, double d3, double d4) {
        int n;
        int n2;
        int n3;
        double d5;
        Random random = new Random();
        Object var10_6 = null;
        if (d3 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d3;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                double[] dArray = (double[])this.data[n];
                int n4 = n2;
                dArray[n4] = dArray[n4] + random.nextDouble() * d;
                ++n3;
            }
        }
        if (d4 > 0.0) {
            d5 = (double)(this.nxy * this.nz) / d4;
            n3 = 0;
            while ((double)n3 < d5) {
                n2 = (int)(random.nextDouble() * (double)this.nxy);
                n = (int)(random.nextDouble() * (double)this.nz);
                double[] dArray = (double[])this.data[n];
                int n5 = n2;
                dArray[n5] = dArray[n5] - random.nextDouble() * d;
                ++n3;
            }
        }
    }
}

