/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import imageware.Builder;
import imageware.DoubleSet;
import imageware.ImageWare;
import java.awt.Point;

public class ImageAccess {
    public static final int PATTERN_SQUARE_3x3 = 0;
    public static final int PATTERN_CROSS_3x3 = 1;
    private ImageWare imageware = null;
    private int nx = 0;
    private int ny = 0;

    public ImageAccess(double[][] dArray) {
        if (dArray == null) {
            throw new ArrayStoreException("Constructor: array == null.");
        }
        this.imageware = Builder.create(dArray);
        this.nx = this.imageware.getSizeX();
        this.ny = this.imageware.getSizeY();
    }

    public ImageAccess(ImageProcessor imageProcessor) {
        if (imageProcessor == null) {
            throw new ArrayStoreException("Constructor: ImageProcessor == null.");
        }
        ImagePlus imagePlus = new ImagePlus("", imageProcessor);
        if (imageProcessor instanceof ByteProcessor) {
            this.imageware = Builder.create(imagePlus, 4);
        } else if (imageProcessor instanceof ShortProcessor) {
            this.imageware = Builder.create(imagePlus, 4);
        } else if (imageProcessor instanceof FloatProcessor) {
            this.imageware = Builder.create(imagePlus, 4);
        }
        this.nx = this.imageware.getSizeX();
        this.ny = this.imageware.getSizeY();
    }

    public ImageAccess(ColorProcessor colorProcessor, int n) {
        if (colorProcessor == null) {
            throw new ArrayStoreException("Constructor: ColorProcessor == null.");
        }
        if (n < 0) {
            throw new ArrayStoreException("Constructor: colorPlane < 0.");
        }
        if (n > 2) {
            throw new ArrayStoreException("Constructor: colorPlane > 2.");
        }
        this.nx = colorProcessor.getWidth();
        this.ny = colorProcessor.getHeight();
        int n2 = this.nx * this.ny;
        ImagePlus imagePlus = new ImagePlus("", (ImageProcessor)colorProcessor);
        this.imageware = new DoubleSet(imagePlus.getStack(), (byte)n);
    }

    public ImageAccess(int n, int n2) {
        this.imageware = new DoubleSet(n, n2, 1);
        this.nx = n;
        this.ny = n2;
    }

    public ImageWare getDataset() {
        return this.imageware;
    }

    public int getWidth() {
        return this.nx;
    }

    public int getHeight() {
        return this.ny;
    }

    public double getMaximum() {
        return this.imageware.getMaximum();
    }

    public double getMinimum() {
        return this.imageware.getMinimum();
    }

    public double getMean() {
        return this.imageware.getMean();
    }

    public double[][] getArrayPixels() {
        double[][] dArray = new double[this.nx][this.ny];
        this.imageware.getXY(0, 0, 0, dArray);
        return dArray;
    }

    public double[] getPixels() {
        return this.imageware.getSliceDouble(0);
    }

    public FloatProcessor createFloatProcessor() {
        FloatProcessor floatProcessor = new FloatProcessor(this.nx, this.ny);
        double[] dArray = this.getPixels();
        int n = dArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)dArray[n2];
            ++n2;
        }
        floatProcessor.setPixels((Object)fArray);
        return floatProcessor;
    }

    public ByteProcessor createByteProcessor() {
        ByteProcessor byteProcessor = new ByteProcessor(this.nx, this.ny);
        double[] dArray = this.getPixels();
        int n = dArray.length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 255.0) {
                d = 255.0;
            }
            byArray[n2] = (byte)d;
            ++n2;
        }
        byteProcessor.setPixels((Object)byArray);
        return byteProcessor;
    }

    public ImageAccess duplicate() {
        double[][] dArray = new double[this.nx][this.ny];
        this.imageware.getXY(0, 0, 0, dArray);
        ImageAccess imageAccess = new ImageAccess(dArray);
        return imageAccess;
    }

    public double getPixel(int n, int n2) {
        return this.imageware.getPixel(n, n2, 0, (byte)2);
    }

    public double getInterpolatedPixel(double d, double d2) {
        return this.imageware.getInterpolatedPixel(d, d2, 0.0, (byte)2);
    }

    public void getColumn(int n, double[] dArray) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("getColumn: x < 0.");
        }
        if (n >= this.nx) {
            throw new IndexOutOfBoundsException("getColumn: x >= nx.");
        }
        if (dArray == null) {
            throw new ArrayStoreException("getColumn: column == null.");
        }
        if (dArray.length != this.ny) {
            throw new ArrayStoreException("getColumn: column.length != ny.");
        }
        this.imageware.getBlockY(n, 0, 0, dArray, (byte)2);
    }

    public void getColumn(int n, int n2, double[] dArray) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("getColumn: x < 0.");
        }
        if (n >= this.nx) {
            throw new IndexOutOfBoundsException("getColumn: x >= nx.");
        }
        if (dArray == null) {
            throw new ArrayStoreException("getColumn: column == null.");
        }
        this.imageware.getBlockY(n, n2, 0, dArray, (byte)2);
    }

    public void getRow(int n, double[] dArray) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("getRow: y < 0.");
        }
        if (n >= this.ny) {
            throw new IndexOutOfBoundsException("getRow: y >= ny.");
        }
        if (dArray == null) {
            throw new ArrayStoreException("getColumn: row == null.");
        }
        if (dArray.length != this.nx) {
            throw new ArrayStoreException("getColumn: row.length != nx.");
        }
        this.imageware.getBlockX(0, n, 0, dArray, (byte)2);
    }

    public void getRow(int n, int n2, double[] dArray) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("getRow: y < 0.");
        }
        if (n2 >= this.ny) {
            throw new IndexOutOfBoundsException("getRow: y >= ny.");
        }
        if (dArray == null) {
            throw new ArrayStoreException("getRow: row == null.");
        }
        this.imageware.getBlockX(n, n2, 0, dArray, (byte)2);
    }

    public void getNeighborhood(int n, int n2, double[][] dArray) {
        this.imageware.getNeighborhoodXY(n, n2, 0, dArray, (byte)2);
    }

    public void getPattern(int n, int n2, double[] dArray, int n3) {
        if (dArray == null) {
            throw new ArrayStoreException("getPattern: neigh == null.");
        }
        double[][] dArray2 = new double[3][3];
        this.imageware.getNeighborhoodXY(n, n2, 0, dArray2, (byte)2);
        switch (n3) {
            case 0: {
                if (dArray.length != 9) {
                    throw new ArrayStoreException("getPattern: neigh.length != 9.");
                }
                dArray[0] = dArray2[0][0];
                dArray[1] = dArray2[1][0];
                dArray[2] = dArray2[2][0];
                dArray[3] = dArray2[0][1];
                dArray[4] = dArray2[1][1];
                dArray[5] = dArray2[2][1];
                dArray[6] = dArray2[0][2];
                dArray[7] = dArray2[1][2];
                dArray[8] = dArray2[2][2];
                break;
            }
            case 1: {
                if (dArray.length != 5) {
                    throw new ArrayStoreException("getPattern: neigh.length != 5");
                }
                dArray[0] = dArray2[1][0];
                dArray[1] = dArray2[0][1];
                dArray[2] = dArray2[1][1];
                dArray[3] = dArray2[2][1];
                dArray[4] = dArray2[0][1];
                break;
            }
            default: {
                throw new ArrayStoreException("getPattern: unexpected pattern.");
            }
        }
    }

    public void getSubImage(int n, int n2, ImageAccess imageAccess) {
        if (imageAccess == null) {
            throw new ArrayStoreException("getSubImage: output == null.");
        }
        if (n < 0) {
            throw new ArrayStoreException("getSubImage: Incompatible image size");
        }
        if (n2 < 0) {
            throw new ArrayStoreException("getSubImage: Incompatible image size");
        }
        if (n >= this.nx) {
            throw new ArrayStoreException("getSubImage: Incompatible image size");
        }
        if (n2 >= this.ny) {
            throw new ArrayStoreException("getSubImage: Incompatible image size");
        }
        int n3 = imageAccess.getWidth();
        int n4 = imageAccess.getHeight();
        double[][] dArray = new double[n3][n4];
        this.imageware.getBlockXY(n, n2, 0, dArray, (byte)2);
        imageAccess.putArrayPixels(dArray);
    }

    public void putPixel(int n, int n2, double d) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("putPixel: x < 0");
        }
        if (n >= this.nx) {
            throw new IndexOutOfBoundsException("putPixel: x >= nx");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("putPixel:  y < 0");
        }
        if (n2 >= this.ny) {
            throw new IndexOutOfBoundsException("putPixel:  y >= ny");
        }
        this.imageware.putPixel(n, n2, 0, d);
    }

    public void putColumn(int n, double[] dArray) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("putColumn: x < 0.");
        }
        if (n >= this.nx) {
            throw new IndexOutOfBoundsException("putColumn: x >= nx.");
        }
        if (dArray == null) {
            throw new ArrayStoreException("putColumn: column == null.");
        }
        if (dArray.length != this.ny) {
            throw new ArrayStoreException("putColumn: column.length != ny.");
        }
        this.imageware.putBoundedY(n, 0, 0, dArray);
    }

    public void putColumn(int n, int n2, double[] dArray) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("putColumn: x < 0.");
        }
        if (n >= this.nx) {
            throw new IndexOutOfBoundsException("putColumn: x >= nx.");
        }
        if (dArray == null) {
            throw new ArrayStoreException("putColumn: column == null.");
        }
        this.imageware.putBoundedY(n, n2, 0, dArray);
    }

    public void putRow(int n, double[] dArray) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("putRow: y < 0.");
        }
        if (n >= this.ny) {
            throw new IndexOutOfBoundsException("putRow: y >= ny.");
        }
        if (dArray == null) {
            throw new ArrayStoreException("putRow: row == null.");
        }
        if (dArray.length != this.nx) {
            throw new ArrayStoreException("putRow: row.length != nx.");
        }
        this.imageware.putBoundedX(0, n, 0, dArray);
    }

    public void putRow(int n, int n2, double[] dArray) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("putRow: y < 0.");
        }
        if (n2 >= this.ny) {
            throw new IndexOutOfBoundsException("putRow: y >= ny.");
        }
        if (dArray == null) {
            throw new ArrayStoreException("putRow: row == null.");
        }
        this.imageware.putBoundedX(n, n2, 0, dArray);
    }

    public void putArrayPixels(double[][] dArray) {
        if (dArray == null) {
            throw new IndexOutOfBoundsException("putArrayPixels: array == null.");
        }
        this.imageware.putBoundedXY(0, 0, 0, dArray);
    }

    public void putSubImage(int n, int n2, ImageAccess imageAccess) {
        if (imageAccess == null) {
            throw new ArrayStoreException("putSubImage: input == null.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("putSubImage: x < 0.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("putSubImage: y < 0.");
        }
        if (n >= this.nx) {
            throw new IndexOutOfBoundsException("putSubImage: x >= nx.");
        }
        if (n2 >= this.ny) {
            throw new IndexOutOfBoundsException("putSubImage: y >= ny.");
        }
        int n3 = imageAccess.getWidth();
        int n4 = imageAccess.getHeight();
        double[][] dArray = imageAccess.getArrayPixels();
        this.imageware.putBoundedXY(n, n2, 0, dArray);
    }

    public void setConstant(double d) {
        this.imageware.fillConstant(d);
    }

    public void normalizeContrast() {
        this.imageware.rescale();
    }

    public void show(String string, Point point) {
        FloatProcessor floatProcessor = this.createFloatProcessor();
        floatProcessor.resetMinAndMax();
        ImagePlus imagePlus = new ImagePlus(string, (ImageProcessor)floatProcessor);
        ImageWindow imageWindow = imagePlus.getWindow();
        imageWindow.setLocation(point.x, point.y);
        imagePlus.show();
    }

    public void show(String string) {
        this.imageware.show(string);
    }

    public void abs() {
        this.imageware.abs();
    }

    public void sqrt() {
        this.imageware.sqrt();
    }

    public void pow(double d) {
        this.imageware.pow(d);
    }

    public void add(double d) {
        this.imageware.add(d);
    }

    public void multiply(double d) {
        this.imageware.multiply(d);
    }

    public void subtract(double d) {
        this.imageware.add(-d);
    }

    public void divide(double d) {
        if (d == 0.0) {
            throw new ArrayStoreException("divide: Divide by 0");
        }
        this.imageware.multiply(1.0 / d);
    }

    public void add(ImageAccess imageAccess, ImageAccess imageAccess2) {
        if (imageAccess.getWidth() != this.nx) {
            throw new ArrayStoreException("add: incompatible size.");
        }
        if (imageAccess.getHeight() != this.ny) {
            throw new ArrayStoreException("add: incompatible size.");
        }
        if (imageAccess2.getWidth() != this.nx) {
            throw new ArrayStoreException("add: incompatible size.");
        }
        if (imageAccess2.getHeight() != this.ny) {
            throw new ArrayStoreException("add: incompatible size.");
        }
        this.imageware.copy(imageAccess.getDataset());
        this.imageware.add(imageAccess2.getDataset());
    }

    public void multiply(ImageAccess imageAccess, ImageAccess imageAccess2) {
        if (imageAccess.getWidth() != this.nx) {
            throw new ArrayStoreException("multiply: incompatible size.");
        }
        if (imageAccess.getHeight() != this.ny) {
            throw new ArrayStoreException("multiply: incompatible size.");
        }
        if (imageAccess2.getWidth() != this.nx) {
            throw new ArrayStoreException("multiply: incompatible size.");
        }
        if (imageAccess2.getHeight() != this.ny) {
            throw new ArrayStoreException("multiply: incompatible size.");
        }
        this.imageware.copy(imageAccess.getDataset());
        this.imageware.multiply(imageAccess2.getDataset());
    }

    public void subtract(ImageAccess imageAccess, ImageAccess imageAccess2) {
        if (imageAccess.getWidth() != this.nx) {
            throw new ArrayStoreException("subtract: incompatible size.");
        }
        if (imageAccess.getHeight() != this.ny) {
            throw new ArrayStoreException("subtract: incompatible size.");
        }
        if (imageAccess2.getWidth() != this.nx) {
            throw new ArrayStoreException("subtract: incompatible size.");
        }
        if (imageAccess2.getHeight() != this.ny) {
            throw new ArrayStoreException("subtract: incompatible size.");
        }
        this.imageware.copy(imageAccess.getDataset());
        this.imageware.subtract(imageAccess2.getDataset());
    }

    public void divide(ImageAccess imageAccess, ImageAccess imageAccess2) {
        if (imageAccess.getWidth() != this.nx) {
            throw new ArrayStoreException("divide: incompatible size.");
        }
        if (imageAccess.getHeight() != this.ny) {
            throw new ArrayStoreException("divide: incompatible size.");
        }
        if (imageAccess2.getWidth() != this.nx) {
            throw new ArrayStoreException("divide: incompatible size.");
        }
        if (imageAccess2.getHeight() != this.ny) {
            throw new ArrayStoreException("divide: incompatible size.");
        }
        this.imageware.copy(imageAccess.getDataset());
        this.imageware.divide(imageAccess2.getDataset());
    }
}

