/*
 * Decompiled with CFR 0.152.
 */
package imageware;

import ij.ImageStack;
import imageware.Access;
import imageware.ShortBuffer;
import java.awt.Image;

public class ShortAccess
extends ShortBuffer
implements Access {
    protected ShortAccess(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected ShortAccess(Image image, int n) {
        super(image, n);
    }

    protected ShortAccess(ImageStack imageStack, int n) {
        super(imageStack, n);
    }

    protected ShortAccess(ImageStack imageStack, byte by) {
        super(imageStack, by);
    }

    protected ShortAccess(byte[] byArray, int n) {
        super(byArray, n);
    }

    protected ShortAccess(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected ShortAccess(byte[][][] byArray, int n) {
        super(byArray, n);
    }

    protected ShortAccess(short[] sArray, int n) {
        super(sArray, n);
    }

    protected ShortAccess(short[][] sArray, int n) {
        super(sArray, n);
    }

    protected ShortAccess(short[][][] sArray, int n) {
        super(sArray, n);
    }

    protected ShortAccess(float[] fArray, int n) {
        super(fArray, n);
    }

    protected ShortAccess(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected ShortAccess(float[][][] fArray, int n) {
        super(fArray, n);
    }

    protected ShortAccess(double[] dArray, int n) {
        super(dArray, n);
    }

    protected ShortAccess(double[][] dArray, int n) {
        super(dArray, n);
    }

    protected ShortAccess(double[][][] dArray, int n) {
        super(dArray, n);
    }

    public double getPixel(int n, int n2, int n3) {
        if (n >= this.nx) {
            return 0.0;
        }
        if (n2 >= this.ny) {
            return 0.0;
        }
        if (n3 >= this.nz) {
            return 0.0;
        }
        if (n < 0) {
            return 0.0;
        }
        if (n2 < 0) {
            return 0.0;
        }
        if (n3 < 0) {
            return 0.0;
        }
        return ((short[])this.data[n3])[n + n2 * this.nx] & 0xFFFF;
    }

    public double getPixel(int n, int n2, int n3, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                throw new ArrayStoreException("\n-------------------------------------------------------\nError in imageware package\nUnable to put a pixel \nat the position (" + n + "," + n2 + "," + n3 + ".\n" + "-------------------------------------------------------\n");
            }
        }
        int n7 = n;
        while (n7 < 0) {
            n7 += n4;
        }
        while (n7 >= this.nx) {
            int n8 = n7 = (n7 = n4 - n7) < 0 ? -n7 : n7;
        }
        int n9 = n2;
        while (n9 < 0) {
            n9 += n5;
        }
        while (n9 >= this.ny) {
            int n10 = n9 = (n9 = n5 - n9) < 0 ? -n9 : n9;
        }
        int n11 = n3;
        while (n11 < 0) {
            n11 += n6;
        }
        while (n11 >= this.nz) {
            int n12 = n11 = (n11 = n6 - n11) < 0 ? -n11 : n11;
        }
        return ((short[])this.data[n11])[n7 + n9 * this.nx] & 0xFFFF;
    }

    public double getInterpolatedPixel(double d, double d2, double d3) {
        if (d >= (double)this.nx) {
            return 0.0;
        }
        if (d2 >= (double)this.ny) {
            return 0.0;
        }
        if (d3 >= (double)this.nz) {
            return 0.0;
        }
        if (d < 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d3 < 0.0) {
            return 0.0;
        }
        double d4 = 0.0;
        int n = d >= 0.0 ? (int)d : (int)d - 1;
        int n2 = d2 >= 0.0 ? (int)d2 : (int)d2 - 1;
        int n3 = d3 >= 0.0 ? (int)d3 : (int)d3 - 1;
        switch (this.getDimension()) {
            case 1: {
                double d5 = ((short[])this.data[n3])[n + n2 * this.nx] & 0xFFFF;
                double d6 = ((short[])this.data[n3])[n + 1 + n2 * this.nx] & 0xFFFF;
                double d7 = d - (double)n;
                return d6 * d7 - d5 * (d7 - 1.0);
            }
            case 2: {
                double d8 = ((short[])this.data[n3])[n + n2 * this.nx] & 0xFFFF;
                double d9 = ((short[])this.data[n3])[n + 1 + n2 * this.nx] & 0xFFFF;
                double d10 = ((short[])this.data[n3])[n + n2 * this.nx + this.nx] & 0xFFFF;
                double d11 = ((short[])this.data[n3])[n + 1 + n2 * this.nx + this.nx] & 0xFFFF;
                double d12 = d - (double)n;
                double d13 = d2 - (double)n2;
                return d12 * (d11 * d13 - d9 * (d13 - 1.0)) - (d12 - 1.0) * (d10 * d13 - d8 * (d13 - 1.0));
            }
            case 3: {
                double d14 = ((short[])this.data[n3])[n + n2 * this.nx] & 0xFFFF;
                double d15 = ((short[])this.data[n3])[n + 1 + n2 * this.nx] & 0xFFFF;
                double d16 = ((short[])this.data[n3])[n + n2 * this.nx + this.nx] & 0xFFFF;
                double d17 = ((short[])this.data[n3])[n + 1 + n2 * this.nx + this.nx] & 0xFFFF;
                double d18 = ((short[])this.data[n3 + 1])[n + n2 * this.nx] & 0xFFFF;
                double d19 = ((short[])this.data[n3 + 1])[n + 1 + n2 * this.nx] & 0xFFFF;
                double d20 = ((short[])this.data[n3 + 1])[n + n2 * this.nx + this.nx] & 0xFFFF;
                double d21 = ((short[])this.data[n3 + 1])[n + 1 + n2 * this.nx + this.nx] & 0xFFFF;
                double d22 = d - (double)n;
                double d23 = d2 - (double)n2;
                double d24 = d3 - (double)n3;
                double d25 = d22 * (d17 * d23 - d15 * (d23 - 1.0)) - (d22 - 1.0) * (d16 * d23 - d14 * (d23 - 1.0));
                double d26 = d22 * (d21 * d23 - d20 * (d23 - 1.0)) - (d22 - 1.0) * (d19 * d23 - d18 * (d23 - 1.0));
                return d26 * d24 - d25 * (d24 - 1.0);
            }
        }
        return d4;
    }

    public double getInterpolatedPixel(double d, double d2, double d3, byte by) {
        double d4 = 0.0;
        int n = d >= 0.0 ? (int)d : (int)d - 1;
        int n2 = d2 >= 0.0 ? (int)d2 : (int)d2 - 1;
        int n3 = d3 >= 0.0 ? (int)d3 : (int)d3 - 1;
        switch (this.getDimension()) {
            case 1: {
                double d5 = this.getPixel(n, n2, n3, by);
                double d6 = this.getPixel(n + 1, n2, n3, by);
                double d7 = d - (double)n;
            }
            case 2: {
                double d8 = this.getPixel(n, n2, n3, by);
                double d9 = this.getPixel(n + 1, n2, n3, by);
                double d10 = this.getPixel(n, n2 + 1, n3, by);
                double d11 = this.getPixel(n + 1, n2 + 1, n3, by);
                double d12 = d - (double)n;
                double d13 = d2 - (double)n2;
                return d12 * (d11 * d13 - d9 * (d13 - 1.0)) - (d12 - 1.0) * (d10 * d13 - d8 * (d13 - 1.0));
            }
            case 3: {
                double d14 = this.getPixel(n, n2, n3, by);
                double d15 = this.getPixel(n + 1, n2, n3, by);
                double d16 = this.getPixel(n, n2 + 1, n3, by);
                double d17 = this.getPixel(n + 1, n2 + 1, n3, by);
                double d18 = this.getPixel(n, n2, n3 + 1, by);
                double d19 = this.getPixel(n + 1, n2, n3 + 1, by);
                double d20 = this.getPixel(n, n2 + 1, n3 + 1, by);
                double d21 = this.getPixel(n + 1, n2 + 1, n3 + 1, by);
                double d22 = d - (double)n;
                double d23 = d2 - (double)n2;
                double d24 = d3 - (double)n3;
                double d25 = d22 * (d17 * d23 - d15 * (d23 - 1.0)) - (d22 - 1.0) * (d16 * d23 - d14 * (d23 - 1.0));
                double d26 = d22 * (d21 * d23 - d20 * (d23 - 1.0)) - (d22 - 1.0) * (d19 * d23 - d18 * (d23 - 1.0));
                return d26 * d24 - d25 * (d24 - 1.0);
            }
        }
        return d4;
    }

    public void putPixel(int n, int n2, int n3, double d) {
        if (n >= this.nx) {
            return;
        }
        if (n2 >= this.ny) {
            return;
        }
        if (n3 >= this.nz) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        ((short[])this.data[n3])[n + n2 * this.nx] = (short)d;
    }

    public void getBoundedX(int n, int n2, int n3, byte[] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n + n4 + n2 * this.nx;
            int n6 = n3;
            int n7 = byArray.length;
            if (n + n7 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n + n7 >= this.nx ? this.nx - n : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                byArray[n9] = (byte)(sArray[n5] & 0xFFFF);
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void getBoundedX(int n, int n2, int n3, short[] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n + n4 + n2 * this.nx;
            int n6 = n3;
            int n7 = sArray.length;
            if (n + n7 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n + n7 >= this.nx ? this.nx - n : n7;
            short[] sArray2 = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray[n9] = (short)(sArray2[n5] & 0xFFFF);
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void getBoundedX(int n, int n2, int n3, float[] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n + n4 + n2 * this.nx;
            int n6 = n3;
            int n7 = fArray.length;
            if (n + n7 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n + n7 >= this.nx ? this.nx - n : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                fArray[n9] = sArray[n5] & 0xFFFF;
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void getBoundedX(int n, int n2, int n3, double[] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n + n4 + n2 * this.nx;
            int n6 = n3;
            int n7 = dArray.length;
            if (n + n7 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n + n7 >= this.nx ? this.nx - n : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                dArray[n9] = sArray[n5] & 0xFFFF;
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void getBoundedY(int n, int n2, int n3, byte[] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n + (n2 + n4) * this.nx;
            int n6 = n3;
            int n7 = byArray.length;
            if (n < 0) {
                return;
            }
            if (n2 + n7 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n2 + n7 >= this.ny ? this.ny - n2 : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                byArray[n9] = (byte)(sArray[n5] & 0xFFFF);
                n5 += this.nx;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void getBoundedY(int n, int n2, int n3, short[] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n + (n2 + n4) * this.nx;
            int n6 = n3;
            int n7 = sArray.length;
            if (n < 0) {
                return;
            }
            if (n2 + n7 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n2 + n7 >= this.ny ? this.ny - n2 : n7;
            short[] sArray2 = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray[n9] = (short)(sArray2[n5] & 0xFFFF);
                n5 += this.nx;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void getBoundedY(int n, int n2, int n3, float[] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n + (n2 + n4) * this.nx;
            int n6 = n3;
            int n7 = fArray.length;
            if (n < 0) {
                return;
            }
            if (n2 + n7 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n2 + n7 >= this.ny ? this.ny - n2 : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                fArray[n9] = sArray[n5] & 0xFFFF;
                n5 += this.nx;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void getBoundedY(int n, int n2, int n3, double[] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n + (n2 + n4) * this.nx;
            int n6 = n3;
            int n7 = dArray.length;
            if (n < 0) {
                return;
            }
            if (n2 + n7 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n2 + n7 >= this.ny ? this.ny - n2 : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                dArray[n9] = sArray[n5] & 0xFFFF;
                n5 += this.nx;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void getBoundedZ(int n, int n2, int n3, byte[] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n3 < 0 ? -n3 : 0;
            int n5 = n3 + n4;
            int n6 = n + n2 * this.nx;
            int n7 = byArray.length;
            if (n < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n7 < 0) {
                return;
            }
            int n8 = n3 + n7 >= this.nz ? this.nz - n3 : n7;
            int n9 = n4;
            while (n9 < n8) {
                byArray[n9] = (byte)(((short[])this.data[n5])[n6] & 0xFFFF);
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void getBoundedZ(int n, int n2, int n3, short[] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n3 < 0 ? -n3 : 0;
            int n5 = n3 + n4;
            int n6 = n + n2 * this.nx;
            int n7 = sArray.length;
            if (n < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n7 < 0) {
                return;
            }
            int n8 = n3 + n7 >= this.nz ? this.nz - n3 : n7;
            int n9 = n4;
            while (n9 < n8) {
                sArray[n9] = (short)(((short[])this.data[n5])[n6] & 0xFFFF);
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void getBoundedZ(int n, int n2, int n3, float[] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n3 < 0 ? -n3 : 0;
            int n5 = n3 + n4;
            int n6 = n + n2 * this.nx;
            int n7 = fArray.length;
            if (n < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n7 < 0) {
                return;
            }
            int n8 = n3 + n7 >= this.nz ? this.nz - n3 : n7;
            int n9 = n4;
            while (n9 < n8) {
                fArray[n9] = ((short[])this.data[n5])[n6] & 0xFFFF;
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void getBoundedZ(int n, int n2, int n3, double[] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n3 < 0 ? -n3 : 0;
            int n5 = n3 + n4;
            int n6 = n + n2 * this.nx;
            int n7 = dArray.length;
            if (n < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n7 < 0) {
                return;
            }
            int n8 = n3 + n7 >= this.nz ? this.nz - n3 : n7;
            int n9 = n4;
            while (n9 < n8) {
                dArray[n9] = ((short[])this.data[n5])[n6] & 0xFFFF;
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void getBoundedXY(int n, int n2, int n3, byte[][] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 + n9 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n2 + n9 >= this.ny ? this.ny - n2 : n9;
            short[] sArray = (short[])this.data[n3];
            int n12 = n5;
            while (n12 < n11) {
                n6 = n + n4 + (n2 + n12) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    byArray[n13][n12] = (byte)(sArray[n6] & 0xFFFF);
                    ++n6;
                    ++n13;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void getBoundedXY(int n, int n2, int n3, short[][] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 + n9 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n2 + n9 >= this.ny ? this.ny - n2 : n9;
            short[] sArray2 = (short[])this.data[n3];
            int n12 = n5;
            while (n12 < n11) {
                n6 = n + n4 + (n2 + n12) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    sArray[n13][n12] = (short)(sArray2[n6] & 0xFFFF);
                    ++n6;
                    ++n13;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void getBoundedXY(int n, int n2, int n3, float[][] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 + n9 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n2 + n9 >= this.ny ? this.ny - n2 : n9;
            short[] sArray = (short[])this.data[n3];
            int n12 = n5;
            while (n12 < n11) {
                n6 = n + n4 + (n2 + n12) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    fArray[n13][n12] = sArray[n6] & 0xFFFF;
                    ++n6;
                    ++n13;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void getBoundedXY(int n, int n2, int n3, double[][] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 + n9 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n2 + n9 >= this.ny ? this.ny - n2 : n9;
            short[] sArray = (short[])this.data[n3];
            int n12 = n5;
            while (n12 < n11) {
                n6 = n + n4 + (n2 + n12) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    dArray[n13][n12] = sArray[n6] & 0xFFFF;
                    ++n6;
                    ++n13;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void getBoundedXZ(int n, int n2, int n3, byte[][] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + n4 + n2 * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    byArray[n13][n12] = (byte)(((short[])this.data[n3])[n7] & 0xFFFF);
                    ++n7;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void getBoundedXZ(int n, int n2, int n3, short[][] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + n4 + n2 * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    sArray[n13][n12] = (short)(((short[])this.data[n3])[n7] & 0xFFFF);
                    ++n7;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void getBoundedXZ(int n, int n2, int n3, float[][] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + n4 + n2 * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    fArray[n13][n12] = ((short[])this.data[n3])[n7] & 0xFFFF;
                    ++n7;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void getBoundedXZ(int n, int n2, int n3, double[][] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + n4 + n2 * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    dArray[n13][n12] = ((short[])this.data[n3])[n7] & 0xFFFF;
                    ++n7;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void getBoundedYZ(int n, int n2, int n3, byte[][] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            if (n < 0) {
                return;
            }
            if (n2 + n8 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n2 + n8 >= this.ny ? this.ny - n2 : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + (n2 + n4) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    byArray[n13][n12] = (byte)(((short[])this.data[n3])[n7] & 0xFFFF);
                    n7 += this.nx;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void getBoundedYZ(int n, int n2, int n3, short[][] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            if (n < 0) {
                return;
            }
            if (n2 + n8 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n2 + n8 >= this.ny ? this.ny - n2 : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + (n2 + n4) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    sArray[n13][n12] = (short)(((short[])this.data[n3])[n7] & 0xFFFF);
                    n7 += this.nx;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void getBoundedYZ(int n, int n2, int n3, float[][] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            if (n < 0) {
                return;
            }
            if (n2 + n8 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n2 + n8 >= this.ny ? this.ny - n2 : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + (n2 + n4) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    fArray[n13][n12] = ((short[])this.data[n3])[n7] & 0xFFFF;
                    n7 += this.nx;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void getBoundedYZ(int n, int n2, int n3, double[][] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            if (n < 0) {
                return;
            }
            if (n2 + n8 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n2 + n8 >= this.ny ? this.ny - n2 : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + (n2 + n4) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    dArray[n13][n12] = ((short[])this.data[n3])[n7] & 0xFFFF;
                    n7 += this.nx;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void getBoundedXYZ(int n, int n2, int n3, byte[][][] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = n3 < 0 ? -n3 : 0;
            int n7 = n3 + n6;
            int n8 = 0;
            int n9 = byArray.length;
            int n10 = byArray[0].length;
            int n11 = byArray[0][0].length;
            if (n + n9 < 0) {
                return;
            }
            if (n2 + n10 < 0) {
                return;
            }
            if (n3 + n11 < 0) {
                return;
            }
            int n12 = n + n9 >= this.nx ? this.nx - n : n9;
            int n13 = n2 + n10 >= this.ny ? this.ny - n2 : n10;
            int n14 = n3 + n11 >= this.nz ? this.nz - n3 : n11;
            int n15 = n6;
            while (n15 < n14) {
                short[] sArray = (short[])this.data[n7];
                int n16 = n5;
                while (n16 < n13) {
                    n8 = n + n4 + (n2 + n16) * this.nx;
                    int n17 = n4;
                    while (n17 < n12) {
                        byArray[n17][n16][n15] = (byte)(sArray[n8] & 0xFFFF);
                        ++n8;
                        ++n17;
                    }
                    ++n16;
                }
                ++n7;
                ++n15;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void getBoundedXYZ(int n, int n2, int n3, short[][][] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = n3 < 0 ? -n3 : 0;
            int n7 = n3 + n6;
            int n8 = 0;
            int n9 = sArray.length;
            int n10 = sArray[0].length;
            int n11 = sArray[0][0].length;
            if (n + n9 < 0) {
                return;
            }
            if (n2 + n10 < 0) {
                return;
            }
            if (n3 + n11 < 0) {
                return;
            }
            int n12 = n + n9 >= this.nx ? this.nx - n : n9;
            int n13 = n2 + n10 >= this.ny ? this.ny - n2 : n10;
            int n14 = n3 + n11 >= this.nz ? this.nz - n3 : n11;
            int n15 = n6;
            while (n15 < n14) {
                short[] sArray2 = (short[])this.data[n7];
                int n16 = n5;
                while (n16 < n13) {
                    n8 = n + n4 + (n2 + n16) * this.nx;
                    int n17 = n4;
                    while (n17 < n12) {
                        sArray[n17][n16][n15] = (short)(sArray2[n8] & 0xFFFF);
                        ++n8;
                        ++n17;
                    }
                    ++n16;
                }
                ++n7;
                ++n15;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void getBoundedXYZ(int n, int n2, int n3, float[][][] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = n3 < 0 ? -n3 : 0;
            int n7 = n3 + n6;
            int n8 = 0;
            int n9 = fArray.length;
            int n10 = fArray[0].length;
            int n11 = fArray[0][0].length;
            if (n + n9 < 0) {
                return;
            }
            if (n2 + n10 < 0) {
                return;
            }
            if (n3 + n11 < 0) {
                return;
            }
            int n12 = n + n9 >= this.nx ? this.nx - n : n9;
            int n13 = n2 + n10 >= this.ny ? this.ny - n2 : n10;
            int n14 = n3 + n11 >= this.nz ? this.nz - n3 : n11;
            int n15 = n6;
            while (n15 < n14) {
                short[] sArray = (short[])this.data[n7];
                int n16 = n5;
                while (n16 < n13) {
                    n8 = n + n4 + (n2 + n16) * this.nx;
                    int n17 = n4;
                    while (n17 < n12) {
                        fArray[n17][n16][n15] = sArray[n8] & 0xFFFF;
                        ++n8;
                        ++n17;
                    }
                    ++n16;
                }
                ++n7;
                ++n15;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void getBoundedXYZ(int n, int n2, int n3, double[][][] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = n3 < 0 ? -n3 : 0;
            int n7 = n3 + n6;
            int n8 = 0;
            int n9 = dArray.length;
            int n10 = dArray[0].length;
            int n11 = dArray[0][0].length;
            if (n + n9 < 0) {
                return;
            }
            if (n2 + n10 < 0) {
                return;
            }
            if (n3 + n11 < 0) {
                return;
            }
            int n12 = n + n9 >= this.nx ? this.nx - n : n9;
            int n13 = n2 + n10 >= this.ny ? this.ny - n2 : n10;
            int n14 = n3 + n11 >= this.nz ? this.nz - n3 : n11;
            int n15 = n6;
            while (n15 < n14) {
                short[] sArray = (short[])this.data[n7];
                int n16 = n5;
                while (n16 < n13) {
                    n8 = n + n4 + (n2 + n16) * this.nx;
                    int n17 = n4;
                    while (n17 < n12) {
                        dArray[n17][n16][n15] = sArray[n8] & 0xFFFF;
                        ++n8;
                        ++n17;
                    }
                    ++n16;
                }
                ++n7;
                ++n15;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void getBlockX(int n, int n2, int n3, byte[] byArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("X", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = byArray.length;
            int n9 = n3;
            while (n9 < 0) {
                n9 += n6;
            }
            while (n9 >= this.nz) {
                int n10 = n9 = (n9 = n6 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n2;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.ny) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            n11 *= this.nx;
            short[] sArray = (short[])this.data[n9];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = n + n13;
                while (n14 < 0) {
                    n14 += n4;
                }
                while (n14 >= this.nx) {
                    int n15 = n14 = (n14 = n4 - n14) < 0 ? -n14 : n14;
                }
                byArray[n13] = (byte)(sArray[n14 + n11] & 0xFFFF);
                ++n13;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getBlockX(int n, int n2, int n3, short[] sArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("X", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = sArray.length;
            int n9 = n3;
            while (n9 < 0) {
                n9 += n6;
            }
            while (n9 >= this.nz) {
                int n10 = n9 = (n9 = n6 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n2;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.ny) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            n11 *= this.nx;
            short[] sArray2 = (short[])this.data[n9];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = n + n13;
                while (n14 < 0) {
                    n14 += n4;
                }
                while (n14 >= this.nx) {
                    int n15 = n14 = (n14 = n4 - n14) < 0 ? -n14 : n14;
                }
                sArray[n13] = (short)(sArray2[n14 + n11] & 0xFFFF);
                ++n13;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getBlockX(int n, int n2, int n3, float[] fArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("X", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = fArray.length;
            int n9 = n3;
            while (n9 < 0) {
                n9 += n6;
            }
            while (n9 >= this.nz) {
                int n10 = n9 = (n9 = n6 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n2;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.ny) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            n11 *= this.nx;
            short[] sArray = (short[])this.data[n9];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = n + n13;
                while (n14 < 0) {
                    n14 += n4;
                }
                while (n14 >= this.nx) {
                    int n15 = n14 = (n14 = n4 - n14) < 0 ? -n14 : n14;
                }
                fArray[n13] = sArray[n14 + n11] & 0xFFFF;
                ++n13;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getBlockX(int n, int n2, int n3, double[] dArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("X", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = dArray.length;
            int n9 = n3;
            while (n9 < 0) {
                n9 += n6;
            }
            while (n9 >= this.nz) {
                int n10 = n9 = (n9 = n6 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n2;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.ny) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            n11 *= this.nx;
            short[] sArray = (short[])this.data[n9];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = n + n13;
                while (n14 < 0) {
                    n14 += n4;
                }
                while (n14 >= this.nx) {
                    int n15 = n14 = (n14 = n4 - n14) < 0 ? -n14 : n14;
                }
                dArray[n13] = sArray[n14 + n11] & 0xFFFF;
                ++n13;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getBlockY(int n, int n2, int n3, byte[] byArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("Y", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = byArray.length;
            int n9 = n3;
            while (n9 < 0) {
                n9 += n6;
            }
            while (n9 >= this.nz) {
                int n10 = n9 = (n9 = n6 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n;
            while (n11 < 0) {
                n11 += n4;
            }
            while (n11 >= this.nx) {
                int n12 = n11 = (n11 = n4 - n11) < 0 ? -n11 : n11;
            }
            short[] sArray = (short[])this.data[n9];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = n2 + n13;
                while (n14 < 0) {
                    n14 += n5;
                }
                while (n14 >= this.ny) {
                    int n15 = n14 = (n14 = n5 - n14) < 0 ? -n14 : n14;
                }
                byArray[n13] = (byte)(sArray[n11 + n14 * this.nx] & 0xFFFF);
                ++n13;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getBlockY(int n, int n2, int n3, short[] sArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("Y", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = sArray.length;
            int n9 = n3;
            while (n9 < 0) {
                n9 += n6;
            }
            while (n9 >= this.nz) {
                int n10 = n9 = (n9 = n6 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n;
            while (n11 < 0) {
                n11 += n4;
            }
            while (n11 >= this.nx) {
                int n12 = n11 = (n11 = n4 - n11) < 0 ? -n11 : n11;
            }
            short[] sArray2 = (short[])this.data[n9];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = n2 + n13;
                while (n14 < 0) {
                    n14 += n5;
                }
                while (n14 >= this.ny) {
                    int n15 = n14 = (n14 = n5 - n14) < 0 ? -n14 : n14;
                }
                sArray[n13] = (short)(sArray2[n11 + n14 * this.nx] & 0xFFFF);
                ++n13;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getBlockY(int n, int n2, int n3, float[] fArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("Y", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = fArray.length;
            int n9 = n3;
            while (n9 < 0) {
                n9 += n6;
            }
            while (n9 >= this.nz) {
                int n10 = n9 = (n9 = n6 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n;
            while (n11 < 0) {
                n11 += n4;
            }
            while (n11 >= this.nx) {
                int n12 = n11 = (n11 = n4 - n11) < 0 ? -n11 : n11;
            }
            short[] sArray = (short[])this.data[n9];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = n2 + n13;
                while (n14 < 0) {
                    n14 += n5;
                }
                while (n14 >= this.ny) {
                    int n15 = n14 = (n14 = n5 - n14) < 0 ? -n14 : n14;
                }
                fArray[n13] = sArray[n11 + n14 * this.nx] & 0xFFFF;
                ++n13;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getBlockY(int n, int n2, int n3, double[] dArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("Y", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = dArray.length;
            int n9 = n3;
            while (n9 < 0) {
                n9 += n6;
            }
            while (n9 >= this.nz) {
                int n10 = n9 = (n9 = n6 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n;
            while (n11 < 0) {
                n11 += n4;
            }
            while (n11 >= this.nx) {
                int n12 = n11 = (n11 = n4 - n11) < 0 ? -n11 : n11;
            }
            short[] sArray = (short[])this.data[n9];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = n2 + n13;
                while (n14 < 0) {
                    n14 += n5;
                }
                while (n14 >= this.ny) {
                    int n15 = n14 = (n14 = n5 - n14) < 0 ? -n14 : n14;
                }
                dArray[n13] = sArray[n11 + n14 * this.nx] & 0xFFFF;
                ++n13;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getBlockZ(int n, int n2, int n3, byte[] byArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("Z", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = byArray.length;
            int n9 = n;
            while (n9 < 0) {
                n9 += n4;
            }
            while (n9 >= this.nx) {
                int n10 = n9 = (n9 = n4 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n2;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.ny) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n9 + n11 * this.nx;
            int n14 = 0;
            while (n14 < n8) {
                int n15 = n3 + n14;
                while (n15 < 0) {
                    n15 += n6;
                }
                while (n15 >= this.nz) {
                    int n16 = n15 = (n15 = n6 - n15) < 0 ? -n15 : n15;
                }
                byArray[n14] = (byte)(((short[])this.data[n15])[n13] & 0xFFFF);
                ++n14;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getBlockZ(int n, int n2, int n3, short[] sArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("Z", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = sArray.length;
            int n9 = n;
            while (n9 < 0) {
                n9 += n4;
            }
            while (n9 >= this.nx) {
                int n10 = n9 = (n9 = n4 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n2;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.ny) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n9 + n11 * this.nx;
            int n14 = 0;
            while (n14 < n8) {
                int n15 = n3 + n14;
                while (n15 < 0) {
                    n15 += n6;
                }
                while (n15 >= this.nz) {
                    int n16 = n15 = (n15 = n6 - n15) < 0 ? -n15 : n15;
                }
                sArray[n14] = (short)(((short[])this.data[n15])[n13] & 0xFFFF);
                ++n14;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getBlockZ(int n, int n2, int n3, float[] fArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("Z", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = fArray.length;
            int n9 = n;
            while (n9 < 0) {
                n9 += n4;
            }
            while (n9 >= this.nx) {
                int n10 = n9 = (n9 = n4 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n2;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.ny) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n9 + n11 * this.nx;
            int n14 = 0;
            while (n14 < n8) {
                int n15 = n3 + n14;
                while (n15 < 0) {
                    n15 += n6;
                }
                while (n15 >= this.nz) {
                    int n16 = n15 = (n15 = n6 - n15) < 0 ? -n15 : n15;
                }
                fArray[n14] = ((short[])this.data[n15])[n13] & 0xFFFF;
                ++n14;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getBlockZ(int n, int n2, int n3, double[] dArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("Z", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = dArray.length;
            int n9 = n;
            while (n9 < 0) {
                n9 += n4;
            }
            while (n9 >= this.nx) {
                int n10 = n9 = (n9 = n4 - n9) < 0 ? -n9 : n9;
            }
            int n11 = n2;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.ny) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n9 + n11 * this.nx;
            int n14 = 0;
            while (n14 < n8) {
                int n15 = n3 + n14;
                while (n15 < 0) {
                    n15 += n6;
                }
                while (n15 >= this.nz) {
                    int n16 = n15 = (n15 = n6 - n15) < 0 ? -n15 : n15;
                }
                dArray[n14] = ((short[])this.data[n15])[n13] & 0xFFFF;
                ++n14;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getBlockXY(int n, int n2, int n3, byte[][] byArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XY", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            int n10 = n3;
            while (n10 < 0) {
                n10 += n6;
            }
            while (n10 >= this.nz) {
                int n11 = n10 = (n10 = n6 - n10) < 0 ? -n10 : n10;
            }
            short[] sArray = (short[])this.data[n10];
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n2 + n12;
                while (n13 < 0) {
                    n13 += n5;
                }
                while (n13 >= this.ny) {
                    int n14 = n13 = (n13 = n5 - n13) < 0 ? -n13 : n13;
                }
                n13 *= this.nx;
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n + n15;
                    while (n16 < 0) {
                        n16 += n4;
                    }
                    while (n16 >= this.nx) {
                        int n17 = n16 = (n16 = n4 - n16) < 0 ? -n16 : n16;
                    }
                    byArray[n15][n12] = (byte)(sArray[n16 + n13] & 0xFFFF);
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getBlockXY(int n, int n2, int n3, short[][] sArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XY", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            int n10 = n3;
            while (n10 < 0) {
                n10 += n6;
            }
            while (n10 >= this.nz) {
                int n11 = n10 = (n10 = n6 - n10) < 0 ? -n10 : n10;
            }
            short[] sArray2 = (short[])this.data[n10];
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n2 + n12;
                while (n13 < 0) {
                    n13 += n5;
                }
                while (n13 >= this.ny) {
                    int n14 = n13 = (n13 = n5 - n13) < 0 ? -n13 : n13;
                }
                n13 *= this.nx;
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n + n15;
                    while (n16 < 0) {
                        n16 += n4;
                    }
                    while (n16 >= this.nx) {
                        int n17 = n16 = (n16 = n4 - n16) < 0 ? -n16 : n16;
                    }
                    sArray[n15][n12] = (short)(sArray2[n16 + n13] & 0xFFFF);
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getBlockXY(int n, int n2, int n3, float[][] fArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XY", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            int n10 = n3;
            while (n10 < 0) {
                n10 += n6;
            }
            while (n10 >= this.nz) {
                int n11 = n10 = (n10 = n6 - n10) < 0 ? -n10 : n10;
            }
            short[] sArray = (short[])this.data[n10];
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n2 + n12;
                while (n13 < 0) {
                    n13 += n5;
                }
                while (n13 >= this.ny) {
                    int n14 = n13 = (n13 = n5 - n13) < 0 ? -n13 : n13;
                }
                n13 *= this.nx;
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n + n15;
                    while (n16 < 0) {
                        n16 += n4;
                    }
                    while (n16 >= this.nx) {
                        int n17 = n16 = (n16 = n4 - n16) < 0 ? -n16 : n16;
                    }
                    fArray[n15][n12] = sArray[n16 + n13] & 0xFFFF;
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getBlockXY(int n, int n2, int n3, double[][] dArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XY", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            int n10 = n3;
            while (n10 < 0) {
                n10 += n6;
            }
            while (n10 >= this.nz) {
                int n11 = n10 = (n10 = n6 - n10) < 0 ? -n10 : n10;
            }
            short[] sArray = (short[])this.data[n10];
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n2 + n12;
                while (n13 < 0) {
                    n13 += n5;
                }
                while (n13 >= this.ny) {
                    int n14 = n13 = (n13 = n5 - n13) < 0 ? -n13 : n13;
                }
                n13 *= this.nx;
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n + n15;
                    while (n16 < 0) {
                        n16 += n4;
                    }
                    while (n16 >= this.nx) {
                        int n17 = n16 = (n16 = n4 - n16) < 0 ? -n16 : n16;
                    }
                    dArray[n15][n12] = sArray[n16 + n13] & 0xFFFF;
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getBlockXZ(int n, int n2, int n3, byte[][] byArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            int n10 = n2;
            while (n10 < 0) {
                n10 += n5;
            }
            while (n10 >= this.ny) {
                int n11 = n10 = (n10 = n5 - n10) < 0 ? -n10 : n10;
            }
            n10 *= this.nx;
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n3 + n12;
                while (n13 < 0) {
                    n13 += n6;
                }
                while (n13 >= this.nz) {
                    n13 = n6 - n10;
                    int n14 = n13 = n13 < 0 ? -n13 : n13;
                }
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n + n15;
                    while (n16 < 0) {
                        n16 += n4;
                    }
                    while (n16 >= this.nx) {
                        int n17 = n16 = (n16 = n4 - n16) < 0 ? -n16 : n16;
                    }
                    byArray[n15][n12] = (byte)(((short[])this.data[n13])[n16 + n10] & 0xFFFF);
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getBlockXZ(int n, int n2, int n3, short[][] sArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            int n10 = n2;
            while (n10 < 0) {
                n10 += n5;
            }
            while (n10 >= this.ny) {
                int n11 = n10 = (n10 = n5 - n10) < 0 ? -n10 : n10;
            }
            n10 *= this.nx;
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n3 + n12;
                while (n13 < 0) {
                    n13 += n6;
                }
                while (n13 >= this.nz) {
                    n13 = n6 - n10;
                    int n14 = n13 = n13 < 0 ? -n13 : n13;
                }
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n + n15;
                    while (n16 < 0) {
                        n16 += n4;
                    }
                    while (n16 >= this.nx) {
                        int n17 = n16 = (n16 = n4 - n16) < 0 ? -n16 : n16;
                    }
                    sArray[n15][n12] = (short)(((short[])this.data[n13])[n16 + n10] & 0xFFFF);
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getBlockXZ(int n, int n2, int n3, float[][] fArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            int n10 = n2;
            while (n10 < 0) {
                n10 += n5;
            }
            while (n10 >= this.ny) {
                int n11 = n10 = (n10 = n5 - n10) < 0 ? -n10 : n10;
            }
            n10 *= this.nx;
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n3 + n12;
                while (n13 < 0) {
                    n13 += n6;
                }
                while (n13 >= this.nz) {
                    n13 = n6 - n10;
                    int n14 = n13 = n13 < 0 ? -n13 : n13;
                }
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n + n15;
                    while (n16 < 0) {
                        n16 += n4;
                    }
                    while (n16 >= this.nx) {
                        int n17 = n16 = (n16 = n4 - n16) < 0 ? -n16 : n16;
                    }
                    fArray[n15][n12] = ((short[])this.data[n13])[n16 + n10] & 0xFFFF;
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getBlockXZ(int n, int n2, int n3, double[][] dArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            int n10 = n2;
            while (n10 < 0) {
                n10 += n5;
            }
            while (n10 >= this.ny) {
                int n11 = n10 = (n10 = n5 - n10) < 0 ? -n10 : n10;
            }
            n10 *= this.nx;
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n3 + n12;
                while (n13 < 0) {
                    n13 += n6;
                }
                while (n13 >= this.nz) {
                    n13 = n6 - n10;
                    int n14 = n13 = n13 < 0 ? -n13 : n13;
                }
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n + n15;
                    while (n16 < 0) {
                        n16 += n4;
                    }
                    while (n16 >= this.nx) {
                        int n17 = n16 = (n16 = n4 - n16) < 0 ? -n16 : n16;
                    }
                    dArray[n15][n12] = ((short[])this.data[n13])[n16 + n10] & 0xFFFF;
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getBlockYZ(int n, int n2, int n3, byte[][] byArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("YZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            int n10 = n;
            while (n10 < 0) {
                n10 += n4;
            }
            while (n10 >= this.nx) {
                int n11 = n10 = (n10 = n4 - n10) < 0 ? -n10 : n10;
            }
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n3 + n12;
                while (n13 < 0) {
                    n13 += n6;
                }
                while (n13 >= this.nz) {
                    int n14 = n13 = (n13 = n6 - n13) < 0 ? -n13 : n13;
                }
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n2 + n15;
                    while (n16 < 0) {
                        n16 += n5;
                    }
                    while (n16 >= this.ny) {
                        int n17 = n16 = (n16 = n5 - n16) < 0 ? -n16 : n16;
                    }
                    byArray[n15][n12] = (byte)(((short[])this.data[n13])[n10 + n16 * this.nx] & 0xFFFF);
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getBlockYZ(int n, int n2, int n3, short[][] sArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("YZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            int n10 = n;
            while (n10 < 0) {
                n10 += n4;
            }
            while (n10 >= this.nx) {
                int n11 = n10 = (n10 = n4 - n10) < 0 ? -n10 : n10;
            }
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n3 + n12;
                while (n13 < 0) {
                    n13 += n6;
                }
                while (n13 >= this.nz) {
                    int n14 = n13 = (n13 = n6 - n13) < 0 ? -n13 : n13;
                }
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n2 + n15;
                    while (n16 < 0) {
                        n16 += n5;
                    }
                    while (n16 >= this.ny) {
                        int n17 = n16 = (n16 = n5 - n16) < 0 ? -n16 : n16;
                    }
                    sArray[n15][n12] = (short)(((short[])this.data[n13])[n10 + n16 * this.nx] & 0xFFFF);
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getBlockYZ(int n, int n2, int n3, float[][] fArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("YZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            int n10 = n;
            while (n10 < 0) {
                n10 += n4;
            }
            while (n10 >= this.nx) {
                int n11 = n10 = (n10 = n4 - n10) < 0 ? -n10 : n10;
            }
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n3 + n12;
                while (n13 < 0) {
                    n13 += n6;
                }
                while (n13 >= this.nz) {
                    int n14 = n13 = (n13 = n6 - n13) < 0 ? -n13 : n13;
                }
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n2 + n15;
                    while (n16 < 0) {
                        n16 += n5;
                    }
                    while (n16 >= this.ny) {
                        int n17 = n16 = (n16 = n5 - n16) < 0 ? -n16 : n16;
                    }
                    fArray[n15][n12] = ((short[])this.data[n13])[n10 + n16 * this.nx] & 0xFFFF;
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getBlockYZ(int n, int n2, int n3, double[][] dArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("YZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            int n10 = n;
            while (n10 < 0) {
                n10 += n4;
            }
            while (n10 >= this.nx) {
                int n11 = n10 = (n10 = n4 - n10) < 0 ? -n10 : n10;
            }
            int n12 = 0;
            while (n12 < n9) {
                int n13 = n3 + n12;
                while (n13 < 0) {
                    n13 += n6;
                }
                while (n13 >= this.nz) {
                    int n14 = n13 = (n13 = n6 - n13) < 0 ? -n13 : n13;
                }
                int n15 = 0;
                while (n15 < n8) {
                    int n16 = n2 + n15;
                    while (n16 < 0) {
                        n16 += n5;
                    }
                    while (n16 >= this.ny) {
                        int n17 = n16 = (n16 = n5 - n16) < 0 ? -n16 : n16;
                    }
                    dArray[n15][n12] = ((short[])this.data[n13])[n10 + n16 * this.nx] & 0xFFFF;
                    ++n15;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getBlockXYZ(int n, int n2, int n3, byte[][][] byArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XYZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            int n10 = byArray[0][0].length;
            int n11 = 0;
            while (n11 < n10) {
                int n12 = n3 + n11;
                while (n12 < 0) {
                    n12 += n6;
                }
                while (n12 >= this.nz) {
                    int n13 = n12 = (n12 = n6 - n12) < 0 ? -n12 : n12;
                }
                short[] sArray = (short[])this.data[n12];
                int n14 = 0;
                while (n14 < n9) {
                    int n15 = n2 + n14;
                    while (n15 < 0) {
                        n15 += n5;
                    }
                    while (n15 >= this.ny) {
                        int n16 = n15 = (n15 = n5 - n15) < 0 ? -n15 : n15;
                    }
                    n15 *= this.nx;
                    int n17 = 0;
                    while (n17 < n8) {
                        int n18 = n + n17;
                        while (n18 < 0) {
                            n18 += n4;
                        }
                        while (n18 >= this.nx) {
                            int n19 = n18 = (n18 = n4 - n18) < 0 ? -n18 : n18;
                        }
                        byArray[n17][n14][n11] = (byte)(sArray[n18 + n15] & 0xFFFF);
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getBlockXYZ(int n, int n2, int n3, short[][][] sArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XYZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            int n10 = sArray[0][0].length;
            int n11 = 0;
            while (n11 < n10) {
                int n12 = n3 + n11;
                while (n12 < 0) {
                    n12 += n6;
                }
                while (n12 >= this.nz) {
                    int n13 = n12 = (n12 = n6 - n12) < 0 ? -n12 : n12;
                }
                short[] sArray2 = (short[])this.data[n12];
                int n14 = 0;
                while (n14 < n9) {
                    int n15 = n2 + n14;
                    while (n15 < 0) {
                        n15 += n5;
                    }
                    while (n15 >= this.ny) {
                        int n16 = n15 = (n15 = n5 - n15) < 0 ? -n15 : n15;
                    }
                    n15 *= this.nx;
                    int n17 = 0;
                    while (n17 < n8) {
                        int n18 = n + n17;
                        while (n18 < 0) {
                            n18 += n4;
                        }
                        while (n18 >= this.nx) {
                            int n19 = n18 = (n18 = n4 - n18) < 0 ? -n18 : n18;
                        }
                        sArray[n17][n14][n11] = (short)(sArray2[n18 + n15] & 0xFFFF);
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getBlockXYZ(int n, int n2, int n3, float[][][] fArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XYZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            int n10 = fArray[0][0].length;
            int n11 = 0;
            while (n11 < n10) {
                int n12 = n3 + n11;
                while (n12 < 0) {
                    n12 += n6;
                }
                while (n12 >= this.nz) {
                    int n13 = n12 = (n12 = n6 - n12) < 0 ? -n12 : n12;
                }
                short[] sArray = (short[])this.data[n12];
                int n14 = 0;
                while (n14 < n9) {
                    int n15 = n2 + n14;
                    while (n15 < 0) {
                        n15 += n5;
                    }
                    while (n15 >= this.ny) {
                        int n16 = n15 = (n15 = n5 - n15) < 0 ? -n15 : n15;
                    }
                    n15 *= this.nx;
                    int n17 = 0;
                    while (n17 < n8) {
                        int n18 = n + n17;
                        while (n18 < 0) {
                            n18 += n4;
                        }
                        while (n18 >= this.nx) {
                            int n19 = n18 = (n18 = n4 - n18) < 0 ? -n18 : n18;
                        }
                        fArray[n17][n14][n11] = sArray[n18 + n15] & 0xFFFF;
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getBlockXYZ(int n, int n2, int n3, double[][][] dArray, byte by) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (by) {
            case 2: {
                n4 = this.nx <= 1 ? 1 : 2 * this.nx - 2;
                n5 = this.ny <= 1 ? 1 : 2 * this.ny - 2;
                n6 = this.nz <= 1 ? 1 : 2 * this.nz - 2;
                break;
            }
            case 3: {
                n4 = this.nx;
                n5 = this.ny;
                n6 = this.nz;
                break;
            }
            default: {
                this.throw_get("XYZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
            }
        }
        try {
            int n7 = n + n2 * this.nx;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            int n10 = dArray[0][0].length;
            int n11 = 0;
            while (n11 < n10) {
                int n12 = n3 + n11;
                while (n12 < 0) {
                    n12 += n6;
                }
                while (n12 >= this.nz) {
                    int n13 = n12 = (n12 = n6 - n12) < 0 ? -n12 : n12;
                }
                short[] sArray = (short[])this.data[n12];
                int n14 = 0;
                while (n14 < n9) {
                    int n15 = n2 + n14;
                    while (n15 < 0) {
                        n15 += n5;
                    }
                    while (n15 >= this.ny) {
                        int n16 = n15 = (n15 = n5 - n15) < 0 ? -n15 : n15;
                    }
                    n15 *= this.nx;
                    int n17 = 0;
                    while (n17 < n8) {
                        int n18 = n + n17;
                        while (n18 < 0) {
                            n18 += n4;
                        }
                        while (n18 >= this.nx) {
                            int n19 = n18 = (n18 = n4 - n18) < 0 ? -n18 : n18;
                        }
                        dArray[n17][n14][n11] = sArray[n18 + n15] & 0xFFFF;
                        ++n17;
                    }
                    ++n14;
                }
                ++n11;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getNeighborhoodX(int n, int n2, int n3, byte[] byArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = byArray.length;
            int n11 = n3;
            while (n11 < 0) {
                n11 += n8;
            }
            while (n11 >= this.nz) {
                int n12 = n11 = (n11 = n8 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n2;
            while (n13 < 0) {
                n13 += n4;
            }
            while (n13 >= this.ny) {
                int n14 = n13 = (n13 = n4 - n13) < 0 ? -n13 : n13;
            }
            n13 *= this.nx;
            int n15 = n - n10 / 2;
            short[] sArray = (short[])this.data[n11];
            int n16 = 0;
            while (n16 < n10) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n5;
                }
                while (n17 >= this.nx) {
                    int n18 = n17 = (n17 = n5 - n17) < 0 ? -n17 : n17;
                }
                byArray[n16] = (byte)(sArray[n17 + n13] & 0xFFFF);
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getNeighborhoodX(int n, int n2, int n3, short[] sArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = sArray.length;
            int n11 = n3;
            while (n11 < 0) {
                n11 += n8;
            }
            while (n11 >= this.nz) {
                int n12 = n11 = (n11 = n8 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n2;
            while (n13 < 0) {
                n13 += n4;
            }
            while (n13 >= this.ny) {
                int n14 = n13 = (n13 = n4 - n13) < 0 ? -n13 : n13;
            }
            n13 *= this.nx;
            int n15 = n - n10 / 2;
            short[] sArray2 = (short[])this.data[n11];
            int n16 = 0;
            while (n16 < n10) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n5;
                }
                while (n17 >= this.nx) {
                    int n18 = n17 = (n17 = n5 - n17) < 0 ? -n17 : n17;
                }
                sArray[n16] = (short)(sArray2[n17 + n13] & 0xFFFF);
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getNeighborhoodX(int n, int n2, int n3, float[] fArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = fArray.length;
            int n11 = n3;
            while (n11 < 0) {
                n11 += n8;
            }
            while (n11 >= this.nz) {
                int n12 = n11 = (n11 = n8 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n2;
            while (n13 < 0) {
                n13 += n4;
            }
            while (n13 >= this.ny) {
                int n14 = n13 = (n13 = n4 - n13) < 0 ? -n13 : n13;
            }
            n13 *= this.nx;
            int n15 = n - n10 / 2;
            short[] sArray = (short[])this.data[n11];
            int n16 = 0;
            while (n16 < n10) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n5;
                }
                while (n17 >= this.nx) {
                    int n18 = n17 = (n17 = n5 - n17) < 0 ? -n17 : n17;
                }
                fArray[n16] = sArray[n17 + n13] & 0xFFFF;
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getNeighborhoodX(int n, int n2, int n3, double[] dArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = dArray.length;
            int n11 = n3;
            while (n11 < 0) {
                n11 += n8;
            }
            while (n11 >= this.nz) {
                int n12 = n11 = (n11 = n8 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n2;
            while (n13 < 0) {
                n13 += n4;
            }
            while (n13 >= this.ny) {
                int n14 = n13 = (n13 = n4 - n13) < 0 ? -n13 : n13;
            }
            n13 *= this.nx;
            int n15 = n - n10 / 2;
            short[] sArray = (short[])this.data[n11];
            int n16 = 0;
            while (n16 < n10) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n5;
                }
                while (n17 >= this.nx) {
                    int n18 = n17 = (n17 = n5 - n17) < 0 ? -n17 : n17;
                }
                dArray[n16] = sArray[n17 + n13] & 0xFFFF;
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("X", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getNeighborhoodY(int n, int n2, int n3, byte[] byArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = byArray.length;
            int n11 = n3;
            while (n11 < 0) {
                n11 += n8;
            }
            while (n11 >= this.nz) {
                int n12 = n11 = (n11 = n8 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n;
            while (n13 < 0) {
                n13 += n5;
            }
            while (n13 >= this.nx) {
                int n14 = n13 = (n13 = n5 - n13) < 0 ? -n13 : n13;
            }
            int n15 = n2 - n10 / 2;
            short[] sArray = (short[])this.data[n11];
            int n16 = 0;
            while (n16 < n10) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n4;
                }
                while (n17 >= this.ny) {
                    int n18 = n17 = (n17 = n4 - n17) < 0 ? -n17 : n17;
                }
                byArray[n16] = (byte)(sArray[n13 + n17 * this.nx] & 0xFFFF);
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getNeighborhoodY(int n, int n2, int n3, short[] sArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = sArray.length;
            int n11 = n3;
            while (n11 < 0) {
                n11 += n8;
            }
            while (n11 >= this.nz) {
                int n12 = n11 = (n11 = n8 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n;
            while (n13 < 0) {
                n13 += n5;
            }
            while (n13 >= this.nx) {
                int n14 = n13 = (n13 = n5 - n13) < 0 ? -n13 : n13;
            }
            int n15 = n2 - n10 / 2;
            short[] sArray2 = (short[])this.data[n11];
            int n16 = 0;
            while (n16 < n10) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n4;
                }
                while (n17 >= this.ny) {
                    int n18 = n17 = (n17 = n4 - n17) < 0 ? -n17 : n17;
                }
                sArray[n16] = (short)(sArray2[n13 + n17 * this.nx] & 0xFFFF);
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getNeighborhoodY(int n, int n2, int n3, float[] fArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = fArray.length;
            int n11 = n3;
            while (n11 < 0) {
                n11 += n8;
            }
            while (n11 >= this.nz) {
                int n12 = n11 = (n11 = n8 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n;
            while (n13 < 0) {
                n13 += n5;
            }
            while (n13 >= this.nx) {
                int n14 = n13 = (n13 = n5 - n13) < 0 ? -n13 : n13;
            }
            int n15 = n2 - n10 / 2;
            short[] sArray = (short[])this.data[n11];
            int n16 = 0;
            while (n16 < n10) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n4;
                }
                while (n17 >= this.ny) {
                    int n18 = n17 = (n17 = n4 - n17) < 0 ? -n17 : n17;
                }
                fArray[n16] = sArray[n13 + n17 * this.nx] & 0xFFFF;
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getNeighborhoodY(int n, int n2, int n3, double[] dArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = dArray.length;
            int n11 = n3;
            while (n11 < 0) {
                n11 += n8;
            }
            while (n11 >= this.nz) {
                int n12 = n11 = (n11 = n8 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n;
            while (n13 < 0) {
                n13 += n5;
            }
            while (n13 >= this.nx) {
                int n14 = n13 = (n13 = n5 - n13) < 0 ? -n13 : n13;
            }
            int n15 = n2 - n10 / 2;
            short[] sArray = (short[])this.data[n11];
            int n16 = 0;
            while (n16 < n10) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n4;
                }
                while (n17 >= this.ny) {
                    int n18 = n17 = (n17 = n4 - n17) < 0 ? -n17 : n17;
                }
                dArray[n16] = sArray[n13 + n17 * this.nx] & 0xFFFF;
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("Y", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getNeighborhoodZ(int n, int n2, int n3, byte[] byArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = byArray.length;
            int n11 = n;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.nx) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n2;
            while (n13 < 0) {
                n13 += n4;
            }
            while (n13 >= this.ny) {
                int n14 = n13 = (n13 = n4 - n13) < 0 ? -n13 : n13;
            }
            int n15 = n11 + n13 * this.nx;
            int n16 = n3 - n10 / 2;
            int n17 = 0;
            while (n17 < n10) {
                int n18 = n16 + n17;
                while (n18 < 0) {
                    n18 += n8;
                }
                while (n18 >= this.nz) {
                    int n19 = n18 = (n18 = n8 - n18) < 0 ? -n18 : n18;
                }
                byArray[n17] = (byte)(((short[])this.data[n18])[n15] & 0xFFFF);
                ++n17;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getNeighborhoodZ(int n, int n2, int n3, short[] sArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = sArray.length;
            int n11 = n;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.nx) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n2;
            while (n13 < 0) {
                n13 += n4;
            }
            while (n13 >= this.ny) {
                int n14 = n13 = (n13 = n4 - n13) < 0 ? -n13 : n13;
            }
            int n15 = n11 + n13 * this.nx;
            int n16 = n3 - n10 / 2;
            int n17 = 0;
            while (n17 < n10) {
                int n18 = n16 + n17;
                while (n18 < 0) {
                    n18 += n8;
                }
                while (n18 >= this.nz) {
                    int n19 = n18 = (n18 = n8 - n18) < 0 ? -n18 : n18;
                }
                sArray[n17] = (short)(((short[])this.data[n18])[n15] & 0xFFFF);
                ++n17;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getNeighborhoodZ(int n, int n2, int n3, float[] fArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = fArray.length;
            int n11 = n;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.nx) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n2;
            while (n13 < 0) {
                n13 += n4;
            }
            while (n13 >= this.ny) {
                int n14 = n13 = (n13 = n4 - n13) < 0 ? -n13 : n13;
            }
            int n15 = n11 + n13 * this.nx;
            int n16 = n3 - n10 / 2;
            int n17 = 0;
            while (n17 < n10) {
                int n18 = n16 + n17;
                while (n18 < 0) {
                    n18 += n8;
                }
                while (n18 >= this.nz) {
                    int n19 = n18 = (n18 = n8 - n18) < 0 ? -n18 : n18;
                }
                fArray[n17] = ((short[])this.data[n18])[n15] & 0xFFFF;
                ++n17;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getNeighborhoodZ(int n, int n2, int n3, double[] dArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = dArray.length;
            int n11 = n;
            while (n11 < 0) {
                n11 += n5;
            }
            while (n11 >= this.nx) {
                int n12 = n11 = (n11 = n5 - n11) < 0 ? -n11 : n11;
            }
            int n13 = n2;
            while (n13 < 0) {
                n13 += n4;
            }
            while (n13 >= this.ny) {
                int n14 = n13 = (n13 = n4 - n13) < 0 ? -n13 : n13;
            }
            int n15 = n11 + n13 * this.nx;
            int n16 = n3 - n10 / 2;
            int n17 = 0;
            while (n17 < n10) {
                int n18 = n16 + n17;
                while (n18 < 0) {
                    n18 += n8;
                }
                while (n18 >= this.nz) {
                    int n19 = n18 = (n18 = n8 - n18) < 0 ? -n18 : n18;
                }
                dArray[n17] = ((short[])this.data[n18])[n15] & 0xFFFF;
                ++n17;
            }
        }
        catch (Exception exception) {
            this.throw_get("Z", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXY(int n, int n2, int n3, byte[][] byArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = byArray.length;
            int n11 = byArray[0].length;
            int n12 = n3;
            while (n12 < 0) {
                n12 += n8;
            }
            while (n12 >= this.nz) {
                int n13 = n12 = (n12 = n8 - n12) < 0 ? -n12 : n12;
            }
            int n14 = n - n10 / 2;
            int n15 = n2 - n11 / 2;
            short[] sArray = (short[])this.data[n12];
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n4;
                }
                while (n17 >= this.ny) {
                    int n18 = n17 = (n17 = n4 - n17) < 0 ? -n17 : n17;
                }
                n17 *= this.nx;
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n5;
                    }
                    while (n20 >= this.nx) {
                        int n21 = n20 = (n20 = n5 - n20) < 0 ? -n20 : n20;
                    }
                    byArray[n19][n16] = (byte)(sArray[n20 + n17] & 0xFFFF);
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXY(int n, int n2, int n3, short[][] sArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = sArray.length;
            int n11 = sArray[0].length;
            int n12 = n3;
            while (n12 < 0) {
                n12 += n8;
            }
            while (n12 >= this.nz) {
                int n13 = n12 = (n12 = n8 - n12) < 0 ? -n12 : n12;
            }
            int n14 = n - n10 / 2;
            int n15 = n2 - n11 / 2;
            short[] sArray2 = (short[])this.data[n12];
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n4;
                }
                while (n17 >= this.ny) {
                    int n18 = n17 = (n17 = n4 - n17) < 0 ? -n17 : n17;
                }
                n17 *= this.nx;
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n5;
                    }
                    while (n20 >= this.nx) {
                        int n21 = n20 = (n20 = n5 - n20) < 0 ? -n20 : n20;
                    }
                    sArray[n19][n16] = (short)(sArray2[n20 + n17] & 0xFFFF);
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXY(int n, int n2, int n3, float[][] fArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = fArray.length;
            int n11 = fArray[0].length;
            int n12 = n3;
            while (n12 < 0) {
                n12 += n8;
            }
            while (n12 >= this.nz) {
                int n13 = n12 = (n12 = n8 - n12) < 0 ? -n12 : n12;
            }
            int n14 = n - n10 / 2;
            int n15 = n2 - n11 / 2;
            short[] sArray = (short[])this.data[n12];
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n4;
                }
                while (n17 >= this.ny) {
                    int n18 = n17 = (n17 = n4 - n17) < 0 ? -n17 : n17;
                }
                n17 *= this.nx;
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n5;
                    }
                    while (n20 >= this.nx) {
                        int n21 = n20 = (n20 = n5 - n20) < 0 ? -n20 : n20;
                    }
                    fArray[n19][n16] = sArray[n20 + n17] & 0xFFFF;
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXY(int n, int n2, int n3, double[][] dArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = dArray.length;
            int n11 = dArray[0].length;
            int n12 = n3;
            while (n12 < 0) {
                n12 += n8;
            }
            while (n12 >= this.nz) {
                int n13 = n12 = (n12 = n8 - n12) < 0 ? -n12 : n12;
            }
            int n14 = n - n10 / 2;
            int n15 = n2 - n11 / 2;
            short[] sArray = (short[])this.data[n12];
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n4;
                }
                while (n17 >= this.ny) {
                    int n18 = n17 = (n17 = n4 - n17) < 0 ? -n17 : n17;
                }
                n17 *= this.nx;
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n5;
                    }
                    while (n20 >= this.nx) {
                        int n21 = n20 = (n20 = n5 - n20) < 0 ? -n20 : n20;
                    }
                    dArray[n19][n16] = sArray[n20 + n17] & 0xFFFF;
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XY", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXZ(int n, int n2, int n3, byte[][] byArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = byArray.length;
            int n11 = byArray[0].length;
            int n12 = n2;
            while (n12 < 0) {
                n12 += n4;
            }
            while (n12 >= this.ny) {
                int n13 = n12 = (n12 = n4 - n12) < 0 ? -n12 : n12;
            }
            n12 *= this.nx;
            int n14 = n - n10 / 2;
            int n15 = n3 - n11 / 2;
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    n17 = n8 - n12;
                    int n18 = n17 = n17 < 0 ? -n17 : n17;
                }
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n5;
                    }
                    while (n20 >= this.nx) {
                        int n21 = n20 = (n20 = n5 - n20) < 0 ? -n20 : n20;
                    }
                    byArray[n19][n16] = (byte)(((short[])this.data[n17])[n20 + n12] & 0xFFFF);
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXZ(int n, int n2, int n3, short[][] sArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = sArray.length;
            int n11 = sArray[0].length;
            int n12 = n2;
            while (n12 < 0) {
                n12 += n4;
            }
            while (n12 >= this.ny) {
                int n13 = n12 = (n12 = n4 - n12) < 0 ? -n12 : n12;
            }
            n12 *= this.nx;
            int n14 = n - n10 / 2;
            int n15 = n3 - n11 / 2;
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    n17 = n8 - n12;
                    int n18 = n17 = n17 < 0 ? -n17 : n17;
                }
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n5;
                    }
                    while (n20 >= this.nx) {
                        int n21 = n20 = (n20 = n5 - n20) < 0 ? -n20 : n20;
                    }
                    sArray[n19][n16] = (short)(((short[])this.data[n17])[n20 + n12] & 0xFFFF);
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXZ(int n, int n2, int n3, float[][] fArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = fArray.length;
            int n11 = fArray[0].length;
            int n12 = n2;
            while (n12 < 0) {
                n12 += n4;
            }
            while (n12 >= this.ny) {
                int n13 = n12 = (n12 = n4 - n12) < 0 ? -n12 : n12;
            }
            n12 *= this.nx;
            int n14 = n - n10 / 2;
            int n15 = n3 - n11 / 2;
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    n17 = n8 - n12;
                    int n18 = n17 = n17 < 0 ? -n17 : n17;
                }
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n5;
                    }
                    while (n20 >= this.nx) {
                        int n21 = n20 = (n20 = n5 - n20) < 0 ? -n20 : n20;
                    }
                    fArray[n19][n16] = ((short[])this.data[n17])[n20 + n12] & 0xFFFF;
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXZ(int n, int n2, int n3, double[][] dArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = dArray.length;
            int n11 = dArray[0].length;
            int n12 = n2;
            while (n12 < 0) {
                n12 += n4;
            }
            while (n12 >= this.ny) {
                int n13 = n12 = (n12 = n4 - n12) < 0 ? -n12 : n12;
            }
            n12 *= this.nx;
            int n14 = n - n10 / 2;
            int n15 = n3 - n11 / 2;
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    n17 = n8 - n12;
                    int n18 = n17 = n17 < 0 ? -n17 : n17;
                }
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n5;
                    }
                    while (n20 >= this.nx) {
                        int n21 = n20 = (n20 = n5 - n20) < 0 ? -n20 : n20;
                    }
                    dArray[n19][n16] = ((short[])this.data[n17])[n20 + n12] & 0xFFFF;
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getNeighborhoodYZ(int n, int n2, int n3, byte[][] byArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = byArray.length;
            int n11 = byArray[0].length;
            int n12 = n;
            while (n12 < 0) {
                n12 += n5;
            }
            while (n12 >= this.nx) {
                int n13 = n12 = (n12 = n5 - n12) < 0 ? -n12 : n12;
            }
            int n14 = n2 - n10 / 2;
            int n15 = n3 - n11 / 2;
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    int n18 = n17 = (n17 = n8 - n17) < 0 ? -n17 : n17;
                }
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n4;
                    }
                    while (n20 >= this.ny) {
                        int n21 = n20 = (n20 = n4 - n20) < 0 ? -n20 : n20;
                    }
                    byArray[n19][n16] = (byte)(((short[])this.data[n17])[n12 + n20 * this.nx] & 0xFFFF);
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getNeighborhoodYZ(int n, int n2, int n3, short[][] sArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = sArray.length;
            int n11 = sArray[0].length;
            int n12 = n;
            while (n12 < 0) {
                n12 += n5;
            }
            while (n12 >= this.nx) {
                int n13 = n12 = (n12 = n5 - n12) < 0 ? -n12 : n12;
            }
            int n14 = n2 - n10 / 2;
            int n15 = n3 - n11 / 2;
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    int n18 = n17 = (n17 = n8 - n17) < 0 ? -n17 : n17;
                }
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n4;
                    }
                    while (n20 >= this.ny) {
                        int n21 = n20 = (n20 = n4 - n20) < 0 ? -n20 : n20;
                    }
                    sArray[n19][n16] = (short)(((short[])this.data[n17])[n12 + n20 * this.nx] & 0xFFFF);
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getNeighborhoodYZ(int n, int n2, int n3, float[][] fArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = fArray.length;
            int n11 = fArray[0].length;
            int n12 = n;
            while (n12 < 0) {
                n12 += n5;
            }
            while (n12 >= this.nx) {
                int n13 = n12 = (n12 = n5 - n12) < 0 ? -n12 : n12;
            }
            int n14 = n2 - n10 / 2;
            int n15 = n3 - n11 / 2;
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    int n18 = n17 = (n17 = n8 - n17) < 0 ? -n17 : n17;
                }
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n4;
                    }
                    while (n20 >= this.ny) {
                        int n21 = n20 = (n20 = n4 - n20) < 0 ? -n20 : n20;
                    }
                    fArray[n19][n16] = ((short[])this.data[n17])[n12 + n20 * this.nx] & 0xFFFF;
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getNeighborhoodYZ(int n, int n2, int n3, double[][] dArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = dArray.length;
            int n11 = dArray[0].length;
            int n12 = n;
            while (n12 < 0) {
                n12 += n5;
            }
            while (n12 >= this.nx) {
                int n13 = n12 = (n12 = n5 - n12) < 0 ? -n12 : n12;
            }
            int n14 = n2 - n10 / 2;
            int n15 = n3 - n11 / 2;
            int n16 = 0;
            while (n16 < n11) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    int n18 = n17 = (n17 = n8 - n17) < 0 ? -n17 : n17;
                }
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n4;
                    }
                    while (n20 >= this.ny) {
                        int n21 = n20 = (n20 = n4 - n20) < 0 ? -n20 : n20;
                    }
                    dArray[n19][n16] = ((short[])this.data[n17])[n12 + n20 * this.nx] & 0xFFFF;
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("YZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXYZ(int n, int n2, int n3, byte[][][] byArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = byArray.length;
            int n11 = byArray[0].length;
            int n12 = byArray[0][0].length;
            int n13 = n - n10 / 2;
            int n14 = n2 - n11 / 2;
            int n15 = n3 - n12 / 2;
            int n16 = 0;
            while (n16 < n12) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    int n18 = n17 = (n17 = n8 - n17) < 0 ? -n17 : n17;
                }
                short[] sArray = (short[])this.data[n17];
                int n19 = 0;
                while (n19 < n11) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n4;
                    }
                    while (n20 >= this.ny) {
                        int n21 = n20 = (n20 = n4 - n20) < 0 ? -n20 : n20;
                    }
                    n20 *= this.nx;
                    int n22 = 0;
                    while (n22 < n10) {
                        int n23 = n13 + n22;
                        while (n23 < 0) {
                            n23 += n5;
                        }
                        while (n23 >= this.nx) {
                            int n24 = n23 = (n23 = n5 - n23) < 0 ? -n23 : n23;
                        }
                        byArray[n22][n19][n16] = (byte)(sArray[n23 + n20] & 0xFFFF);
                        ++n22;
                    }
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Mirror or periodic boundaray conditions", byArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXYZ(int n, int n2, int n3, short[][][] sArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = sArray.length;
            int n11 = sArray[0].length;
            int n12 = sArray[0][0].length;
            int n13 = n - n10 / 2;
            int n14 = n2 - n11 / 2;
            int n15 = n3 - n12 / 2;
            int n16 = 0;
            while (n16 < n12) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    int n18 = n17 = (n17 = n8 - n17) < 0 ? -n17 : n17;
                }
                short[] sArray2 = (short[])this.data[n17];
                int n19 = 0;
                while (n19 < n11) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n4;
                    }
                    while (n20 >= this.ny) {
                        int n21 = n20 = (n20 = n4 - n20) < 0 ? -n20 : n20;
                    }
                    n20 *= this.nx;
                    int n22 = 0;
                    while (n22 < n10) {
                        int n23 = n13 + n22;
                        while (n23 < 0) {
                            n23 += n5;
                        }
                        while (n23 >= this.nx) {
                            int n24 = n23 = (n23 = n5 - n23) < 0 ? -n23 : n23;
                        }
                        sArray[n22][n19][n16] = (short)(sArray2[n23 + n20] & 0xFFFF);
                        ++n22;
                    }
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Mirror or periodic boundaray conditions", sArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXYZ(int n, int n2, int n3, float[][][] fArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = fArray.length;
            int n11 = fArray[0].length;
            int n12 = fArray[0][0].length;
            int n13 = n - n10 / 2;
            int n14 = n2 - n11 / 2;
            int n15 = n3 - n12 / 2;
            int n16 = 0;
            while (n16 < n12) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    int n18 = n17 = (n17 = n8 - n17) < 0 ? -n17 : n17;
                }
                short[] sArray = (short[])this.data[n17];
                int n19 = 0;
                while (n19 < n11) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n4;
                    }
                    while (n20 >= this.ny) {
                        int n21 = n20 = (n20 = n4 - n20) < 0 ? -n20 : n20;
                    }
                    n20 *= this.nx;
                    int n22 = 0;
                    while (n22 < n10) {
                        int n23 = n13 + n22;
                        while (n23 < 0) {
                            n23 += n5;
                        }
                        while (n23 >= this.nx) {
                            int n24 = n23 = (n23 = n5 - n23) < 0 ? -n23 : n23;
                        }
                        fArray[n22][n19][n16] = sArray[n23 + n20] & 0xFFFF;
                        ++n22;
                    }
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Mirror or periodic boundaray conditions", fArray, n, n2, n3);
        }
    }

    public void getNeighborhoodXYZ(int n, int n2, int n3, double[][][] dArray, byte by) {
        int n4;
        int n5;
        int n6 = by == 2 ? (this.nx <= 1 ? 1 : 2 * this.nx - 2) : (n5 = this.nx);
        int n7 = by == 2 ? (this.ny <= 1 ? 1 : 2 * this.ny - 2) : (n4 = this.ny);
        int n8 = by == 2 ? (this.nz <= 1 ? 1 : 2 * this.nz - 2) : this.nz;
        try {
            int n9 = n + n2 * this.nx;
            int n10 = dArray.length;
            int n11 = dArray[0].length;
            int n12 = dArray[0][0].length;
            int n13 = n - n10 / 2;
            int n14 = n2 - n11 / 2;
            int n15 = n3 - n12 / 2;
            int n16 = 0;
            while (n16 < n12) {
                int n17 = n15 + n16;
                while (n17 < 0) {
                    n17 += n8;
                }
                while (n17 >= this.nz) {
                    int n18 = n17 = (n17 = n8 - n17) < 0 ? -n17 : n17;
                }
                short[] sArray = (short[])this.data[n17];
                int n19 = 0;
                while (n19 < n11) {
                    int n20 = n14 + n19;
                    while (n20 < 0) {
                        n20 += n4;
                    }
                    while (n20 >= this.ny) {
                        int n21 = n20 = (n20 = n4 - n20) < 0 ? -n20 : n20;
                    }
                    n20 *= this.nx;
                    int n22 = 0;
                    while (n22 < n10) {
                        int n23 = n13 + n22;
                        while (n23 < 0) {
                            n23 += n5;
                        }
                        while (n23 >= this.nx) {
                            int n24 = n23 = (n23 = n5 - n23) < 0 ? -n23 : n23;
                        }
                        dArray[n22][n19][n16] = sArray[n23 + n20] & 0xFFFF;
                        ++n22;
                    }
                    ++n19;
                }
                ++n16;
            }
        }
        catch (Exception exception) {
            this.throw_get("XYZ", "Mirror or periodic boundaray conditions", dArray, n, n2, n3);
        }
    }

    public void putBoundedX(int n, int n2, int n3, byte[] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n + n4 + n2 * this.nx;
            int n6 = n3;
            int n7 = byArray.length;
            if (n + n7 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n + n7 >= this.nx ? this.nx - n : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray[n5] = (short)(byArray[n9] & 0xFF);
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("X", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void putBoundedX(int n, int n2, int n3, short[] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n + n4 + n2 * this.nx;
            int n6 = n3;
            int n7 = sArray.length;
            if (n + n7 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n + n7 >= this.nx ? this.nx - n : n7;
            short[] sArray2 = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray2[n5] = (short)(sArray[n9] & 0xFFFF);
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("X", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void putBoundedX(int n, int n2, int n3, float[] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n + n4 + n2 * this.nx;
            int n6 = n3;
            int n7 = fArray.length;
            if (n + n7 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n + n7 >= this.nx ? this.nx - n : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray[n5] = (short)fArray[n9];
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("X", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void putBoundedX(int n, int n2, int n3, double[] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n + n4 + n2 * this.nx;
            int n6 = n3;
            int n7 = dArray.length;
            if (n + n7 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n + n7 >= this.nx ? this.nx - n : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray[n5] = (short)dArray[n9];
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("X", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void putBoundedY(int n, int n2, int n3, byte[] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n + (n2 + n4) * this.nx;
            int n6 = n3;
            int n7 = byArray.length;
            if (n < 0) {
                return;
            }
            if (n2 + n7 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n2 + n7 >= this.ny ? this.ny - n2 : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray[n5] = (short)(byArray[n9] & 0xFF);
                n5 += this.nx;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("Y", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void putBoundedY(int n, int n2, int n3, short[] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n + (n2 + n4) * this.nx;
            int n6 = n3;
            int n7 = sArray.length;
            if (n < 0) {
                return;
            }
            if (n2 + n7 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n2 + n7 >= this.ny ? this.ny - n2 : n7;
            short[] sArray2 = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray2[n5] = (short)(sArray[n9] & 0xFFFF);
                n5 += this.nx;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("Y", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void putBoundedY(int n, int n2, int n3, float[] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n + (n2 + n4) * this.nx;
            int n6 = n3;
            int n7 = fArray.length;
            if (n < 0) {
                return;
            }
            if (n2 + n7 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n2 + n7 >= this.ny ? this.ny - n2 : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray[n5] = (short)fArray[n9];
                n5 += this.nx;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("Y", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void putBoundedY(int n, int n2, int n3, double[] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n + (n2 + n4) * this.nx;
            int n6 = n3;
            int n7 = dArray.length;
            if (n < 0) {
                return;
            }
            if (n2 + n7 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n8 = n2 + n7 >= this.ny ? this.ny - n2 : n7;
            short[] sArray = (short[])this.data[n3];
            int n9 = n4;
            while (n9 < n8) {
                sArray[n5] = (short)dArray[n9];
                n5 += this.nx;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("Y", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void putBoundedZ(int n, int n2, int n3, byte[] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n3 < 0 ? -n3 : 0;
            int n5 = n3 + n4;
            int n6 = n + n2 * this.nx;
            int n7 = byArray.length;
            if (n < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n7 < 0) {
                return;
            }
            int n8 = n3 + n7 >= this.nz ? this.nz - n3 : n7;
            int n9 = n4;
            while (n9 < n8) {
                ((short[])this.data[n5])[n6] = (short)(byArray[n9] & 0xFF);
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("Z", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void putBoundedZ(int n, int n2, int n3, short[] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n3 < 0 ? -n3 : 0;
            int n5 = n3 + n4;
            int n6 = n + n2 * this.nx;
            int n7 = sArray.length;
            if (n < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n7 < 0) {
                return;
            }
            int n8 = n3 + n7 >= this.nz ? this.nz - n3 : n7;
            int n9 = n4;
            while (n9 < n8) {
                ((short[])this.data[n5])[n6] = (short)(sArray[n9] & 0xFFFF);
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("Z", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void putBoundedZ(int n, int n2, int n3, float[] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n3 < 0 ? -n3 : 0;
            int n5 = n3 + n4;
            int n6 = n + n2 * this.nx;
            int n7 = fArray.length;
            if (n < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n7 < 0) {
                return;
            }
            int n8 = n3 + n7 >= this.nz ? this.nz - n3 : n7;
            int n9 = n4;
            while (n9 < n8) {
                ((short[])this.data[n5])[n6] = (short)fArray[n9];
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("Z", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void putBoundedZ(int n, int n2, int n3, double[] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n3 < 0 ? -n3 : 0;
            int n5 = n3 + n4;
            int n6 = n + n2 * this.nx;
            int n7 = dArray.length;
            if (n < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n7 < 0) {
                return;
            }
            int n8 = n3 + n7 >= this.nz ? this.nz - n3 : n7;
            int n9 = n4;
            while (n9 < n8) {
                ((short[])this.data[n5])[n6] = (short)dArray[n9];
                ++n5;
                ++n9;
            }
        }
        catch (Exception exception) {
            this.throw_put("Z", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void putBoundedXY(int n, int n2, int n3, byte[][] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 + n9 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n2 + n9 >= this.ny ? this.ny - n2 : n9;
            short[] sArray = (short[])this.data[n3];
            int n12 = n5;
            while (n12 < n11) {
                n6 = n + n4 + (n2 + n12) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    sArray[n6] = (short)(byArray[n13][n12] & 0xFF);
                    ++n6;
                    ++n13;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("XY", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void putBoundedXY(int n, int n2, int n3, short[][] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 + n9 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n2 + n9 >= this.ny ? this.ny - n2 : n9;
            short[] sArray2 = (short[])this.data[n3];
            int n12 = n5;
            while (n12 < n11) {
                n6 = n + n4 + (n2 + n12) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    sArray2[n6] = (short)(sArray[n13][n12] & 0xFFFF);
                    ++n6;
                    ++n13;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("XY", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void putBoundedXY(int n, int n2, int n3, float[][] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 + n9 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n2 + n9 >= this.ny ? this.ny - n2 : n9;
            short[] sArray = (short[])this.data[n3];
            int n12 = n5;
            while (n12 < n11) {
                n6 = n + n4 + (n2 + n12) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    sArray[n6] = (short)fArray[n13][n12];
                    ++n6;
                    ++n13;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("XY", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void putBoundedXY(int n, int n2, int n3, double[][] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = 0;
            int n7 = n3;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 + n9 < 0) {
                return;
            }
            if (n3 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n2 + n9 >= this.ny ? this.ny - n2 : n9;
            short[] sArray = (short[])this.data[n3];
            int n12 = n5;
            while (n12 < n11) {
                n6 = n + n4 + (n2 + n12) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    sArray[n6] = (short)dArray[n13][n12];
                    ++n6;
                    ++n13;
                }
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("XY", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void putBoundedXZ(int n, int n2, int n3, byte[][] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + n4 + n2 * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    ((short[])this.data[n6])[n7] = (short)(byArray[n13][n12] & 0xFF);
                    ++n7;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("YZ", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void putBoundedXZ(int n, int n2, int n3, short[][] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + n4 + n2 * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    ((short[])this.data[n6])[n7] = (short)(sArray[n13][n12] & 0xFFFF);
                    ++n7;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("YZ", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void putBoundedXZ(int n, int n2, int n3, float[][] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + n4 + n2 * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    ((short[])this.data[n6])[n7] = (short)fArray[n13][n12];
                    ++n7;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("YZ", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void putBoundedXZ(int n, int n2, int n3, double[][] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            if (n + n8 < 0) {
                return;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n + n8 >= this.nx ? this.nx - n : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + n4 + n2 * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    ((short[])this.data[n6])[n7] = (short)dArray[n13][n12];
                    ++n7;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("YZ", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void putBoundedYZ(int n, int n2, int n3, byte[][] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = byArray.length;
            int n9 = byArray[0].length;
            if (n < 0) {
                return;
            }
            if (n2 + n8 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n2 + n8 >= this.ny ? this.ny - n2 : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + (n2 + n4) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    ((short[])this.data[n6])[n7] = (short)(byArray[n13][n12] & 0xFF);
                    n7 += this.nx;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("XZ", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void putBoundedYZ(int n, int n2, int n3, short[][] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = sArray.length;
            int n9 = sArray[0].length;
            if (n < 0) {
                return;
            }
            if (n2 + n8 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n2 + n8 >= this.ny ? this.ny - n2 : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + (n2 + n4) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    ((short[])this.data[n6])[n7] = (short)(sArray[n13][n12] & 0xFFFF);
                    n7 += this.nx;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("XZ", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void putBoundedYZ(int n, int n2, int n3, float[][] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = fArray.length;
            int n9 = fArray[0].length;
            if (n < 0) {
                return;
            }
            if (n2 + n8 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n2 + n8 >= this.ny ? this.ny - n2 : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + (n2 + n4) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    ((short[])this.data[n6])[n7] = (short)fArray[n13][n12];
                    n7 += this.nx;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("XZ", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void putBoundedYZ(int n, int n2, int n3, double[][] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n2 < 0 ? -n2 : 0;
            int n5 = n3 < 0 ? -n3 : 0;
            int n6 = n3 + n5;
            int n7 = 0;
            int n8 = dArray.length;
            int n9 = dArray[0].length;
            if (n < 0) {
                return;
            }
            if (n2 + n8 < 0) {
                return;
            }
            if (n3 + n9 < 0) {
                return;
            }
            int n10 = n2 + n8 >= this.ny ? this.ny - n2 : n8;
            int n11 = n3 + n9 >= this.nz ? this.nz - n3 : n9;
            int n12 = n5;
            while (n12 < n11) {
                n7 = n + (n2 + n4) * this.nx;
                int n13 = n4;
                while (n13 < n10) {
                    ((short[])this.data[n6])[n7] = (short)dArray[n13][n12];
                    n7 += this.nx;
                    ++n13;
                }
                ++n6;
                ++n12;
            }
        }
        catch (Exception exception) {
            this.throw_put("XZ", "Bounded check", dArray, n, n2, n3);
        }
    }

    public void putBoundedXYZ(int n, int n2, int n3, byte[][][] byArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = n3 < 0 ? -n3 : 0;
            int n7 = n3 + n6;
            int n8 = 0;
            int n9 = byArray.length;
            int n10 = byArray[0].length;
            int n11 = byArray[0][0].length;
            if (n + n9 < 0) {
                return;
            }
            if (n2 + n10 < 0) {
                return;
            }
            if (n3 + n11 < 0) {
                return;
            }
            int n12 = n + n9 >= this.nx ? this.nx - n : n9;
            int n13 = n2 + n10 >= this.ny ? this.ny - n2 : n10;
            int n14 = n3 + n11 >= this.nz ? this.nz - n3 : n11;
            int n15 = n6;
            while (n15 < n14) {
                short[] sArray = (short[])this.data[n7];
                int n16 = n5;
                while (n16 < n13) {
                    n8 = n + n4 + (n2 + n16) * this.nx;
                    int n17 = n4;
                    while (n17 < n12) {
                        sArray[n8] = (short)(byArray[n17][n16][n15] & 0xFF);
                        ++n8;
                        ++n17;
                    }
                    ++n16;
                }
                ++n7;
                ++n15;
            }
        }
        catch (Exception exception) {
            this.throw_put("XYZ", "Bounded check", byArray, n, n2, n3);
        }
    }

    public void putBoundedXYZ(int n, int n2, int n3, short[][][] sArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = n3 < 0 ? -n3 : 0;
            int n7 = n3 + n6;
            int n8 = 0;
            int n9 = sArray.length;
            int n10 = sArray[0].length;
            int n11 = sArray[0][0].length;
            if (n + n9 < 0) {
                return;
            }
            if (n2 + n10 < 0) {
                return;
            }
            if (n3 + n11 < 0) {
                return;
            }
            int n12 = n + n9 >= this.nx ? this.nx - n : n9;
            int n13 = n2 + n10 >= this.ny ? this.ny - n2 : n10;
            int n14 = n3 + n11 >= this.nz ? this.nz - n3 : n11;
            int n15 = n6;
            while (n15 < n14) {
                short[] sArray2 = (short[])this.data[n7];
                int n16 = n5;
                while (n16 < n13) {
                    n8 = n + n4 + (n2 + n16) * this.nx;
                    int n17 = n4;
                    while (n17 < n12) {
                        sArray2[n8] = (short)(sArray[n17][n16][n15] & 0xFFFF);
                        ++n8;
                        ++n17;
                    }
                    ++n16;
                }
                ++n7;
                ++n15;
            }
        }
        catch (Exception exception) {
            this.throw_put("XYZ", "Bounded check", sArray, n, n2, n3);
        }
    }

    public void putBoundedXYZ(int n, int n2, int n3, float[][][] fArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = n3 < 0 ? -n3 : 0;
            int n7 = n3 + n6;
            int n8 = 0;
            int n9 = fArray.length;
            int n10 = fArray[0].length;
            int n11 = fArray[0][0].length;
            if (n + n9 < 0) {
                return;
            }
            if (n2 + n10 < 0) {
                return;
            }
            if (n3 + n11 < 0) {
                return;
            }
            int n12 = n + n9 >= this.nx ? this.nx - n : n9;
            int n13 = n2 + n10 >= this.ny ? this.ny - n2 : n10;
            int n14 = n3 + n11 >= this.nz ? this.nz - n3 : n11;
            int n15 = n6;
            while (n15 < n14) {
                short[] sArray = (short[])this.data[n7];
                int n16 = n5;
                while (n16 < n13) {
                    n8 = n + n4 + (n2 + n16) * this.nx;
                    int n17 = n4;
                    while (n17 < n12) {
                        sArray[n8] = (short)fArray[n17][n16][n15];
                        ++n8;
                        ++n17;
                    }
                    ++n16;
                }
                ++n7;
                ++n15;
            }
        }
        catch (Exception exception) {
            this.throw_put("XYZ", "Bounded check", fArray, n, n2, n3);
        }
    }

    public void putBoundedXYZ(int n, int n2, int n3, double[][][] dArray) {
        try {
            if (n >= this.nx) {
                return;
            }
            if (n2 >= this.ny) {
                return;
            }
            if (n3 >= this.nz) {
                return;
            }
            int n4 = n < 0 ? -n : 0;
            int n5 = n2 < 0 ? -n2 : 0;
            int n6 = n3 < 0 ? -n3 : 0;
            int n7 = n3 + n6;
            int n8 = 0;
            int n9 = dArray.length;
            int n10 = dArray[0].length;
            int n11 = dArray[0][0].length;
            if (n + n9 < 0) {
                return;
            }
            if (n2 + n10 < 0) {
                return;
            }
            if (n3 + n11 < 0) {
                return;
            }
            int n12 = n + n9 >= this.nx ? this.nx - n : n9;
            int n13 = n2 + n10 >= this.ny ? this.ny - n2 : n10;
            int n14 = n3 + n11 >= this.nz ? this.nz - n3 : n11;
            int n15 = n6;
            while (n15 < n14) {
                short[] sArray = (short[])this.data[n7];
                int n16 = n5;
                while (n16 < n13) {
                    n8 = n + n4 + (n2 + n16) * this.nx;
                    int n17 = n4;
                    while (n17 < n12) {
                        sArray[n8] = (short)dArray[n17][n16][n15];
                        ++n8;
                        ++n17;
                    }
                    ++n16;
                }
                ++n7;
                ++n15;
            }
        }
        catch (Exception exception) {
            this.throw_put("XYZ", "Bounded check", dArray, n, n2, n3);
        }
    }
}

