/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JProgressBar;

public class CProgressBar
extends JProgressBar {
    private String comment;
    private int len;
    private double startTime;
    private int currentValue = 0;
    private boolean isIntegrated;

    public CProgressBar(boolean isIntegrated) {
        this.isIntegrated = isIntegrated;
        if (isIntegrated) {
            this.setPreferredSize(new Dimension(300, 20));
            this.setMinimumSize(this.getPreferredSize());
            Font font = this.getFont();
            Font font1 = new Font(font.getFamily(), font.getStyle(), font.getSize() - 2);
            this.setFont(font1);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 20);
    }

    public Dimension getMinimunSize() {
        return new Dimension(300, 20);
    }

    public Dimension getMaximumSize() {
        return new Dimension(300, 20);
    }

    public void start(String comment, int len) {
        this.len = len;
        this.comment = comment;
        this.currentValue = 0;
        if (this.isIntegrated) {
            this.enable();
            this.setMinimum(0);
            this.setValue(this.currentValue);
            this.setMaximum(len);
            this.setStringPainted(true);
        } else {
            IJ.showStatus((String)comment);
            IJ.showProgress((double)0.0);
        }
        this.startTime = System.currentTimeMillis();
    }

    public void progress(String text, int value) {
        this.currentValue = value;
        if (this.isIntegrated) {
            this.setValue(this.currentValue);
            this.setString(String.valueOf(this.comment) + text);
        } else {
            IJ.showStatus((String)(String.valueOf(this.comment) + text));
            IJ.showProgress((double)((double)this.currentValue / (double)this.len));
        }
    }

    public void increment(String text) {
        ++this.currentValue;
        if (this.isIntegrated) {
            this.setValue(this.currentValue);
            this.setString(String.valueOf(this.comment) + text);
        } else {
            IJ.showStatus((String)(String.valueOf(this.comment) + text));
            IJ.showProgress((double)((double)this.currentValue / (double)this.len));
        }
    }

    public void increment(String text, int inc) {
        this.currentValue += inc;
        if (this.isIntegrated) {
            this.setValue(this.currentValue);
            this.setString(String.valueOf(this.comment) + text);
        } else {
            IJ.showStatus((String)(String.valueOf(this.comment) + text));
            IJ.showProgress((double)((double)this.currentValue / (double)this.len));
        }
    }

    public void finish() {
        if (this.isIntegrated) {
            this.setValue(this.len);
            this.disable();
            this.setString(String.valueOf(this.comment) + " time: " + ((double)System.currentTimeMillis() - this.startTime) + " ms");
        } else {
            IJ.showStatus((String)(String.valueOf(this.comment) + " time: " + ((double)System.currentTimeMillis() - this.startTime) + " ms"));
            IJ.showProgress((double)1.0);
        }
    }
}

