/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

class FEMatrix {
    public static void multMatrix(double[][] m, double[][] g, double[][] mg) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 2) {
                mg[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 4) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 4) {
                    mg[i2][j] = mg[i2][j] + m[i2][k] * g[k][j];
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void rotate(double[][] a, int i, int j, int k, int l, double tau, double s) {
        double g = a[i][j];
        double h = a[k][l];
        a[i][j] = g - s * (h + g * tau);
        a[k][l] = h + s * (g - h * tau);
    }

    public static void jacobi(double[][] a, int n, double[] d, double[][] v, int nrot) {
        int iq;
        double[] b = new double[n + 1];
        double[] z = new double[n + 1];
        int ip = 1;
        while (ip <= n) {
            iq = 1;
            while (iq <= n) {
                v[ip][iq] = 0.0;
                ++iq;
            }
            v[ip][ip] = 1.0;
            ++ip;
        }
        ip = 1;
        while (ip <= n) {
            b[ip] = d[ip] = a[ip][ip];
            z[ip] = 0.0;
            ++ip;
        }
        nrot = 0;
        int i = 1;
        while (i <= 50) {
            double sm = 0.0;
            ip = 1;
            while (ip <= n - 1) {
                iq = ip + 1;
                while (iq <= n) {
                    sm += Math.abs(a[ip][iq]);
                    ++iq;
                }
                ++ip;
            }
            if (sm == 0.0) {
                return;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            ip = 1;
            while (ip <= n - 1) {
                iq = ip + 1;
                while (iq <= n) {
                    double g = 100.0 * Math.abs(a[ip][iq]);
                    if (i > 4 && Math.abs(d[ip]) + g == Math.abs(d[ip]) && Math.abs(d[iq]) + g == Math.abs(d[iq])) {
                        a[ip][iq] = 0.0;
                    } else if (Math.abs(a[ip][iq]) > tresh) {
                        double t;
                        double h = d[iq] - d[ip];
                        if (Math.abs(h) + g == Math.abs(h)) {
                            t = a[ip][iq] / h;
                        } else {
                            double theta = 0.5 * h / a[ip][iq];
                            t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                            if (theta < 0.0) {
                                t = -t;
                            }
                        }
                        double c = 1.0 / Math.sqrt(1.0 + t * t);
                        double s = t * c;
                        double tau = s / (1.0 + c);
                        h = t * a[ip][iq];
                        int n2 = ip;
                        z[n2] = z[n2] - h;
                        int n3 = iq;
                        z[n3] = z[n3] + h;
                        int n4 = ip;
                        d[n4] = d[n4] - h;
                        int n5 = iq;
                        d[n5] = d[n5] + h;
                        a[ip][iq] = 0.0;
                        int j = 1;
                        while (j <= ip - 1) {
                            FEMatrix.rotate(a, j, ip, j, iq, tau, s);
                            ++j;
                        }
                        j = ip + 1;
                        while (j <= iq - 1) {
                            FEMatrix.rotate(a, ip, j, j, iq, tau, s);
                            ++j;
                        }
                        j = iq + 1;
                        while (j <= n) {
                            FEMatrix.rotate(a, ip, j, iq, j, tau, s);
                            ++j;
                        }
                        j = 1;
                        while (j <= n) {
                            FEMatrix.rotate(v, j, ip, j, iq, tau, s);
                            ++j;
                        }
                        ++nrot;
                    }
                    ++iq;
                }
                ++ip;
            }
            ip = 1;
            while (ip <= n) {
                int n6 = ip;
                b[n6] = b[n6] + z[ip];
                d[ip] = b[ip];
                z[ip] = 0.0;
                ++ip;
            }
            ++i;
        }
    }

    public static void choldc(double[][] a, int n, double[][] l) {
        int j;
        double[] p = new double[n + 1];
        int i = 1;
        while (i <= n) {
            j = i;
            while (j <= n) {
                double sum = a[i][j];
                int k = i - 1;
                while (k >= 1) {
                    sum -= a[i][k] * a[j][k];
                    --k;
                }
                if (i == j) {
                    if (!(sum <= 0.0)) {
                        p[i] = Math.sqrt(sum);
                    }
                } else {
                    a[j][i] = sum / p[i];
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i <= n) {
            j = i;
            while (j <= n) {
                if (i == j) {
                    l[i][i] = p[i];
                } else {
                    l[j][i] = a[j][i];
                    l[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    public static int inverse(double[][] TB, double[][] InvB, int N) {
        int j;
        double[][] B = new double[N + 1][N + 2];
        double[][] A = new double[N + 1][2 * N + 2];
        double[][] C = new double[N + 1][N + 1];
        double eps = 1.0E-19;
        int k = 1;
        while (k <= N) {
            j = 1;
            while (j <= N) {
                B[k][j] = TB[k][j];
                ++j;
            }
            ++k;
        }
        k = 1;
        while (k <= N) {
            j = 1;
            while (j <= N + 1) {
                A[k][j] = B[k][j];
                ++j;
            }
            j = N + 2;
            while (j <= 2 * N + 1) {
                A[k][j] = 0.0;
                ++j;
            }
            A[k][k - 1 + N + 2] = 1.0;
            ++k;
        }
        k = 1;
        while (k <= N) {
            double maxpivot = Math.abs(A[k][k]);
            int npivot = k;
            int i = k;
            while (i <= N) {
                if (maxpivot < Math.abs(A[i][k])) {
                    maxpivot = Math.abs(A[i][k]);
                    npivot = i;
                }
                ++i;
            }
            if (maxpivot >= eps) {
                if (npivot != k) {
                    j = k;
                    while (j <= 2 * N + 1) {
                        double temp = A[npivot][j];
                        A[npivot][j] = A[k][j];
                        A[k][j] = temp;
                        ++j;
                    }
                }
                double D = A[k][k];
                j = 2 * N + 1;
                while (j >= k) {
                    A[k][j] = A[k][j] / D;
                    --j;
                }
                i = 1;
                while (i <= N) {
                    if (i != k) {
                        double mult = A[i][k];
                        j = 2 * N + 1;
                        while (j >= k) {
                            A[i][j] = A[i][j] - mult * A[k][j];
                            --j;
                        }
                    }
                    ++i;
                }
            } else {
                return -1;
            }
            ++k;
        }
        k = 1;
        int p = 1;
        while (k <= N) {
            j = N + 2;
            int q = 1;
            while (j <= 2 * N + 1) {
                InvB[p][q] = A[k][j];
                ++j;
                ++q;
            }
            ++k;
            ++p;
        }
        return 0;
    }

    public static void AperB(double[][] _A, double[][] _B, double[][] _res, int _righA, int _colA, int _righB, int _colB) {
        int p = 1;
        while (p <= _righA) {
            int q = 1;
            while (q <= _colB) {
                _res[p][q] = 0.0;
                int l = 1;
                while (l <= _colA) {
                    _res[p][q] = _res[p][q] + _A[p][l] * _B[l][q];
                    ++l;
                }
                ++q;
            }
            ++p;
        }
    }

    public static void A_TperB(double[][] _A, double[][] _B, double[][] _res, int _righA, int _colA, int _righB, int _colB) {
        int p = 1;
        while (p <= _colA) {
            int q = 1;
            while (q <= _colB) {
                _res[p][q] = 0.0;
                int l = 1;
                while (l <= _righA) {
                    _res[p][q] = _res[p][q] + _A[l][p] * _B[l][q];
                    ++l;
                }
                ++q;
            }
            ++p;
        }
    }

    public static void AperB_T(double[][] _A, double[][] _B, double[][] _res, int _righA, int _colA, int _righB, int _colB) {
        int p = 1;
        while (p <= _colA) {
            int q = 1;
            while (q <= _colB) {
                _res[p][q] = 0.0;
                int l = 1;
                while (l <= _righA) {
                    _res[p][q] = _res[p][q] + _A[p][l] * _B[q][l];
                    ++l;
                }
                ++q;
            }
            ++p;
        }
    }

    public static void pv(double[] v, String str) {
        System.out.println("------------" + str + "--------------");
        System.out.println(" " + v[1] + " " + v[2] + " " + v[3] + " " + v[4] + " " + v[5] + " " + v[6]);
        System.out.println("------------------------------------------");
    }

    public static void pm(double[][] S, String str) {
        System.out.println("------------" + str + "--------------");
        System.out.println(" " + S[1][1] + " " + S[1][2] + " " + S[1][3] + " " + S[1][4] + " " + S[1][5] + " " + S[1][6]);
        System.out.println(" " + S[2][1] + " " + S[2][2] + " " + S[2][3] + " " + S[2][4] + " " + S[2][5] + " " + S[2][6]);
        System.out.println(" " + S[3][1] + " " + S[3][2] + " " + S[3][3] + " " + S[3][4] + " " + S[3][5] + " " + S[3][6]);
        System.out.println(" " + S[4][1] + " " + S[4][2] + " " + S[4][3] + " " + S[4][4] + " " + S[4][5] + " " + S[4][6]);
        System.out.println(" " + S[5][1] + " " + S[5][2] + " " + S[5][3] + " " + S[5][4] + " " + S[5][5] + " " + S[5][6]);
        System.out.println(" " + S[6][1] + " " + S[6][2] + " " + S[6][3] + " " + S[6][4] + " " + S[6][5] + " " + S[6][6]);
        System.out.println("------------------------------------------");
    }

    FEMatrix() {
    }
}

