/*
 * Decompiled with CFR 0.152.
 */
package spottracker2d;

import ij.IJ;
import ij.gui.Roi;
import imageware.ImageWare;
import java.awt.Point;
import java.util.Vector;
import spottracker2d.CProgressBar;
import spottracker2d.Handler;
import spottracker2d.PointTrack;

public class Tracker {
    private Vector X;
    private ImageWare input;
    private int nx;
    private int ny;
    private int nt;
    private CProgressBar progress;
    private Point[][] range;
    private boolean firstCall = true;
    private int delta = -1;
    private double normalizeFactor = -1.0;
    private double constraintMovement = -1.0;
    private double constraintCenter = -1.0;
    private boolean refinePosition = false;
    private Handler handler;
    private int[][][] pos;
    private double[][][] cost;
    private double normv = 1.0;
    private double maxcost = 1.0;
    private double progressFactor = 0.0;

    public Tracker(ImageWare input, Handler handler, CProgressBar progress) {
        this.progress = progress;
        this.input = input;
        this.handler = handler;
        this.nt = input.getSizeZ();
        this.nx = input.getSizeX();
        this.ny = input.getSizeY();
        handler.xspot = new float[this.nt];
        handler.yspot = new float[this.nt];
        handler.vspot = new int[this.nt];
        this.range = new Point[this.nt][2];
        this.firstCall = true;
        progress.start("Tracking ", this.nt);
        this.pos = new int[this.nt][this.nx][this.ny];
        this.cost = new double[this.nt][this.nx][this.ny];
    }

    public boolean run(PointTrack startingPoint, Vector node, int delta, double normalizeFactor, double constraintMovement, double constraintCenter, boolean refinePosition) {
        PointTrack end;
        PointTrack start;
        this.progress.start("Tracking ", this.nt);
        this.handler.X1Enveloppe = new int[this.nt + 1];
        this.handler.Y1Enveloppe = new int[this.nt + 1];
        this.handler.X2Enveloppe = new int[this.nt + 1];
        this.handler.Y2Enveloppe = new int[this.nt + 1];
        int c = 0;
        while (c < node.size()) {
            PointTrack pt = (PointTrack)node.elementAt(c);
            if (pt.x < 0 || pt.y < 0 || pt.t < 0 || pt.x >= this.nx || pt.y >= this.ny || pt.t >= this.nt) {
                Roi roi = this.handler.imp.getRoi();
                if (roi == null) {
                    IJ.error((String)("The node: x=" + pt.x + " y=" + pt.y + " at the image:" + (pt.t + 1) + " is outside of the image\n" + "The image size is [" + this.nx + "," + this.ny + "]."));
                } else {
                    IJ.error((String)("The node: x=" + pt.x + " y=" + pt.y + " at the image:" + (pt.t + 1) + " is outside of the image\n" + "The ROI size on the image is [" + this.nx + "," + this.ny + "]."));
                }
                return false;
            }
            ++c;
        }
        int c2 = 0;
        while (c2 < node.size() - 1) {
            start = (PointTrack)node.elementAt(c2);
            if (!this.checkNodeConsistency(delta, start, end = (PointTrack)node.elementAt(c2 + 1))) {
                IJ.error((String)("The distance from one node to next node is too high. It is impossible not possible to reach the node (t=" + (start.t + 1) + " x=" + start.x + " y=" + start.y + ") to the " + "node (t=" + (end.t + 1) + " x=" + end.x + " y=" + end.y + " with the maximum displacement at " + delta));
                return false;
            }
            ++c2;
        }
        PointTrack pt0 = (PointTrack)node.elementAt(0);
        PointTrack first = new PointTrack(pt0.x, pt0.y, pt0.z, 0, 0.0f);
        PointTrack ptn = (PointTrack)node.elementAt(node.size() - 1);
        PointTrack last = new PointTrack(ptn.x, ptn.y, ptn.z, this.nt, 0.0f);
        start = (PointTrack)node.elementAt(0);
        if (start.t > 0) {
            this.createEnveloppeBackward(delta, first, start);
        }
        int c3 = 0;
        while (c3 < node.size() - 1) {
            start = (PointTrack)node.elementAt(c3);
            end = (PointTrack)node.elementAt(c3 + 1);
            this.createEnveloppeForward(delta, false, start, end);
            ++c3;
        }
        start = (PointTrack)node.elementAt(node.size() - 1);
        if (start.t < this.nt) {
            this.createEnveloppeForward(delta, true, start, last);
        }
        boolean flagRetrack = false;
        if (this.delta != delta) {
            flagRetrack = true;
        }
        if (this.normalizeFactor != normalizeFactor) {
            flagRetrack = true;
        }
        if (this.constraintMovement != constraintMovement) {
            flagRetrack = true;
        }
        if (this.constraintCenter != constraintCenter) {
            flagRetrack = true;
        }
        if (this.refinePosition != refinePosition) {
            flagRetrack = true;
        }
        this.delta = delta;
        this.normalizeFactor = normalizeFactor;
        this.constraintMovement = constraintMovement;
        this.constraintCenter = constraintCenter;
        this.refinePosition = refinePosition;
        this.maxcost = normalizeFactor + constraintMovement + constraintCenter;
        boolean[] profile = this.defineTrackingProfile(flagRetrack, node);
        double norm = startingPoint.value != 0.0f ? normalizeFactor / (double)startingPoint.value : normalizeFactor / 100.0;
        double[][] mapMove = this.createMovementMap(constraintMovement, delta);
        double[][] mapCenter = this.createCenterMap(constraintCenter);
        this.normv = normalizeFactor + constraintMovement + constraintCenter;
        double costinit = mapCenter[this.nx / 2][this.ny / 2] + mapMove[delta][delta];
        int c4 = 0;
        while (c4 < node.size() - 1) {
            start = (PointTrack)node.elementAt(c4);
            if (this.checkProfile(profile, start, end = (PointTrack)node.elementAt(c4 + 1))) {
                this.dpaForward(start, end, norm, mapMove, mapCenter, costinit);
            }
            ++c4;
        }
        start = (PointTrack)node.elementAt(node.size() - 1);
        if (start.t == last.t) {
            this.handler.xspot[start.t - 1] = start.x;
            this.handler.yspot[start.t - 1] = start.y;
            this.handler.vspot[start.t - 1] = 0;
        } else if (this.checkProfile(profile, start, last)) {
            ++last.t;
            this.dpaForward(start, last, norm, mapMove, mapCenter, costinit);
        }
        start = (PointTrack)node.elementAt(0);
        if (this.checkProfile(profile, first, start)) {
            this.dpaBackward(start, first, norm, mapMove, mapCenter, costinit);
        }
        if (refinePosition) {
            this.refinePosition(node);
        }
        this.handler.subpixelTrace = refinePosition;
        int[] vspotsmooth = new int[this.nt];
        int t = 1;
        while (t < this.nt - 1) {
            vspotsmooth[t] = (this.handler.vspot[t - 1] + this.handler.vspot[t] + this.handler.vspot[t + 1]) / 3;
            ++t;
        }
        System.arraycopy(vspotsmooth, 1, this.handler.vspot, 0, this.nt - 2);
        this.progress.finish();
        return true;
    }

    private void dpaForward(PointTrack start, PointTrack end, double norm, double[][] mapMove, double[][] mapCenter, double costinit) {
        int ys;
        int xs;
        int y1;
        int x1;
        int t1 = start.t;
        int t2 = end.t;
        if (t1 < 0) {
            t1 = 0;
        }
        if (t1 >= this.nt) {
            t1 = this.nt;
        }
        if (t2 < 0) {
            t2 = 0;
        }
        if (t2 >= this.nt) {
            t2 = this.nt;
        }
        double[][] pix = new double[this.nx][this.ny];
        if (Math.abs(end.t - t1) == 0) {
            this.handler.xspot[t1] = start.x;
            this.handler.yspot[t1] = start.y;
            this.handler.vspot[t1] = 0;
            return;
        }
        if (Math.abs(end.t - t1) == 1) {
            this.handler.xspot[t1] = start.x;
            this.handler.yspot[t1] = start.y;
            this.handler.vspot[t1] = 0;
            if (t2 >= 0 && t2 < this.nt) {
                this.handler.xspot[t2] = end.x;
                this.handler.yspot[t2] = end.y;
                this.handler.vspot[t2] = 0;
            }
            return;
        }
        int delta = (mapMove.length - 1) / 2;
        int x2 = x1 = start.x;
        int y2 = y1 = start.y;
        double[][] currentCost = new double[this.nx][this.ny];
        double[][] previousCost = new double[this.nx][this.ny];
        previousCost[x1][y1] = 0.0;
        this.pos[t1][x1][y1] = x1 + y1 * this.nx;
        this.input.getXY(0, 0, t1, pix);
        this.cost[t1][x1][y1] = pix[x1][y1] * norm + costinit;
        int index = 0;
        double maxCost = 0.0;
        Object image = null;
        int offsetXCenter = this.nx / 2;
        int offsetYCenter = this.ny / 2;
        int t = t1 + 1;
        while (t < t2) {
            int x;
            this.progress.increment("forward Image " + t);
            this.input.getXY(0, 0, t, pix);
            x2 += delta;
            y2 += delta;
            x1 = (x1 -= delta) < this.handler.X1Enveloppe[t] ? this.handler.X1Enveloppe[t] : x1;
            y1 = y1 < this.handler.Y1Enveloppe[t] ? this.handler.Y1Enveloppe[t] : (y1 -= delta);
            x2 = x2 > this.handler.X2Enveloppe[t] ? this.handler.X2Enveloppe[t] : x2;
            y2 = y2 > this.handler.Y2Enveloppe[t] ? this.handler.Y2Enveloppe[t] : y2;
            int y = y1;
            while (y <= y2) {
                int yprev1 = y - delta;
                int yprev2 = y + delta;
                yprev1 = yprev1 < this.handler.Y1Enveloppe[t - 1] ? this.handler.Y1Enveloppe[t - 1] : yprev1;
                yprev2 = yprev2 > this.handler.Y2Enveloppe[t - 1] ? this.handler.Y2Enveloppe[t - 1] : yprev2;
                x = x1;
                while (x <= x2) {
                    int xprev1 = x - delta;
                    int xprev2 = x + delta;
                    xprev1 = xprev1 < this.handler.X1Enveloppe[t - 1] ? this.handler.X1Enveloppe[t - 1] : xprev1;
                    xprev2 = xprev2 > this.handler.X2Enveloppe[t - 1] ? this.handler.X2Enveloppe[t - 1] : xprev2;
                    maxCost = -1.7976931348623157E308;
                    int xprev = xprev1;
                    while (xprev <= xprev2) {
                        int yprev = yprev1;
                        while (yprev <= yprev2) {
                            double curCost = previousCost[xprev][yprev] + mapMove[xprev - x + delta][yprev - y + delta];
                            if (curCost > maxCost) {
                                maxCost = curCost;
                                index = xprev + this.nx * yprev;
                            }
                            ++yprev;
                        }
                        ++xprev;
                    }
                    this.pos[t][x][y] = index;
                    currentCost[x][y] = maxCost + pix[x][y] * norm + mapCenter[x][y];
                    xs = index % this.nx;
                    ys = index / this.nx;
                    this.cost[t][x][y] = pix[x][y] * norm + mapCenter[x][y] + mapMove[xs - x + delta][ys - y + delta];
                    ++x;
                }
                ++y;
            }
            x = 0;
            while (x < this.nx) {
                int y3 = 0;
                while (y3 < this.ny) {
                    previousCost[x][y3] = currentCost[x][y3];
                    ++y3;
                }
                ++x;
            }
            ++t;
        }
        double max = -1.7976931348623157E308;
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                if (currentCost[x][y] > max) {
                    max = currentCost[x][y];
                    index = x + y * this.nx;
                }
                ++y;
            }
            ++x;
        }
        int t3 = t2 - 1;
        while (t3 >= t1) {
            xs = index % this.nx;
            ys = index / this.nx;
            xs = xs < this.handler.X1Enveloppe[t3] ? this.handler.X1Enveloppe[t3] : xs;
            ys = ys < this.handler.Y1Enveloppe[t3] ? this.handler.Y1Enveloppe[t3] : ys;
            xs = xs > this.handler.X2Enveloppe[t3] ? this.handler.X2Enveloppe[t3] : xs;
            ys = ys > this.handler.Y2Enveloppe[t3] ? this.handler.Y2Enveloppe[t3] : ys;
            this.handler.xspot[t3] = xs;
            this.handler.yspot[t3] = ys;
            index = this.pos[t3][xs][ys];
            int v = this.round(this.cost[t3][xs][ys] * 100.0 / this.normv);
            v = v < 0 ? 0 : v;
            this.handler.vspot[t3] = v > 100 ? 100 : v;
            --t3;
        }
    }

    private void dpaBackward(PointTrack start, PointTrack first, double norm, double[][] mapMove, double[][] mapCenter, double costinit) {
        int ys;
        int xs;
        int y1;
        int x1;
        int t1 = start.t;
        int t2 = first.t;
        if (t1 < 0) {
            t1 = 0;
        }
        if (t1 >= this.nt) {
            t1 = this.nt;
        }
        if (t2 < 0) {
            t2 = 0;
        }
        if (t2 >= this.nt) {
            t2 = this.nt;
        }
        double[][] pix = new double[this.nx][this.ny];
        if (Math.abs(first.t - t1) == 0) {
            this.handler.xspot[t1] = start.x;
            this.handler.yspot[t1] = start.y;
            this.handler.vspot[t1] = 0;
            return;
        }
        if (Math.abs(t2 - t1) == 1) {
            this.handler.xspot[t1] = start.x;
            this.handler.yspot[t1] = start.y;
            this.handler.vspot[t1] = this.round(pix[start.x][start.y]);
            this.handler.xspot[t2] = first.x;
            this.handler.yspot[t2] = first.y;
            this.handler.vspot[t2] = 0;
            return;
        }
        int delta = (mapMove.length - 1) / 2;
        int x2 = x1 = start.x;
        int y2 = y1 = start.y;
        double[][] currentCost = new double[this.nx][this.ny];
        double[][] previousCost = new double[this.nx][this.ny];
        previousCost[x1][y1] = 0.0;
        this.pos[t1][x1][y1] = x1 + y1 * this.nx;
        this.input.getXY(0, 0, t1, pix);
        this.cost[t1][x1][y1] = pix[x1][y1] * norm + costinit;
        int index = 0;
        double maxCost = 0.0;
        Object image = null;
        int offsetXCenter = this.nx / 2;
        int offsetYCenter = this.ny / 2;
        int t = t1 - 1;
        while (t >= t2) {
            int x;
            this.progress.increment("backward Image " + t);
            this.input.getXY(0, 0, t, pix);
            x2 += delta;
            y2 += delta;
            x1 = (x1 -= delta) < this.handler.X1Enveloppe[t] ? this.handler.X1Enveloppe[t] : x1;
            y1 = y1 < this.handler.Y1Enveloppe[t] ? this.handler.Y1Enveloppe[t] : (y1 -= delta);
            x2 = x2 > this.handler.X2Enveloppe[t] ? this.handler.X2Enveloppe[t] : x2;
            y2 = y2 > this.handler.Y2Enveloppe[t] ? this.handler.Y2Enveloppe[t] : y2;
            int y = y1;
            while (y <= y2) {
                int yprev1 = y - delta;
                int yprev2 = y + delta;
                yprev1 = yprev1 < this.handler.Y1Enveloppe[t + 1] ? this.handler.Y1Enveloppe[t + 1] : yprev1;
                yprev2 = yprev2 > this.handler.Y2Enveloppe[t + 1] ? this.handler.Y2Enveloppe[t + 1] : yprev2;
                x = x1;
                while (x <= x2) {
                    int xprev1 = x - delta;
                    int xprev2 = x + delta;
                    xprev1 = xprev1 < this.handler.X1Enveloppe[t + 1] ? this.handler.X1Enveloppe[t + 1] : xprev1;
                    xprev2 = xprev2 > this.handler.X2Enveloppe[t + 1] ? this.handler.X2Enveloppe[t + 1] : xprev2;
                    maxCost = -1.7976931348623157E308;
                    int xprev = xprev1;
                    while (xprev <= xprev2) {
                        int yprev = yprev1;
                        while (yprev <= yprev2) {
                            double curCost = previousCost[xprev][yprev] + mapMove[xprev - x + delta][yprev - y + delta];
                            if (curCost > maxCost) {
                                maxCost = curCost;
                                index = xprev + this.nx * yprev;
                            }
                            ++yprev;
                        }
                        ++xprev;
                    }
                    this.pos[t][x][y] = index;
                    currentCost[x][y] = maxCost + pix[x][y] * norm + mapCenter[x][y];
                    xs = index % this.nx;
                    ys = index / this.nx;
                    this.cost[t][x][y] = pix[x][y] * norm + mapCenter[x][y] + mapMove[xs - x + delta][ys - y + delta];
                    ++x;
                }
                ++y;
            }
            x = 0;
            while (x < this.nx) {
                int y3 = 0;
                while (y3 < this.ny) {
                    previousCost[x][y3] = currentCost[x][y3];
                    ++y3;
                }
                ++x;
            }
            --t;
        }
        double max = -1.7976931348623157E308;
        int x = 0;
        while (x < this.nx) {
            int y = 0;
            while (y < this.ny) {
                if (currentCost[x][y] > max) {
                    max = currentCost[x][y];
                    index = x + y * this.nx;
                }
                ++y;
            }
            ++x;
        }
        int t3 = t2;
        while (t3 <= t1) {
            xs = index % this.nx;
            ys = index / this.nx;
            xs = xs < this.handler.X1Enveloppe[t3] ? this.handler.X1Enveloppe[t3] : xs;
            ys = ys < this.handler.Y1Enveloppe[t3] ? this.handler.Y1Enveloppe[t3] : ys;
            xs = xs > this.handler.X2Enveloppe[t3] ? this.handler.X2Enveloppe[t3] : xs;
            ys = ys > this.handler.Y2Enveloppe[t3] ? this.handler.Y2Enveloppe[t3] : ys;
            this.handler.xspot[t3] = xs;
            this.handler.yspot[t3] = ys;
            index = this.pos[t3][xs][ys];
            int v = this.round(this.cost[t3][xs][ys] * 100.0 / this.normv);
            v = v < 0 ? 0 : v;
            this.handler.vspot[t3] = v > 100 ? 100 : v;
            ++t3;
        }
    }

    private boolean checkProfile(boolean[] profile, PointTrack start, PointTrack end) {
        int k = start.t;
        while (k < end.t) {
            if (profile[k]) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private boolean checkNodeConsistency(int delta, PointTrack start, PointTrack end) {
        int dx = Math.abs(start.x - end.x);
        int dy = Math.abs(start.y - end.y);
        int dt = Math.abs(start.t - end.t);
        if (dt <= 0) {
            return false;
        }
        if ((double)dx / (double)dt > (double)delta) {
            return false;
        }
        return !((double)dy / (double)dt > (double)delta);
    }

    private void createEnveloppeForward(int delta, boolean openCone, PointTrack start, PointTrack end) {
        int limit = 0;
        double nx2 = (double)this.nx / 2.0;
        double ny2 = (double)this.ny / 2.0;
        int t = start.t;
        while (t <= end.t) {
            this.handler.X1Enveloppe[t] = start.x - (t - start.t) * delta;
            this.handler.Y1Enveloppe[t] = start.y - (t - start.t) * delta;
            this.handler.X2Enveloppe[t] = start.x + (t - start.t) * delta;
            this.handler.Y2Enveloppe[t] = start.y + (t - start.t) * delta;
            if (!openCone) {
                int X1aux = end.x - (end.t - t) * delta;
                int Y1aux = end.y - (end.t - t) * delta;
                int X2aux = end.x + (end.t - t) * delta;
                int Y2aux = end.y + (end.t - t) * delta;
                this.handler.X1Enveloppe[t] = this.handler.X1Enveloppe[t] > X1aux ? this.handler.X1Enveloppe[t] : X1aux;
                this.handler.Y1Enveloppe[t] = this.handler.Y1Enveloppe[t] > Y1aux ? this.handler.Y1Enveloppe[t] : Y1aux;
                this.handler.X2Enveloppe[t] = this.handler.X2Enveloppe[t] < X2aux ? this.handler.X2Enveloppe[t] : X2aux;
                this.handler.Y2Enveloppe[t] = this.handler.Y2Enveloppe[t] < Y2aux ? this.handler.Y2Enveloppe[t] : Y2aux;
            }
            limit = this.round(nx2 - this.handler.nucleus[t][3] - 0.5);
            this.handler.X1Enveloppe[t] = this.handler.X1Enveloppe[t] < limit ? limit : this.handler.X1Enveloppe[t];
            limit = this.round(ny2 - this.handler.nucleus[t][4] - 0.5);
            this.handler.Y1Enveloppe[t] = this.handler.Y1Enveloppe[t] < limit ? limit : this.handler.Y1Enveloppe[t];
            limit = this.round(nx2 + this.handler.nucleus[t][3] + 0.5);
            this.handler.X2Enveloppe[t] = this.handler.X2Enveloppe[t] >= limit ? limit : this.handler.X2Enveloppe[t];
            limit = this.round(ny2 + this.handler.nucleus[t][4] + 0.5);
            this.handler.Y2Enveloppe[t] = this.handler.Y2Enveloppe[t] >= limit ? limit : this.handler.Y2Enveloppe[t];
            ++t;
        }
    }

    private void createEnveloppeBackward(int delta, PointTrack start, PointTrack end) {
        int limit = 0;
        double nx2 = (double)this.nx / 2.0;
        double ny2 = (double)this.ny / 2.0;
        int t = end.t;
        while (t >= start.t) {
            this.handler.X1Enveloppe[t] = end.x - (end.t - t) * delta;
            this.handler.Y1Enveloppe[t] = end.y - (end.t - t) * delta;
            this.handler.X2Enveloppe[t] = end.x + (end.t - t) * delta;
            this.handler.Y2Enveloppe[t] = end.y + (end.t - t) * delta;
            limit = this.round(nx2 - this.handler.nucleus[t][3] - 0.5);
            this.handler.X1Enveloppe[t] = this.handler.X1Enveloppe[t] < limit ? limit : this.handler.X1Enveloppe[t];
            limit = this.round(ny2 - this.handler.nucleus[t][4] - 0.5);
            this.handler.Y1Enveloppe[t] = this.handler.Y1Enveloppe[t] < limit ? limit : this.handler.Y1Enveloppe[t];
            limit = this.round(nx2 + this.handler.nucleus[t][3] + 0.5);
            this.handler.X2Enveloppe[t] = this.handler.X2Enveloppe[t] >= limit ? limit : this.handler.X2Enveloppe[t];
            limit = this.round(ny2 + this.handler.nucleus[t][4] + 0.5);
            this.handler.Y2Enveloppe[t] = this.handler.Y2Enveloppe[t] >= limit ? limit : this.handler.Y2Enveloppe[t];
            --t;
        }
    }

    private boolean[] defineTrackingProfile(boolean flagRetrack, Vector node) {
        int t;
        boolean[] profile = new boolean[this.nt];
        if (flagRetrack) {
            int t2 = 0;
            while (t2 < this.nt) {
                profile[t2] = true;
                ++t2;
            }
            return profile;
        }
        Point[][] current = new Point[this.nt][2];
        PointTrack first = (PointTrack)node.elementAt(0);
        int t3 = 0;
        while (t3 < first.t) {
            current[t3][0] = new Point(-1, -1);
            current[t3][1] = new Point(first.x, first.y);
            ++t3;
        }
        int c = 0;
        while (c < node.size() - 1) {
            PointTrack p1 = (PointTrack)node.elementAt(c);
            PointTrack p2 = (PointTrack)node.elementAt(c + 1);
            t = p1.t;
            while (t < p2.t) {
                current[t][0] = new Point(p1.x, p1.y);
                current[t][1] = new Point(p2.x, p2.y);
                ++t;
            }
            ++c;
        }
        PointTrack last = (PointTrack)node.elementAt(node.size() - 1);
        int t4 = last.t;
        while (t4 < this.nt) {
            current[t4][0] = new Point(last.x, last.y);
            current[t4][1] = new Point(-1, -1);
            ++t4;
        }
        if (this.firstCall) {
            t = 0;
            while (t < this.nt) {
                this.range[t][0] = new Point(current[t][0]);
                this.range[t][1] = new Point(current[t][1]);
                profile[t] = true;
                ++t;
            }
            this.firstCall = false;
        } else {
            t = 0;
            while (t < this.nt) {
                profile[t] = !current[t][0].equals(this.range[t][0]) || !current[t][1].equals(this.range[t][1]);
                this.range[t][0].x = current[t][0].x;
                this.range[t][0].y = current[t][0].y;
                this.range[t][1].x = current[t][1].x;
                this.range[t][1].y = current[t][1].y;
                ++t;
            }
        }
        return profile;
    }

    private double[][] createMovementMap(double constraintMovement, int delta) {
        double[][] mapMove = new double[delta * 2 + 1][delta * 2 + 1];
        double cm = (double)delta * Math.sqrt(2.0);
        int i = -delta;
        while (i <= delta) {
            int j = -delta;
            while (j <= delta) {
                mapMove[i + delta][j + delta] = constraintMovement * (1.0 - Math.sqrt(Math.pow(i, 2.0) + Math.pow(j, 2.0)) / cm);
                ++j;
            }
            ++i;
        }
        return mapMove;
    }

    private double[][] createCenterMap(double constraintCenter) {
        int nx2 = this.nx / 2;
        int ny2 = this.ny / 2;
        double[][] mapCenter = new double[2 * nx2 + 1][2 * ny2 + 1];
        double cc = (double)nx2 * Math.sqrt(2.0);
        int i = -nx2;
        while (i <= nx2) {
            int j = -ny2;
            while (j <= ny2) {
                mapCenter[i + nx2][j + ny2] = constraintCenter * (1.0 - Math.sqrt(Math.pow(i, 2.0) + Math.pow(j, 2.0)) / cc);
                ++j;
            }
            ++i;
        }
        return mapCenter;
    }

    private void refinePosition(Vector node) {
        double[][] n33 = new double[5][5];
        boolean nodet = false;
        int t = 0;
        while (t < this.nt) {
            int xs = this.round(this.handler.xspot[t]);
            int ys = this.round(this.handler.yspot[t]);
            float[] p = new float[2];
            int x = xs - 2;
            int y = ys - 2;
            nodet = false;
            int i = 0;
            while (i < node.size()) {
                PointTrack pt = (PointTrack)node.elementAt(i);
                if (pt.t == t) {
                    nodet = true;
                }
                ++i;
            }
            if (!nodet) {
                this.input.getBoundedXY(x, y, t, n33);
                double xg = 0.0;
                double yg = 0.0;
                double ng = 0.0;
                double min = Double.MAX_VALUE;
                int i2 = 0;
                while (i2 <= 4) {
                    int j = 0;
                    while (j <= 4) {
                        if (n33[i2][j] < min) {
                            min = n33[i2][j];
                        }
                        ++j;
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 <= 4) {
                    int j = 0;
                    while (j <= 4) {
                        double n = n33[i3][j] - min;
                        xg += n * (double)(xs + i3);
                        yg += n * (double)(ys + j);
                        ng += n;
                        ++j;
                    }
                    ++i3;
                }
                if (ng > 0.0) {
                    this.handler.xspot[t] = (float)(xg / ng) - 1.5f;
                    this.handler.yspot[t] = (float)(yg / ng) - 1.5f;
                }
            } else {
                int n = t;
                this.handler.xspot[n] = (float)((double)this.handler.xspot[n] + 0.5);
                int n2 = t;
                this.handler.yspot[n2] = (float)((double)this.handler.yspot[n2] + 0.5);
            }
            ++t;
        }
    }

    private int round(double f) {
        double f05 = f + 0.5;
        if (f05 >= 0.0) {
            return (int)f05;
        }
        int iAdd = (int)f05 - 1;
        return (int)(f05 - (double)iAdd) + iAdd;
    }
}

