package ExcelInterface;

/*
 * SaveToExcel.java
 *
 * Created on 09 October 2003, 14:58
 */
import ij.*;
import ij.text.*;
import ij.measure.*;
import ij.io.*;
import ij.gui.*;

import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.poifs.filesystem.*;

import java.io.*;

//import javax.swing.*;

import IJUtilities.*;

/** This class saves IJ results to Excel format.
 * @author KURT DE VOS (Kurt dot De dot Vos at man dot ac dot uk)
 * @version 1.4
 * @deprecated This class will be replaced by the methods in HSSFIO and HSSFWriteUtils
 *  Only used now to allow direct writing of the results table to excel
 *  For any other application use the HSSFIO and HSSFWriteUtils
 */

public class SaveToExcel {
    
    private boolean debug = true;
    
    private FileOutputStream out;
    private HSSFWorkbook wb;
    private HSSFSheet s;
    private HSSFRow r;
    private HSSFCell c;
    
    private String filePath = null; //Path to Excel File
    
    private static final String FILE_SEPARATOR = System.getProperty("file.separator"); // system independent file separator
    
    private static String DEFAULT_PATH = Prefs.getHomeDir()+FILE_SEPARATOR; // IJ dir
   
    /** Creates a new instance of SaveToExcel
     */
    public SaveToExcel() {
    }
    
    /** Initialization: Get and Check File Path and Load Existing Workbook
     * or create New Workbook, and create a New Sheet accordingly
     * @return true if successfull
     */
    private boolean initializeExcel(){
        if  (filePath == null)
            filePath = getFileName_classic(); // get path from FileChooser built into IJ (recordable)
        //filePath = getFileName(); // get path from JFileChooser
        if (filePath == ""){ // no path when input is canceled :: Abort
            IJ.error("You Need to Specfify a Valid Path");
            return false;
        }else{ // path ok
            return initializeHSSF(); // load or create workbook and create  a new worksheet
        }
    } // initializeExcel()
    
    /** Initialization: Load Existing Workbook
     * or create New Workbook,
     * and create a New WorkSheet in the workbook
     * @return true is success, defaults to false
     */
    private boolean  initializeHSSF(){
        if (checkFile(filePath)){ // if the file exist...
            try{ // we will try to load it...
                POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(filePath)); // load file
                wb = new HSSFWorkbook(fs); // load the workbook
            }catch(IOException ioE){
                System.out.println(ioE.getMessage());
                System.out.println("File Not Found, Or No ExcelFile");
            }
            int sheets = wb.getNumberOfSheets();
            if (debug)
                System.out.println("sheets: "+sheets);
            if (workSheetChoice()) {
                s = wb.createSheet("IJResults"+(sheets+1)); // now make a new worksheet
            }
            else{
                String[] wsList = wsList(wb);
                GenericDialog dg = new GenericDialog("Choose WorkSheet");
                dg.addChoice("Work Sheets",  wsList, wsList[0]);
                dg.showDialog();
                if (dg.wasCanceled()) return false;
                int wsID = dg.getNextChoiceIndex();
                
                try{
                    s = wb.getSheetAt(wsID);
                }catch(Exception e){
                    System.out.println(e.getMessage());
                }
            }
        }
        else{ // if the file does not exist...
            wb = new HSSFWorkbook(); // we create a new file
            if (debug)
                System.out.println("new HSSFWorkbook()");
            int sheets = wb.getNumberOfSheets();
            s = wb.createSheet("IJResults"+(sheets+1)); // now make a new worksheet
            if (debug)
                System.out.println("new HSSFSheet @ "+(sheets+1));
        }
        
        if (wb != null && s != null){
            if (debug){
                System.out.println("Sheets: "+wb.getNumberOfSheets());
                System.out.println("HSSF Initialized as: " + filePath );
            }
            return true;
        }
        
        return false;
    } // initializeHSSF()
    
    
    public void writeRsTable(ResultsTable rt){
        
        if (initializeExcel()){
           
            r = s.createRow((short)(0));
            c = r.createCell((short)(r.getLastCellNum()+1)); // workaround for first blank column heading
            c.setCellValue("Count");
            c.setCellStyle(headingCellStyle());
            if (debug){
                System.out.println("Count written");
            }
            /* Write the Column Headers */
            String headings = rt.getColumnHeadings(); // get the column headings
            if (debug){
                System.out.println("headings: "+headings.toString());
            }
            String[] headArray = new StringUtils().split(headings); // parse the headings to an array
            if (s.getRow(0) == null)
                r = s.createRow((short)(0)); // create a row to contain the headings
            
            for (short cellnum = (short) 0; cellnum < headArray.length; cellnum++){
                try{
                    c = r.createCell((short)(r.getLastCellNum()+1));
                    c.setCellValue(headArray[cellnum]);
                    c.setCellStyle(headingCellStyle());
                }catch(Exception e){
                    System.out.println(e.getMessage());
                }
            }
            /* Write the Data */
            for (short rownum = (short) 0; rownum < rt.getCounter(); rownum++){
                String data = rt.getRowAsString(rownum); // get the data
                if (debug){
                    System.out.println("data: row:"+rownum+" data: "+data.toString());
                }
                int row = s.getLastRowNum();
                r = s.createRow((short)(row+1));
                r.setRowNum((short)(row+1));
                
                String[] dataTextArray = new StringUtils().split(data); // parse the data to an array
                for (short cellnum = (short) 0; cellnum < dataTextArray.length; cellnum++){
                    c = r.createCell((short)(r.getLastCellNum()+1));
                    try{
                        float value = Float.parseFloat(dataTextArray[cellnum]); // try to convert string to float
                        c.setCellValue(value); // if it is a float write it
                    } catch(Exception e){
                        System.out.println("Float error " +e.getMessage());
                        c.setCellValue(dataTextArray[cellnum]); // in case it is no number the try{} jumps here and writes the non-Float
                    }
                }
            }
            if (debug){
                System.out.println("Data written");
            }
            try{
                out = new FileOutputStream(filePath);
                wb.write(out);
                System.out.println("Saved: "+ filePath);
            }catch(IOException ioE){
                System.out.println("filepath exception "+ filePath);
                System.out.println(ioE.getMessage());
                IJ.error("You Need to Specify a Valid Path \n Save not Possible"); // should not happen
            }
        }
    } // writeResultsTableToExcel(ResultsTable rt)
    
    private boolean checkFile(String p){ // does the file exist ?
        return new File(p).isFile();
    } // checkFile(String path)
    
    private String getFileName_classic(){
        SaveDialog sd = new SaveDialog("Select...","Result",".xls");
        String p = sd.getDirectory()+FILE_SEPARATOR+sd.getFileName();
        if (!(p.endsWith(".xls") | p.endsWith(".XLS")) ) // check for extension
            p +=".xls"; //add extension if it was not given as input
        DEFAULT_PATH = sd.getDirectory();
        return p;
    } // getFileName()
    
    /** Style for Headers - Bold, Centered
     * @return returns a HSSFCellStyle
     */
    private HSSFCellStyle headingCellStyle(){
        HSSFFont font = wb.createFont(); // defaults to Arial on windows
        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD); // bold
        HSSFCellStyle style = wb.createCellStyle(); // make style
        style.setFont(font); // set font
        style.setAlignment(HSSFCellStyle.ALIGN_CENTER); // set alignment to centered
        return style;
    } // headingCellStyle()
    
   private boolean workSheetChoice(){
        YesNoCancelDialog YNCdg = new YesNoCancelDialog(IJ.getInstance(), " New Worksheet" , "Do you want to create a new worksheet?");
        if (YNCdg.yesPressed()) return true;
        return false;
    }
    
    private String[] wsList(HSSFWorkbook wb){
        String[] str = new String[wb.getNumberOfSheets()];
        for (int i=0; i<wb.getNumberOfSheets(); i++){
            str[i] = wb.getSheetName(i);
        }
        return str;
    }
    
    
} // SaveToExcel.class
