/*
 * Excel_Writer_ToolBar.java
 *
 * Created on 04 December 2003, 12:33
 */
import ij.*;
import ij.gui.*;
import ij.plugin.frame.*;
import ij.measure.*;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import org.apache.poi.hssf.usermodel.*;

import ExcelInterface.*;
import HSSFViewer.*;

/** This class is a ImageJ Plugin that generates a gui for
 * HSSFIO.class and HSSFWriteUtils.class
 * @author KURT DE VOS
 */
public class Excel_Writer_GUI extends PlugInFrame implements ActionListener{
    /** Reference to SviewerPanel that will show the Excel File
     * @see SViewerPanel.class
     * Part of the SViewer contribution to Jakarta POI
     */
    private SViewerPanel p;
    /** Reference to parent frame of gui */
    private JFrame frame;
    /** Refenence to toolbar */
    private JToolBar toolBar;
    /** JLabel to contain status messages */
    private JLabel statusBar;
    /** JButtons that make up gui */
    private JButton button1, button2, button3, button4, button5, button6, button7, button8, button9, button10,
    button20, button21, button22, button23;
    /** JMenuBar to contain the menus of the gui */
    private JMenuBar menuBar;
    /** JMenu subunits of menuBar */
    private JMenu menuFile, menuEdit, menuSheet, menuWrite, menuDelete;
    /** JMenuItem subunits of JMenu */
    private JMenuItem menuFileNew, menuFileOpen, menuFileSave, menuFileClose, menuFileExit,
    menuSheetAdd, menuSheetDel, menuSheetRename, menuSheetSelect,
    menuWriteRT, menuWriteRow, menuWriteColumn, menuWriteHeads, menuWriteClip,
    menuDeleteLastRow, menuDeleteCol;
    /** JPanels */
    private JPanel JTopPanel, JViewerPanel;
    /** Base String of status messages */
    private final String SB_BASE_TEXT = "  Status: ";
    /** Reference to name of active file */
    private String activeFile;
    /** Reference to name of active sheet */
    private String  activeSheet;
    /** Instance of HSSFIO needed for IO Functions */
    private HSSFIO io = null;
    /** Instance of HSSFWriteUtils needed for data writing */
    private HSSFWriteUtils wu = null;
    /** reference to HSSFWorkbook */
    private HSSFWorkbook wb;
    /** reference to HSSFSheet */
    private HSSFSheet s;
    
    /** Constructor: Creates a new instance of Excel_Writer_ToolBar */
    public Excel_Writer_GUI() {
        super("Excel Writer");
        try {
            //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
        buildGUI();
    } // end of Excel_Writer_GUI()
    
    /** Run method to execute the plugin
     * @param arg
     */
    public void run(String arg){
        GUI.center(this);
        toFront();
    } // the run method that starts of the plugin
    
    /** Create the GUI */
    private void buildGUI(){
        frame = new JFrame("Excel Writer"); // main frame
        frame.setDefaultCloseOperation(frame.DISPOSE_ON_CLOSE);
        frame.setResizable(false);
        frame.getContentPane().setLayout(new BorderLayout());
        
        JTopPanel = makeTopPanel();
        JViewerPanel = new JPanel();
        
        frame.getContentPane().add(JTopPanel, BorderLayout.NORTH);
        frame.pack();
        frame.setIconImage(this.getImageIcon("excel.gif").getImage()); // setting the icon of the main frame
        frame.setVisible(true);
        System.out.println("components: "+frame.getComponentCount());
    } // end of buildGUI()
    
    /** Create JMenubar
     * @return JMenuBar
     */
    private JMenuBar makeMenuBar(){
        menuBar = new JMenuBar();
        //File menu
        menuFile = new JMenu("File");
        menuFile.setMnemonic(KeyEvent.VK_F);
        menuBar.add(menuFile);
        menuFileNew = CreateMenuItem( menuFile, "New", null, KeyEvent.VK_N,  null);
        menuFileOpen = CreateMenuItem( menuFile, "Open...", null, KeyEvent.VK_O,  "Open Excel File...");
        menuFileSave = CreateMenuItem( menuFile, "Save", null, KeyEvent.VK_S, " Save Excel File...");
        menuFileClose = CreateMenuItem( menuFile, "Close", null, KeyEvent.VK_C, " Close Excel File...");
        menuFileExit = CreateMenuItem( menuFile, "Exit", null, KeyEvent.VK_E, null);
        // Sheet menu
        menuSheet = new JMenu("Sheet");
        menuSheet.setMnemonic(KeyEvent.VK_S);
        menuBar.add(menuSheet);
        menuSheetAdd = CreateMenuItem(menuSheet, "Add...", null, KeyEvent.VK_A,  "Add WorkSheet...");
        menuSheetDel = CreateMenuItem(menuSheet, "Delete...", null, KeyEvent.VK_D,  "Delete WorkSheet...");
        menuSheetRename = CreateMenuItem(menuSheet, "Rename...", null, KeyEvent.VK_R,  "Rename WorkSheet...");
        menuSheetSelect = CreateMenuItem(menuSheet, "Select...", null , KeyEvent.VK_S,  "Select WorkSheet...");
        // Write menu
        menuWrite = new JMenu("Write");
        menuWrite.setMnemonic(KeyEvent.VK_W);
        menuBar.add(menuWrite);
        menuWriteRT = CreateMenuItem(menuWrite, "ResultTable...", null, KeyEvent.VK_R,  "Write ResultsTable...");
        menuWriteHeads = CreateMenuItem(menuWrite, "Headings...", null, KeyEvent.VK_H,  "Write Headings...");
        menuWriteRow = CreateMenuItem(menuWrite, "Last Row...", null, KeyEvent.VK_L,  "Write Last Row..." );
        menuWriteColumn = CreateMenuItem(menuWrite, "Column...", null, KeyEvent.VK_C,  "Write Column...");
        menuWriteClip = CreateMenuItem(menuWrite, "ClipBoard...", null, KeyEvent.VK_I,  "Write ClipBoard...");
        // Delete Menu
        menuDelete = new JMenu("Delete");
        menuDelete.setMnemonic(KeyEvent.VK_D);
        menuBar.add(menuDelete);
        menuDeleteLastRow = CreateMenuItem(menuDelete, "Last Row...", null, KeyEvent.VK_R,  "Delete Last Row...");
        menuDeleteCol = CreateMenuItem(menuDelete, "Column...", null, KeyEvent.VK_C,  "Delete Column...");
        
        return menuBar;
    } // end of makeMenuBar()
    
    /** Creates a JMenuItem
     * adds it to a JMenuBar
     * sets the Icon
     * sets the ToolTip
     * @param menu JMenuBar
     * @param sText description
     * @param image Icon
     * @param key Mnemonic
     * @param sToolTip ToolTip
     * @return JMenuItem
     */
    private JMenuItem CreateMenuItem(JMenu menu,  String sText, ImageIcon image, int key, String sToolTip) {
        JMenuItem menuItem =  new JMenuItem();
        menuItem.setText(sText);
        if (image != null)
            menuItem.setIcon(image);
        if (key > 0)
            menuItem.setMnemonic(key);
        if (sToolTip != null)
            menuItem.setToolTipText(sToolTip);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuItem;
    } //end of CreateMenuItem(JMenu menu,  String sText, ImageIcon image, int key, String sToolTip)
    
    /** Status bar
     * @return JLabel
     */
    private JLabel makeStatusBar(){
        statusBar = new JLabel("");
        statusBar.setText(SB_BASE_TEXT);
        return statusBar;
    } // end of makeStatusBar()
    
    /** creates JToolBar
     * @return JToolBar
     */
    private JToolBar makeToolBar(){
        JToolBar toolBar = new JToolBar(); // will contain the buttons
        int iconSize = 24;
        toolBar.setOrientation(JToolBar.HORIZONTAL);
        toolBar.setFloatable(false);
        button1 = makeJButton(toolBar, this.getImageIcon("New"+iconSize+".gif"), "New Excel File..."); // create File
        button2= makeJButton(toolBar, this.getImageIcon("Open"+iconSize+".gif"),"Open Excel File..."); // Select File
        button3= makeJButton(toolBar, this.getImageIcon("Save"+iconSize+".gif"), "Save Excel File..."); // save
        //button4=makeJButton(toolBar, this.getImageIcon("Close"+iconSize+".gif"), "Close Excel File..."); // Close
        toolBar.addSeparator();
        button20 = makeJButton(toolBar, this.getImageIcon("Excelsheet"+iconSize+".gif"), "Add WorkSheet..."); // add worksheet
        button21 = makeJButton(toolBar, this.getImageIcon("Delete"+iconSize+".gif"), "Delete WorkSheet..."); // delete worksheet
        toolBar.addSeparator();
        button5 = makeJButton(toolBar, this.getImageIcon("SaveAs"+iconSize+".gif"), "Write ResultsTable..."); // write RT
        button6 = makeJButton(toolBar, this.getImageIcon("RowInsertBefore"+iconSize+".gif"),"Write Column Headings..."); // write headings
        button7 = makeJButton(toolBar, this.getImageIcon("RowInsertAfter"+iconSize+".gif"),"Append Last Measurement..."); // Append row
        button8 = makeJButton(toolBar, this.getImageIcon("RowDelete"+iconSize+".gif"),"Delete Last Row..."); // delete row
        button9 = makeJButton(toolBar, this.getImageIcon("ColumnInsertAfter"+iconSize+".gif"), "Write Column..."); // write column
        button10 = makeJButton(toolBar, this.getImageIcon("ColumnDelete"+iconSize+".gif"), "Delete Last Column..."); // delete column
        return toolBar;
    } // end of  makeToolBar()
    
    /** creates a JButton
     * adds it to a JToolBar
     * sets the Icon
     * sets the ToolTip
     * @param toolBar JToolBar
     * @param image Icon
     * @param sToolTip ToolTip
     * @return JButton
     */
    private JButton makeJButton(JToolBar toolBar, ImageIcon image, String sToolTip){
        JButton button = null;
        if (image != null){
            button = new JButton(image);
        }
        else  button = new JButton();
        button.setToolTipText(sToolTip);
        button.addActionListener(this);
        toolBar.add(button);
        return button;
    } // end of makeJButton(JToolBar toolBar, ImageIcon image, String sToolTip)
    
    /** Method to make a panel containing the menu and toolbar
     * @return the panel
     */
    private JPanel makeTopPanel(){
        JTopPanel = new JPanel(new BorderLayout());
        JTopPanel.add(makeMenuBar(), BorderLayout.NORTH);
        JTopPanel.add(makeToolBar(), BorderLayout.CENTER);
        JTopPanel.add(makeStatusBar(), BorderLayout.SOUTH);
        return JTopPanel;
    } // end of  makeTopPanel()
    
    /** Method to fill the viewerPanel with the representation
     * of the excel file
     */
    private void createViewerPanel(){
        JViewerPanel.removeAll();
        frame.remove((Component)(JViewerPanel));
        System.out.println("components: "+frame.getComponentCount());
        p = new SViewerPanel(wb, true);
        try{
            p.selectTab(io.getActiveSheetIndex());
        }catch(Exception e){
            System.out.println(e.getMessage());
        }
        JViewerPanel.add(p);
        frame.getContentPane().add(JViewerPanel, BorderLayout.CENTER);
        frame.pack();
        setFrameTitle();
        System.out.println("components: "+frame.getComponentCount());
    } // end of createViewerPanel()
    
    /** Method to get the name of the active sheet
     * @return active sheet
     */
    private String getActiveSheet(){
        if (io != null)
            activeSheet = io.sheetName;
        else activeSheet = "";
        return activeSheet;
    } // end of getActiveSheet()
    
    /** Method to get the name of the active file
     * @return file name
     */
    private String getActiveFile(){
        if (io != null){
            String filePath = io.getFilePath();
            activeFile = filePath.substring(filePath.lastIndexOf(System.getProperty("file.separator"))+1);
        }
        else activeFile = "";
        return activeFile;
    } // end of getActiveFile()
    
    /** updates the title of the frame to include the
     * active file and sheet name
     */
    private void setFrameTitle(){
        String fileName=getActiveFile();
        String sheetName=getActiveSheet();
        if (fileName==null){
            fileName="";
            sheetName="";
        }
        frame.setTitle("Excel Writer: "+fileName+":"+sheetName);
    } // end of setFrameTitle()
    
    private static final int FILE_NEW = 1, FILE_OPEN =2, FILE_SAVE = 3, FILE_EXIT = 4, FILE_CLOSE = 5;
    private void ioActions(int action){
        switch(action){
            case FILE_NEW:
                io = new HSSFIO();
                statusBar.setText(SB_BASE_TEXT+"Creating File...");
                io.createExcelFile();
                initWriteUtils();
                createViewerPanel();
                statusBar.setText(SB_BASE_TEXT+"Creating File... Done");
                break;
            case FILE_OPEN:
                io = new HSSFIO();
                statusBar.setText(SB_BASE_TEXT+"Loading File...");
                io.loadExcelFile();
                initWriteUtils();
                createViewerPanel();
                statusBar.setText(SB_BASE_TEXT+"Loading File... Done");
                break;
            case FILE_SAVE:
                if (HSSFIOExists()){
                    statusBar.setText(SB_BASE_TEXT+"Saving File...");
                    io.saveExcel();
                    setFrameTitle();
                    statusBar.setText(SB_BASE_TEXT+"Saving File... Done");
                    isChanged = false;
                }
                else IJ.error("you have to load/create a file first");
                break;
            case FILE_EXIT:
                frame.dispose();
                break;
            case FILE_CLOSE:
                if (HSSFIOExists()){
                    statusBar.setText(SB_BASE_TEXT+"Closing File...");
                    JViewerPanel.removeAll();
                    io.closeExcelFile();
                    this.wb = io.wb;
                    setFrameTitle();
                    statusBar.setText(SB_BASE_TEXT+"Closing File... Done");
                }
                break;
        }
    }
    
    /** initializes writeUtils to write the data to a sheet */
    private void initWriteUtils(){
        this.wb = io.wb;
        this.s = io.s;
        wu = new HSSFWriteUtils();
        wu.setWb(wb);
        wu.setSheet(s);
    } // end of initWriteUtils()
    
    private static final int WRITE_TABLE = 1, WRITE_HEADINGS = 2, WRITE_ROW = 3, WRITE_COLUMN = 4;
    private void writeActions(int action){
        isChanged = true;
        ResultsTable rt = null;
        try{
            rt = ResultsTable.getResultsTable();
        }catch(Exception ex){
            System.out.println(ex.getMessage());
        }
        if (HSSFIOExists() && (rt !=null)){
            switch(action){
                case WRITE_TABLE:
                    statusBar.setText(SB_BASE_TEXT+"Writing Table...");
                    wu.writeRsTable(rt);
                    createViewerPanel();
                    statusBar.setText(SB_BASE_TEXT+"Writing Table... Done");
                    break;
                case WRITE_HEADINGS:
                    statusBar.setText(SB_BASE_TEXT+"Writing Headings...");
                    wu.writeColumnHeadings("Counter "+rt.getColumnHeadings());
                    createViewerPanel();
                    statusBar.setText(SB_BASE_TEXT+"Writing Headings... Done");
                    break;
                case WRITE_ROW:
                    statusBar.setText(SB_BASE_TEXT+"Writing Row...");
                    wu.appendLastLine(rt.getRowAsString(rt.getCounter()-1));
                    createViewerPanel();
                    statusBar.setText(SB_BASE_TEXT+"Writing Row... Done");
                    break;
                case WRITE_COLUMN:
                    statusBar.setText(SB_BASE_TEXT+"Writing Column...");
                    wu.writeOneColumn(rt);
                    setFrameTitle();
                    statusBar.setText(SB_BASE_TEXT+"Writing Column... Done");
                    break;
            }
        }
        else IJ.error("you have to load/create a file first \n ResultsTable needed");
    } // end of writeActions(int action)
    
    private void actionWriteClip(){
        isChanged = true;
        if (HSSFIOExists()){
            statusBar.setText(SB_BASE_TEXT+"Writing ClipBoard...");
            wu.writeFromClipboard();
            createViewerPanel();
            statusBar.setText(SB_BASE_TEXT+"Writing ClipBoard... Done");
        }
        else IJ.error("you have to load/create a file first");
    } // end of actionWriteClip()
    
    private static final int DELETE_ROW = 1, DELETE_COLUMN = 2;
    private void deleteActions(int action){
        isChanged = true;
        switch(action){
            case DELETE_ROW:
                if (HSSFIOExists()){
                    statusBar.setText(SB_BASE_TEXT+"Deleting Row...");
                    wu.deleteLastRow();
                    createViewerPanel();
                    statusBar.setText(SB_BASE_TEXT+"Deleting Row... Done");
                }
                else IJ.error("you have to load/create a file first");
                break;
            case DELETE_COLUMN:
                ResultsTable rt = null;
                try{
                    rt = ResultsTable.getResultsTable();
                }catch(Exception ex){
                    System.out.println(ex.getMessage());
                }
                if (HSSFIOExists()){
                    statusBar.setText(SB_BASE_TEXT+"Deleting Column...");
                    wu.deleteOneColumn(rt);
                    createViewerPanel();
                    statusBar.setText(SB_BASE_TEXT+"Deleting Column... Done");
                }
                else IJ.error("you have to load/create a file first \n ResultsTable needed");
                break;
        }
    } // end of deleteActions(int action)
    
    private static final int SHEET_ADD = 1, SHEET_DELETE = 2, SHEET_RENAME = 3, SHEET_SELECT = 4;
    private void sheetActions(int action){
        isChanged = true;
        if (HSSFIOExists()){
            switch(action){
                case SHEET_ADD:
                    statusBar.setText(SB_BASE_TEXT+"Adding Worksheet...");
                    io.addWorkSheet();
                    this.s = io.s;
                    wu.setSheet(s);
                    createViewerPanel();
                    statusBar.setText(SB_BASE_TEXT+"Adding Worksheet... Done");
                    break;
                case SHEET_DELETE:
                    statusBar.setText(SB_BASE_TEXT+"Deleting Worksheet...");
                    io.deleteWorkSheet();
                    io.selectActiveSheet();
                    this.s = io.s;
                    wu.setSheet(s);
                    createViewerPanel();
                    statusBar.setText(SB_BASE_TEXT+"Deleting Worksheet... Done");
                    break;
                case SHEET_RENAME:
                    statusBar.setText(SB_BASE_TEXT+"Renaming Worksheet...");
                    io.renameSheet();
                    this.s = io.s;
                    createViewerPanel();
                    statusBar.setText(SB_BASE_TEXT+"Renaming Worksheet... Done");
                    break;
                case SHEET_SELECT:
                    statusBar.setText(SB_BASE_TEXT+"Select Worksheet...");
                    io.selectActiveSheet();
                    this.s = io.s;
                    wu.setSheet(s);
                    p.selectTab(io.getActiveSheetIndex());
                    setFrameTitle();
                    statusBar.setText(SB_BASE_TEXT+"Select Worksheet... Done");
                    break;
            }
        }
        else IJ.error("you have to load/create a file first");
    } // end of sheetActions(int action)
    
    /** Contains the actions associated with the GUI
     * @param e ActionEvent
     */
    boolean isChanged = false;
    public void actionPerformed(ActionEvent e){
        Object obj = e.getSource();
        if (obj.equals(button1) | obj.equals(menuFileNew))
            ioActions(FILE_NEW); // create
        else if (obj.equals(button2) | obj.equals(menuFileOpen))
            ioActions(FILE_OPEN); // load
        else if (obj.equals(button3) | obj.equals(menuFileSave))
            ioActions(FILE_SAVE); //save
        else if (obj.equals(menuFileClose)){
            if (isChanged){
                int n = JOptionPane.showConfirmDialog(null, "Save...", "Save changes ?", JOptionPane.YES_NO_OPTION);
                if (n == JOptionPane.YES_OPTION)
                    ioActions(FILE_SAVE); //save
                else if (n == JOptionPane.NO_OPTION){}
            }
            ioActions(FILE_CLOSE);
        }
        else if (obj.equals(menuFileExit)){
            int n = JOptionPane.showConfirmDialog(null, "Exit...", "Do you want to exit?", JOptionPane.YES_NO_OPTION);
            if (n == JOptionPane.YES_OPTION){
                if (isChanged){
                    int s = JOptionPane.showConfirmDialog(null, "Save...", "Save changes ?", JOptionPane.YES_NO_OPTION);
                    if (s == JOptionPane.YES_OPTION)
                        ioActions(FILE_SAVE); //save
                    else if (s == JOptionPane.NO_OPTION){}
                }
                ioActions(FILE_EXIT); //exit
            }
            else if  (n == JOptionPane.YES_OPTION){
                return;
            }
        }
        else if (obj.equals(button5) | obj.equals(menuWriteRT))
            writeActions(WRITE_TABLE); // write table
        else if (obj.equals(button6) | obj.equals(menuWriteHeads))
            writeActions(WRITE_HEADINGS); //write headding
        else if (obj.equals(button7) | obj.equals(menuWriteRow))
            writeActions(WRITE_ROW); // write row
        else if (obj.equals(button8) | obj.equals(menuDeleteLastRow)){
            int n = JOptionPane.showConfirmDialog(null, "Delete...", "Are you sure?", JOptionPane.YES_NO_OPTION);
            if (n == JOptionPane.YES_OPTION){
                deleteActions(DELETE_ROW); //delete row
            }
            if (n == JOptionPane.NO_OPTION){
                return;
            }
        }
        else if (obj.equals(button9) | obj.equals(menuWriteColumn))
            writeActions(WRITE_COLUMN); // write column
        else if (obj.equals(button10) | obj.equals(menuDeleteCol)){
            int n = JOptionPane.showConfirmDialog(null, "Delete...", "Are you sure?", JOptionPane.YES_NO_OPTION);
            if (n == JOptionPane.YES_OPTION){
                deleteActions(DELETE_COLUMN); //delete column
            }
            if (n == JOptionPane.NO_OPTION){
                return;
            }
        }
        else if (obj.equals(menuWriteClip)) actionWriteClip(); // write clipboard
        else if (obj.equals(button20) | obj.equals(menuSheetAdd))
            sheetActions(SHEET_ADD); // Add worksheet
        else if (obj.equals(button21) | obj.equals(menuSheetDel)){
            int n = JOptionPane.showConfirmDialog(null, "Delete...", "Are you sure?", JOptionPane.YES_NO_OPTION);
            if (n == JOptionPane.YES_OPTION){
                sheetActions(SHEET_DELETE); //delete worksheet
            }
            if (n == JOptionPane.NO_OPTION){
                return;
            }
        }
        else if (obj.equals(button22) | obj.equals(menuSheetRename))
            sheetActions(SHEET_RENAME); // rename worksheet
        else if (obj.equals(button23) | obj.equals(menuSheetSelect))
            sheetActions(SHEET_SELECT); //Select worksheet
    } // end of actionPerformed(ActionEvent e)
    
    /** Create an Icon from an URL
     * @param iconName filename of icon file
     * @return ImageIcon
     */
    private ImageIcon getImageIcon(String iconName){ //gets icon from a file
        ImageIcon icon = null;
        java.net.URL imageURL = Excel_Writer_GUI.class.getResource("ExcelInterface/rsrc/"+iconName);
        try{
            if (imageURL != null) {
                icon = new ImageIcon(imageURL);
            }
        }catch (Exception e){
            System.out.println(e.getMessage());
        }
        return icon;
    } // end of getImageIcon(String iconName)
    
    /** Checks if an Excel file is loaded
     * @return returns true if the file exists
     * defaults to false
     */
    private boolean  HSSFIOExists(){
        if (io != null) return true;
        return false;
    } // end of HSSFIOExists()
    
} // Excel_Writer_GUI.class