/*
 * StringUtils.java
 *
 * Created on 10 October 2003, 15:53
 */

package IJUtilities;

import java.util.*;
/** Utilities for usage with Strings
 * @author KURT DE VOS
 */
public class StringUtils {
    
    /** Creates a new instance of StringUtils
     * 
     */
    public StringUtils() {
    }
    
    /** Splits a string in substrings separated by the given delimiter
     * @return returns String Array containing the substrings
     * @param str String to split
     * @param delim delimiter that separates substrings
     */    
    public String [] split(String str, String delim) {
        StringTokenizer t = new StringTokenizer(str, delim);
        int tokenNo = t.countTokens();
        String[] tokenArray=new String[tokenNo];
        int i=0;
        while (t.hasMoreTokens()){
            tokenArray[i] = t.nextToken(delim);
            i++;
        }
        return tokenArray;
    }
    
    /** Splits a String in substrings separated by white space
     * @param string String to split
     * @return String Array containing the substrings
     */    
    public String [] split(String string) {
        return split(string, " \t");
    }
    
}
