/*
 * XLSFileFilter.java
 *
 * Created on 15 October 2003, 08:44
 */

package ExcelInterface;

import java.io.*;

/**
 *
 * @author  KURT DE VOS
 */
/** Adapted from Java Tip 85: Fun and games with JFileChooser
 * FileFilter to select only Excel *.xls Files
 * Might be a problem for Apple Classic OS9 since there are no extensions ???
 * therefore i used   fc.addChoosableFileFilter(new  XlsFilter()); to retain *.* if neccessary
 * Have to check how HFFS loading acts in this case...
 **/
public class XlsFileFilter extends javax.swing.filechooser.FileFilter{
    
    public boolean accept(File f) {
        //if it is a directory -- we want to show it so return true.
        if (f.isDirectory()){
            return true;
        }
        //get the extension of the file
        String extension = getExtension(f);
        //check to see if the extension is equal to "xls"
        if (extension.equals("xls")){
            return true;
        }
        //default -- fall through. False is return on all
        //occasions except:
        //a) the file is a directory
        //b) the file's extension is what we are looking for.
        return false;
    } // accept(File f)
    
    public String getDescription() {
        return "Excel Files (*.xls)";
    } // getDescription()
    
    /**
     * Method to get the extension of the file, in lowercase
     */
    private String getExtension(File f) {
        String s = f.getName();
        int i = s.lastIndexOf('.');
        if (i > 0 &&  i < s.length() - 1){
            return s.substring(i+1).toLowerCase();
        }
        return "";
    } // getExtension(File f)
    
} //  XlsFilter.class
