
/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache POI" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache POI", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */


package HSSFViewer;

import java.util.Iterator;
import javax.swing.table.*;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFCell;

/**
 * Sheet Viewer Table Model - The model for the Sheet Viewer just overrides things.
 * @author Andrew C. Oliver
 */

public class SVTableModel extends AbstractTableModel {
    private HSSFSheet st = null;
    int maxcol = 0;
    
    public SVTableModel(HSSFSheet st, int maxcol) {
        this.st = st;
        this.maxcol=maxcol;
    }
    
    public SVTableModel(HSSFSheet st) {
        this.st = st;
        Iterator i = st.rowIterator();
        
        while (i.hasNext()) {
            HSSFRow row = (HSSFRow)i.next();
            if (maxcol < (row.getLastCellNum()+1)) {
                this.maxcol = row.getLastCellNum();
            }
        }
    }
    
    
    public int getColumnCount() {
        return this.maxcol+1;
    }
    public Object getValueAt(int row, int col) {
        HSSFRow r = st.getRow(row);
        HSSFCell c = null;
        if (r != null) {
            c = r.getCell((short)col);
        }
        return c;
    }
    public int getRowCount() {
        return st.getLastRowNum() + 1;
    }
    
    public Class getColumnClass(int c) {
        return HSSFCell.class;
    }
    
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }
    
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue != null){
            System.out.println("SVTableModel.setValueAt. value type = "+aValue.getClass().getName());
            HSSFRow r = st.getRow(rowIndex);
            HSSFCell c = null;
            if (r != null) {
                c = r.getCell((short)columnIndex);
                try{
                    float value = Float.parseFloat(aValue.toString()); // try to convert string to float
                    c.setCellValue(value); // if it is a float write it
                } catch(Exception e){
                    System.out.println("Float error " +e.getMessage());
                    c.setCellValue(aValue.toString()); // in case it is no number the try{} jumps here and writes the non-Float
                }
            }
        }
        else System.out.println("SVTableModel.setValueAt. value type = null");
    }
    
    
}
