/*
 * Save_XY_Coordinates_to_Excel.java
 *
 * Created on 08 January 2004, 09:51
 */
import ij.*;
import ij.plugin.filter.*;
import ij.process.*;
import ij.measure.*;
import ij.gui.*;

import ExcelInterface.*;
import org.apache.poi.hssf.usermodel.*;
/**
 *
 * @author  KURT DE VOS
 *
 *  This Plugin saves the XY Coordinates of a ROI to an excelfile
 *  It is identical to the XYWriter in IJ, but saves to excel instead of to a text file, 
 *  and it processes all slices in a stack.
 */
public class Save_XY_Coordinates_to_Excel implements PlugInFilter {
    ImagePlus imp;
    HSSFWorkbook wb;
    HSSFIO io;
    HSSFSheet s;
    HSSFRow row;
    HSSFCell cell;
    
    /** Creates a new instance of Save_XY_Coordinates_to_Excel */
    public Save_XY_Coordinates_to_Excel() {
    }
    
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_ALL+ROI_REQUIRED+NO_CHANGES;
    }
    
    public void run(ImageProcessor ip) {
        try {
            saveXYCoordinates(imp);
            IJ.write("Done");
        } catch (IllegalArgumentException e) {
            IJ.showMessage("Save_XY_Coordinates_to_Excel", e.getMessage());
        }
    }
    
    private void initializeExcel(){
        io = new HSSFIO();
        io.createExcelFile();
        this.wb = io.wb;
        this.s= io.s;
    }
    
    public void saveXYCoordinates(ImagePlus img){
        initializeExcel();
        for (int slice=1; slice<=imp.getStackSize(); slice++){
            imp.setSlice(slice);
            Roi roi = imp.getRoi();
            if (roi==null)
                throw new IllegalArgumentException("ROI required");
            if (!(roi instanceof PolygonRoi))
                throw new IllegalArgumentException("Irregular area or line selection required");
            
            java.awt.Rectangle r = roi.getBoundingRect();
            PolygonRoi p = (PolygonRoi)roi;
            int n = p.getNCoordinates();
            int[] x = p.getXCoordinates();
            int[] y = p.getYCoordinates();
            
            Calibration cal = imp.getCalibration();
            boolean scaled = cal.scaled();
            
            for (int i=0; i<n; i++) {
                int rowIndex = s.getLastRowNum();
                if (scaled){
                    row = s.createRow((short)(rowIndex+1));
                    row.setRowNum((short)(rowIndex+1));
                    cell = row.createCell((short)(row.getLastCellNum()+1));
                    cell.setCellValue(slice);
                    cell = row.createCell((short)(row.getLastCellNum()+1));
                    cell.setCellValue(((r.x+x[i])*cal.pixelWidth));
                    cell = row.createCell((short)(row.getLastCellNum()+1));
                    cell.setCellValue(IJ.d2s((r.y+y[i])*cal.pixelHeight));
                }
                else{
                    row = s.createRow((short)(rowIndex+1));
                    row.setRowNum((short)(rowIndex+1));
                    cell = row.createCell((short)(row.getLastCellNum()+1));
                    cell.setCellValue(slice);
                    cell = row.createCell((short)(row.getLastCellNum()+1));
                    cell.setCellValue((r.x+x[i]));
                    cell = row.createCell((short)(row.getLastCellNum()+1));
                    cell.setCellValue((r.y+y[i]));
                }
            }
        }
        io.saveExcel(); // save the excelfile
    }  
}
